/*
 * Decompiled with CFR 0.152.
 */
package cn.net.aicare.pabulumlibrary.bleprofile;

import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import cn.net.aicare.pabulumlibrary.PabulumSDK;
import cn.net.aicare.pabulumlibrary.bleprofile.BleManager;
import cn.net.aicare.pabulumlibrary.bleprofile.BleManagerCallbacks;
import cn.net.aicare.pabulumlibrary.utils.L;

public abstract class BleProfileService
extends Service
implements BleManagerCallbacks {
    private static final String TAG = "BleProfileService";
    public static final String BROADCAST_CONNECTION_STATE = "aicare.net.cn.BROADCAST_CONNECTION_STATE";
    public static final String BROADCAST_SERVICES_DISCOVERED = "aicare.net.cn.BROADCAST_SERVICES_DISCOVERED";
    public static final String BROADCAST_ERROR = "aicare.net.cn.BROADCAST_ERROR";
    public static final String BROADCAST_INDICATION_SUCCESS = "aicare.net.cn.BROADCAST_INDICATION_SUCCESS";
    public static final String BROADCAST_READ_RSSI = "aicare.net.cn.BROADCAST_READ_RSSI";
    public static final String BROADCAST_WRITE_SUCCESS = "aicare.net.cn.BROADCAST_WRITE_SUCCESS";
    public static final String EXTRA_DEVICE_ADDRESS = "aicare.net.cn.EXTRA_DEVICE_ADDRESS";
    public static final String EXTRA_RSSI = "aicare.net.cn.EXTRA_RSSI";
    public static final String EXTRA_DEVICE_NAME = "aicare.net.cn.EXTRA_DEVICE_NAME";
    public static final String EXTRA_CONNECTION_STATE = "aicare.net.cn.EXTRA_CONNECTION_STATE";
    public static final String EXTRA_ERROR_MESSAGE = "aicare.net.cn.EXTRA_ERROR_MESSAGE";
    public static final String EXTRA_ERROR_CODE = "aicare.net.cn.EXTRA_ERROR_CODE";
    public static final String EXTRA_WRITE_VALUE = "aicare.net.cn.EXTRA_WRITE_VALUE";
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTED = 1;
    public static final int STATE_CONNECTING = 2;
    public static final int STATE_DISCONNECTING = 3;
    public static final int STATE_INDICATION_SUCCESS = 4;
    public static final int STATE_DISCOVER_SERVICES = 5;
    private BleManager<BleManagerCallbacks> mBleManager;
    private boolean mConnected;
    private String mDeviceAddress;
    private String mDeviceName;

    public IBinder onBind(Intent intent) {
        return this.getBinder();
    }

    protected LocalBinder getBinder() {
        return new LocalBinder();
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public void onCreate() {
        super.onCreate();
        this.mBleManager = this.initializeManager();
        this.mBleManager.setGattCallbacks(this);
    }

    protected abstract BleManager initializeManager();

    @RequiresPermission(value="android.permission.BLUETOOTH")
    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.i((String)"Suzy", (String)"service started!");
        if (!PabulumSDK.getInstance().isCheck()) {
            Log.e((String)"PabulumSDK", (String)"\u8bf7\u5148\u8c03\u7528PabulumSDK.getInstance().init(),\u5e76\u5224\u65ad\u662f\u5426\u521d\u59cb\u5316\u6210\u529f.(Please call PabulumSDK.getInstance (). Init () first, and judge whether the initialization is successful.)");
            throw new SecurityException("\u8bf7\u5148\u8c03\u7528PabulumSDK.getInstance().init(),\u5e76\u5224\u65ad\u521d\u59cb\u5316\u662f\u5426\u6210\u529f.(Please call PabulumSDK.getInstance (). Init () first, and judge whether the initialization is successful.)");
        }
        if (intent == null || !intent.hasExtra(EXTRA_DEVICE_ADDRESS)) {
            throw new UnsupportedOperationException("No device address at EXTRA_DEVICE_ADDRESS key");
        }
        this.mDeviceAddress = intent.getStringExtra(EXTRA_DEVICE_ADDRESS);
        Intent broadcast = new Intent(BROADCAST_CONNECTION_STATE);
        broadcast.putExtra(EXTRA_CONNECTION_STATE, 2);
        this.sendBroadcast(broadcast);
        BluetoothManager bluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
        BluetoothAdapter adapter = bluetoothManager.getAdapter();
        BluetoothDevice device = adapter.getRemoteDevice(this.mDeviceAddress);
        this.mDeviceName = device.getName();
        this.onServiceStarted();
        if (!this.mConnected && this.mBleManager != null) {
            this.mBleManager.connect((Context)this, device);
        }
        return 3;
    }

    protected void onServiceStarted() {
    }

    public void onDestroy() {
        super.onDestroy();
        this.mBleManager = null;
        this.mDeviceAddress = null;
        this.mDeviceName = null;
        this.mConnected = false;
    }

    @Override
    public void onDeviceConnected() {
        this.mConnected = true;
        Intent broadcast = new Intent(BROADCAST_CONNECTION_STATE);
        broadcast.putExtra(EXTRA_CONNECTION_STATE, 1);
        broadcast.putExtra(EXTRA_DEVICE_ADDRESS, this.mDeviceAddress);
        broadcast.putExtra(EXTRA_DEVICE_NAME, this.mDeviceName);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void onDeviceDisconnected() {
        this.mConnected = false;
        this.mDeviceAddress = null;
        this.mDeviceName = null;
        Intent broadcast = new Intent(BROADCAST_CONNECTION_STATE);
        broadcast.putExtra(EXTRA_CONNECTION_STATE, 0);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
        L.e(TAG, "onDeviceDisconnected");
        this.stopSelf();
    }

    @Override
    public void onServicesDiscovered() {
        Intent broadcast = new Intent(BROADCAST_CONNECTION_STATE);
        broadcast.putExtra(EXTRA_CONNECTION_STATE, 5);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void onError(String message, int errorCode) {
        Intent broadcast = new Intent(BROADCAST_ERROR);
        broadcast.putExtra(EXTRA_ERROR_MESSAGE, message);
        broadcast.putExtra(EXTRA_ERROR_CODE, errorCode);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
        L.d(TAG, "onError->onDeviceDisconnected" + message);
        this.onDeviceDisconnected();
    }

    @Override
    public void onIndicationSuccess() {
        Intent broadcast = new Intent(BROADCAST_CONNECTION_STATE);
        broadcast.putExtra(EXTRA_CONNECTION_STATE, 4);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void onReadRssi(int rssi) {
        Intent broadcast = new Intent(BROADCAST_READ_RSSI);
        broadcast.putExtra(EXTRA_RSSI, rssi);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void onWriteSuccess(byte[] value) {
        Intent broadcast = new Intent(BROADCAST_WRITE_SUCCESS);
        broadcast.putExtra(EXTRA_WRITE_VALUE, value);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    public class LocalBinder
    extends Binder {
        public final void disconnect() {
            L.i(BleProfileService.TAG, "disconnect->" + BleProfileService.this.mConnected);
            if (!BleProfileService.this.mConnected) {
                L.i(BleProfileService.TAG, "disconnect->onDeviceDisconnected111111");
                BleProfileService.this.onDeviceDisconnected();
                return;
            }
            if (BleProfileService.this.mBleManager != null) {
                L.i(BleProfileService.TAG, "disconnect->onDeviceDisconnected22222222");
                BleProfileService.this.mBleManager.disconnect();
            }
        }

        public String getDeviceAddress() {
            return BleProfileService.this.mDeviceAddress;
        }

        public String getDeviceName() {
            return BleProfileService.this.mDeviceName;
        }

        public boolean isConnected() {
            return BleProfileService.this.mConnected;
        }
    }
}

