/*
 * Decompiled with CFR 0.152.
 */
package cn.net.aicare.pabulumlibrary.bleprofile;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelUuid;
import androidx.annotation.RequiresPermission;
import androidx.appcompat.app.AppCompatActivity;
import cn.net.aicare.pabulumlibrary.bleprofile.BleProfileService;
import cn.net.aicare.pabulumlibrary.entity.FoodData;
import cn.net.aicare.pabulumlibrary.pabulum.PabulumService;
import cn.net.aicare.pabulumlibrary.scandecoder.ScanRecord;
import cn.net.aicare.pabulumlibrary.utils.L;
import cn.net.aicare.pabulumlibrary.utils.PabulumBleConfig;
import cn.net.aicare.pabulumlibrary.utils.ParseData;
import java.util.List;

public abstract class BleProfileServiceReadyActivity
extends AppCompatActivity {
    private static final String TAG = "BleProfileServiceReadyActivity";
    protected static final int REQUEST_ENABLE_BT = 2;
    protected boolean mIsScanning = false;
    private BluetoothManager bluetoothManager = null;
    private BluetoothAdapter adapter = null;
    private boolean mRegisterTag = false;
    private BleProfileService.LocalBinder mLocalBinder;
    private final BroadcastReceiver mCommonBroadcastReceiver = new BroadcastReceiver(){

        @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("aicare.net.cn.BROADCAST_CONNECTION_STATE".equals(action)) {
                int state = intent.getIntExtra("aicare.net.cn.EXTRA_CONNECTION_STATE", 0);
                L.e(BleProfileServiceReadyActivity.TAG, "onDeviceDisconnected");
                BleProfileServiceReadyActivity.this.onStateChanged(state);
            } else if ("aicare.net.cn.BROADCAST_ERROR".equals(action)) {
                String message = intent.getStringExtra("aicare.net.cn.EXTRA_ERROR_MESSAGE");
                int errorCode = intent.getIntExtra("aicare.net.cn.EXTRA_ERROR_CODE", 0);
                BleProfileServiceReadyActivity.this.onError(message, errorCode);
            } else if ("aicare.net.cn.BROADCAST_READ_RSSI".equals(action)) {
                int rssi = intent.getIntExtra("aicare.net.cn.EXTRA_RSSI", 0);
                BleProfileServiceReadyActivity.this.onReadRssi(rssi);
            } else if (action.equals("aicare.net.cn.FOOD_DATA")) {
                FoodData foodData = (FoodData)intent.getSerializableExtra("aicare.net.cn.EXTRA_FOOD_DATA");
                BleProfileServiceReadyActivity.this.getFoodData(foodData);
            } else if (action.equals("aicare.net.cn.DEVICE_UNIT")) {
                byte i = intent.getByteExtra("aicare.net.cn.EXTRA_DEVICE_UNIT", (byte)0);
                BleProfileServiceReadyActivity.this.getUnit(i);
            } else if (action.equals("aicare.net.cn.BLE_VERSION")) {
                String version = intent.getStringExtra("aicare.net.cn.EXTRA_BLE_VERSION");
                BleProfileServiceReadyActivity.this.getBleVersion(version);
            } else if (action.equals("aicare.net.cn.BLE_DID")) {
                int did = intent.getIntExtra("aicare.net.cn.BLE_DID", 0);
                BleProfileServiceReadyActivity.this.getBleDID(did);
            } else if (action.equals("aicare.net.cn.TIMING")) {
                int status = intent.getIntExtra("aicare.net.cn.TIMING", 0);
                BleProfileServiceReadyActivity.this.getTimeStatus(status);
            } else if (action.equals("aicare.net.cn.SYN_TIME")) {
                int timeS = intent.getIntExtra("aicare.net.cn.SYN_TIME", 0);
                byte cmdType = intent.getByteExtra("aicare.net.cn.SYN_TIME_CMD_TYPE", (byte)33);
                BleProfileServiceReadyActivity.this.getSynTime(cmdType, timeS);
            } else if (action.equals("aicare.net.cn.TIMING_COUNTDOWN")) {
                int timeS = intent.getIntExtra("aicare.net.cn.TIMING_COUNTDOWN", 0);
                BleProfileServiceReadyActivity.this.getCountdownStart(timeS);
            } else if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(action)) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                switch (state) {
                    case 13: {
                        BleProfileServiceReadyActivity.this.bluetoothTurningOff();
                        break;
                    }
                    case 11: {
                        BleProfileServiceReadyActivity.this.bluetoothTurningOn();
                        break;
                    }
                    case 10: {
                        BleProfileServiceReadyActivity.this.bluetoothStateOff();
                        break;
                    }
                    case 12: {
                        BleProfileServiceReadyActivity.this.bluetoothStateOn();
                    }
                }
            } else if ("aicare.net.cn.BROADCAST_WRITE_SUCCESS".equals(action)) {
                byte[] value = intent.getByteArrayExtra("aicare.net.cn.EXTRA_WRITE_VALUE");
                BleProfileServiceReadyActivity.this.onWriteSuccess(value);
            } else if ("aicare.net.cn.DEVICE_UNITS".equals(action)) {
                int[] value = intent.getIntArrayExtra("aicare.net.cn.EXTRA_DEVICE_UNITS");
                BleProfileServiceReadyActivity.this.getUnits(value);
            } else if ("aicare.net.cn.DEVICE_ERRS".equals(action)) {
                int[] value = intent.getIntArrayExtra("aicare.net.cn.EXTRA_DEVICE_ERRS");
                BleProfileServiceReadyActivity.this.getErrCodes(value);
            } else if ("aicare.net.cn.STOP_ALARM".equals(action)) {
                BleProfileServiceReadyActivity.this.getStopAlarm();
            } else if ("aicare.net.cn.PENETRATE_DATA".equals(action)) {
                byte[] value = intent.getByteArrayExtra("aicare.net.cn.PENETRATE_DATA");
                BleProfileServiceReadyActivity.this.getPenetrateData(value);
            }
        }
    };
    private final ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            BleProfileService.LocalBinder bleService = (BleProfileService.LocalBinder)service;
            BleProfileServiceReadyActivity.this.setLocalBinder(bleService);
            BleProfileServiceReadyActivity.this.onServiceBinded(bleService);
            if (bleService.isConnected()) {
                BleProfileServiceReadyActivity.this.onStateChanged(1);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            BleProfileServiceReadyActivity.this.setLocalBinder(null);
        }
    };
    private final BluetoothAdapter.LeScanCallback mLEScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            if (device != null) {
                boolean isContainsUUID;
                ScanRecord scanResult = ScanRecord.parseFromBytes(scanRecord);
                List<ParcelUuid> uuidList = scanResult.getServiceUuids();
                boolean bl = isContainsUUID = BleProfileServiceReadyActivity.this.isListEmpty(uuidList) ? false : uuidList.contains(ParcelUuid.fromString((String)"0000ffb0-0000-1000-8000-00805f9b34fb"));
                if (isContainsUUID) {
                    byte[] specificData = scanResult.getManufacturerSpecificData();
                    L.e(BleProfileServiceReadyActivity.TAG, "\u5382\u5546\u4fe1\u606f:" + ParseData.arr2Str(specificData));
                    if (specificData != null && specificData.length >= 2 && specificData[0] == -84) {
                        byte deviceType = specificData[1];
                        L.i(BleProfileServiceReadyActivity.TAG, "\u8bbe\u5907\u7c7b\u578b:" + deviceType);
                        if (deviceType == 4 || deviceType == 5) {
                            PabulumBleConfig.getInstance().setDeviceType(deviceType);
                            BleProfileServiceReadyActivity.this.onLeScanCallback(device, rssi);
                        }
                    }
                }
            }
        }
    };

    public void setLocalBinder(BleProfileService.LocalBinder mLocalBinder) {
        this.mLocalBinder = mLocalBinder;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.onInitialize();
        try {
            this.registerReceiver(this.mCommonBroadcastReceiver, BleProfileServiceReadyActivity.makeIntentFilter());
            this.mRegisterTag = true;
            Intent service = new Intent((Context)this, PabulumService.class);
            this.bindService(service, this.mServiceConnection, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onInitialize() {
        this.bluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
        if (this.bluetoothManager != null) {
            this.adapter = this.bluetoothManager.getAdapter();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            this.unbindService(this.mServiceConnection);
            if (this.mRegisterTag) {
                this.unregisterReceiver(this.mCommonBroadcastReceiver);
                this.mRegisterTag = false;
            }
            this.mLocalBinder = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static IntentFilter makeIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("aicare.net.cn.BROADCAST_CONNECTION_STATE");
        intentFilter.addAction("aicare.net.cn.BROADCAST_SERVICES_DISCOVERED");
        intentFilter.addAction("aicare.net.cn.BROADCAST_ERROR");
        intentFilter.addAction("aicare.net.cn.BROADCAST_INDICATION_SUCCESS");
        intentFilter.addAction("aicare.net.cn.BROADCAST_READ_RSSI");
        intentFilter.addAction("aicare.net.cn.FOOD_DATA");
        intentFilter.addAction("aicare.net.cn.DEVICE_UNIT");
        intentFilter.addAction("aicare.net.cn.DEVICE_UNITS");
        intentFilter.addAction("aicare.net.cn.BLE_VERSION");
        intentFilter.addAction("aicare.net.cn.BLE_DID");
        intentFilter.addAction("aicare.net.cn.TIMING");
        intentFilter.addAction("aicare.net.cn.SYN_TIME");
        intentFilter.addAction("aicare.net.cn.TIMING_COUNTDOWN");
        intentFilter.addAction("aicare.net.cn.SYN_TIME");
        intentFilter.addAction("aicare.net.cn.DEVICE_ERRS");
        intentFilter.addAction("aicare.net.cn.STOP_ALARM");
        intentFilter.addAction("aicare.net.cn.PENETRATE_DATA");
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        intentFilter.addAction("aicare.net.cn.BROADCAST_WRITE_SUCCESS");
        return intentFilter;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public void connectDevice(BluetoothDevice device) {
        this.stopScan();
        Intent service = new Intent((Context)this, PabulumService.class);
        service.putExtra("aicare.net.cn.EXTRA_DEVICE_ADDRESS", device.getAddress());
        this.startService(service);
        this.bindService(service, this.mServiceConnection, 0);
    }

    protected boolean isDeviceConnected() {
        return this.mLocalBinder != null;
    }

    protected boolean ensureBLESupported() {
        return this.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    @RequiresPermission(value="android.permission.BLUETOOTH")
    protected boolean isBLEEnabled() {
        return this.adapter != null && this.adapter.isEnabled();
    }

    protected void showBLEDialog() {
        Intent enableIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
        this.startActivityForResult(enableIntent, 2);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH", "android.permission.BLUETOOTH_ADMIN"})
    protected void startScan() {
        if (this.isBLEEnabled()) {
            if (!this.mIsScanning && this.adapter != null) {
                this.adapter.startLeScan(this.mLEScanCallback);
                this.mIsScanning = true;
                this.onStartScan();
            }
        } else {
            this.showBLEDialog();
        }
    }

    protected abstract void onStartScan();

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    protected void stopScan() {
        if (this.mIsScanning) {
            if (this.adapter != null) {
                this.adapter.stopLeScan(this.mLEScanCallback);
            }
            this.mIsScanning = false;
        }
    }

    protected void bluetoothStateOff() {
    }

    protected void bluetoothTurningOn() {
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    protected void bluetoothTurningOff() {
        L.d(TAG, "\u84dd\u7259\u5173\u95ed\u4e2d");
        if (this.mIsScanning) {
            this.stopScan();
        } else if (this.mLocalBinder != null) {
            this.mLocalBinder.disconnect();
        }
    }

    protected void bluetoothStateOn() {
    }

    protected abstract void onServiceBinded(BleProfileService.LocalBinder var1);

    protected abstract void onReadRssi(int var1);

    protected abstract void onError(String var1, int var2);

    protected void onStateChanged(int state) {
        switch (state) {
            case 0: {
                L.e(TAG, "onDeviceDisconnected");
                try {
                    this.unbindService(this.mServiceConnection);
                    this.mLocalBinder = null;
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    protected abstract void getFoodData(FoodData var1);

    protected abstract void getUnit(byte var1);

    protected abstract void getUnits(int[] var1);

    protected abstract void getBleVersion(String var1);

    protected abstract void getBleDID(int var1);

    protected abstract void getTimeStatus(int var1);

    protected abstract void getCountdownStart(int var1);

    protected abstract void getSynTime(byte var1, int var2);

    protected abstract void getErrCodes(int[] var1);

    protected abstract void getStopAlarm();

    protected abstract void getPenetrateData(byte[] var1);

    protected abstract void onWriteSuccess(byte[] var1);

    protected abstract void onLeScanCallback(BluetoothDevice var1, int var2);

    private boolean isListEmpty(List<ParcelUuid> list) {
        return list == null || list.size() == 0;
    }
}

