/*
 * Decompiled with CFR 0.152.
 */
package cn.net.aicare.pabulumlibrary.pabulum;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.SparseArray;
import androidx.annotation.RequiresPermission;
import cn.net.aicare.pabulumlibrary.bleprofile.BleManager;
import cn.net.aicare.pabulumlibrary.entity.BleInfo;
import cn.net.aicare.pabulumlibrary.entity.FoodData;
import cn.net.aicare.pabulumlibrary.pabulum.PabulumManagerCallbacks;
import cn.net.aicare.pabulumlibrary.utils.L;
import cn.net.aicare.pabulumlibrary.utils.PabulumBleConfig;
import cn.net.aicare.pabulumlibrary.utils.ParseData;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;

public class PabulumManager
implements BleManager<PabulumManagerCallbacks> {
    private static final String TAG = PabulumManager.class.getName();
    private final int OPEN_BLE_MSG = 3;
    private final int CLOSE_BLE_MSG = 4;
    private final int GET_BLE_SERVICE = 5;
    private final int DIS_BLE_SERVICE = 6;
    private final int CONNECT_BLE_TIMEOUT = 8;
    private final int GET_SERVER_TIMEOUT = 9;
    private PabulumManagerCallbacks mCallbacks;
    private BluetoothGatt mBluetoothGatt;
    private Context mContext;
    private PabulumBleConfig pabulumBleConfig;
    private BluetoothDevice bluetoothDevice;
    private long discoverServicesTime = 0L;
    private long getServerOut = 8000L;
    private Handler handler = new Handler(Looper.myLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 8: {
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    BluetoothGatt gatt = (BluetoothGatt)msg.obj;
                    PabulumManager.this.discoverServicesTime = System.currentTimeMillis();
                    if (gatt == null) break;
                    L.i(TAG, "\u8fde\u63a5\u6210\u529f,\u6b63\u5728\u83b7\u53d6\u670d\u52a1");
                    gatt.discoverServices();
                    PabulumManager.this.bleInfo.setAddress(PabulumManager.this.bluetoothDevice.getAddress());
                    PabulumManager.this.bleInfo.setName(PabulumManager.this.bluetoothDevice.getName());
                    PabulumManager.this.handler.sendEmptyMessageDelayed(9, PabulumManager.this.getServerOut);
                    break;
                }
                case 9: {
                    L.i(TAG, "\u83b7\u53d6\u670d\u52a1\u8d85\u65f6");
                    PabulumManager.this.closeBluetoothGatt();
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
    };
    private BleInfo bleInfo;
    private static final String ERROR_CONNECTION_STATE_CHANGE = "Error on connection state change";
    private static final String ERROR_DISCOVERY_SERVICE = "Error on discovering services";
    private static final String ERROR_WRITE_DESCRIPTOR = "Error on writing descriptor";
    public static final String SERVICE_UUID_STR = "0000ffb0-0000-1000-8000-00805f9b34fb";
    private static final UUID AICARE_SERVICE_UUID = UUID.fromString("0000ffb0-0000-1000-8000-00805f9b34fb");
    private static final UUID AICARE_NOTIFY_CHARACTERISTIC_UUID = UUID.fromString("0000ffb2-0000-1000-8000-00805f9b34fb");
    private static final UUID AICARE_WRITE_CHARACTERISTIC_UUID = UUID.fromString("0000ffb1-0000-1000-8000-00805f9b34fb");
    private static final UUID DESCR_TWO = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private BluetoothGattCharacteristic mAicareWCharacteristic;
    private BluetoothGattCharacteristic mAicareNCharacteristic;
    private static PabulumManager managerInstance = null;
    private final MyBluetoothGattCallback mGattCallback = new MyBluetoothGattCallback();
    private Runnable timerRunnable = new Runnable(){

        @Override
        public void run() {
            L.e(TAG, "\u5012\u8ba1\u65f6\u7ed3\u675f");
            PabulumManager.this.onAuthStatus(false);
        }
    };

    public static synchronized PabulumManager getPabulumManager() {
        if (managerInstance == null) {
            managerInstance = new PabulumManager();
        }
        return managerInstance;
    }

    @Override
    public void setGattCallbacks(PabulumManagerCallbacks callbacks) {
        this.mCallbacks = callbacks;
    }

    @Override
    public void connect(Context context, BluetoothDevice device) {
        L.i(TAG, "connect");
        this.bluetoothDevice = device;
        this.mBluetoothGatt = device.connectGatt(context, false, (BluetoothGattCallback)this.mGattCallback);
        this.mContext = context;
        this.pabulumBleConfig = PabulumBleConfig.getInstance();
        this.bleInfo = new BleInfo();
    }

    @Override
    public void disconnect() {
        L.i(TAG, "disconnect\u65b9\u6cd5\u88ab\u8c03\u7528");
        if (this.mBluetoothGatt != null) {
            this.mBluetoothGatt.disconnect();
        }
    }

    @Override
    public void closeBluetoothGatt() {
        if (this.mBluetoothGatt != null) {
            this.disconnect();
            SystemClock.sleep((long)300L);
            this.mBluetoothGatt.close();
            this.refresh(this.mBluetoothGatt);
            this.mBluetoothGatt = null;
            this.mAicareWCharacteristic = null;
            this.mAicareNCharacteristic = null;
            this.mCallbacks.onDeviceDisconnected();
        }
    }

    private void enableAicareIndication() {
        L.i(TAG, "enableAicareIndication");
        boolean sendOk = this.mBluetoothGatt.setCharacteristicNotification(this.mAicareNCharacteristic, true);
        List mm = this.mAicareNCharacteristic.getDescriptors();
        if (sendOk) {
            for (BluetoothGattDescriptor bluetoothGattDescriptor : mm) {
                bluetoothGattDescriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                this.mBluetoothGatt.writeDescriptor(bluetoothGattDescriptor);
            }
        }
        L.i(TAG, "enableAicareIndication sync.......................");
    }

    private boolean hasAicareUUID() {
        return this.mAicareWCharacteristic != null;
    }

    public void writeValue(byte[] b) {
        if (this.hasAicareUUID()) {
            this.mAicareWCharacteristic.setValue(b);
            this.mAicareWCharacteristic.setWriteType(1);
            this.mBluetoothGatt.writeCharacteristic(this.mAicareWCharacteristic);
        }
    }

    public void sendCMD(byte type, byte unitType) {
        byte[] b = this.pabulumBleConfig.initByteArray(type, unitType);
        this.writeValue(b);
    }

    public void sendCMDTime(byte type) {
        byte[] b = this.pabulumBleConfig.initByteArrayTime(type);
        this.writeValue(b);
    }

    public void sendCMDTime(byte type, int secAll) {
        byte[] time = new byte[2];
        if (secAll > 0) {
            int min = secAll / 60;
            int sec = secAll % 60;
            time[0] = (byte)min;
            time[1] = (byte)sec;
        }
        byte[] b = this.pabulumBleConfig.initByteArrayTimeLess(type, time);
        this.writeValue(b);
    }

    public void sendCMDStopAlarm() {
        byte[] b = this.pabulumBleConfig.initByteArrayStopAlarm();
        this.writeValue(b);
    }

    public void setWeight(int weight) {
        this.writeValue(this.pabulumBleConfig.initSetWeighCMD(weight));
    }

    public void powerOff() {
        this.writeValue(this.pabulumBleConfig.initPowerOffCMD());
    }

    public void setData(long data, int cmdTpye) {
        this.writeValue(this.pabulumBleConfig.initSetCMD(data, cmdTpye));
    }

    public void getDid() {
        this.writeValue(this.pabulumBleConfig.initGetDID());
    }

    public void getVersion() {
        this.writeValue(this.pabulumBleConfig.initGetVersion());
    }

    public void getUnits() {
        this.writeValue(this.pabulumBleConfig.initGetUnits());
    }

    private void handleData(byte[] b) {
        SparseArray<Object> sparseArray = this.pabulumBleConfig.handleBLEData(b);
        if (sparseArray != null && sparseArray.size() != 0) {
            if (sparseArray.indexOfKey(0) >= 0) {
                this.mCallbacks.getFoodWeight((FoodData)sparseArray.get(0));
            } else if (sparseArray.indexOfKey(2) >= 0) {
                String version = (String)sparseArray.get(2);
                L.e(TAG, "version\uff1a" + version);
                L.e(TAG, "address\uff1a" + this.bluetoothDevice.getAddress());
                this.cancelTimer();
                this.mCallbacks.getBleVersion(version);
                this.bleInfo.setVersion(version);
                if (this.pabulumBleConfig.isVersionOK(version)) {
                    if (this.pabulumBleConfig.compareAddress(this.bluetoothDevice.getAddress())) {
                        this.onAuthStatus(true);
                    } else {
                        this.auth();
                    }
                } else {
                    L.e(TAG, "\u7248\u672c\u672a\u901a\u8fc7");
                    this.onAuthStatus(false);
                }
            } else if (sparseArray.indexOfKey(1) >= 0) {
                this.mCallbacks.getDeviceUnit((Byte)sparseArray.get(1));
            } else if (sparseArray.indexOfKey(3) >= 0) {
                this.cancelTimer();
                L.e(TAG, "IS_AUTH");
                this.onAuthStatus((Boolean)sparseArray.get(3));
            } else if (sparseArray.indexOfKey(4) >= 0) {
                int did = (Integer)sparseArray.get(4);
                this.mCallbacks.getBleDID(did);
            } else if (sparseArray.indexOfKey(5) >= 0) {
                int status = (Integer)sparseArray.get(5);
                this.mCallbacks.getTimeStatus(status);
            } else if (sparseArray.indexOfKey(6) >= 0) {
                int timeS = (Integer)sparseArray.get(6);
                this.mCallbacks.getSynTime((byte)33, timeS);
            } else if (sparseArray.indexOfKey(7) >= 0) {
                int timeS = (Integer)sparseArray.get(7);
                this.mCallbacks.getCountdownStart(timeS);
            } else if (sparseArray.indexOfKey(8) >= 0) {
                int timeS = (Integer)sparseArray.get(8);
                this.mCallbacks.getSynTime((byte)34, timeS);
            } else if (sparseArray.indexOfKey(9) >= 0) {
                int timeS = (Integer)sparseArray.get(9);
                this.mCallbacks.getSynTime((byte)36, timeS);
            } else if (sparseArray.indexOfKey(10) >= 0) {
                int timeS = (Integer)sparseArray.get(10);
                this.mCallbacks.getSynTime((byte)37, timeS);
            } else if (sparseArray.indexOfKey(11) >= 0) {
                int[] units = (int[])sparseArray.get(11);
                this.mCallbacks.getUnits(units);
            } else if (sparseArray.indexOfKey(12) >= 0) {
                int[] errCodes = (int[])sparseArray.get(12);
                this.mCallbacks.getErrCode(errCodes);
            } else if (sparseArray.indexOfKey(13) >= 0) {
                this.mCallbacks.getStopAlarm();
            } else if (sparseArray.indexOfKey(14) >= 0) {
                byte[] data = (byte[])sparseArray.get(14);
                this.mCallbacks.getPenetrateData(data);
            }
        }
    }

    private void auth() {
        L.e(TAG, "auth");
        this.writeValue(this.pabulumBleConfig.initAuthBytes());
        this.startTimer();
    }

    private void onAuthStatus(boolean isAuth) {
        this.mCallbacks.onIndicationSuccess();
    }

    private void startTimer() {
        this.cancelTimer();
        this.handler.postDelayed(this.timerRunnable, 1500L);
    }

    private void cancelTimer() {
        this.handler.removeCallbacks(this.timerRunnable);
    }

    private void refresh(BluetoothGatt gatt) {
        try {
            boolean result;
            L.e(TAG, "refresh device cache");
            Method localMethod = gatt.getClass().getMethod("refresh", null);
            if (localMethod != null && !(result = ((Boolean)localMethod.invoke((Object)gatt, (Object[])null)).booleanValue())) {
                L.e(TAG, "refresh failed");
            }
        }
        catch (Exception e) {
            L.e(TAG, "An exception occurred while refreshing device cache");
        }
    }

    static {
        try {
            System.loadLibrary("aicare-lib");
            L.e(TAG, "load libs!");
        }
        catch (Exception e) {
            L.e(TAG, "not found libs!");
        }
    }

    public class MyBluetoothGattCallback
    extends BluetoothGattCallback {
        @RequiresPermission(value="android.permission.BLUETOOTH")
        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            if (status == 0) {
                if (newState == 2) {
                    PabulumManager.this.handler.removeMessages(5);
                    Message message = Message.obtain();
                    message.what = 5;
                    message.obj = gatt;
                    PabulumManager.this.handler.sendMessageDelayed(message, 300L);
                } else if (newState == 0) {
                    if (System.currentTimeMillis() - PabulumManager.this.discoverServicesTime > 800L) {
                        L.i(TAG, "onDeviceDisconnected->Device disconnected");
                        PabulumManager.this.discoverServicesTime = System.currentTimeMillis();
                        gatt.disconnect();
                        gatt.close();
                        PabulumManager.this.mCallbacks.onDeviceDisconnected();
                    } else {
                        L.e(TAG, "\u8fde\u63a5\u65ad\u5f00\u95f4\u9694\u8fc7\u77ed");
                        PabulumManager.this.closeBluetoothGatt();
                        PabulumManager.this.mCallbacks.onDeviceDisconnected();
                    }
                }
            } else {
                L.d(TAG, "onDeviceDisconnected->onConnectionStateChange fail");
                PabulumManager.this.closeBluetoothGatt();
                PabulumManager.this.mCallbacks.onError(PabulumManager.ERROR_CONNECTION_STATE_CHANGE, status);
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            if (status == 0) {
                PabulumManager.this.handler.removeMessages(9);
                L.i(TAG, "onServicesDiscovered Success");
                L.i(TAG, "onServicesDiscovered status = " + status);
                List services = gatt.getServices();
                for (BluetoothGattService service : services) {
                    L.i(TAG, "\u83b7\u53d6\u670d\u52a1\u7684uuid: " + service.getUuid());
                }
                if (services.size() == 0) {
                    PabulumManager.this.disconnect();
                    return;
                }
                PabulumManager.this.mCallbacks.onDeviceConnected();
                L.i(TAG, "\u83b7\u53d6\u670d\u52a1\u6210\u529f");
                BluetoothGattService service = gatt.getService(AICARE_SERVICE_UUID);
                if (service != null) {
                    PabulumManager.this.mAicareWCharacteristic = service.getCharacteristic(AICARE_WRITE_CHARACTERISTIC_UUID);
                    PabulumManager.this.mAicareNCharacteristic = service.getCharacteristic(AICARE_NOTIFY_CHARACTERISTIC_UUID);
                }
                if (PabulumManager.this.hasAicareUUID()) {
                    PabulumManager.this.enableAicareIndication();
                }
            } else {
                L.i(TAG, "onServicesDiscoveredy\u5f02\u5e38");
                PabulumManager.this.mCallbacks.onError(PabulumManager.ERROR_DISCOVERY_SERVICE, status);
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0 && characteristic.getUuid().equals(AICARE_WRITE_CHARACTERISTIC_UUID)) {
                byte[] b = characteristic.getValue();
                L.i(TAG, "onCharacteristicWrite " + ParseData.arr2Str(b));
                PabulumManager.this.mCallbacks.onWriteSuccess(b);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            byte[] b = characteristic.getValue();
            L.i(TAG, "onCharacteristicChanged " + ParseData.arr2Str(b));
            gatt.readRemoteRssi();
            PabulumManager.this.handleData(b);
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (status == 0) {
                L.i(TAG, "onDescriptorWrite");
                PabulumManager.this.sendCMD((byte)-9, (byte)0);
            } else {
                L.e(TAG, "Error on writing descriptor (" + status + ")");
                PabulumManager.this.mCallbacks.onError(PabulumManager.ERROR_WRITE_DESCRIPTOR, status);
            }
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            super.onReadRemoteRssi(gatt, rssi, status);
            if (status == 0) {
                PabulumManager.this.mCallbacks.onReadRssi(rssi);
            }
        }
    }
}

