/*
 * Decompiled with CFR 0.152.
 */
package cn.net.aicare.pabulumlibrary.pabulum;

import android.content.Intent;
import android.os.IBinder;
import cn.net.aicare.pabulumlibrary.bleprofile.BleManager;
import cn.net.aicare.pabulumlibrary.bleprofile.BleProfileService;
import cn.net.aicare.pabulumlibrary.entity.FoodData;
import cn.net.aicare.pabulumlibrary.pabulum.PabulumManager;
import cn.net.aicare.pabulumlibrary.pabulum.PabulumManagerCallbacks;
import cn.net.aicare.pabulumlibrary.utils.L;
import java.io.Serializable;

public class PabulumService
extends BleProfileService
implements PabulumManagerCallbacks {
    private static String TAG = PabulumService.class.getName();
    private PabulumManager mManager;
    public boolean mBinded;
    private final BleProfileService.LocalBinder mBinder = new PabulumBinder();
    public static final String FOOD_WEIGHT = "aicare.net.cn.FOOD_DATA";
    public static final String DEVICE_UNIT = "aicare.net.cn.DEVICE_UNIT";
    public static final String DEVICE_UNITS = "aicare.net.cn.DEVICE_UNITS";
    public static final String BLE_VERSION = "aicare.net.cn.BLE_VERSION";
    public static final String BLE_DID = "aicare.net.cn.BLE_DID";
    public static final String TIMING = "aicare.net.cn.TIMING";
    public static final String SYN_TIME = "aicare.net.cn.SYN_TIME";
    public static final String TIMING_COUNTDOWN = "aicare.net.cn.TIMING_COUNTDOWN";
    public static final String SYN_TIME_CMD_TYPE = "aicare.net.cn.SYN_TIME_CMD_TYPE";
    public static final String DEVICE_ERRS = "aicare.net.cn.DEVICE_ERRS";
    public static final String STOP_ALARM = "aicare.net.cn.STOP_ALARM";
    public static final String PENETRATE_DATA = "aicare.net.cn.PENETRATE_DATA";
    public static final String EXTRA_FOOD_DATA = "aicare.net.cn.EXTRA_FOOD_DATA";
    public static final String EXTRA_DEVICE_UNIT = "aicare.net.cn.EXTRA_DEVICE_UNIT";
    public static final String EXTRA_DEVICE_UNITS = "aicare.net.cn.EXTRA_DEVICE_UNITS";
    public static final String EXTRA_BLE_VERSION = "aicare.net.cn.EXTRA_BLE_VERSION";
    public static final String EXTRA_DEVICE_ERRS = "aicare.net.cn.EXTRA_DEVICE_ERRS";

    @Override
    public void getFoodWeight(FoodData foodData) {
        Intent broadcast = new Intent(FOOD_WEIGHT);
        broadcast.putExtra(EXTRA_FOOD_DATA, (Serializable)foodData);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void getDeviceUnit(byte unitType) {
        Intent broadcast = new Intent(DEVICE_UNIT);
        broadcast.putExtra(EXTRA_DEVICE_UNIT, unitType);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void getUnits(int[] units) {
        Intent broadcast = new Intent(DEVICE_UNITS);
        broadcast.putExtra(EXTRA_DEVICE_UNITS, units);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void getBleVersion(String version) {
        Intent broadcast = new Intent(BLE_VERSION);
        broadcast.putExtra(EXTRA_BLE_VERSION, version);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void getBleDID(int did) {
        Intent broadcast = new Intent(BLE_DID);
        broadcast.putExtra(BLE_DID, did);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void getTimeStatus(int status) {
        Intent broadcast = new Intent(TIMING);
        broadcast.putExtra(TIMING, status);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void getCountdownStart(int time) {
        Intent broadcast = new Intent(TIMING_COUNTDOWN);
        broadcast.putExtra(TIMING_COUNTDOWN, time);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void getSynTime(byte cmdType, int timeS) {
        Intent broadcast = new Intent(SYN_TIME);
        broadcast.putExtra(SYN_TIME_CMD_TYPE, cmdType);
        broadcast.putExtra(SYN_TIME, timeS);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void getStopAlarm() {
        Intent broadcast = new Intent(STOP_ALARM);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void getErrCode(int[] errCodes) {
        Intent broadcast = new Intent(DEVICE_ERRS);
        broadcast.putExtra(EXTRA_DEVICE_ERRS, errCodes);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    public void getPenetrateData(byte[] data) {
        Intent broadcast = new Intent(PENETRATE_DATA);
        broadcast.putExtra(PENETRATE_DATA, data);
        broadcast.setPackage(this.getPackageName());
        this.sendBroadcast(broadcast);
    }

    @Override
    protected BleProfileService.LocalBinder getBinder() {
        return this.mBinder;
    }

    @Override
    protected BleManager<PabulumManagerCallbacks> initializeManager() {
        this.mManager = PabulumManager.getPabulumManager();
        return this.mManager;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        L.i("Suzy", "PabulumService.onCreate");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public IBinder onBind(Intent intent) {
        this.mBinded = true;
        return super.onBind(intent);
    }

    public void onRebind(Intent intent) {
        this.mBinded = true;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        this.mBinded = false;
        return super.onUnbind(intent);
    }

    public class PabulumBinder
    extends BleProfileService.LocalBinder {
        public PabulumService getService() {
            return PabulumService.this;
        }

        public void setUnit(byte unitType) {
            L.i(TAG, "\u8bbe\u7f6e\u5355\u4f4d:" + unitType);
            PabulumService.this.mManager.sendCMD((byte)6, unitType);
        }

        public void netWeight() {
            PabulumService.this.mManager.sendCMD((byte)20, (byte)0);
        }

        public void startTime() {
            PabulumService.this.mManager.sendCMDTime((byte)1);
        }

        public void startTimeLess(int sec) {
            PabulumService.this.mManager.sendCMDTime((byte)35, sec);
        }

        public void pauseTime(int sec) {
            PabulumService.this.mManager.sendCMDTime((byte)36, sec);
        }

        public void pauseTimeLess(int sec) {
            PabulumService.this.mManager.sendCMDTime((byte)37, sec);
        }

        public void resetTime() {
            PabulumService.this.mManager.sendCMDTime((byte)3);
        }

        public void stopAlarm() {
            PabulumService.this.mManager.sendCMDStopAlarm();
        }

        public void setWeight(int weight) {
            PabulumService.this.mManager.setWeight(weight);
        }

        public void powerOff() {
            PabulumService.this.mManager.powerOff();
        }

        public void getDid() {
            PabulumService.this.mManager.getDid();
        }

        public void getVersion() {
            PabulumService.this.mManager.getVersion();
        }

        public void getUnits() {
            PabulumService.this.mManager.getUnits();
        }

        public void setCal(long data) {
            PabulumService.this.mManager.setData(data, -79);
        }

        public void setAllCal(long data) {
            PabulumService.this.mManager.setData(data, -78);
        }

        public void setFat(long data) {
            PabulumService.this.mManager.setData(data, -70);
        }

        public void setPro(long data) {
            PabulumService.this.mManager.setData(data, -69);
        }

        public void setCar(long data) {
            PabulumService.this.mManager.setData(data, -68);
        }

        public void setFib(long data) {
            PabulumService.this.mManager.setData(data, -67);
        }

        public void setCho(long data) {
            PabulumService.this.mManager.setData(data, -66);
        }

        public void setSod(long data) {
            PabulumService.this.mManager.setData(data, -65);
        }

        public void setSug(long data) {
            PabulumService.this.mManager.setData(data, -32);
        }

        public void setAllFat(long data) {
            PabulumService.this.mManager.setData(data, -77);
        }

        public void setAllPro(long data) {
            PabulumService.this.mManager.setData(data, -76);
        }

        public void setAllCar(long data) {
            PabulumService.this.mManager.setData(data, -75);
        }

        public void setAllFib(long data) {
            PabulumService.this.mManager.setData(data, -74);
        }

        public void setAllCho(long data) {
            PabulumService.this.mManager.setData(data, -73);
        }

        public void setAllSod(long data) {
            PabulumService.this.mManager.setData(data, -72);
        }

        public void setAllSug(long data) {
            PabulumService.this.mManager.setData(data, -71);
        }

        public void writeValue(byte[] value) {
            if (value != null) {
                if (value.length > 20) {
                    throw new UnsupportedOperationException("value's length > 20");
                }
            } else {
                throw new NullPointerException("value is null");
            }
            PabulumService.this.mManager.writeValue(value);
        }
    }
}

