/*
 * Decompiled with CFR 0.152.
 */
package cn.net.aicare.pabulumlibrary.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import androidx.annotation.RequiresPermission;
import cn.net.aicare.pabulumlibrary.entity.BleInfo;
import cn.net.aicare.pabulumlibrary.utils.L;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Scanner;

public class BleUtils {
    private static final String TAG = "BleUtils";
    private static final String POST_BLE_INFO_URL = "http://aicare.net.cn/register/weightuser/pushBTInfo";

    private static String getVersionName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isConnected(Context context) {
        NetworkInfo info;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        return null != connectivity && null != (info = connectivity.getActiveNetworkInfo()) && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED;
    }

    private static String getBleJson(Context context, BleInfo bleInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("appName=" + context.getPackageName());
        stringBuilder.append("&");
        stringBuilder.append("appVersion=" + BleUtils.getVersionName(context));
        stringBuilder.append("&");
        stringBuilder.append("emailAddress=Visitor");
        stringBuilder.append("&");
        stringBuilder.append("phoneType=" + Build.MANUFACTURER + " " + Build.PRODUCT);
        stringBuilder.append("&");
        stringBuilder.append("phoneVersion=Android " + Build.VERSION.RELEASE + ", API " + Build.VERSION.SDK_INT);
        stringBuilder.append("&");
        stringBuilder.append("phoneLanguage=" + Locale.getDefault().getLanguage());
        stringBuilder.append("&");
        stringBuilder.append("btMacAddress=" + (bleInfo == null ? "" : bleInfo.getAddress()));
        stringBuilder.append("&");
        stringBuilder.append("btVersion=" + (bleInfo == null ? "" : bleInfo.getVersion()));
        stringBuilder.append("&");
        stringBuilder.append("btName=" + (bleInfo == null ? "" : bleInfo.getName()));
        stringBuilder.append("&");
        stringBuilder.append("isCheck=" + (bleInfo == null ? "" : String.valueOf(bleInfo.getIsCheck())));
        return stringBuilder.toString();
    }

    public static void startTask(Context context, BleInfo bleInfo) {
        L.e(TAG, "startTask");
        new BleTask(context, bleInfo).execute(new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Void postBleInfo(Context context, BleInfo bleInfo) {
        L.e(TAG, "postBleInfo");
        InputStream inputStream = null;
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(POST_BLE_INFO_URL);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            urlConnection.setUseCaches(false);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setReadTimeout(10000);
            urlConnection.connect();
            DataOutputStream wr = new DataOutputStream(urlConnection.getOutputStream());
            String jsonStr = BleUtils.getBleJson(context, bleInfo).toString();
            L.e(TAG, "jsonStr = " + jsonStr);
            wr.writeBytes(jsonStr);
            wr.flush();
            wr.close();
            int statusCode = urlConnection.getResponseCode();
            L.e(TAG, "statusCode = " + statusCode);
            if (statusCode == 200) {
                inputStream = new BufferedInputStream(urlConnection.getInputStream());
                Scanner s = new Scanner(inputStream).useDelimiter("\\A");
                String result = s.hasNext() ? s.next() : "";
                L.e(TAG, "response result = " + result);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return null;
    }

    private static class BleTask
    extends AsyncTask<Void, Void, Void> {
        private Context context;
        private BleInfo bleInfo;

        private BleTask(Context context, BleInfo bleInfo) {
            this.context = context;
            this.bleInfo = bleInfo;
        }

        protected Void doInBackground(Void ... voids) {
            return BleUtils.postBleInfo(this.context, this.bleInfo);
        }
    }
}

