/*
 * Decompiled with CFR 0.152.
 */
package cn.net.aicare.pabulumlibrary.utils;

import aicare.net.cn.aicareutils.AicareUtils;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import cn.net.aicare.pabulumlibrary.entity.FoodData;
import cn.net.aicare.pabulumlibrary.utils.L;
import cn.net.aicare.pabulumlibrary.utils.ParseData;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;

public class PabulumBleConfig {
    private static String TAG = PabulumBleConfig.class.getName();
    public static final byte[] CHECK_BM = new byte[]{-83, 1};
    public static final byte FLAG = -84;
    private static final byte SETTING = -52;
    public static final byte GET_VERSION = -9;
    public static final byte GET_UNITS = -15;
    private static final byte STA_DATA = -54;
    private static final byte CHANGE_DATA = -50;
    private static final byte DATA_FLAG = -2;
    private static final byte DATA_DID = 30;
    private static final byte DATA_ERR = 38;
    public static final byte DATA_DID_0 = 0;
    public static final byte TYPE_04 = 4;
    public static final byte TYPE_05 = 5;
    private static final byte CHANGE_UNIT_SUCCESS = -2;
    private static final byte DATA_COFFEE = -14;
    private static final byte POWER_OFF = -80;
    private byte deviceType = (byte)4;
    private byte unitType = 0;
    private static PabulumBleConfig instance;
    public static final byte UNIT_G = 0;
    public static final byte UNIT_ML = 1;
    public static final byte UNIT_LB = 2;
    public static final byte UNIT_OZ = 3;
    public static final byte UNIT_KG = 4;
    public static final byte UNIT_FG = 5;
    public static final byte UNIT_ML_MILK = 6;
    public static final byte UNIT_ML_WATER = 7;
    public static final byte UNIT_FL_OZ_MILK = 8;
    public static final byte UNIT_FL_OZ_WATER = 9;
    public static final byte SET_UNIT = 6;
    public static final byte NET_WEIGHT = 20;
    public static final byte TIMING = 32;
    public static final byte TIMING_LESS = 35;
    public static final byte SYN_TIME = 33;
    public static final byte SYN_TIME_LESS = 34;
    public static final byte TIMING_PAUSE = 36;
    public static final byte TIMING_PAUSE_LESS = 37;
    public static final byte STOP_ALARM = 38;
    public static final byte TIMING_START = 1;
    public static final byte TIMING_RESET = 3;
    public static final byte TIME_SEND = 0;
    public static final byte TIME_RECEIVE = 1;
    private static final int SUM_START = 2;
    private static final int SUM_END = 7;
    private static final String VERSION_SPILT = "_";
    private byte[] encryptBytes;

    private PabulumBleConfig() {
    }

    public static synchronized PabulumBleConfig getInstance() {
        if (instance == null) {
            instance = new PabulumBleConfig();
        }
        return instance;
    }

    public void setDeviceType(byte deviceType) {
        this.deviceType = deviceType;
    }

    public byte getDeviceType() {
        return this.deviceType;
    }

    public void setUnitType(byte unitType) {
        this.unitType = unitType;
    }

    public byte[] initByteArray(byte type, byte unitType) {
        byte[] b = new byte[8];
        b[0] = -84;
        b[1] = this.deviceType;
        switch (type) {
            case 6: {
                b[2] = -2;
                b[3] = 6;
                b[4] = unitType;
                this.setUnitType(unitType);
                break;
            }
            case 20: {
                b[2] = -2;
                b[3] = 20;
                b[4] = 1;
                break;
            }
            case -9: {
                b[2] = -9;
            }
        }
        b[6] = -52;
        b[7] = this.getByteSum(b, 2, 7);
        L.i(PabulumBleConfig.class, ParseData.arr2Str(b));
        return b;
    }

    public byte[] initByteArrayTime(byte type) {
        byte[] b = new byte[8];
        b[0] = -84;
        b[1] = this.deviceType;
        b[2] = -14;
        b[3] = 32;
        switch (type) {
            case 1: {
                b[4] = 1;
                break;
            }
            case 3: {
                b[4] = 3;
            }
        }
        b[5] = 0;
        b[6] = -52;
        b[7] = this.getByteSum(b, 2, 7);
        L.i(PabulumBleConfig.class, ParseData.arr2Str(b));
        return b;
    }

    public byte[] initByteArrayTimeLess(byte type, byte[] typeTime) {
        byte[] b = new byte[8];
        if (typeTime.length >= 2) {
            b[0] = -84;
            b[1] = this.deviceType;
            b[2] = -14;
            b[3] = type;
            b[4] = typeTime[0];
            b[5] = typeTime[1];
            b[6] = -52;
            b[7] = this.getByteSum(b, 2, 7);
            L.i(PabulumBleConfig.class, ParseData.arr2Str(b));
        }
        return b;
    }

    public byte[] initByteArrayStopAlarm() {
        byte[] b = new byte[8];
        b[0] = -84;
        b[1] = this.deviceType;
        b[2] = -14;
        b[3] = 38;
        b[6] = -52;
        b[7] = this.getByteSum(b, 2, 7);
        L.i(PabulumBleConfig.class, ParseData.arr2Str(b));
        return b;
    }

    public byte[] initPowerOffCMD() {
        byte[] b = new byte[8];
        b[0] = -84;
        b[1] = this.deviceType;
        b[2] = -2;
        b[6] = -80;
        b[7] = this.getByteSum(b, 2, 7);
        return b;
    }

    public byte[] initSetCMD(long data, int type) {
        byte[] b = new byte[8];
        b[0] = -84;
        b[1] = this.deviceType;
        byte[] bytes = ParseData.int2Bytes(data, 4);
        for (int i = 0; i < bytes.length; ++i) {
            b[i + 2] = bytes[i];
        }
        b[6] = Integer.valueOf(type).byteValue();
        b[7] = this.getByteSum(b, 2, 7);
        return b;
    }

    public byte[] initGetDID() {
        byte[] b;
        b = new byte[]{-84, this.deviceType, -2, 30, 0, 0, -52, this.getByteSum(b, 2, 7)};
        return b;
    }

    public byte[] initGetVersion() {
        byte[] b;
        b = new byte[]{-84, this.deviceType, -9, 0, 0, 0, -52, this.getByteSum(b, 2, 7)};
        L.i(PabulumBleConfig.class, ParseData.arr2Str(b));
        return b;
    }

    public byte[] initGetUnits() {
        byte[] b;
        b = new byte[]{-84, this.deviceType, -15, 1, 0, 0, -52, this.getByteSum(b, 2, 7)};
        L.i(PabulumBleConfig.class, ParseData.arr2Str(b));
        return b;
    }

    public byte[] initSetWeighCMD(int weight) {
        if (Math.abs(weight) > 65535) {
            throw new UnsupportedOperationException("-65535 < weight < 65535");
        }
        byte[] b = new byte[8];
        b[0] = -84;
        b[1] = this.deviceType;
        byte[] weiBytes = ParseData.int2Bytes(Math.abs(weight), 2);
        b[2] = weiBytes[1];
        b[3] = weiBytes[0];
        if (weight < 0) {
            b[5] = ParseData.bitToByte("00000001");
        }
        b[6] = -54;
        b[7] = this.getByteSum(b, 2, 7);
        return b;
    }

    public byte getByteSum(byte[] b, int start, int end) {
        if (b[0] == -84 && (b[1] == 4 || b[1] == 5)) {
            int j = 0;
            for (int i = start; i < end; ++i) {
                j += b[i];
            }
            int result = j & 0xFF;
            return (byte)result;
        }
        return -1;
    }

    private boolean checkData(byte[] b) {
        if (b.length == 8) {
            byte result = this.getByteSum(b, 2, 7);
            if (result != -1 && result == b[7]) {
                return true;
            }
            if (result == -1 && b[7] == -1) {
                return true;
            }
        }
        return false;
    }

    public SparseArray<Object> handleBLEData(byte[] b) {
        SparseArray sparseArray = new SparseArray();
        if (this.checkData(b)) {
            if (b[2] == -9) {
                sparseArray.put(2, (Object)this.getVersion(b));
            } else if (b[2] == -15) {
                sparseArray.put(11, (Object)this.getUnits(b));
            } else {
                if (b[6] == -52) {
                    if (b[2] == -2) {
                        switch (b[3]) {
                            case 6: {
                                if (b[4] == -2) break;
                                this.setUnitType(b[4]);
                                sparseArray.put(1, (Object)b[4]);
                                break;
                            }
                            case 30: {
                                int did = (b[4] << 8) + b[5];
                                sparseArray.put(4, (Object)did);
                                return sparseArray;
                            }
                            case 38: {
                                int errCode = b[4] & 0xFF;
                                if ((errCode & 1) == 0 && (errCode >> 1 & 1) == 0) {
                                    return null;
                                }
                                int[] errCodes = new int[]{errCode & 1, errCode >> 1 & 1};
                                sparseArray.put(12, (Object)errCodes);
                                return sparseArray;
                            }
                        }
                    } else if (b[2] == -14) {
                        switch (b[3]) {
                            case 32: {
                                if (b[5] == 0) {
                                    sparseArray.put(5, (Object)b[4]);
                                }
                                return sparseArray;
                            }
                            case 33: {
                                if (b[5] < 0 || b[5] > 60) break;
                                int timeSecond = b[4] * 60 + b[5];
                                sparseArray.put(6, (Object)timeSecond);
                                return sparseArray;
                            }
                            case 35: {
                                if (b[5] >= 0 && b[5] <= 60) {
                                    int timeSecond = b[4] * 60 + b[5];
                                    sparseArray.put(7, (Object)timeSecond);
                                    return sparseArray;
                                }
                            }
                            case 34: {
                                if (b[5] < 0 || b[5] > 60) break;
                                int timeSecond = b[4] * 60 + b[5];
                                sparseArray.put(8, (Object)timeSecond);
                                return sparseArray;
                            }
                            case 36: {
                                if (b[5] < 0 || b[5] > 60) break;
                                int timeSecond = b[4] * 60 + b[5];
                                sparseArray.put(9, (Object)timeSecond);
                                return sparseArray;
                            }
                            case 37: {
                                if (b[5] < 0 || b[5] > 60) break;
                                int timeSecond = b[4] * 60 + b[5];
                                sparseArray.put(10, (Object)timeSecond);
                                return sparseArray;
                            }
                            case 38: {
                                sparseArray.put(13, (Object)true);
                                return sparseArray;
                            }
                        }
                    }
                }
                block14 : switch (b[1]) {
                    case 4: {
                        switch (b[6]) {
                            case -54: {
                                sparseArray.put(0, (Object)this.getDataFromType04(b));
                                break block14;
                            }
                            case -50: {
                                sparseArray.put(0, (Object)this.getDataFromType04(b));
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (b[6]) {
                            case -54: {
                                sparseArray.put(0, (Object)this.getDataFromType05(b));
                                break block14;
                            }
                            case -50: {
                                sparseArray.put(0, (Object)this.getDataFromType05(b));
                            }
                        }
                    }
                }
            }
        } else if (b[0] == CHECK_BM[0] && b[1] == CHECK_BM[1]) {
            if (this.encryptBytes != null) {
                boolean isAuth = this.compareBytes(b, this.encryptBytes);
                sparseArray.put(3, (Object)isAuth);
                this.encryptBytes = null;
            } else {
                L.i(TAG, "\u63e1\u624b\u5df2\u5b8c\u6210/\u672a\u5f00\u59cb:" + ParseData.arr2Str(b));
            }
        } else {
            L.i(TAG, "\u900f\u4f20\u6307\u4ee4:" + ParseData.arr2Str(b));
            sparseArray.put(14, (Object)b);
        }
        return sparseArray;
    }

    public FoodData getDataFromType04Test(byte[] b) {
        return this.getDataFromType04(b);
    }

    private FoodData getDataFromType04(byte[] b) {
        FoodData foodData = new FoodData();
        double weight = ParseData.getData(2, 3, b) / 10.0;
        String str = ParseData.byteToBit(b[5]);
        int flag = Integer.parseInt(str.substring(str.length() - 1, str.length()));
        foodData.setUnit(this.unitType);
        switch (this.unitType) {
            case 3: {
                foodData.setData(String.valueOf(ParseData.g2oz(weight, 2)));
                break;
            }
            case 2: {
                foodData.setData(ParseData.g2lb(weight, 2));
                break;
            }
            case 4: {
                foodData.setData(ParseData.g2kg(weight, 2));
                break;
            }
            case 5: {
                foodData.setData(ParseData.g2fg(weight, 2));
                break;
            }
            case 6: {
                foodData.setData(ParseData.g2mlMilk(weight, 2));
                break;
            }
            case 7: {
                foodData.setData(ParseData.g2mlWater(weight, 2));
                break;
            }
            case 8: {
                foodData.setData(ParseData.g2flozMilk(weight, 2));
                break;
            }
            case 9: {
                foodData.setData(ParseData.g2flozWater(weight, 2));
                break;
            }
            case 0: 
            case 1: {
                foodData.setData(String.valueOf(ParseData.keepDecimal(weight, 2)));
            }
        }
        if (flag == 1) {
            foodData.setData(this.getWeight(foodData));
            weight = 0.0 - weight;
        }
        foodData.setWeight(weight);
        foodData.setDeviceType((byte)4);
        return foodData;
    }

    public FoodData getDataFromType05Test(byte[] b) {
        return this.getDataFromType05(b);
    }

    private FoodData getDataFromType05(byte[] b) {
        FoodData foodData = new FoodData();
        double weight = ParseData.getData(2, 3, 4, b);
        String str = ParseData.byteToBit(b[5]);
        int flag = Integer.parseInt(str.substring(str.length() - 1, str.length()));
        this.setUnitType(ParseData.bitToByte(str.substring(0, 4)));
        byte point = ParseData.bitToByte(str.substring(4, 7));
        switch (point) {
            case 0: {
                this.parseWeight(foodData, weight, 0);
                break;
            }
            case 1: {
                this.parseWeight(foodData, weight / 10.0, 1);
                break;
            }
            case 2: {
                this.parseWeight(foodData, weight / 100.0, 2);
                break;
            }
            case 3: {
                this.parseWeight(foodData, weight / 1000.0, 3);
                break;
            }
            case 4: {
                this.parseWeight(foodData, weight / 10000.0, 4);
                break;
            }
            case 5: {
                this.parseWeight(foodData, weight / 100000.0, 5);
                break;
            }
            case 6: {
                this.parseWeight(foodData, weight / 1000000.0, 6);
                break;
            }
            case 7: {
                this.parseWeight(foodData, weight / 1.0E7, 7);
            }
        }
        if (flag == 1) {
            double result = 0.0 - foodData.getWeight();
            foodData.setData(this.getWeight(foodData));
            foodData.setWeight(result);
        }
        foodData.setUnit(this.unitType);
        foodData.setDeviceType((byte)5);
        return foodData;
    }

    private void parseWeight(FoodData foodData, double weight, int count) {
        switch (this.unitType) {
            case 2: {
                foodData.setData(ParseData.oz2lb(String.valueOf(weight), count));
                foodData.setWeight(Double.parseDouble(ParseData.oz2g(weight, count)));
                break;
            }
            case 3: {
                foodData.setData(ParseData.keepDecimal(weight, count));
                foodData.setWeight(Double.parseDouble(ParseData.oz2g(weight, count)));
                break;
            }
            case 4: {
                foodData.setData(ParseData.keepDecimal(weight, count));
                foodData.setWeight(Double.parseDouble(ParseData.kg2g(weight, count)));
                break;
            }
            case 5: {
                foodData.setData(ParseData.keepDecimal(weight, count));
                foodData.setWeight(Double.parseDouble(ParseData.fg2g(weight, count)));
                break;
            }
            case 6: {
                foodData.setData(ParseData.keepDecimal(weight, count));
                foodData.setWeight(Double.parseDouble(ParseData.ml2gMilk(weight, count)));
                break;
            }
            case 7: {
                foodData.setData(ParseData.keepDecimal(weight, count));
                foodData.setWeight(Double.parseDouble(ParseData.ml2gWater(weight, count)));
                break;
            }
            case 8: {
                foodData.setData(ParseData.keepDecimal(weight, count));
                foodData.setWeight(Double.parseDouble(ParseData.floz2gMilk(weight, count)));
                break;
            }
            case 9: {
                foodData.setData(ParseData.keepDecimal(weight, count));
                foodData.setWeight(Double.parseDouble(ParseData.floz2gWater(weight, count)));
                break;
            }
            case 0: 
            case 1: {
                foodData.setData(ParseData.keepDecimal(weight, count));
                foodData.setWeight(weight);
            }
        }
    }

    @NonNull
    private String getWeight(FoodData foodData) {
        return new StringBuffer().append("-").append(foodData.getData()).toString();
    }

    private String getVersion(byte[] b) {
        String date = ParseData.binaryToHex(b[3]).replace("0x", "");
        String year = String.valueOf(Integer.parseInt(date.substring(0, 1), 16) + 2015);
        String month = ParseData.addZero(String.valueOf(Integer.parseInt(date.substring(1, date.length()), 16)));
        String day = ParseData.addZero(String.valueOf(ParseData.binaryToDecimal(b[4])));
        String version = String.valueOf(ParseData.keepDecimal((float)ParseData.binaryToDecimal(b[5]) / 10.0f, 1));
        return new StringBuffer().append(year).append(month).append(day).append(VERSION_SPILT).append(version).toString();
    }

    int[] getUnits(byte[] b) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int unit = ((b[4] & 0xFF) << 8) + (b[5] & 0xFF);
        for (int i = 0; i < 16; ++i) {
            if ((unit >> i & 1) != 1) continue;
            list.add(i);
        }
        int[] units = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            units[i] = (Integer)list.get(i);
        }
        return units;
    }

    public byte[] initAuthBytes() {
        byte[] authBytes = AicareUtils.initRandomByteArr();
        this.encryptBytes = this.encrypt(Arrays.copyOfRange(authBytes, 2, authBytes.length));
        return authBytes;
    }

    public boolean isVersionOK(String version) {
        return AicareUtils.isVersionOk((String)version);
    }

    public boolean compareAddress(String address) {
        return AicareUtils.compareAddress((String)address);
    }

    private byte[] encrypt(byte[] bytes) {
        return AicareUtils.encrypt((byte[])bytes, (boolean)false);
    }

    private boolean compareBytes(byte[] b1, byte[] b2) {
        return AicareUtils.compareBytes((byte[])b1, (byte[])b2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CmdType {
        public static final byte SET_CAL = -79;
        public static final byte SET_ALL_CAL = -78;
        public static final byte SET_ALL_FAT = -77;
        public static final byte SET_ALL_PRO = -76;
        public static final byte SET_ALL_CAR = -75;
        public static final byte SET_ALL_FIB = -74;
        public static final byte SET_ALL_CHO = -73;
        public static final byte SET_ALL_SOD = -72;
        public static final byte SET_ALL_SUG = -71;
        public static final byte SET_FAT = -70;
        public static final byte SET_PRO = -69;
        public static final byte SET_CAR = -68;
        public static final byte SET_FIB = -67;
        public static final byte SET_CHO = -66;
        public static final byte SET_SOD = -65;
        public static final byte SET_SUG = -32;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResultType {
        public static final int FOOD_DATA = 0;
        public static final int UNIT_TYPE = 1;
        public static final int BLE_VERSION = 2;
        public static final int IS_AUTH = 3;
        public static final int BLE_DID = 4;
        public static final int TIMING = 5;
        public static final int SYN_TIME = 6;
        public static final int TIMING_LESS = 7;
        public static final int SYN_TIME_LESS = 8;
        public static final int TIMING_PAUSE = 9;
        public static final int TIMING_PAUSE_LESS = 10;
        public static final int GET_UNITS = 11;
        public static final int ERR_DATA = 12;
        public static final int STOP_ALARM = 13;
        public static final int PENETRATE_DATA = 14;
    }
}

