/*
 * Decompiled with CFR 0.152.
 */
package cn.net.aicare.pabulumlibrary.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.IllegalFormatFlagsException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseData {
    public static String binaryToHex(byte b) {
        String str = ParseData.byteToBit(b);
        String hexStr = Integer.toHexString(Integer.parseInt(str, 2));
        return "0x" + ParseData.addZero(hexStr.toUpperCase());
    }

    public static String byteToBit(byte b) {
        return "" + (byte)(b >> 7 & 1) + (byte)(b >> 6 & 1) + (byte)(b >> 5 & 1) + (byte)(b >> 4 & 1) + (byte)(b >> 3 & 1) + (byte)(b >> 2 & 1) + (byte)(b >> 1 & 1) + (byte)(b >> 0 & 1);
    }

    public static byte bitToByte(String byteStr) {
        if (null == byteStr) {
            return 0;
        }
        int len = byteStr.length();
        if (!ParseData.isBinary(byteStr)) {
            throw new IllegalFormatFlagsException("Not a binary format");
        }
        byteStr = ParseData.addZero2Binary(byteStr);
        int re = len == 8 ? (byteStr.charAt(0) == '0' ? Integer.parseInt(byteStr, 2) : Integer.parseInt(byteStr, 2) - 256) : Integer.parseInt(byteStr, 2);
        return (byte)re;
    }

    public static double getData(int first, int second, byte[] b) {
        double data = ((b[first] & 0xFF) << 8) + (b[second] & 0xFF);
        return data;
    }

    public static double getData(int first, int second, int three, byte[] b) {
        double data = ((b[first] & 0xFF) << 16) + ((b[second] & 0xFF) << 8) + (b[three] & 0xFF);
        return data;
    }

    public static int binaryToDecimal(byte b) {
        String str = ParseData.byteToBit(b);
        return Integer.parseInt(str, 2);
    }

    public static String addZero2Binary(String str) {
        StringBuffer stringBuffer = new StringBuffer();
        if (str.length() < 4) {
            for (int i = 0; i < 4 - str.length(); ++i) {
                stringBuffer.append("0");
            }
            stringBuffer.append(str);
            return stringBuffer.toString();
        }
        if (str.length() > 4 && str.length() < 8) {
            for (int i = 0; i < 8 - str.length(); ++i) {
                stringBuffer.append("0");
            }
            stringBuffer.append(str);
            return stringBuffer.toString();
        }
        return str;
    }

    public static String addZero(String str) {
        StringBuffer stringBuffer = new StringBuffer();
        if (str.length() == 1) {
            stringBuffer.append("0");
            stringBuffer.append(str);
            return stringBuffer.toString();
        }
        return str;
    }

    public static String arr2Str(byte[] b) {
        if (b == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < b.length; ++i) {
            stringBuffer.append(ParseData.binaryToHex(b[i]));
            if (i == b.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static boolean isBinary(String binary) {
        String str = "^[0-1]+$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(binary);
        return m.matches();
    }

    public static String keepDecimal(double d, int count) {
        StringBuffer formatBuffer = new StringBuffer();
        formatBuffer.append("#####0");
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                if (i == 0) {
                    formatBuffer.append(".");
                }
                formatBuffer.append("0");
            }
        }
        DecimalFormat df = new DecimalFormat(formatBuffer.toString(), new DecimalFormatSymbols(Locale.US));
        return df.format(d);
    }

    public static String oz2lb(String d, int count) {
        StringBuffer stringBuffer = new StringBuffer();
        int lb = (int)(Double.parseDouble(d) / 16.0);
        double oz = Double.parseDouble(d) % 16.0;
        stringBuffer.append(lb);
        stringBuffer.append(":");
        stringBuffer.append(ParseData.keepDecimal(oz, count));
        return stringBuffer.toString();
    }

    public static String g2lb(double d, int count) {
        try {
            return ParseData.oz2lb(ParseData.g2oz(d, count), count);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String g2oz(double d, int count) {
        return ParseData.keepDecimal(d * 0.03527396, count);
    }

    public static String oz2g(double d, int count) {
        return ParseData.keepDecimal(d / 0.03527396, count);
    }

    public static String kg2g(double d, int count) {
        return ParseData.keepDecimal(d * 1000.0, count);
    }

    public static String g2kg(double d, int count) {
        return ParseData.keepDecimal(d / 1000.0, count);
    }

    public static String fg2g(double d, int count) {
        return ParseData.keepDecimal(d * 500.0, count);
    }

    public static String g2fg(double d, int count) {
        return ParseData.keepDecimal(d / 500.0, count);
    }

    public static String g2mlMilk(double d, int count) {
        return ParseData.keepDecimal(d * 0.97, count);
    }

    public static String ml2gMilk(double d, int count) {
        return ParseData.keepDecimal(d / 0.97, count);
    }

    public static String g2mlWater(double d, int count) {
        return ParseData.keepDecimal(d, count);
    }

    public static String ml2gWater(double d, int count) {
        return ParseData.keepDecimal(d, count);
    }

    public static String g2flozMilk(double d, int count) {
        return ParseData.keepDecimal(d * 0.03280351, count);
    }

    public static String floz2gMilk(double d, int count) {
        return ParseData.keepDecimal(d / 0.03280351, count);
    }

    public static String g2flozWater(double d, int count) {
        return ParseData.keepDecimal(d * 0.03381805, count);
    }

    public static String floz2gWater(double d, int count) {
        return ParseData.keepDecimal(d / 0.03381805, count);
    }

    public static String lb2g(String lb, int count) {
        if (lb.contains(":")) {
            String[] lbArr = lb.split(":");
            try {
                double oz = Double.valueOf(lbArr[0]) * 16.0 + Double.valueOf(lbArr[1]);
                return ParseData.oz2g(oz, count);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return "-1";
    }

    public static String lb2oz(String lb, int count) {
        if (lb.contains(":")) {
            String[] lbArr = lb.split(":");
            try {
                return ParseData.keepDecimal(Double.valueOf(lbArr[0]) * 16.0 + Double.valueOf(lbArr[1]), count);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return "-1";
    }

    public static byte[] int2Bytes(long i, int length) {
        if (length == 2) {
            return new byte[]{(byte)(i >> 8 & 0xFFL), (byte)(i & 0xFFL)};
        }
        if (length == 4) {
            return new byte[]{(byte)(i >> 24 & 0xFFL), (byte)(i >> 16 & 0xFFL), (byte)(i >> 8 & 0xFFL), (byte)(i & 0xFFL)};
        }
        return null;
    }
}

