/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.data;

import com.jieli.jl_rcsp.interfaces.data.OnDataEventCallback;
import com.jieli.jl_rcsp.interfaces.data.OnDataTransferListener;
import com.jieli.jl_rcsp.model.data.ReadParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ReadDataCache
extends ReadParams {
    private final ByteArrayOutputStream mOutputStream;
    private OnDataTransferListener mListener;
    private OnDataEventCallback mCallback;
    private int offset;
    private int seq;

    public ReadDataCache(ReadParams readParams) {
        ByteArrayOutputStream byteArrayOutputStream;
        ReadParams readParams2 = readParams;
        int n = readParams2.getDataType();
        int n2 = readParams2.getVersion();
        int n3 = readParams2.getSendLimit();
        int n4 = readParams2.getReceiveLimit();
        int n5 = readParams2.getDataLen();
        short s = readParams2.getCrc();
        super(n, n2, n3, n4, n5, s);
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        this.mOutputStream = byteArrayOutputStream2;
        this.seq = -1;
    }

    public void resetBuf() {
        this.mOutputStream.reset();
    }

    public boolean putData(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            try {
                this.mOutputStream.write(byArray);
                return true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public byte[] getOutputData() {
        return this.mOutputStream.toByteArray();
    }

    public void setListener(OnDataTransferListener onDataTransferListener) {
        this.mListener = onDataTransferListener;
    }

    public OnDataTransferListener getListener() {
        return this.mListener;
    }

    public OnDataEventCallback getCallback() {
        return this.mCallback;
    }

    public void setCallback(OnDataEventCallback onDataEventCallback) {
        this.mCallback = onDataEventCallback;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int n) {
        this.seq = n;
    }
}

