/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.watch.fatfs;

import android.bluetooth.BluetoothDevice;
import com.jieli.jl_fatfs.FatFileSystem;
import com.jieli.jl_fatfs.interfaces.IBluetoothCtrl;
import com.jieli.jl_rcsp.constant.WatchConstant;
import com.jieli.jl_rcsp.impl.RcspOpImpl;
import com.jieli.jl_rcsp.interfaces.rcsp.RcspCommandCallback;
import com.jieli.jl_rcsp.interfaces.watch.OnWatchOpCallback;
import com.jieli.jl_rcsp.model.base.BaseError;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.command.external_flash.ExtFlashIOCtrlNoResponseCmd;
import com.jieli.jl_rcsp.model.command.external_flash.ExternalFlashIOCtrlCmd;
import com.jieli.jl_rcsp.model.parameter.ExternalFlashIOCtrlParam;
import com.jieli.jl_rcsp.model.response.ExternalFlashIOCtrlResponse;
import com.jieli.jl_rcsp.tool.DeviceStatusManager;
import com.jieli.jl_rcsp.tool.WatchCacheManager;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.CommandBuilder;
import com.jieli.jl_rcsp.util.CryptoUtil;
import com.jieli.jl_rcsp.util.JL_Log;
import com.jieli.jl_rcsp.util.RcspUtil;
import com.jieli.jl_rcsp.watch.fatfs.FatFsWatch;

public class FatFsBluetoothImp
implements IBluetoothCtrl {
    private static final String e = "FatFsBluetoothImp";
    private final RcspOpImpl a;
    private final FatFsWatch b;
    private final DeviceStatusManager c;
    private final WatchCacheManager d;

    public FatFsBluetoothImp(FatFsWatch fatFsWatch) {
        FatFsBluetoothImp fatFsBluetoothImp = this;
        this.c = DeviceStatusManager.getInstance();
        this.b = fatFsWatch;
        fatFsBluetoothImp.a = fatFsWatch.getRcspOp();
        fatFsBluetoothImp.d = new WatchCacheManager();
    }

    private int b(BluetoothDevice bluetoothDevice) {
        FatFsBluetoothImp fatFsBluetoothImp = fatFsBluetoothImp.c.getExtFlashMsg(bluetoothDevice);
        if (fatFsBluetoothImp == null) {
            return 0;
        }
        return fatFsBluetoothImp.getBlockSize();
    }

    private int d(BluetoothDevice bluetoothDevice) {
        FatFsBluetoothImp fatFsBluetoothImp = fatFsBluetoothImp.c.getExtFlashMsg(bluetoothDevice);
        if (fatFsBluetoothImp == null) {
            return 0;
        }
        return fatFsBluetoothImp.getReceiveMtu();
    }

    private void a(BluetoothDevice bluetoothDevice, int n, byte[] byArray) {
        int n2 = this.b(bluetoothDevice);
        if (n2 == 0) {
            this.a(bluetoothDevice, "handleWriteFatData :: mtu is 0 .");
            return;
        }
        FatFileSystem fatFileSystem = this.e(bluetoothDevice);
        if (fatFileSystem != null && !fatFileSystem.writeBufferIsEmpty()) {
            if (byArray.length <= n2) {
                n2 = 0;
            } else {
                byte[] byArray2 = byArray;
                byArray = new byte[n2];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
                n2 = 1;
            }
            this.a(bluetoothDevice, n2, n, byArray);
            return;
        }
        this.a(bluetoothDevice, "handleWriteFatData :: fatFs is null or write buffer is empty.");
    }

    private void a(BluetoothDevice bluetoothDevice, String string) {
        JL_Log.w((String)e, (String)("updateWriteFailed : " + string));
        this.b(bluetoothDevice, false);
    }

    private void b(BluetoothDevice bluetoothDevice, boolean bl) {
        if (!RcspUtil.deviceEquals((BluetoothDevice)bluetoothDevice, (BluetoothDevice)this.a.getTargetDevice())) {
            return;
        }
        JL_Log.w((String)e, (String)("updateWriteResult : " + bl));
        if (this.b.getWatchSystem() != null) {
            this.b.getWatchSystem().updateWriteStatus(bl);
        }
    }

    private void a(BluetoothDevice bluetoothDevice, int n, int n2, byte[] byArray) {
        RcspCommandCallback<ExtFlashIOCtrlNoResponseCmd> rcspCommandCallback;
        JL_Log.d((String)e, (String)("-writeDataToDevice- :: device =" + RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice) + ", offset = " + n2 + ", flag = " + n));
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        bluetoothDevice = CommandBuilder.buildExternalFlashWriteDataCmd((int)n, (int)n2, (byte[])byArray);
        RcspCommandCallback<ExtFlashIOCtrlNoResponseCmd> rcspCommandCallback2 = rcspCommandCallback;
        rcspCommandCallback = new RcspCommandCallback<ExtFlashIOCtrlNoResponseCmd>(){

            public void onCommandResponse(BluetoothDevice bluetoothDevice, ExtFlashIOCtrlNoResponseCmd extFlashIOCtrlNoResponseCmd) {
                Object object = FatFsBluetoothImp.this.e(bluetoothDevice);
                if (object != null && !((FatFileSystem)object).writeBufferIsEmpty()) {
                    ExternalFlashIOCtrlParam externalFlashIOCtrlParam = (ExternalFlashIOCtrlParam)extFlashIOCtrlNoResponseCmd.getParam();
                    int n = externalFlashIOCtrlParam.getData().length;
                    Object[] objectArray = new Object[3];
                    Object[] objectArray2 = objectArray;
                    objectArray2[0] = RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice);
                    objectArray2[1] = extFlashIOCtrlNoResponseCmd;
                    objectArray[2] = n;
                    JL_Log.d((String)e, (String)RcspUtil.formatString((String)">>>> writeDataToDevice :: device = %s, ctrlCmd = %s, dataLen = %d", (Object[])objectArray2));
                    ((FatFileSystem)object).callbackProgress(n);
                    int n2 = externalFlashIOCtrlParam.getOffset();
                    if (!externalFlashIOCtrlParam.isFinalData()) {
                        int n3 = n2 + n;
                        object = ((FatFileSystem)object).getWriteLeftData();
                        Object[] objectArray3 = new Object[2];
                        Object[] objectArray4 = objectArray3;
                        objectArray4[0] = n2;
                        objectArray3[1] = n3;
                        JL_Log.i((String)e, (String)RcspUtil.formatString((String)"writeDataToDevice :: oldOffset = %d, offset = %d", (Object[])objectArray4));
                        FatFsBluetoothImp.this.a(bluetoothDevice, n3, (byte[])object);
                    } else if (!FatFsBluetoothImp.this.a(n2)) {
                        FatFsBluetoothImp.this.a(bluetoothDevice, 0);
                    } else {
                        FatFsBluetoothImp.this.a(bluetoothDevice);
                    }
                    return;
                }
                FatFsBluetoothImp.this.a(bluetoothDevice, "writeDataToDevice : fatFs is null or write buffer is empty.");
            }

            public void onErrCode(BluetoothDevice bluetoothDevice, BaseError baseError) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice);
                objectArray[1] = baseError;
                objectArray2.FatFsBluetoothImp.this.a(bluetoothDevice, RcspUtil.formatString((String)"writeDataToDevice :: device = %s, error = %s", (Object[])objectArray2));
            }
        };
        this.a.sendRcspCommand(bluetoothDevice2, (CommandBase)bluetoothDevice, (RcspCommandCallback)rcspCommandCallback2);
    }

    private void b(BluetoothDevice bluetoothDevice, int n, int n2, byte[] byArray) {
        RcspCommandCallback<ExtFlashIOCtrlNoResponseCmd> rcspCommandCallback;
        JL_Log.d((String)e, (String)("-writeDataToDeviceModify- :: device =" + RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice) + ", offset = " + n2 + ", flag = " + n));
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        bluetoothDevice = CommandBuilder.buildExternalFlashWriteDataCmd((int)n, (int)n2, (byte[])byArray);
        RcspCommandCallback<ExtFlashIOCtrlNoResponseCmd> rcspCommandCallback2 = rcspCommandCallback;
        rcspCommandCallback = new RcspCommandCallback<ExtFlashIOCtrlNoResponseCmd>(){

            public void onCommandResponse(BluetoothDevice bluetoothDevice, ExtFlashIOCtrlNoResponseCmd extFlashIOCtrlNoResponseCmd) {
                FatFileSystem fatFileSystem = FatFsBluetoothImp.this.e(bluetoothDevice);
                if (fatFileSystem != null && !fatFileSystem.writeBufferIsEmpty()) {
                    ExternalFlashIOCtrlParam externalFlashIOCtrlParam = (ExternalFlashIOCtrlParam)extFlashIOCtrlNoResponseCmd.getParam();
                    int n = externalFlashIOCtrlParam.getData().length;
                    Object[] objectArray = new Object[3];
                    Object[] objectArray2 = objectArray;
                    objectArray2[0] = RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice);
                    objectArray[1] = n;
                    objectArray[2] = extFlashIOCtrlNoResponseCmd;
                    JL_Log.d((String)e, (String)RcspUtil.formatString((String)"-writeDataToDeviceModify- :: device = %s, dataLen = %d, ctrlCmd = %s", (Object[])objectArray2));
                    fatFileSystem.callbackProgress(n);
                    int n2 = externalFlashIOCtrlParam.getOffset();
                    if (externalFlashIOCtrlParam.getFlag() == 1) {
                        int n3 = n2 + n;
                        byte[] byArray = fatFileSystem.getNeedSendLeftData();
                        FatFsBluetoothImp.this.b(bluetoothDevice, n3, byArray);
                    } else if (!FatFsBluetoothImp.this.a(n2)) {
                        FatFsBluetoothImp.this.a(bluetoothDevice, 1);
                    } else {
                        FatFsBluetoothImp.this.a(bluetoothDevice);
                    }
                    return;
                }
                FatFsBluetoothImp.this.a(bluetoothDevice, "writeDataToDeviceModify :: fatFs is null or write buffer is empty.");
            }

            public void onErrCode(BluetoothDevice bluetoothDevice, BaseError baseError) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice);
                objectArray[1] = baseError;
                objectArray2.FatFsBluetoothImp.this.a(bluetoothDevice, RcspUtil.formatString((String)"writeDataToDeviceModify :: device = %s, error = %s", (Object[])objectArray2));
            }
        };
        this.a.sendRcspCommand(bluetoothDevice2, (CommandBase)bluetoothDevice, (RcspCommandCallback)rcspCommandCallback2);
    }

    private void b(BluetoothDevice bluetoothDevice, final int n, final byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            int n2 = this.b(bluetoothDevice);
            if (n2 == 0) {
                this.a(bluetoothDevice, "handleWriteFatDataModify :: mtu is 0 .");
                return;
            }
            final FatFileSystem fatFileSystem = this.e(bluetoothDevice);
            if (fatFileSystem != null && !fatFileSystem.writeBufferIsEmpty()) {
                int n3 = fatFileSystem.getLeftDevSize();
                JL_Log.i((String)e, (String)("handleWriteFatDataModify :: lefDevSize = " + n3 + ", mtu = " + n2 + ", leftData length = " + byArray.length));
                if (n3 < n2) {
                    RcspCommandCallback<ExternalFlashIOCtrlCmd> rcspCommandCallback;
                    n2 = CryptoUtil.CRC16((byte[])fatFileSystem.getNeedWriteData(), (short)0);
                    BluetoothDevice bluetoothDevice2 = bluetoothDevice;
                    bluetoothDevice = CommandBuilder.buildExternalFlashQueryWriteResultCmd((int)1, (short)n2);
                    RcspCommandCallback<ExternalFlashIOCtrlCmd> rcspCommandCallback2 = rcspCommandCallback;
                    rcspCommandCallback = new RcspCommandCallback<ExternalFlashIOCtrlCmd>(){

                        public void onCommandResponse(BluetoothDevice bluetoothDevice, ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd) {
                            ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd2 = externalFlashIOCtrlCmd;
                            JL_Log.i((String)e, (String)("handleWriteFatDataModify :: onCommandResponse = " + externalFlashIOCtrlCmd));
                            externalFlashIOCtrlCmd = (ExternalFlashIOCtrlResponse)externalFlashIOCtrlCmd2.getResponse();
                            if (externalFlashIOCtrlCmd2.getStatus() == 0 && externalFlashIOCtrlCmd.getResult() == 0) {
                                int n3 = externalFlashIOCtrlCmd.getSize();
                                if (n3 > 0) {
                                    5 v1 = this;
                                    v1.fatFileSystem.setNeedWriteData(n3);
                                    5 v2 = this;
                                    int n2 = v2.n;
                                    v1.FatFsBluetoothImp.this.b(bluetoothDevice, n2, v2.byArray);
                                    return;
                                }
                                JL_Log.e((String)e, (String)"handleWriteFatDataModify :: left size is zero. error data");
                            } else {
                                JL_Log.e((String)e, (String)"handleWriteFatDataModify :: response an bad status");
                            }
                            FatFsBluetoothImp.this.b(bluetoothDevice, false);
                        }

                        public void onErrCode(BluetoothDevice bluetoothDevice, BaseError baseError) {
                            FatFsBluetoothImp.this.a(bluetoothDevice, "handleWriteFatDataModify :: onErrCode = " + baseError);
                        }
                    };
                    this.a.sendRcspCommand(bluetoothDevice2, (CommandBase)bluetoothDevice, (RcspCommandCallback)rcspCommandCallback2);
                } else {
                    if (byArray.length <= n2) {
                        n2 = fatFileSystem.judgeWriteFinish(byArray.length) ^ 1;
                    } else {
                        byte[] byArray2 = byArray;
                        byArray = new byte[n2];
                        System.arraycopy(byArray2, 0, byArray, 0, n2);
                        n2 = 1;
                    }
                    this.b(bluetoothDevice, n2, n, byArray);
                }
                return;
            }
            this.a(bluetoothDevice, "handleWriteFatDataModify :: fatfs is null or write buffer is empty.");
            return;
        }
        this.a(bluetoothDevice, "handleWriteFatDataModify :: data is null.");
    }

    private void a(BluetoothDevice bluetoothDevice, final int n) {
        RcspCommandCallback<ExternalFlashIOCtrlCmd> rcspCommandCallback;
        int n2;
        short s;
        final FatFileSystem fatFileSystem = this.e(bluetoothDevice);
        if (fatFileSystem == null) {
            this.a(bluetoothDevice, "queryWriteDataResult : fatFs is null.");
            return;
        }
        if (n == 1) {
            s = CryptoUtil.CRC16((byte[])fatFileSystem.getNeedWriteData(), (short)0);
            n2 = 1;
        } else {
            s = fatFileSystem.getCrc16();
            n2 = 0;
        }
        JL_Log.e((String)e, (String)("-queryWriteDataResult- version = " + n + ", crc16 = " + s + ", hex str = " + CHexConver.byte2HexStr((byte[])CHexConver.shortToBigBytes((short)s)) + ", flag = " + n2));
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        bluetoothDevice = CommandBuilder.buildExternalFlashQueryWriteResultCmd((int)n2, (short)s);
        RcspCommandCallback<ExternalFlashIOCtrlCmd> rcspCommandCallback2 = rcspCommandCallback;
        rcspCommandCallback = new RcspCommandCallback<ExternalFlashIOCtrlCmd>(){

            public void onCommandResponse(BluetoothDevice bluetoothDevice, ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd) {
                ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd2 = externalFlashIOCtrlCmd;
                ExternalFlashIOCtrlResponse externalFlashIOCtrlResponse = (ExternalFlashIOCtrlResponse)externalFlashIOCtrlCmd2.getResponse();
                JL_Log.w((String)e, (String)("queryWriteDataResult :: FlashQueryWriteResultCmd  = " + externalFlashIOCtrlCmd));
                if (externalFlashIOCtrlCmd2.getStatus() == 0 && externalFlashIOCtrlResponse.getResult() == 0) {
                    if (n == 1) {
                        fatFileSystem.setNeedWriteData(externalFlashIOCtrlResponse.getSize());
                    }
                    FatFsBluetoothImp.this.b(bluetoothDevice, true);
                } else {
                    FatFsBluetoothImp.this.a(bluetoothDevice, "queryWriteDataResult :: ExternalFlashQueryWriteResult response bad status. ");
                }
            }

            public void onErrCode(BluetoothDevice bluetoothDevice, BaseError baseError) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice);
                objectArray[1] = baseError;
                objectArray2.FatFsBluetoothImp.this.a(bluetoothDevice, RcspUtil.formatString((String)"queryWriteDataResult :: ExternalFlashQueryWriteResult >> device = %s, error = %s", (Object[])objectArray2));
            }
        };
        this.a.sendRcspCommand(bluetoothDevice2, (CommandBase)bluetoothDevice, (RcspCommandCallback)rcspCommandCallback2);
    }

    private void a(BluetoothDevice bluetoothDevice) {
        FatFileSystem fatFileSystem = this.e(bluetoothDevice);
        if (fatFileSystem == null) {
            this.a(bluetoothDevice, "checkWriteDataResult :: fatFs is null");
            return;
        }
        WatchCacheManager.WatchCache watchCache = this.d.getWatchCacheByDevice(bluetoothDevice);
        if (watchCache == null) {
            this.a(bluetoothDevice, "checkWriteDataResult :: cache is null");
            return;
        }
        WatchCacheManager.WatchCache watchCache2 = watchCache;
        WatchCacheManager.WatchCache watchCache3 = watchCache;
        watchCache3.setNeedCheckReadData(true);
        fatFileSystem.createReadBuffer(watchCache3.getWriteLen());
        int n = watchCache2.getWriteOffset();
        this.a(bluetoothDevice, n, watchCache2.getWriteLen());
    }

    private void a(BluetoothDevice bluetoothDevice, int n, int n2) {
        int n3 = this.d(bluetoothDevice);
        if (n3 == 0) {
            n3 = this.b(bluetoothDevice);
        }
        if (n3 == 0) {
            JL_Log.w((String)e, (String)"handleReadData :: mtu is 0");
            this.a(bluetoothDevice, false, new byte[0]);
            return;
        }
        JL_Log.d((String)e, (String)("handleReadData :: offset = " + n + ", size = " + n2));
        if (n2 <= n3) {
            this.a(bluetoothDevice, 0, n, n2);
        } else {
            this.a(bluetoothDevice, 1, n, n3);
        }
    }

    private void a(BluetoothDevice bluetoothDevice, boolean bl, byte[] byArray) {
        Object object = this.e(bluetoothDevice);
        if (object == null) {
            return;
        }
        String string = e;
        JL_Log.d((String)string, (String)("updateReadResult :: device : " + RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice) + ", isSuccess : " + bl));
        if (WatchConstant.ENABLE_WRITE_DATA_CHECK && this.d.isNeedCheckReadData(bluetoothDevice)) {
            object = this.d.removeWatchCacheByDevice(bluetoothDevice);
            if (bl) {
                short s = CryptoUtil.CRC16((byte[])byArray, (short)0);
                JL_Log.i((String)string, (String)("updateReadResult :: readCrc16 : " + s + ", cacheCrc16 : " + ((WatchCacheManager.WatchCache)object).getCrc16() + ", cache offset = " + ((WatchCacheManager.WatchCache)object).getWriteOffset()));
                if (((WatchCacheManager.WatchCache)object).getCrc16() == s) {
                    bl = this.d(bluetoothDevice) != 0;
                    this.a(bluetoothDevice, bl ? 1 : 0);
                    return;
                }
            }
            JL_Log.w((String)string, (String)("updateReadResult ::  " + bl + ", crc is error. "));
            this.b(bluetoothDevice, false);
            return;
        }
        ((FatFileSystem)object).updateReadStatus(bl, byArray);
    }

    private void a(BluetoothDevice bluetoothDevice, int n, int n2, int n3) {
        RcspCommandCallback<ExternalFlashIOCtrlCmd> rcspCommandCallback;
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice);
        objectArray2[1] = n;
        objectArray2[2] = n2;
        objectArray[3] = n3;
        JL_Log.d((String)e, (String)RcspUtil.formatString((String)"readDataFromDevice :: device = %s, flag = %d, offset=%d, size=%s", (Object[])objectArray2));
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        bluetoothDevice = CommandBuilder.buildExternalFlashReadDataCmd((int)n, (int)n2, (int)n3);
        RcspCommandCallback<ExternalFlashIOCtrlCmd> rcspCommandCallback2 = rcspCommandCallback;
        rcspCommandCallback = new RcspCommandCallback<ExternalFlashIOCtrlCmd>(){

            public void onCommandResponse(BluetoothDevice bluetoothDevice, ExternalFlashIOCtrlCmd object) {
                FatFileSystem fatFileSystem = object4.FatFsBluetoothImp.this.e(bluetoothDevice);
                if (fatFileSystem != null && !fatFileSystem.readBufferIsEmpty()) {
                    Object object2 = object;
                    Object object3 = (ExternalFlashIOCtrlResponse)object2.getResponse();
                    Object[] objectArray = new Object[2];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice);
                    objectArray[1] = object;
                    JL_Log.d((String)e, (String)RcspUtil.formatString((String)"readDataFromDevice :: device = %s, ctrlCmd = %s", (Object[])objectArray2));
                    if (object2.getStatus() == 0 && object3.getResult() == 0) {
                        object = (ExternalFlashIOCtrlParam)object.getParam();
                        byte[] byArray = object3.getData();
                        object3 = byArray;
                        int n = object.getOffset();
                        if (byArray != null && ((ExternalFlashIOCtrlResponse)object3).length > 0) {
                            fatFileSystem.putDataInReadBuff((byte[])object3);
                            n += ((ExternalFlashIOCtrlResponse)object3).length;
                        }
                        if (!object.isFinalData()) {
                            int n2 = fatFileSystem.getReadLeftSize();
                            object4.FatFsBluetoothImp.this.a(bluetoothDevice, n, n2);
                        } else {
                            7 v3 = object4;
                            Object object4 = fatFileSystem.getReadBuffer();
                            v3.FatFsBluetoothImp.this.a(bluetoothDevice, true, (byte[])object4);
                        }
                        return;
                    }
                    JL_Log.w((String)e, (String)("readDataFromDevice :: readDataFromExternalFlash response bad status. ctrlCmd : " + object));
                    object4.FatFsBluetoothImp.this.a(bluetoothDevice, false, new byte[0]);
                    return;
                }
                object = e;
                StringBuilder stringBuilder = new StringBuilder().append("readDataFromDevice :: fatfs = ").append(fatFileSystem).append(", readBufferIsEmpty : ");
                boolean bl = fatFileSystem != null && fatFileSystem.readBufferIsEmpty();
                JL_Log.w((String)object, (String)stringBuilder.append(bl).toString());
                object4.FatFsBluetoothImp.this.a(bluetoothDevice, false, new byte[0]);
            }

            public void onErrCode(BluetoothDevice bluetoothDevice, BaseError baseError) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[2];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice);
                objectArray2[1] = baseError;
                JL_Log.w((String)e, (String)RcspUtil.formatString((String)"readDataFromDevice >> onErrCode :: device = %s, error = %s", (Object[])objectArray3));
                objectArray.FatFsBluetoothImp.this.a(bluetoothDevice, false, new byte[0]);
            }
        };
        this.a.sendRcspCommand(bluetoothDevice2, (CommandBase)bluetoothDevice, (RcspCommandCallback)rcspCommandCallback2);
    }

    private FatFileSystem e(BluetoothDevice bluetoothDevice) {
        if (RcspUtil.deviceEquals((BluetoothDevice)bluetoothDevice, (BluetoothDevice)this.a.getTargetDevice())) {
            return this.b.getWatchSystem();
        }
        return null;
    }

    private int c(BluetoothDevice bluetoothDevice) {
        FatFsBluetoothImp fatFsBluetoothImp = fatFsBluetoothImp.c.getExtFlashMsg(bluetoothDevice);
        if (fatFsBluetoothImp == null) {
            return 0;
        }
        return fatFsBluetoothImp.getCluster();
    }

    private void a(BluetoothDevice bluetoothDevice, boolean bl) {
        if ((this = ((FatFsBluetoothImp)this).e(bluetoothDevice)) == null) {
            return;
        }
        ((FatFileSystem)this).updateFlagStatus(bl);
    }

    private boolean a(int n) {
        return WatchConstant.ENABLE_WRITE_DATA_CHECK && n >= 8192 && n <= 16384;
    }

    @Override
    public BluetoothDevice getConnectedDevice() {
        return this.a.getTargetDevice();
    }

    @Override
    public void writeFatDataToDevice(BluetoothDevice bluetoothDevice, int n, byte[] byArray) {
        String string = e;
        Object[] objectArray = new Object[3];
        Object object = objectArray;
        object[0] = RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice);
        object[1] = n;
        objectArray[2] = CHexConver.byte2HexStr((byte[])byArray);
        JL_Log.d((String)string, (String)RcspUtil.formatString((String)">>>>>> writeFatDataToDevice :: device = %s, offset = %d, \ndata = %s", (Object[])object));
        object = this.e(bluetoothDevice);
        if (object == null) {
            this.a(bluetoothDevice, "writeFatDataToDevice >> fatFs is null.");
            return;
        }
        ((FatFileSystem)object).setWriteBuffer(byArray);
        if (this.a(n)) {
            this.d.putWatchCacheByDevice(bluetoothDevice, new WatchCacheManager.WatchCache().setWriteOffset(n).setWriteLen(byArray.length).setCrc16(CryptoUtil.CRC16((byte[])byArray, (short)0)));
        }
        if (this.d(bluetoothDevice) != 0) {
            int n2 = ((FatFileSystem)object).getLeftDevSize();
            JL_Log.i((String)string, (String)("-writeFatDataToDevice-  leftDevSize ==> " + n2));
            if (n2 > 0) {
                Object object2 = object;
                ((FatFileSystem)object2).setNeedWriteData(n2);
                byArray = ((FatFileSystem)object2).getNeedSendLeftData();
            }
            this.b(bluetoothDevice, n, byArray);
            return;
        }
        this.a(bluetoothDevice, n, byArray);
    }

    @Override
    public void readFatDataFromDevice(BluetoothDevice bluetoothDevice, int n, int n2) {
        String string = e;
        Object[] objectArray = new Object[3];
        Object object = objectArray;
        object[0] = RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice);
        object[1] = n;
        objectArray[2] = n2;
        JL_Log.d((String)string, (String)RcspUtil.formatString((String)"readFatDataFromDevice :: device = %s, offset = %d, size = %d", (Object[])object));
        object = ((FatFsBluetoothImp)object2).e(bluetoothDevice);
        if (object == null) {
            FatFsBluetoothImp fatFsBluetoothImp = object2;
            JL_Log.w((String)string, (String)"readFatDataFromDevice :: fatFs is null");
            Object object2 = new byte[0];
            fatFsBluetoothImp.a(bluetoothDevice, false, (byte[])object2);
            return;
        }
        ((FatFileSystem)object).createReadBuffer(n2);
        ((FatFsBluetoothImp)object2).a(bluetoothDevice, n, n2);
    }

    @Override
    public void sendWriteFlag(final BluetoothDevice bluetoothDevice, boolean bl) {
        OnWatchOpCallback<Boolean> onWatchOpCallback;
        String string = e;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice);
        objectArray[1] = bl;
        JL_Log.d((String)string, (String)RcspUtil.formatString((String)"sendWriteFlag :: device = %s, writeFlag = %s", (Object[])objectArray2));
        if (this.e(bluetoothDevice) == null) {
            JL_Log.w((String)string, (String)"sendWriteFlag :: fatFs is null");
            this.a(bluetoothDevice, false);
            return;
        }
        OnWatchOpCallback<Boolean> onWatchOpCallback2 = onWatchOpCallback;
        onWatchOpCallback = new OnWatchOpCallback<Boolean>(){

            @Override
            public void onSuccess(Boolean bl) {
                FatFsBluetoothImp.this.a(bluetoothDevice, true);
            }

            @Override
            public void onFailed(BaseError baseError) {
                FatFsBluetoothImp.this.a(bluetoothDevice, false);
            }
        };
        this.b.sendWriteProtectFlag(bl, onWatchOpCallback2);
    }

    @Override
    public void release() {
        this.d.destroy();
    }
}

