/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.command.file_op;

import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.model.base.CommandWithParamAndResponse;
import com.jieli.jl_rcsp.model.base.CommonResponse;
import com.jieli.jl_rcsp.util.CHexConver;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SmallFileTransferCmd
extends CommandWithParamAndResponse<Param, Response> {
    public static final byte TYPE_CONTACTS = 1;
    public static final byte TYPE_SPORTS_RECORD = 2;
    public static final byte TYPE_HEART_RATE = 3;
    public static final byte TYPE_BLOOD_OXYGEN = 4;
    public static final byte TYPE_SLEEP = 5;
    public static final byte TYPE_MESSAGE_SYNC = 6;
    public static final byte TYPE_WEATHER = 7;
    public static final byte TYPE_CALL_LOG = 8;
    public static final byte TYPE_STEP = 9;
    public static final byte OP_QUERY_BY_TYPE = 0;
    public static final byte OP_READ_FILE = 1;
    public static final byte OP_ADD_FILE = 2;
    public static final byte OP_UPDATE_FILE = 3;
    public static final byte OP_DELETE_FILE = 4;
    public static final byte FLAG_FIRST_PACKET = 1;

    public SmallFileTransferCmd(Param param) {
        super(40, SmallFileTransferCmd.class.getSimpleName(), param);
    }

    public static class ResultResponse
    extends Response {
        public byte ret;

        public ResultResponse(byte by) {
            this.ret = by;
        }
    }

    public static class AddFileResponse
    extends ResultResponse {
        public short id;

        public AddFileResponse(byte[] byArray) {
            super(byArray[0]);
            if (byArray.length >= 3) {
                this.id = CHexConver.bytesToShort(byArray[1], byArray[2]);
            }
        }
    }

    public static class ReadFileResponse
    extends Response {
        public byte ret;
        public byte[] fileData;
        public short crc;

        public ReadFileResponse(byte[] byArray) {
            ((ReadFileResponse)object).ret = byArray[0];
            if (((ReadFileResponse)object).ret == 0) {
                ReadFileResponse readFileResponse = object;
                ((ReadFileResponse)object).fileData = new byte[byArray.length - 3];
                readFileResponse.crc = CHexConver.bytesToShort(byArray[1], byArray[2]);
                Object object = readFileResponse.fileData;
                int n = readFileResponse.fileData.length;
                System.arraycopy(byArray, 3, object, 0, n);
            }
        }
    }

    public static class QueryResponse
    extends Response {
        private final byte version;
        private final List<File> files;

        public QueryResponse(byte by, byte[] byArray) {
            QueryResponse queryResponse = this;
            queryResponse.version = byArray[0];
            queryResponse.files = new ArrayList<File>();
            int n = 1;
            while (n < byArray.length) {
                File file;
                if (this.version != 0) continue;
                short s = CHexConver.bytesToShort(byArray[n], byArray[n + 1]);
                int n2 = CHexConver.bytesToInt(byArray[n + 2], byArray[n + 3]);
                File file2 = file;
                file = new File(by, s, n2);
                this.files.add(file2);
                n += 4;
            }
        }

        public List<File> getFiles() {
            return this.files;
        }

        public static class File {
            public short id;
            public int size;
            public byte type;

            public File(byte by, short s, int n) {
                this.type = by;
                this.id = s;
                this.size = n;
            }
        }
    }

    public static class Response
    extends CommonResponse {
    }

    public static class DeleteFileParam
    extends Param {
        public DeleteFileParam(byte by, short s) {
            super((byte)4, ByteBuffer.allocate(3).put(by).putShort(s).array());
        }
    }

    public static class UpdateFileParam
    extends Param {
        public UpdateFileParam(byte by, short s, short s2, short s3, byte[] byArray, short s4) {
            super((byte)3, ByteBuffer.allocate(byArray.length + 9).put(by).putShort(s).putShort(s2).putShort(s3).putShort(s4).put(byArray).array());
        }
    }

    public static class AddFileParam
    extends Param {
        public AddFileParam(byte by, short s, short s2, byte[] byArray, short s3) {
            super((byte)2, ByteBuffer.allocate(byArray.length + 7).put(by).putShort(s).putShort(s2).put(CHexConver.shortToBigBytes(s3)).put(byArray).array());
        }
    }

    public static class ReadFileParam
    extends Param {
        public ReadFileParam(byte by, short s, short s2, short s3, byte by2) {
            super((byte)1, ByteBuffer.allocate(8).put(by).putShort(s).putShort(s2).putShort(s3).put(by2).array());
        }
    }

    public static class QueryParam
    extends Param {
        public QueryParam(byte by) {
            QueryParam queryParam = object;
            byte[] byArray = new byte[1];
            Object object = byArray;
            byArray[0] = by;
            super((byte)0, (byte[])object);
        }
    }

    public static class Param
    extends BaseParameter {
        public byte op;
        public byte[] data;

        public Param(byte by, byte[] byArray) {
            this.op = by;
            this.data = byArray;
        }

        @Override
        public byte[] getParamData() {
            return ByteBuffer.allocate(this.data.length + 1).put(this.op).put(this.data).array();
        }
    }
}

