/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.command.nfc;

import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.model.base.CommandWithParamAndResponse;
import com.jieli.jl_rcsp.model.base.CommonResponse;
import com.jieli.jl_rcsp.util.CHexConver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class NFCOperationCmd
extends CommandWithParamAndResponse<Param, Response> {
    public NFCOperationCmd(Param param) {
        super(164, NFCOperationCmd.class.getSimpleName(), param);
    }

    public static class GetDefaultNfcResponse
    extends Response {
        private final short id;

        public GetDefaultNfcResponse(int n, short s) {
            super(n);
            this.id = s;
        }

        public short getId() {
            return this.id;
        }
    }

    public static class Response
    extends CommonResponse {
        private final int result;

        public Response(int n) {
            this.result = n;
        }

        public int getResult() {
            return this.result;
        }
    }

    public static class InsertFileEndParam
    extends Param {
        private final String fileName;

        public InsertFileEndParam(int n, String string) {
            super(n, 7);
            this.fileName = string;
        }

        public String getFileName() {
            return this.fileName;
        }

        @Override
        public byte[] getParamData() {
            ByteArrayOutputStream byteArrayOutputStream;
            block3: {
                ByteArrayOutputStream byteArrayOutputStream2;
                byteArrayOutputStream = byteArrayOutputStream2;
                byteArrayOutputStream();
                byteArrayOutputStream2.write(super.getParamData());
                String string = ((InsertFileEndParam)((Object)string)).fileName;
                if (string == null) break block3;
                try {
                    byteArrayOutputStream.write(string.getBytes());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static class InsertFileParam
    extends Param {
        private final int fileSize;
        private final String fileName;

        public InsertFileParam(int n, int n2, String string) {
            super(n, 6);
            this.fileSize = n2;
            this.fileName = string;
        }

        public int getFileSize() {
            return this.fileSize;
        }

        public String getFileName() {
            return this.fileName;
        }

        @Override
        public byte[] getParamData() {
            ByteArrayOutputStream byteArrayOutputStream;
            block3: {
                ByteArrayOutputStream byteArrayOutputStream2;
                byteArrayOutputStream = byteArrayOutputStream2;
                byteArrayOutputStream();
                byteArrayOutputStream.write(super.getParamData());
                byteArrayOutputStream2.write(CHexConver.intToBigBytes(((InsertFileParam)((Object)string)).fileSize));
                String string = ((InsertFileParam)((Object)string)).fileName;
                if (string == null) break block3;
                try {
                    byteArrayOutputStream.write(string.getBytes());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static class SetDefaultNfcParam
    extends DefaultNfcParam {
        private final short id;

        public SetDefaultNfcParam(int n, short s) {
            SetDefaultNfcParam setDefaultNfcParam = object;
            Object object = CHexConver.shortToBigBytes(s);
            super(n, 1, (byte[])object);
            setDefaultNfcParam.id = s;
        }

        public short getId() {
            return this.id;
        }
    }

    public static class GetDefaultNfcParam
    extends DefaultNfcParam {
        public GetDefaultNfcParam(int n) {
            super(n, 0, null);
        }
    }

    public static class DefaultNfcParam
    extends Param {
        private final int flag;
        private final byte[] value;

        public DefaultNfcParam(int n, int n2, byte[] byArray) {
            super(n, 5);
            this.flag = n2;
            this.value = byArray;
        }

        public int getFlag() {
            return this.flag;
        }

        public byte[] getValue() {
            return this.value;
        }

        @Override
        public byte[] getParamData() {
            ByteArrayOutputStream byteArrayOutputStream;
            block5: {
                ByteArrayOutputStream byteArrayOutputStream2;
                byteArrayOutputStream = byteArrayOutputStream2;
                byteArrayOutputStream();
                byteArrayOutputStream.write(super.getParamData());
                byte by = (byte)((DefaultNfcParam)object).flag;
                byteArrayOutputStream2.write(by);
                Object object = ((DefaultNfcParam)object).value;
                if (((DefaultNfcParam)object).value == null) break block5;
                if (((Object)object).length <= 0) break block5;
                try {
                    byteArrayOutputStream.write((byte[])object);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static class DeleteMsgParam
    extends Param {
        private final short id;

        public DeleteMsgParam(int n, short s) {
            super(n, 3);
            this.id = s;
        }

        public short getId() {
            return this.id;
        }

        @Override
        public byte[] getParamData() {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            try {
                byteArrayOutputStream2.write(super.getParamData());
                byteArrayOutputStream.write(CHexConver.shortToBigBytes(this.id));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return byteArrayOutputStream2.toByteArray();
        }
    }

    public static class ModifyMsgParam
    extends Param {
        private final short id;
        private final int mask;
        private final byte[] value;

        public ModifyMsgParam(int n, short s, int n2, byte[] byArray) {
            super(n, 2);
            this.id = s;
            this.mask = n2;
            this.value = byArray;
        }

        public short getId() {
            return this.id;
        }

        public int getMask() {
            return this.mask;
        }

        public byte[] getValue() {
            return this.value;
        }

        @Override
        public byte[] getParamData() {
            ByteArrayOutputStream byteArrayOutputStream;
            block4: {
                ByteArrayOutputStream byteArrayOutputStream2;
                byteArrayOutputStream = byteArrayOutputStream2;
                byteArrayOutputStream();
                byteArrayOutputStream.write(super.getParamData());
                byteArrayOutputStream.write(CHexConver.shortToBigBytes(((ModifyMsgParam)object).id));
                byteArrayOutputStream2.write(CHexConver.intToBigBytes(((ModifyMsgParam)object).mask));
                Object object = ((ModifyMsgParam)object).value;
                if (((ModifyMsgParam)object).value == null) break block4;
                if (((Object)object).length <= 0) break block4;
                try {
                    byteArrayOutputStream.write((byte[])object);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static class StartSyncParam
    extends Param {
        public StartSyncParam(int n) {
            super(n, 0);
        }

        @Override
        public byte[] getParamData() {
            return super.getParamData();
        }
    }

    public static class NotifyNfcParam
    extends Param {
        public NotifyNfcParam(int n) {
            super(n, 4);
        }

        @Override
        public byte[] getParamData() {
            return super.getParamData();
        }
    }

    public static class Param
    extends BaseParameter {
        private final int devHandler;
        private final int op;

        public Param(int n, int n2) {
            this.devHandler = n;
            this.op = n2;
        }

        public int getDevHandler() {
            return this.devHandler;
        }

        public int getOp() {
            return this.op;
        }

        @Override
        public byte[] getParamData() {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            byteArrayOutputStream2.write(CHexConver.intToBigBytes(this.devHandler));
            byte by = (byte)this.getOp();
            try {
                byteArrayOutputStream.write(by);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return byteArrayOutputStream2.toByteArray();
        }
    }
}

