/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device;

import com.jieli.jl_rcsp.model.device.AlarmListInfo;
import com.jieli.jl_rcsp.model.device.ChannelInfo;
import com.jieli.jl_rcsp.model.device.DefaultAlarmBell;
import com.jieli.jl_rcsp.model.device.DevStorageInfo;
import com.jieli.jl_rcsp.model.device.EqInfo;
import com.jieli.jl_rcsp.model.device.EqPresetInfo;
import com.jieli.jl_rcsp.model.device.ExpandFunction;
import com.jieli.jl_rcsp.model.device.FmStatusInfo;
import com.jieli.jl_rcsp.model.device.ID3MusicInfo;
import com.jieli.jl_rcsp.model.device.LightControlInfo;
import com.jieli.jl_rcsp.model.device.MusicNameInfo;
import com.jieli.jl_rcsp.model.device.MusicStatusInfo;
import com.jieli.jl_rcsp.model.device.PlayModeInfo;
import com.jieli.jl_rcsp.model.device.VoiceMode;
import com.jieli.jl_rcsp.model.device.health.HealthSettingInfo;
import com.jieli.jl_rcsp.model.device.health.SportsInfo;
import com.jieli.jl_rcsp.model.response.TargetInfoResponse;
import com.jieli.jl_rcsp.util.CHexConver;
import java.util.List;

public class DeviceInfo
extends TargetInfoResponse {
    private AlarmListInfo alarmListInfo;
    private List<DefaultAlarmBell> alarmDefaultBells;
    private int alarmVersion;
    private byte alarmExpandFlag = 0;
    private MusicNameInfo musicNameInfo;
    private MusicStatusInfo musicStatusInfo;
    private PlayModeInfo playModeInfo;
    private boolean isAuxPlay;
    private String playFileFormat;
    private int cluster;
    private byte currentDevIndex;
    private EqPresetInfo eqPresetInfo;
    private EqInfo eqInfo;
    private DevStorageInfo devStorageInfo;
    private LightControlInfo lightControlInfo;
    private EqInfo soundCardEqInfo;
    private List<ChannelInfo> channelInfos;
    private FmStatusInfo fmStatusInfo;
    private float frequency;
    private ID3MusicInfo iD3MusicInfo;
    private VoiceMode currentVoiceMode;
    private List<VoiceMode> voiceModeList;
    private int phoneStatus;
    private ExpandFunction expandFunction;
    private HealthSettingInfo healthSettingInfo;
    private SportsInfo sportsInfo;

    public static DeviceInfo convertFromTargetInfo(TargetInfoResponse targetInfoResponse) {
        if (targetInfoResponse == null) {
            return null;
        }
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setVersionName(targetInfoResponse.getVersionName()).setVersionCode(targetInfoResponse.getVersionCode()).setProtocolVersion(targetInfoResponse.getProtocolVersion()).setEdrAddr(targetInfoResponse.getEdrAddr()).setEdrStatus(targetInfoResponse.getEdrStatus()).setEdrProfile(targetInfoResponse.getEdrProfile()).setBleAddr(targetInfoResponse.getBleAddr()).setBleOnly(targetInfoResponse.isBleOnly()).setPlatform(targetInfoResponse.getPlatform()).setLicense(targetInfoResponse.getLicense()).setVolume(targetInfoResponse.getVolume()).setMaxVol(targetInfoResponse.getMaxVol()).setQuantity(targetInfoResponse.getQuantity()).setLowPowerLimit(targetInfoResponse.getLowPowerLimit()).setFunctionMask(targetInfoResponse.getFunctionMask()).setCurFunction(targetInfoResponse.getCurFunction()).setSdkType(targetInfoResponse.getSdkType()).setName(targetInfoResponse.getName()).setPid(targetInfoResponse.getPid()).setVid(targetInfoResponse.getVid()).setMandatoryUpgradeFlag(targetInfoResponse.getMandatoryUpgradeFlag()).setRequestOtaFlag(targetInfoResponse.getRequestOtaFlag()).setUbootVersionCode(targetInfoResponse.getUbootVersionCode()).setUbootVersionName(targetInfoResponse.getUbootVersionName()).setSupportDoubleBackup(targetInfoResponse.isSupportDoubleBackup()).setNeedBootLoader(targetInfoResponse.isNeedBootLoader()).setSingleBackupOtaWay(targetInfoResponse.getSingleBackupOtaWay()).setAllowConnectFlag(targetInfoResponse.getAllowConnectFlag()).setAuthKey(targetInfoResponse.getAuthKey()).setProjectCode(targetInfoResponse.getProjectCode()).setCustomVersionMsg(targetInfoResponse.getCustomVersionMsg()).setEmitterSupport(targetInfoResponse.isEmitterSupport()).setEmitterStatus(targetInfoResponse.getEmitterStatus()).setSupportOfflineShow(targetInfoResponse.isSupportOfflineShow()).setSupportUsb(targetInfoResponse.isSupportUsb()).setSupportSd0(targetInfoResponse.isSupportSd0()).setSupportSd1(targetInfoResponse.isSupportSd1()).setSupportVolumeSync(targetInfoResponse.isSupportVolumeSync()).setSupportPackageCrc16(targetInfoResponse.isSupportPackageCrc16()).setGetFileByNameWithDev(targetInfoResponse.isGetFileByNameWithDev()).setContactsTransferBySmallFile(targetInfoResponse.isContactsTransferBySmallFile()).setExpandMode(targetInfoResponse.getExpandMode()).setBLEToSppWay(targetInfoResponse.isBLEToSppWay()).setExpandFunc(targetInfoResponse.getExpandFunc().getRawData());
        return deviceInfo;
    }

    public static DeviceInfo mergeTargetInfos(DeviceInfo deviceInfo, DeviceInfo deviceInfo2) {
        if (deviceInfo == null) {
            return deviceInfo2;
        }
        DeviceInfo deviceInfo3 = deviceInfo2;
        deviceInfo3.setVoiceModeList(deviceInfo.getVoiceModeList()).setCurrentVoiceMode(deviceInfo.getCurrentVoiceMode()).setAlarmVersion(deviceInfo.getAlarmVersion()).setAlarmDefaultBells(deviceInfo.getAlarmDefaultBells()).setAlarmExpandFlag(deviceInfo.getAlarmExpandFlag()).setAlarmListInfo(deviceInfo.getAlarmListInfo()).setMusicNameInfo(deviceInfo.getMusicNameInfo()).setMusicStatusInfo(deviceInfo.getMusicStatusInfo()).setPlayModeInfo(deviceInfo.getPlayModeInfo()).setPlayFileFormat(deviceInfo.getPlayFileFormat()).setPhoneStatus(deviceInfo.getPhoneStatus()).setEqInfo(deviceInfo.getEqInfo()).setEqPresetInfo(deviceInfo.getEqPresetInfo()).setSoundCardEqInfo(deviceInfo.getSoundCardEqInfo()).setLightControlInfo(deviceInfo.getLightControlInfo()).setCluster(deviceInfo.getCluster()).setCurrentDevIndex(deviceInfo.getCurrentDevIndex()).setFrequency(deviceInfo.getFrequency()).setFmStatusInfo(deviceInfo.getFmStatusInfo()).setAuxPlay(deviceInfo.isAuxPlay()).setiD3MusicInfo(deviceInfo.getiD3MusicInfo()).setHealthSettingInfo(deviceInfo.getHealthSettingInfo()).setSportsInfo(deviceInfo.getSportsInfo());
        return deviceInfo3;
    }

    public AlarmListInfo getAlarmListInfo() {
        return this.alarmListInfo;
    }

    public DeviceInfo setAlarmListInfo(AlarmListInfo alarmListInfo) {
        this.alarmListInfo = alarmListInfo;
        return this;
    }

    public List<DefaultAlarmBell> getAlarmDefaultBells() {
        return this.alarmDefaultBells;
    }

    public DeviceInfo setAlarmDefaultBells(List<DefaultAlarmBell> list) {
        this.alarmDefaultBells = list;
        return this;
    }

    public int getAlarmVersion() {
        return this.alarmVersion;
    }

    public DeviceInfo setAlarmVersion(int n) {
        this.alarmVersion = n;
        return this;
    }

    public byte getAlarmExpandFlag() {
        return this.alarmExpandFlag;
    }

    public DeviceInfo setAlarmExpandFlag(byte by) {
        this.alarmExpandFlag = by;
        return this;
    }

    public MusicNameInfo getMusicNameInfo() {
        return this.musicNameInfo;
    }

    public DeviceInfo setMusicNameInfo(MusicNameInfo musicNameInfo) {
        this.musicNameInfo = musicNameInfo;
        return this;
    }

    public MusicStatusInfo getMusicStatusInfo() {
        return this.musicStatusInfo;
    }

    public DeviceInfo setMusicStatusInfo(MusicStatusInfo musicStatusInfo) {
        this.musicStatusInfo = musicStatusInfo;
        return this;
    }

    public PlayModeInfo getPlayModeInfo() {
        return this.playModeInfo;
    }

    public DeviceInfo setPlayModeInfo(PlayModeInfo playModeInfo) {
        this.playModeInfo = playModeInfo;
        return this;
    }

    public boolean isAuxPlay() {
        return this.isAuxPlay;
    }

    public DeviceInfo setAuxPlay(boolean bl) {
        this.isAuxPlay = bl;
        return this;
    }

    public String getPlayFileFormat() {
        return this.playFileFormat;
    }

    public DeviceInfo setPlayFileFormat(String string) {
        this.playFileFormat = string;
        return this;
    }

    public int getCluster() {
        return this.cluster;
    }

    public DeviceInfo setCluster(int n) {
        this.cluster = n;
        return this;
    }

    public byte getCurrentDevIndex() {
        return this.currentDevIndex;
    }

    public DeviceInfo setCurrentDevIndex(byte by) {
        this.currentDevIndex = by;
        return this;
    }

    public EqPresetInfo getEqPresetInfo() {
        return this.eqPresetInfo;
    }

    public DeviceInfo setEqPresetInfo(EqPresetInfo eqPresetInfo) {
        this.eqPresetInfo = eqPresetInfo;
        return this;
    }

    public EqInfo getEqInfo() {
        return this.eqInfo;
    }

    public DeviceInfo setEqInfo(EqInfo eqInfo) {
        this.eqInfo = eqInfo;
        return this;
    }

    public LightControlInfo getLightControlInfo() {
        return this.lightControlInfo;
    }

    public DeviceInfo setLightControlInfo(LightControlInfo lightControlInfo) {
        this.lightControlInfo = lightControlInfo;
        return this;
    }

    public EqInfo getSoundCardEqInfo() {
        return this.soundCardEqInfo;
    }

    public DeviceInfo setSoundCardEqInfo(EqInfo eqInfo) {
        this.soundCardEqInfo = eqInfo;
        return this;
    }

    public List<ChannelInfo> getChannelInfos() {
        return this.channelInfos;
    }

    public DeviceInfo setChannelInfos(List<ChannelInfo> list) {
        this.channelInfos = list;
        return this;
    }

    public FmStatusInfo getFmStatusInfo() {
        return this.fmStatusInfo;
    }

    public DeviceInfo setFmStatusInfo(FmStatusInfo fmStatusInfo) {
        this.fmStatusInfo = fmStatusInfo;
        return this;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public DeviceInfo setFrequency(float f) {
        this.frequency = f;
        return this;
    }

    public ID3MusicInfo getiD3MusicInfo() {
        return this.iD3MusicInfo;
    }

    public DeviceInfo setiD3MusicInfo(ID3MusicInfo iD3MusicInfo) {
        this.iD3MusicInfo = iD3MusicInfo;
        return this;
    }

    public VoiceMode getCurrentVoiceMode() {
        return this.currentVoiceMode;
    }

    public DeviceInfo setCurrentVoiceMode(VoiceMode voiceMode) {
        this.currentVoiceMode = voiceMode;
        return this;
    }

    public List<VoiceMode> getVoiceModeList() {
        return this.voiceModeList;
    }

    public DeviceInfo setVoiceModeList(List<VoiceMode> list) {
        this.voiceModeList = list;
        return this;
    }

    public DevStorageInfo getDevStorageInfo() {
        return this.devStorageInfo;
    }

    public DeviceInfo setDevStorageInfo(DevStorageInfo devStorageInfo) {
        this.devStorageInfo = devStorageInfo;
        return this;
    }

    public ExpandFunction getExpandFunction() {
        return this.expandFunction;
    }

    public DeviceInfo setExpandFunction(ExpandFunction expandFunction) {
        this.expandFunction = expandFunction;
        return this;
    }

    public int getPhoneStatus() {
        return this.phoneStatus;
    }

    public DeviceInfo setPhoneStatus(int n) {
        this.phoneStatus = n;
        return this;
    }

    public boolean isMandatoryUpgrade() {
        return this.getMandatoryUpgradeFlag() == 1;
    }

    public boolean isBtEnable() {
        return this.getFunctionMask() == 0 || this.checkDevModeExist((byte)0);
    }

    public boolean isDevMusicEnable() {
        return this.checkDevModeExist((byte)1);
    }

    public boolean isRTCEnable() {
        return this.checkDevModeExist((byte)2);
    }

    public boolean isAuxEnable() {
        return this.checkDevModeExist((byte)3);
    }

    public boolean isFmEnable() {
        return this.checkDevModeExist((byte)4);
    }

    public boolean isLightEnable() {
        return this.checkDevModeExist((byte)5);
    }

    public boolean isFmTxEnable() {
        return this.checkDevModeExist((byte)6);
    }

    public boolean checkDevModeExist(byte by) {
        if (by > 32) {
            return false;
        }
        double d = CHexConver.byteToInt(by);
        byte by2 = CHexConver.intToByte((int)Math.pow(2.0, d));
        return (this.getFunctionMask() & by2) == by2;
    }

    public DeviceInfo setHealthSettingInfo(HealthSettingInfo healthSettingInfo) {
        this.healthSettingInfo = healthSettingInfo;
        return this;
    }

    public HealthSettingInfo getHealthSettingInfo() {
        return this.healthSettingInfo;
    }

    public SportsInfo getSportsInfo() {
        return this.sportsInfo;
    }

    public DeviceInfo setSportsInfo(SportsInfo sportsInfo) {
        this.sportsInfo = sportsInfo;
        return this;
    }

    @Override
    public String toString() {
        return "DeviceInfo{alarmListInfo=" + this.alarmListInfo + ", alarmDefaultBells=" + this.alarmDefaultBells + ", alarmVersion=" + this.alarmVersion + ", alarmExpandFlag=" + this.alarmExpandFlag + ", musicNameInfo=" + this.musicNameInfo + ", musicStatusInfo=" + this.musicStatusInfo + ", playModeInfo=" + this.playModeInfo + ", isAuxPlay=" + this.isAuxPlay + ", playFileFormat='" + this.playFileFormat + '\'' + ", cluster=" + this.cluster + ", currentDevIndex=" + this.currentDevIndex + ", eqPresetInfo=" + this.eqPresetInfo + ", eqInfo=" + this.eqInfo + ", devStorageInfo=" + this.devStorageInfo + ", lightControlInfo=" + this.lightControlInfo + ", soundCardEqInfo=" + this.soundCardEqInfo + ", channelInfos=" + this.channelInfos + ", fmStatusInfo=" + this.fmStatusInfo + ", frequency=" + this.frequency + ", iD3MusicInfo=" + this.iD3MusicInfo + ", currentVoiceMode=" + this.currentVoiceMode + ", voiceModeList=" + this.voiceModeList + ", phoneStatus=" + this.phoneStatus + ", expandFunction=" + this.expandFunction + ", healthSettingInfo=" + this.healthSettingInfo + ", sportsInfo=" + this.sportsInfo + "} \n" + super.toString();
    }
}

