/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device;

import android.os.Parcel;
import android.os.Parcelable;
import com.jieli.jl_rcsp.util.CHexConver;

public class VoiceData
implements Parcelable {
    public static final int VOICE_TYPE_PCM = 0;
    public static final int VOICE_TYPE_SPEEX = 1;
    public static final int VOICE_TYPE_OPUS = 2;
    public static final int ENCODING_PCM_8BIT = 1;
    public static final int ENCODING_PCM_16BIT = 2;
    public static final int CHANNEL_MONO = 1;
    public static final int CHANNEL_STEREO = 2;
    public static final Parcelable.Creator<VoiceData> CREATOR = new Parcelable.Creator<VoiceData>(){

        public VoiceData createFromParcel(Parcel parcel) {
            return new VoiceData(parcel);
        }

        public VoiceData[] newArray(int n) {
            return new VoiceData[n];
        }
    };
    private int dataType;
    private byte[] data;
    private int sampleRate = 16000;
    private int format = 2;
    private int channel = 1;

    public VoiceData() {
    }

    public VoiceData(Parcel parcel) {
        this.dataType = parcel.readInt();
        this.data = parcel.createByteArray();
        this.sampleRate = parcel.readInt();
        this.format = parcel.readInt();
        this.channel = parcel.readInt();
    }

    public int getDataType() {
        return this.dataType;
    }

    public VoiceData setDataType(int n) {
        this.dataType = n;
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    public VoiceData setData(byte[] byArray) {
        this.data = byArray;
        return this;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public VoiceData setSampleRate(int n) {
        this.sampleRate = n;
        return this;
    }

    public int getFormat() {
        return this.format;
    }

    public VoiceData setFormat(int n) {
        this.format = n;
        return this;
    }

    public int getChannel() {
        return this.channel;
    }

    public VoiceData setChannel(int n) {
        this.channel = n;
        return this;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.dataType);
        parcel.writeByteArray(this.data);
        parcel.writeInt(this.sampleRate);
        parcel.writeInt(this.format);
        parcel.writeInt(this.channel);
    }

    public String toString() {
        return "VoiceData{dataType=" + this.dataType + ", data=" + CHexConver.byte2HexStr(this.data) + ", sampleRate=" + this.sampleRate + ", format=" + this.format + ", channel=" + this.channel + '}';
    }

    public boolean equals(Object object) {
        if (object instanceof VoiceData) {
            object = (VoiceData)object;
            return this.dataType == ((VoiceData)object).dataType && this.sampleRate == ((VoiceData)object).sampleRate && this.format == ((VoiceData)object).format && this.channel == ((VoiceData)object).channel;
        }
        return false;
    }

    public int hashCode() {
        return this.dataType + this.sampleRate + this.format + this.channel;
    }
}

