/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.health.HealthData;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.JL_Log;

public class Altitude
extends HealthData {
    private static final int DATA_INTERVAL = 4;
    private int realTimeValue;
    private int minValue;
    private int maxValue;

    public Altitude(int n, byte by, byte[] byArray) {
        Altitude altitude = this;
        super(2, by, byArray, n);
        altitude.parseAltitudeData(n, by, byArray);
    }

    private void parseAltitudeData(int n, byte by, byte[] byArray) {
        if (n == 0) {
            byte[] byArray2 = CHexConver.getBooleanArrayBig(by);
            by = 0;
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] != 1) continue;
                if (i != 0) {
                    if (i != 1) {
                        if (i != 2) continue;
                        this.maxValue = this.getValueFromData(by, byArray);
                        by = (byte)(by + 4);
                        continue;
                    }
                    this.minValue = this.getValueFromData(by, byArray);
                    by = (byte)(by + 4);
                    continue;
                }
                this.realTimeValue = this.getValueFromData(by, byArray);
                by = (byte)(by + 4);
            }
        } else {
            JL_Log.e("Altitude", "no support version : " + n);
        }
    }

    private int getValueFromData(int n, byte[] byArray) {
        if (byArray != null && n + 4 <= byArray.length) {
            return CHexConver.bytesToInt(byArray, n, 4);
        }
        return 0;
    }

    public int getRealTimeValue() {
        return this.realTimeValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    @Override
    public String toString() {
        return "Altitude{realTimeValue=" + this.realTimeValue + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + "} " + super.toString();
    }
}

