/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import android.text.TextUtils;
import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.health.IHealthSettingToAttr;
import com.jieli.jl_rcsp.util.CHexConver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class FallDetection
implements IHealthSettingToAttr {
    public static final byte MODE_BRIGHT = 0;
    public static final byte MODE_SHAKE = 1;
    public static final byte MODE_CALL = 2;
    private String contact;
    private boolean enable;
    private byte mode;

    public FallDetection(byte[] byArray) {
        FallDetection fallDetection = this;
        fallDetection.parseData(byArray);
    }

    private void parseData(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            int n = CHexConver.byteToInt(byArray[0]) == 1 ? 1 : 0;
            this.enable = n;
            n = 1;
            int n2 = 2;
            if (byArray.length >= 2) {
                this.mode = byArray[n];
            } else {
                n2 = n;
            }
            this.contact = "";
            if (this.mode == 2) {
                n = 0;
                int n3 = n2 + 1;
                if (byArray.length >= n3) {
                    n = Math.min(CHexConver.byteToInt(byArray[n2]), byArray.length - n3);
                } else {
                    n3 = n2;
                }
                if (n > 0 && byArray.length >= n3 + n) {
                    this.contact = new String(byArray, n3, n).trim();
                }
            }
            return;
        }
    }

    private byte[] toData() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        try {
            new ByteArrayOutputStream().write(new byte[]{(byte)(this.enable ? 1 : 0), this.mode});
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.mode == 2 && !TextUtils.isEmpty((CharSequence)this.contact)) {
            try {
                byteArrayOutputStream2.write(this.contact.getBytes().length);
                byteArrayOutputStream2.write(this.contact.getBytes());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byteArrayOutputStream2.toByteArray();
    }

    public String getContact() {
        return this.contact;
    }

    public FallDetection setContact(String string) {
        this.contact = string;
        return this;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public FallDetection setEnable(boolean bl) {
        this.enable = bl;
        return this;
    }

    public FallDetection setMode(byte by) {
        this.mode = by;
        return this;
    }

    public byte getMode() {
        return this.mode;
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public AttrBean toAttr() {
        return new AttrBean().setAttrData(this.toData()).setType((byte)this.getType());
    }

    public String toString() {
        return "FallDetection{contact='" + this.contact + '\'' + ", enable=" + this.enable + ", mode=" + this.mode + '}';
    }
}

