/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.health.IHealthSettingToAttr;
import java.nio.ByteBuffer;

public class SleepDetection
implements IHealthSettingToAttr {
    public static final byte STATUS_CLOSE = 0;
    public static final byte STATUS_ALL_DAY = 1;
    public static final byte STATUS_CUSTOM_TIME = 2;
    private byte status;
    public byte startHour;
    public byte startMin;
    public byte endHour;
    public byte endMin;

    public SleepDetection(byte[] byArray) {
        SleepDetection sleepDetection = this;
        sleepDetection.parseData(byArray);
    }

    private void parseData(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.status = byArray[0];
            int n = 1;
            if (byArray.length >= 3) {
                this.startHour = (byte)Math.max(Math.min(byArray[n], 23), 0);
                this.startMin = (byte)Math.max(Math.min(byArray[2], 59), 0);
                n = 3;
            }
            if (byArray.length >= n + 2) {
                this.endHour = (byte)Math.max(Math.min(byArray[n], 23), 0);
                this.endMin = (byte)Math.max(Math.min(byArray[n + 1], 59), 0);
            }
            return;
        }
    }

    private byte[] toData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(5);
        byteBuffer.put(this.status).put(this.startHour).put(this.startMin).put(this.endHour).put(this.endMin);
        return byteBuffer.array();
    }

    public byte getStatus() {
        return this.status;
    }

    public SleepDetection setStatus(byte by) {
        this.status = by;
        return this;
    }

    public byte getStartHour() {
        return this.startHour;
    }

    public SleepDetection setStartHour(byte by) {
        this.startHour = by;
        return this;
    }

    public byte getStartMin() {
        return this.startMin;
    }

    public SleepDetection setStartMin(byte by) {
        this.startMin = by;
        return this;
    }

    public byte getEndHour() {
        return this.endHour;
    }

    public SleepDetection setEndHour(byte by) {
        this.endHour = by;
        return this;
    }

    public byte getEndMin() {
        return this.endMin;
    }

    public SleepDetection setEndMin(byte by) {
        this.endMin = by;
        return this;
    }

    public String toString() {
        return "SleepDetection{status=" + this.status + ", startHour=" + this.startHour + ", startMin=" + this.startMin + ", endHour=" + this.endHour + ", endMin=" + this.endMin + '}';
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public AttrBean toAttr() {
        return new AttrBean().setType((byte)this.getType()).setAttrData(this.toData());
    }
}

