/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.health.HealthData;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.JL_Log;

public class SportsSteps
extends HealthData {
    private int stepNum;
    private int distance;
    private int calorie;

    public SportsSteps(int n, byte by, byte[] byArray) {
        SportsSteps sportsSteps = this;
        super(3, by, byArray, n);
        sportsSteps.parseSportsStepsData(n, by, byArray);
    }

    private void parseSportsStepsData(int n, byte by, byte[] byArray) {
        if (n == 0) {
            byte[] byArray2 = CHexConver.getBooleanArrayBig(by);
            by = 0;
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] != 1) continue;
                if (i != 0) {
                    if (i != 1) {
                        if (i != 2) continue;
                        this.calorie = this.getValueFromData(by, 2, byArray);
                        by = (byte)(by + 2);
                        continue;
                    }
                    this.distance = this.getValueFromData(by, 2, byArray);
                    by = (byte)(by + 2);
                    continue;
                }
                this.stepNum = this.getValueFromData(by, 4, byArray);
                by = (byte)(by + 4);
            }
        } else {
            JL_Log.e("SportsSteps", "no support version : " + n);
        }
    }

    private int getValueFromData(int n, int n2, byte[] byArray) {
        if (byArray != null && n + n2 <= byArray.length) {
            return CHexConver.bytesToInt(byArray, n, n2);
        }
        return 0;
    }

    public int getStepNum() {
        return this.stepNum;
    }

    public int getDistance() {
        return this.distance;
    }

    public int getCalorie() {
        return this.calorie;
    }

    @Override
    public String toString() {
        return "SportsSteps{stepNum=" + this.stepNum + ", distance=" + this.distance + ", calorie=" + this.calorie + "} " + super.toString();
    }
}

