/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.health.IHealthSettingToAttr;
import com.jieli.jl_rcsp.util.CHexConver;
import java.nio.ByteBuffer;

public class UserInfo
implements IHealthSettingToAttr {
    public static final int SEX_WOMAN = 0;
    public static final int SEX_MAN = 1;
    private short height;
    private short weight;
    private int birthYear;
    private byte birthMonth;
    private byte birthDay;
    private byte sex;

    public UserInfo(byte[] byArray) {
        UserInfo userInfo = this;
        userInfo.parseData(byArray);
    }

    private void parseData(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            int n = 0;
            int n2 = 2;
            if (byArray.length >= 2) {
                this.height = CHexConver.bytesToShort(byArray[n], byArray[1]);
            } else {
                n2 = n;
            }
            n = n2 + 2;
            if (byArray.length >= n) {
                this.weight = CHexConver.bytesToShort(byArray[n2], byArray[n2 + 1]);
            } else {
                n = n2;
            }
            n2 = n + 2;
            if (byArray.length >= n2) {
                this.birthYear = CHexConver.bytesToInt(byArray[n], byArray[n + 1]);
            } else {
                n2 = n;
            }
            n = n2 + 1;
            if (byArray.length >= n) {
                this.birthMonth = byArray[n2];
            } else {
                n = n2;
            }
            n2 = n + 1;
            if (byArray.length >= n2) {
                this.birthDay = byArray[n];
            } else {
                n2 = n;
            }
            if (byArray.length >= n2 + 1) {
                this.sex = byArray[n2];
            }
            return;
        }
    }

    private byte[] toData() {
        return ByteBuffer.allocate(9).putShort(this.height).putShort(this.weight).putShort((short)this.birthYear).put(this.birthMonth).put(this.birthDay).put(this.sex).array();
    }

    public short getHeight() {
        return this.height;
    }

    public UserInfo setHeight(short s) {
        this.height = s;
        return this;
    }

    public short getWeight() {
        return this.weight;
    }

    public UserInfo setWeight(short s) {
        this.weight = s;
        return this;
    }

    public byte getSex() {
        return this.sex;
    }

    public UserInfo setSex(byte by) {
        this.sex = by;
        return this;
    }

    public int getBirthYear() {
        return this.birthYear;
    }

    public UserInfo setBirthYear(int n) {
        this.birthYear = n;
        return this;
    }

    public byte getBirthMonth() {
        return this.birthMonth;
    }

    public UserInfo setBirthMonth(byte by) {
        this.birthMonth = by;
        return this;
    }

    public UserInfo setBirthDay(byte by) {
        this.birthDay = by;
        return this;
    }

    public byte getBirthDay() {
        return this.birthDay;
    }

    public String toString() {
        return "UserInfo{height=" + this.height + ", weight=" + this.weight + ", year=" + this.birthYear + ", month=" + this.birthMonth + ", day=" + this.birthDay + ", sex=" + this.sex + '}';
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public AttrBean toAttr() {
        return new AttrBean().setType((byte)this.getType()).setAttrData(this.toData());
    }
}

