/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.response;

import android.os.Parcel;
import android.os.Parcelable;
import com.jieli.jl_rcsp.model.base.CommonResponse;
import com.jieli.jl_rcsp.util.CHexConver;
import java.util.List;
import java.util.Objects;

public class ADVInfoResponse
extends CommonResponse
implements Parcelable {
    public static final Parcelable.Creator<ADVInfoResponse> CREATOR = new Parcelable.Creator<ADVInfoResponse>(){

        public ADVInfoResponse createFromParcel(Parcel parcel) {
            return new ADVInfoResponse(parcel);
        }

        public ADVInfoResponse[] newArray(int n) {
            return new ADVInfoResponse[n];
        }
    };
    private int pid;
    private int vid;
    private int uid;
    private int leftDeviceQuantity;
    private boolean isLeftCharging;
    private int rightDeviceQuantity;
    private boolean isRightCharging;
    private int chargingBinQuantity;
    private boolean isDeviceCharging;
    private String deviceName;
    private int micChannel;
    private int workModel;
    private List<KeySettings> mKeySettingsList;
    private List<LedSettings> mLedSettingsList;
    private int inEarSettings;
    private String language;
    private byte[] modes;

    public ADVInfoResponse() {
    }

    public ADVInfoResponse(Parcel parcel) {
        this.vid = parcel.readInt();
        this.uid = parcel.readInt();
        this.pid = parcel.readInt();
        this.leftDeviceQuantity = parcel.readInt();
        boolean bl = parcel.readByte() != 0;
        this.isLeftCharging = bl;
        this.rightDeviceQuantity = parcel.readInt();
        bl = parcel.readByte() != 0;
        this.isRightCharging = bl;
        this.chargingBinQuantity = parcel.readInt();
        bl = parcel.readByte() != 0;
        this.isDeviceCharging = bl;
        this.deviceName = parcel.readString();
        this.micChannel = parcel.readInt();
        this.workModel = parcel.readInt();
        this.mKeySettingsList = parcel.createTypedArrayList(KeySettings.CREATOR);
        this.mLedSettingsList = parcel.createTypedArrayList(LedSettings.CREATOR);
        this.inEarSettings = parcel.readInt();
        this.language = parcel.readString();
        this.modes = parcel.createByteArray();
    }

    public static boolean baseInfoCompare(ADVInfoResponse aDVInfoResponse, ADVInfoResponse aDVInfoResponse2) {
        if (aDVInfoResponse != null && aDVInfoResponse2 != null) {
            if (aDVInfoResponse == aDVInfoResponse2) {
                return true;
            }
            return aDVInfoResponse.pid == aDVInfoResponse2.pid && aDVInfoResponse.vid == aDVInfoResponse2.vid && aDVInfoResponse.uid == aDVInfoResponse2.uid && aDVInfoResponse.leftDeviceQuantity == aDVInfoResponse2.leftDeviceQuantity && aDVInfoResponse.isLeftCharging == aDVInfoResponse2.isLeftCharging && aDVInfoResponse.rightDeviceQuantity == aDVInfoResponse2.rightDeviceQuantity && aDVInfoResponse.isRightCharging == aDVInfoResponse2.isRightCharging && aDVInfoResponse.chargingBinQuantity == aDVInfoResponse2.chargingBinQuantity && aDVInfoResponse.isDeviceCharging == aDVInfoResponse2.isDeviceCharging && aDVInfoResponse.micChannel == aDVInfoResponse2.micChannel && aDVInfoResponse.workModel == aDVInfoResponse2.workModel && aDVInfoResponse.inEarSettings == aDVInfoResponse2.inEarSettings && Objects.equals(aDVInfoResponse.deviceName, aDVInfoResponse2.deviceName);
        }
        return false;
    }

    public int getPid() {
        return this.pid;
    }

    public ADVInfoResponse setPid(int n) {
        this.pid = n;
        return this;
    }

    public int getVid() {
        return this.vid;
    }

    public ADVInfoResponse setVid(int n) {
        this.vid = n;
        return this;
    }

    public int getUid() {
        return this.uid;
    }

    public ADVInfoResponse setUid(int n) {
        this.uid = n;
        return this;
    }

    public int getLeftDeviceQuantity() {
        return this.leftDeviceQuantity;
    }

    public ADVInfoResponse setLeftDeviceQuantity(int n) {
        this.leftDeviceQuantity = n;
        return this;
    }

    public boolean isLeftCharging() {
        return this.isLeftCharging;
    }

    public ADVInfoResponse setLeftCharging(boolean bl) {
        this.isLeftCharging = bl;
        return this;
    }

    public int getRightDeviceQuantity() {
        return this.rightDeviceQuantity;
    }

    public ADVInfoResponse setRightDeviceQuantity(int n) {
        this.rightDeviceQuantity = n;
        return this;
    }

    public boolean isRightCharging() {
        return this.isRightCharging;
    }

    public ADVInfoResponse setRightCharging(boolean bl) {
        this.isRightCharging = bl;
        return this;
    }

    public int getChargingBinQuantity() {
        return this.chargingBinQuantity;
    }

    public ADVInfoResponse setChargingBinQuantity(int n) {
        this.chargingBinQuantity = n;
        return this;
    }

    public boolean isDeviceCharging() {
        return this.isDeviceCharging;
    }

    public ADVInfoResponse setDeviceCharging(boolean bl) {
        this.isDeviceCharging = bl;
        return this;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public ADVInfoResponse setDeviceName(String string) {
        this.deviceName = string;
        return this;
    }

    public int getMicChannel() {
        return this.micChannel;
    }

    public ADVInfoResponse setMicChannel(int n) {
        this.micChannel = n;
        return this;
    }

    public int getWorkModel() {
        return this.workModel;
    }

    public ADVInfoResponse setWorkModel(int n) {
        this.workModel = n;
        return this;
    }

    public List<KeySettings> getKeySettingsList() {
        return this.mKeySettingsList;
    }

    public ADVInfoResponse setKeySettingsList(List<KeySettings> list) {
        this.mKeySettingsList = list;
        return this;
    }

    public List<LedSettings> getLedSettingsList() {
        return this.mLedSettingsList;
    }

    public ADVInfoResponse setLedSettingsList(List<LedSettings> list) {
        this.mLedSettingsList = list;
        return this;
    }

    public int getInEarSettings() {
        return this.inEarSettings;
    }

    public ADVInfoResponse setInEarSettings(int n) {
        this.inEarSettings = n;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public ADVInfoResponse setLanguage(String string) {
        this.language = string;
        return this;
    }

    public byte[] getModes() {
        return this.modes;
    }

    public ADVInfoResponse setModes(byte[] byArray) {
        this.modes = byArray;
        return this;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.vid);
        parcel.writeInt(this.uid);
        parcel.writeInt(this.pid);
        parcel.writeInt(this.leftDeviceQuantity);
        parcel.writeByte((byte)(this.isLeftCharging ? 1 : 0));
        parcel.writeInt(this.rightDeviceQuantity);
        parcel.writeByte((byte)(this.isRightCharging ? 1 : 0));
        parcel.writeInt(this.chargingBinQuantity);
        parcel.writeByte((byte)(this.isDeviceCharging ? 1 : 0));
        parcel.writeString(this.deviceName);
        parcel.writeInt(this.micChannel);
        parcel.writeInt(this.workModel);
        parcel.writeTypedList(this.mKeySettingsList);
        parcel.writeTypedList(this.mLedSettingsList);
        parcel.writeInt(this.inEarSettings);
        parcel.writeString(this.language);
        parcel.writeByteArray(this.modes);
    }

    @Override
    public String toString() {
        return "ADVInfoResponse{pid=" + this.pid + ", vid=" + this.vid + ", uid=" + this.uid + ", leftDeviceQuantity=" + this.leftDeviceQuantity + ", isLeftCharging=" + this.isLeftCharging + ", rightDeviceQuantity=" + this.rightDeviceQuantity + ", isRightCharging=" + this.isRightCharging + ", chargingBinQuantity=" + this.chargingBinQuantity + ", isDeviceCharging=" + this.isDeviceCharging + ", deviceName='" + this.deviceName + '\'' + ", micChannel=" + this.micChannel + ", workModel=" + this.workModel + ", mKeySettingsList=" + this.mKeySettingsList + ", mLedSettingsList=" + this.mLedSettingsList + ", inEarSettings=" + this.inEarSettings + ", language=" + this.language + ", modes=" + CHexConver.byte2HexStr(this.modes) + "} " + super.toString();
    }

    public static class LedSettings
    implements Parcelable {
        public static final Parcelable.Creator<LedSettings> CREATOR = new Parcelable.Creator<LedSettings>(){

            public LedSettings createFromParcel(Parcel parcel) {
                return new LedSettings(parcel);
            }

            public LedSettings[] newArray(int n) {
                return new LedSettings[n];
            }
        };
        private int scene;
        private int effect;

        public LedSettings() {
        }

        public LedSettings(Parcel parcel) {
            this.scene = parcel.readInt();
            this.effect = parcel.readInt();
        }

        public int getScene() {
            return this.scene;
        }

        public void setScene(int n) {
            this.scene = n;
        }

        public int getEffect() {
            return this.effect;
        }

        public void setEffect(int n) {
            this.effect = n;
        }

        public byte[] toData() {
            return new byte[]{CHexConver.intToByte(this.scene), CHexConver.intToByte(this.effect)};
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.scene);
            parcel.writeInt(this.effect);
        }

        public String toString() {
            return "LedSettings{scene=" + this.scene + ", effect=" + this.effect + '}';
        }
    }

    public static class KeySettings
    implements Parcelable {
        public static final Parcelable.Creator<KeySettings> CREATOR = new Parcelable.Creator<KeySettings>(){

            public KeySettings createFromParcel(Parcel parcel) {
                return new KeySettings(parcel);
            }

            public KeySettings[] newArray(int n) {
                return new KeySettings[n];
            }
        };
        private int keyNum;
        private int action;
        private int function;

        public KeySettings() {
        }

        public KeySettings(Parcel parcel) {
            this.keyNum = parcel.readInt();
            this.action = parcel.readInt();
            this.function = parcel.readInt();
        }

        public int getKeyNum() {
            return this.keyNum;
        }

        public void setKeyNum(int n) {
            this.keyNum = n;
        }

        public int getAction() {
            return this.action;
        }

        public void setAction(int n) {
            this.action = n;
        }

        public int getFunction() {
            return this.function;
        }

        public void setFunction(int n) {
            this.function = n;
        }

        public byte[] toData() {
            byte[] byArray = new byte[3];
            byte[] byArray2 = byArray;
            byArray2[0] = CHexConver.intToByte(this.keyNum);
            byArray2[1] = CHexConver.intToByte(this.action);
            byArray[2] = CHexConver.intToByte(this.function);
            return byArray;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.keyNum);
            parcel.writeInt(this.action);
            parcel.writeInt(this.function);
        }

        public String toString() {
            return "KeySettings{, keyNum=" + this.keyNum + ", action=" + this.action + ", function=" + this.function + '}';
        }
    }
}

