/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.tool.datahandles;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.jieli.jl_rcsp.interfaces.bluetooth.IBluetoothProxy;
import com.jieli.jl_rcsp.interfaces.rcsp.RcspCommandCallback;
import com.jieli.jl_rcsp.model.DataInfo;
import com.jieli.jl_rcsp.model.base.BaseError;
import com.jieli.jl_rcsp.model.base.BasePacket;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.tool.CommandHelper;
import com.jieli.jl_rcsp.tool.DeviceStatusManager;
import com.jieli.jl_rcsp.tool.datahandles.BasePacketParse;
import com.jieli.jl_rcsp.tool.datahandles.DataHandler;
import com.jieli.jl_rcsp.tool.datahandles.DataInfoCache;
import com.jieli.jl_rcsp.tool.datahandles.ParseHelper;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.JL_Log;
import com.jieli.jl_rcsp.util.RcspUtil;
import java.util.ArrayList;

public class DataHandlerModify
implements DataHandler {
    private final String a = DataHandlerModify.class.getSimpleName();
    private final DeviceStatusManager b = DeviceStatusManager.getInstance();
    private final IBluetoothProxy c;
    private final BasePacketParse d;
    private final DataInfoCache e = new DataInfoCache();
    private final HandlerThread f;
    private final Handler g;
    private final Handler h;

    public DataHandlerModify(IBluetoothProxy iBluetoothProxy) {
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread;
        ((DataHandlerModify)object2).f = new HandlerThread("DataHandlerModify");
        ((DataHandlerModify)object2).h = new Handler(Looper.getMainLooper());
        if (iBluetoothProxy != null) {
            Handler handler;
            BasePacketParse basePacketParse;
            DataHandlerModify dataHandlerModify = object2;
            DataHandlerModify dataHandlerModify2 = object2;
            dataHandlerModify2.c = iBluetoothProxy;
            Object object2 = basePacketParse;
            basePacketParse = new BasePacketParse();
            dataHandlerModify2.d = object2;
            handlerThread2.start();
            object2 = handler;
            handler = new Handler(handlerThread2.getLooper(), object -> {
                object = object.obj;
                if (object instanceof Runnable) {
                    ((Runnable)object).run();
                }
                return true;
            });
            dataHandlerModify.g = object2;
            return;
        }
        throw new NullPointerException("IBluetoothProxy can not be null.");
    }

    private long a() {
        return System.currentTimeMillis();
    }

    private int a(BluetoothDevice bluetoothDevice) {
        return this.b.getMaxCommunicationMtu(bluetoothDevice);
    }

    private int b(BluetoothDevice bluetoothDevice) {
        return this.b.getMaxReceiveMtu(bluetoothDevice);
    }

    private boolean c(DataInfo dataInfo) {
        byte[] byArray = ParseHelper.packSendBasePacket(dataInfo.getBasePacket());
        if (byArray == null) {
            JL_Log.i(objectArray2.a, "send data :: pack data error.");
            return false;
        }
        int n = objectArray2.a(dataInfo.getDevice());
        if (byArray.length > n) {
            JL_Log.e(objectArray2.a, "send data over communication mtu [" + n + "] limit.");
            return false;
        }
        n = 0;
        for (int i = 0; i < 3; ++i) {
            boolean bl = objectArray2.c.sendDataToDevice(dataInfo.getDevice(), byArray);
            n = bl ? 1 : 0;
            if (bl) break;
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n != 0;
        objectArray[1] = CHexConver.byte2HexStr(byArray);
        JL_Log.d(objectArray2.a, RcspUtil.formatString("send ret : %s, data : [%s]", objectArray2));
        return n != 0;
    }

    private void a(DataInfo dataInfo, BaseError baseError) {
        if (dataInfo != null && dataInfo.getRcspCmdCallback() != null) {
            if (dataInfo.getBasePacket() != null) {
                baseError.setOpCode(dataInfo.getBasePacket().getOpCode());
            }
            this.h.post(() -> {
                dataInfo.getRcspCmdCallback().onErrCode(dataInfo.getDevice(), baseError);
                this.c.callbackErrorEvent(baseError);
            });
            return;
        }
        JL_Log.d(this.a, " callError info == null || info.getRcspCmdCallback() == null  + " + dataInfo);
    }

    private void a(DataInfo dataInfo, CommandBase commandBase) {
        if (dataInfo != null && dataInfo.getRcspCmdCallback() != null && commandBase != null) {
            this.h.post(() -> dataInfo.getRcspCmdCallback().onCommandResponse(dataInfo.getDevice(), commandBase));
            return;
        }
        JL_Log.d(this.a, "callbackCmd >>> " + dataInfo);
    }

    private int d(DataInfo dataInfo) {
        if (dataInfo == null) {
            return Integer.MAX_VALUE;
        }
        return dataInfo.getBasePacket().getOpCodeSn() << 16 | dataInfo.getBasePacket().getOpCode();
    }

    @Override
    public void addSendData(DataInfo dataInfo) {
        dataInfo.setSendTime(this.a());
        this.g.post(() -> {
            if (!((DataHandlerModify)((Object)baseError2)).c(dataInfo)) {
                BaseError baseError;
                DataHandlerModify dataHandlerModify = baseError2;
                BaseError baseError2 = baseError;
                baseError = new BaseError(12288);
                dataHandlerModify.a(dataInfo, baseError2);
                return;
            }
            if (dataInfo.getBasePacket().getHasResponse() == 1) {
                Object object = baseError2;
                ((DataHandlerModify)object).e.add(dataInfo);
                Handler handler = ((DataHandlerModify)object).g;
                handler.sendMessageDelayed(handler.obtainMessage(super.d(dataInfo), (Object)(DataHandlerModify)((Object)baseError2).new TimeOutCheck(dataInfo)), (long)dataInfo.getTimeoutMs());
            } else {
                DataInfo dataInfo2 = dataInfo;
                Object object = dataInfo2.getBasePacket();
                int n = ((BasePacket)object).getOpCodeSn();
                ((BasePacket)object).setOpCodeSn(256);
                object = ParseHelper.convert2Command(dataInfo2.getDevice(), (BasePacket)object);
                if (object != null) {
                    ((CommandBase)object).setOpCodeSn(n);
                }
                super.a(dataInfo, (CommandBase)object);
            }
        });
    }

    @Override
    public void addRecvData(DataInfo dataInfo) {
        this.g.post(() -> {
            int n = this.b(dataInfo.getDevice());
            ArrayList<BasePacket> arrayList = this.d.findPacketData(n, dataInfo.getRecvData());
            if (arrayList != null && !arrayList.isEmpty()) {
                for (BasePacket basePacket : arrayList) {
                    if (basePacket.getType() == 1) {
                        this.c.receiveDataFromDevice(dataInfo.getDevice(), basePacket);
                        continue;
                    }
                    DataInfo dataInfo2 = this.e.getDataInfo(basePacket);
                    if (dataInfo2 == null) {
                        JL_Log.w(this.a, "addRecvData : not found cache data info. " + basePacket);
                        continue;
                    }
                    CommandBase commandBase = ParseHelper.convert2Command(dataInfo2.getDevice(), basePacket);
                    if (commandBase == null) {
                        BaseError baseError;
                        BaseError baseError2 = baseError;
                        baseError = new BaseError(12289);
                        this.a(dataInfo2, baseError2);
                    } else {
                        this.c.receiveDataFromDevice(dataInfo.getDevice(), basePacket);
                    }
                    DataHandlerModify dataHandlerModify = this;
                    dataHandlerModify.e.remove(dataInfo2);
                    dataHandlerModify.g.removeMessages(this.d(dataInfo2));
                    this.a(dataInfo2, commandBase);
                    CommandHelper.getInstance().removeCommandBase(dataInfo2.getDevice(), basePacket);
                }
                return;
            }
            JL_Log.w(this.a, "addRecvData : Not found command.");
        });
    }

    @Override
    public void release() {
        DataHandlerModify dataHandlerModify = this;
        dataHandlerModify.g.removeCallbacksAndMessages(null);
        dataHandlerModify.d.release();
        CommandHelper.getInstance().release();
        if (!dataHandlerModify.e.isEmpty()) {
            ArrayList<DataInfo> arrayList = new ArrayList<DataInfo>(this.e);
            this.e.clear();
            for (DataInfo dataInfo : arrayList) {
                BaseError baseError;
                Object object = dataInfo.getRcspCmdCallback();
                if (object == null) continue;
                RcspCommandCallback rcspCommandCallback = object;
                dataInfo = dataInfo.getDevice();
                object = baseError;
                baseError = new BaseError(8192);
                rcspCommandCallback.onErrCode((BluetoothDevice)dataInfo, (BaseError)object);
            }
        }
        this.f.quitSafely();
    }

    public class TimeOutCheck
    implements Runnable {
        private final DataInfo a;

        public TimeOutCheck(DataInfo dataInfo) {
            this.a = dataInfo;
            dataInfo.setSendTime(System.currentTimeMillis());
        }

        @Override
        public void run() {
            TimeOutCheck timeOutCheck = this;
            JL_Log.w(timeOutCheck.DataHandlerModify.this.a, "send data timeout  --> " + this.a);
            if (timeOutCheck.a.getReSendCount() < 3) {
                TimeOutCheck timeOutCheck2 = this;
                DataInfo dataInfo = timeOutCheck2.a;
                dataInfo.setReSendCount(dataInfo.getReSendCount() + 1);
                timeOutCheck2.DataHandlerModify.this.e.remove(this.a);
                timeOutCheck2.DataHandlerModify.this.addSendData(this.a);
            } else {
                BaseError baseError;
                TimeOutCheck timeOutCheck3 = this;
                timeOutCheck3.DataHandlerModify.this.e.remove(this.a);
                CommandHelper.getInstance().removeCommandBase(this.a.getDevice(), this.a.getBasePacket());
                BaseError baseError2 = baseError;
                baseError = new BaseError(12290);
                timeOutCheck3.DataHandlerModify.this.a(this.a, baseError2);
            }
        }
    }
}

