/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.util;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Build;
import android.text.TextUtils;
import com.jieli.jl_rcsp.model.LtvBean;
import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.util.CHexConver;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class RcspUtil {
    public static BluetoothDevice getRemoteDevice(String string) {
        if (!BluetoothAdapter.checkBluetoothAddress((String)string)) {
            return null;
        }
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            return null;
        }
        try {
            return bluetoothAdapter.getRemoteDevice(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean deviceEquals(BluetoothDevice bluetoothDevice, BluetoothDevice bluetoothDevice2) {
        return bluetoothDevice != null && bluetoothDevice2 != null && bluetoothDevice.getAddress().equals(bluetoothDevice2.getAddress());
    }

    @SuppressLint(value={"MissingPermission"})
    public static String printBtDeviceInfo(BluetoothDevice bluetoothDevice) {
        String string;
        if (bluetoothDevice != null) {
            if (Build.VERSION.SDK_INT > 30) {
                string = bluetoothDevice.toString();
            } else {
                Object[] objectArray = new Object[3];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = bluetoothDevice.getName();
                objectArray2[1] = bluetoothDevice.getType();
                objectArray[2] = bluetoothDevice.getAddress();
                string = RcspUtil.formatString("device:{ name : %s,type : %d, address : %s }", objectArray2);
            }
        } else {
            string = "null";
        }
        return string;
    }

    public static String formatString(String string, Object ... objectArray) {
        return String.format(Locale.ENGLISH, string, objectArray);
    }

    public static int time2Int(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        Calendar calendar2 = calendar;
        int n = calendar2.get(2) + 1;
        int n2 = calendar2.get(5);
        int n3 = calendar2.get(11);
        int n4 = calendar2.get(12);
        int n5 = calendar2.get(13);
        return calendar.get(1) - 2010 << 26 | n << 22 | n2 << 17 | n3 << 12 | n4 << 6 | n5;
    }

    public static long intToTime(int n) {
        int n2 = n;
        n = (n2 >> 26 & 0x3F) + 2010;
        int n3 = n2 >> 22 & 0xF;
        int n4 = n2 >> 17 & 0x1F;
        int n5 = n2 >> 12 & 0x1F;
        int n6 = n2 >> 6 & 0x3F;
        int n7 = n2 & 0x3F;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, n3 - 1);
        calendar.set(5, n4);
        calendar.set(11, n5);
        calendar.set(12, n6);
        calendar.set(13, n7);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static int formatBleMtu(int n) {
        if (n < 20) {
            n = 20;
        }
        if (n > 509) {
            n = 509;
        }
        return n;
    }

    public static byte[] addressCovertToByteArray(String string) {
        byte[] byArray;
        byte[] byArray2 = null;
        if (!TextUtils.isEmpty((CharSequence)string) && string.contains(":")) {
            string = string.replace(":", "");
            int n = string.length() / 2;
            byArray = new byte[n];
            if (n == 6) {
                for (int i = 0; i < n; ++i) {
                    byte by;
                    int n2 = i * 2;
                    int n3 = n2 + 2;
                    if (n3 > string.length()) continue;
                    try {
                        byte[] byArray3 = byArray;
                        int n4 = i;
                        by = (byte)Integer.valueOf(string.substring(n2, n3), 16).intValue();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return null;
                    }
                    byArray3[n4] = by;
                    continue;
                }
            } else {
                byArray = null;
            }
        } else {
            byArray = byArray2;
        }
        return byArray;
    }

    public static int changeConnectStatus(int n) {
        return n != 1 ? (n != 2 ? 0 : 1) : 3;
    }

    public static byte[] packLTVPacket(int n, byte[] byArray) {
        byte[] byArray2 = null;
        if (byArray != null) {
            int n2 = byArray.length + 1;
            byte[] byArray3 = new byte[n2 + 1];
            byArray2 = byArray3;
            byArray2[0] = CHexConver.intToByte(n2);
            byArray3[1] = CHexConver.intToByte(n);
            n = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 2, n);
        }
        return byArray2;
    }

    public static byte[] packLTVPacket2(int n, byte[] byArray) {
        byte[] byArray2 = null;
        if (byArray != null) {
            int n2 = byArray.length + 1;
            byte[] byArray3 = new byte[n2 + 2];
            byArray2 = byArray3;
            int n3 = n;
            byte[] byArray4 = CHexConver.int2byte2(n2);
            n = byArray4.length;
            System.arraycopy(byArray4, 0, byArray2, 0, n);
            byArray3[2] = CHexConver.intToByte(n3);
            n = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 3, n);
        }
        return byArray2;
    }

    public static List<LtvBean> parseLTVData(byte[] byArray) {
        if (byArray != null && byArray.length > 1) {
            byte by;
            ArrayList<LtvBean> arrayList;
            ArrayList<LtvBean> arrayList2 = arrayList;
            arrayList = new ArrayList<LtvBean>();
            int n = 0;
            while (n < byArray.length && ++n + (by = byArray[n]) <= byArray.length) {
                int n2 = CHexConver.byteToInt(byArray[n]);
                int n3 = n + 1;
                n = by - 1;
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, n3, byArray2, 0, n);
                n = n3 + n;
                arrayList2.add(new LtvBean(by, n2, byArray2));
            }
            return arrayList2;
        }
        return new ArrayList<LtvBean>();
    }

    public static byte[] attrs2Bytes(List<AttrBean> object) {
        List<AttrBean> list = object;
        object = ByteBuffer.allocate(list.size() * 128);
        for (AttrBean attrBean : list) {
            ((ByteBuffer)object).put((byte)(attrBean.getAttrData().length + 1)).put(attrBean.getType()).put(attrBean.getAttrData());
        }
        byte[] byArray = new byte[((Buffer)object).position()];
        ((ByteBuffer)object).flip();
        ((ByteBuffer)object).get(byArray);
        return byArray;
    }

    public static byte[] getData(String string, int n) {
        if (string != null && n > 0) {
            return RcspUtil.getData(string.getBytes(), n);
        }
        return null;
    }

    public static byte[] getData(byte[] byArray, int n) {
        if (byArray != null && n > 0) {
            if (byArray.length <= n) {
                return byArray;
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        return null;
    }

    public static boolean checkMaskHasBit(int n, byte by) {
        if (by > 32) {
            return false;
        }
        double d = CHexConver.byteToInt(by);
        byte by2 = CHexConver.intToByte((int)Math.pow(2.0, d));
        return (n & by2) == by2;
    }
}

