/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_fatfs;

import android.os.Handler;
import android.os.Looper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jieli.jl_fatfs.interfaces.IBluetoothCtrl;
import com.jieli.jl_fatfs.interfaces.OnFatFileProgressListener;
import com.jieli.jl_fatfs.interfaces.OnFatFsInitListener;
import com.jieli.jl_fatfs.interfaces.OnFatFsOpResultListener;
import com.jieli.jl_fatfs.model.FatFile;
import com.jieli.jl_fatfs.model.FatOpParam;
import com.jieli.jl_fatfs.model.FatWriteOp;
import com.jieli.jl_fatfs.model.FileExtMsg;
import com.jieli.jl_fatfs.tool.PackResFormat;
import com.jieli.jl_fatfs.utils.FatUtil;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.CryptoUtil;
import com.jieli.jl_rcsp.util.JL_Log;
import com.jieli.jl_rcsp.util.WatchFileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FatFileSystem {
    private static final String u = "FatFileSystem";
    private static final String[] v;
    private volatile boolean a;
    private volatile long b;
    private final ExecutorService c;
    private final IBluetoothCtrl d;
    private final Handler e;
    private final Map<String, ArrayList<FatFile>> f;
    private String g;
    private byte[] h;
    private int i;
    private short j;
    private int k;
    private byte[] l;
    private int m;
    private byte[] n;
    private int o;
    private final OnFatFsInitListener p;
    private FatOpParam q;
    private PackResFormat r;
    private Gson s;
    private final String[] t;

    public FatFileSystem(int n, int n2, int n3, String[] object, IBluetoothCtrl iBluetoothCtrl, OnFatFsInitListener onFatFsInitListener, OnFatFileProgressListener onFatFileProgressListener) {
        String[] stringArray = object;
        object = Executors.newSingleThreadExecutor();
        this.c = object;
        this.e = new Handler(Looper.getMainLooper());
        this.f = new HashMap<String, ArrayList<FatFile>>();
        this.g = "/";
        this.h = null;
        this.i = 0;
        this.j = 0;
        this.n = null;
        this.o = 0;
        this.t = stringArray;
        this.d = iBluetoothCtrl;
        this.p = onFatFsInitListener;
        if (iBluetoothCtrl != null) {
            if (n > n2) {
                n = n2;
            }
            FatFileSystem fatFileSystem = this;
            fatFileSystem.b = fatFileSystem.libInit(n, n2);
            if (fatFileSystem.b != 0L) {
                FatFileSystem fatFileSystem2 = this;
                fatFileSystem2.b(false);
                fatFileSystem2.updateSysStatus(fatFileSystem2.b, n3);
                if (n3 != 0 && onFatFileProgressListener != null) {
                    this.q = new FatOpParam().setOp(255).setFilePath("/").setTotalSize(8192L).setProgressListener(onFatFileProgressListener);
                }
                object.submit(() -> {
                    FatFileSystem fatFileSystem = this;
                    fatFileSystem.b();
                    int bl = fatFileSystem.initDiskOp();
                    if (bl == 0) {
                        void var2_5;
                        JL_Log.w((String)u, (String)"FatFs init ok.");
                        if (n3 != 0) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            this.updateSysStatus(0);
                        }
                        FatFileSystem fatFileSystem2 = this;
                        n3 = fatFileSystem2.mountDevice(fatFileSystem2.b);
                        if (n3 == 0) {
                            boolean bl2 = true;
                        } else {
                            boolean bl3 = false;
                        }
                        FatFileSystem fatFileSystem3 = this;
                        fatFileSystem3.b((boolean)var2_5);
                        if (fatFileSystem3.a) {
                            FatFileSystem fatFileSystem4 = this;
                            JL_Log.w((String)u, (String)"FatFs mount ok.");
                            fatFileSystem4.a();
                            fatFileSystem4.listFatDir("/", null);
                            fatFileSystem4.r = new PackResFormat();
                            fatFileSystem4.s = new GsonBuilder().create();
                        } else {
                            JL_Log.e((String)u, (String)("FatFs mount failed. res = " + n3));
                            this.a(n3);
                        }
                    } else {
                        JL_Log.e((String)u, (String)("FatFs init error. ret = " + bl));
                        this.a(bl);
                    }
                });
                return;
            }
            throw new RuntimeException("init lib failed.");
        }
        throw new RuntimeException("IBluetoothCtrl cannot be null.");
    }

    private void j() {
        FatFileSystem fatFileSystem = this;
        fatFileSystem.h = null;
        fatFileSystem.j = 0;
        fatFileSystem.i = 0;
        fatFileSystem.k = 0;
        fatFileSystem.m = 0;
        fatFileSystem.l = null;
    }

    private void i() {
        FatFileSystem fatFileSystem = this;
        fatFileSystem.n = null;
        fatFileSystem.o = 0;
    }

    private void b() {
        FatOpParam fatOpParam = this.q;
        if (fatOpParam != null) {
            fatOpParam.setSumFileDataLen(0);
        }
        this.e.post(() -> {
            FatOpParam fatOpParam = this.q;
            if (fatOpParam != null && fatOpParam.getProgressListener() != null) {
                this.q.getProgressListener().onStart(this.q.getFilePath());
            }
        });
    }

    private void a(float f) {
        this.e.post(() -> {
            FatOpParam fatOpParam = this.q;
            if (fatOpParam != null && fatOpParam.getProgressListener() != null) {
                this.q.getProgressListener().onProgress(f);
            }
        });
    }

    private void b(int n) {
        this.e.post(() -> {
            JL_Log.i((String)u, (String)("-callbackStop- mFatOpParam :: " + this.q + ", result = " + n));
            Object object = this.q;
            if (object != null) {
                object = ((FatOpParam)object).getProgressListener();
                this.j();
                this.q = null;
                if (object != null) {
                    object.onStop(n);
                }
            }
        });
    }

    private float c(int n) {
        FatOpParam fatOpParam = this.q;
        if (fatOpParam != null && fatOpParam.getTotalSize() != 0L) {
            float f;
            int n2 = this.q.getSumFileDataLen() + n;
            this.q.setSumFileDataLen(n2);
            float f2 = (float)n2 * 100.0f / (float)this.q.getTotalSize();
            if (f > 100.0f) {
                f2 = 100.0f;
            }
            return f2;
        }
        return 0.0f;
    }

    private void a() {
        FatFileSystem fatFileSystem = this;
        fatFileSystem.e.post(() -> {
            OnFatFsInitListener onFatFsInitListener = ((FatFileSystem)((Object)onFatFsInitListener)).p;
            if (onFatFsInitListener != null) {
                onFatFsInitListener.onInitOk();
            }
        });
        JL_Log.d((String)u, (String)("callbackInitOk :: " + this.q));
        if (fatFileSystem.q != null) {
            this.b(0);
        }
    }

    private void a(int n) {
        JL_Log.e((String)u, (String)("callbackInitFailed :: " + this.q + ", code = " + n));
        if (this.q != null) {
            this.b(n);
        }
        this.e.post(() -> {
            OnFatFsInitListener onFatFsInitListener = ((FatFileSystem)((Object)onFatFsInitListener)).p;
            if (onFatFsInitListener != null) {
                onFatFsInitListener.onInitFailed(n);
            }
        });
    }

    private void b(boolean bl) {
        this.a = bl;
    }

    public static boolean isIgnoreFile(String string) {
        if (string != null) {
            String[] stringArray = v;
            if (v != null && stringArray.length != 0) {
                boolean bl = false;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!stringArray[i].equalsIgnoreCase(string)) continue;
                    bl = true;
                    break;
                }
                return bl;
            }
        }
        return false;
    }

    private ArrayList<FatFile> a(ArrayList<FatFile> object) {
        if (object != null && !((ArrayList)object).isEmpty()) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                FatFile fatFile = (FatFile)object.next();
                if (FatFileSystem.isIgnoreFile(fatFile.getName())) continue;
                arrayList2.add(fatFile);
            }
            return arrayList2;
        }
        return object;
    }

    private long d() {
        return (long)this.getFreeSize() * 4096L;
    }

    private boolean d(int n) {
        JL_Log.d((String)u, (String)("hasEnoughSpace : getRealFatFreeSize = " + this.d() + ", dataLen = " + n));
        return this.d() - (long)n >= 0L;
    }

    private boolean a(String string) {
        File file;
        if (string == null) {
            return false;
        }
        File file2 = file;
        return new File(string).exists() && file2.isFile();
    }

    private Gson c() {
        if (this.s == null) {
            this.s = new GsonBuilder().create();
        }
        return this.s;
    }

    private static /* synthetic */ void a(OnFatFsOpResultListener onFatFsOpResultListener, byte[] byArray) {
        onFatFsOpResultListener.onResult(byArray);
    }

    private static /* synthetic */ void b(OnFatFsOpResultListener onFatFsOpResultListener, byte[] byArray) {
        if (onFatFsOpResultListener != null) {
            onFatFsOpResultListener.onResult(byArray);
        }
    }

    static {
        try {
            System.loadLibrary("jl_fatfs");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        v = new String[]{"JL", "FONT", "SIDEBAR"};
    }

    public void mount(OnFatFsOpResultListener<Integer> onFatFsOpResultListener) {
        if (this.c.isShutdown()) {
            if (onFatFsOpResultListener != null) {
                onFatFsOpResultListener.onResult(8);
            }
            return;
        }
        this.c.submit(() -> {
            FatFileSystem fatFileSystem = this;
            int n = fatFileSystem.mountDevice(fatFileSystem.b);
            if (n == 0) {
                JL_Log.w((String)u, (String)"FatFs mount ok.");
            }
            this.e.post(() -> {
                if (onFatFsOpResultListener != null) {
                    onFatFsOpResultListener.onResult(n);
                }
            });
        });
    }

    public void createFatFile(String string, boolean bl, OnFatFileProgressListener onFatFileProgressListener) {
        if (this.a && !this.c.isShutdown()) {
            if (this.q != null) {
                JL_Log.w((String)u, (String)("An operation is in progress. mFatOpParam = " + this.q));
                if (onFatFileProgressListener != null) {
                    onFatFileProgressListener.onStop(4352);
                }
                return;
            }
            this.q = new FatOpParam().setOp(2).setFilePath(string).setProgressListener(onFatFileProgressListener);
            this.c.submit(() -> {
                Object object = this.q;
                if (object == null) {
                    this.b(4097);
                    return;
                }
                byte[] byArray = WatchFileUtil.readFileData(((FatOpParam)object).getFilePath());
                object = byArray;
                if (byArray != null && ((Object)object).length != 0) {
                    if (this.d.getConnectedDevice() == null) {
                        this.b(8192);
                        return;
                    }
                    this.q.setTotalSize(((Object)object).length + 16384);
                    if (!bl) {
                        FatFileSystem fatFileSystem = this;
                        if (!fatFileSystem.isMatchVersion(fatFileSystem.q.getFilePath(), (byte[])object)) {
                            this.b(16896);
                            return;
                        }
                    }
                    if (!this.d(((Object)object).length)) {
                        this.b(20);
                        return;
                    }
                    FatFileSystem fatFileSystem = this;
                    fatFileSystem.b();
                    String string = FatUtil.getFatFilePath(fatFileSystem.g, this.q.getFilePath());
                    int n = 0;
                    if (fatFileSystem.getFatFileMsg(string) != null) {
                        n = this.deleteFile(string);
                        JL_Log.w((String)u, (String)("deleteFile :: res = " + n + ", fatFilePath = " + string));
                    }
                    if (n == 0 || n == 4 || n == 5) {
                        n = this.createNewFile(string, (byte[])object);
                    }
                    JL_Log.w((String)u, (String)("createFatFile :: res = " + n));
                    this.b(n);
                    if (n != 0) return;
                    this.listFatDir("/", null);
                    return;
                }
                this.b(4);
            });
            return;
        }
        if (onFatFileProgressListener != null) {
            onFatFileProgressListener.onStop(22);
        }
    }

    public void deleteFatFile(String string, OnFatFileProgressListener onFatFileProgressListener) {
        if (this.a && !this.c.isShutdown()) {
            if (this.q != null) {
                JL_Log.w((String)u, (String)("deleteFatFile = An operation is in progress. mFatOpParam = " + this.q));
                if (onFatFileProgressListener != null) {
                    onFatFileProgressListener.onStop(4352);
                }
                return;
            }
            this.q = new FatOpParam().setOp(3).setFilePath(string).setProgressListener(onFatFileProgressListener).setTotalSize(16384L);
            this.c.submit(() -> {
                if (this.q == null) {
                    this.b(4097);
                    return;
                }
                if (this.d.getConnectedDevice() == null) {
                    this.b(8192);
                    return;
                }
                FatFileSystem fatFileSystem = this;
                fatFileSystem.b();
                int n = fatFileSystem.deleteFile(fatFileSystem.q.getFilePath());
                JL_Log.w((String)u, (String)("deleteFatFile res = " + n + ", FilePath = " + this.q.getFilePath()));
                this.b(n);
                if (n == 0) {
                    this.listFatDir("/", null);
                }
            });
            return;
        }
        if (onFatFileProgressListener != null) {
            onFatFileProgressListener.onStop(22);
        }
    }

    public void openFatFile(String string, OnFatFsOpResultListener<byte[]> onFatFsOpResultListener) {
        if (this.a && !this.c.isShutdown()) {
            this.c.submit(() -> {
                FatFileSystem fatFileSystem = object;
                Object object = fatFileSystem.openFile(string);
                JL_Log.w((String)u, (String)("openFatFile data = " + Arrays.toString((byte[])object)));
                fatFileSystem.e.post(() -> FatFileSystem.b(onFatFsOpResultListener, (byte[])object));
            });
            return;
        }
        if (onFatFsOpResultListener != null) {
            onFatFsOpResultListener.onResult(null);
        }
    }

    public void listFatDir(String string, OnFatFsOpResultListener<ArrayList<FatFile>> onFatFsOpResultListener) {
        if (this.a && !this.c.isShutdown()) {
            this.c.submit(() -> {
                ArrayList<FatFile> arrayList = ((FatFileSystem)((Object)arrayList2)).listDir(string);
                if (arrayList != null) {
                    if (!((FatFileSystem)((Object)arrayList2)).g.equalsIgnoreCase(string)) {
                        ((FatFileSystem)((Object)arrayList2)).g = ((FatFileSystem)((Object)arrayList2)).g.equalsIgnoreCase("/") ? ((FatFileSystem)((Object)arrayList2)).g + string : ((FatFileSystem)((Object)arrayList2)).g + "/" + string;
                    }
                    JL_Log.i((String)u, (String)("listFatDir :: put list in cache. curBrowsePath = " + ((FatFileSystem)((Object)arrayList2)).g + ", fatFiles size = " + arrayList.size()));
                    ((FatFileSystem)((Object)arrayList2)).f.put(((FatFileSystem)((Object)arrayList2)).g, arrayList);
                }
                FatFileSystem fatFileSystem = arrayList2;
                ArrayList<FatFile> arrayList2 = fatFileSystem.a(arrayList);
                fatFileSystem.e.post(() -> {
                    if (onFatFsOpResultListener != null) {
                        onFatFsOpResultListener.onResult(arrayList2);
                    }
                });
            });
            return;
        }
        if (onFatFsOpResultListener != null) {
            onFatFsOpResultListener.onResult(null);
        }
    }

    public void getFatFsFreeSize(OnFatFsOpResultListener<Long> onFatFsOpResultListener) {
        if (this.a && !this.c.isShutdown()) {
            this.c.submit(() -> {
                FatFileSystem fatFileSystem = this;
                long l = fatFileSystem.d();
                fatFileSystem.e.post(() -> {
                    if (onFatFsOpResultListener != null) {
                        onFatFsOpResultListener.onResult(l);
                    }
                });
            });
            return;
        }
        if (onFatFsOpResultListener != null) {
            onFatFsOpResultListener.onResult(0L);
        }
    }

    public String getCurBrowsePath() {
        return this.g;
    }

    public FatFile getFatFileMsg(String string) {
        if (string != null && ((FatFileSystem)((Object)iterator)).f.size() != 0) {
            Object var2_2 = null;
            Object object = u;
            JL_Log.d((String)object, (String)("getFatFileMsg : filePath = " + string));
            int n = string.lastIndexOf("/");
            if (n == -1) {
                return null;
            }
            String string2 = n > 0 ? string.substring(0, n) : "/";
            JL_Log.d((String)object, (String)("getFatFileMsg : key = " + string2));
            object = ((FatFileSystem)((Object)iterator)).f.get(string2);
            if (object == null) {
                object = ((FatFileSystem)((Object)iterator)).f.get(string2 + "/");
            }
            if (object != null) {
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    object = (FatFile)iterator.next();
                    JL_Log.d((String)u, (String)("getFatFileMsg : >>>  " + object + ", target = " + string));
                    if (!string.equalsIgnoreCase(((FatFile)object).getPath())) continue;
                    break;
                }
            } else {
                object = var2_2;
            }
            JL_Log.d((String)u, (String)("getFatFileMsg : fatFile = " + object));
            return object;
        }
        return null;
    }

    public void replaceFatFile(String string, OnFatFileProgressListener onFatFileProgressListener) {
        if (this.a && !this.c.isShutdown()) {
            if (this.q != null) {
                JL_Log.w((String)u, (String)("An operation is in progress. mFatOpParam = " + this.q));
                if (onFatFileProgressListener != null) {
                    onFatFileProgressListener.onStop(4352);
                }
                return;
            }
            this.q = new FatOpParam().setOp(4).setFilePath(string).setProgressListener(onFatFileProgressListener);
            this.c.submit(() -> {
                Object object = this.q;
                if (object == null) {
                    this.b(4097);
                    return;
                }
                byte[] byArray = WatchFileUtil.readFileData(((FatOpParam)object).getFilePath());
                object = byArray;
                if (byArray != null && ((Object)object).length != 0) {
                    if (this.d.getConnectedDevice() == null) {
                        this.b(8192);
                        return;
                    }
                    FatFileSystem fatFileSystem = this;
                    fatFileSystem.q.setTotalSize(((Object)object).length + 32768);
                    String string = FatUtil.getFatFilePath(fatFileSystem.g, this.q.getFilePath());
                    if (this.d(((Object)object).length)) {
                        FatFileSystem fatFileSystem2 = this;
                        this.b();
                        int n = fatFileSystem2.replaceFatFile(string, (byte[])object);
                        JL_Log.w((String)u, (String)("replaceFatFile :: -replaceFatFile- res = " + n));
                        fatFileSystem2.b(n);
                    } else {
                        this.b();
                        int n = this.deleteFile(string);
                        String string2 = u;
                        JL_Log.d((String)string2, (String)("replaceFatFile :: -deleteFile- res = " + n));
                        if (n != 0) {
                            this.b(n);
                            return;
                        }
                        int n2 = this.createNewFile(string, (byte[])object);
                        JL_Log.w((String)string2, (String)("replaceFatFile :: -createNewFile- res = " + n2));
                        this.b(n2);
                    }
                    return;
                }
                this.b(4);
            });
            return;
        }
        if (onFatFileProgressListener != null) {
            onFatFileProgressListener.onStop(22);
        }
    }

    public void getFileHeadData(String string, OnFatFsOpResultListener<byte[]> onFatFsOpResultListener) {
        if (this.a && !this.c.isShutdown()) {
            this.c.submit(() -> {
                string = this.getFileHead(string);
                if (onFatFsOpResultListener != null) {
                    this.e.post(() -> FatFileSystem.a(onFatFsOpResultListener, (byte[])string));
                }
            });
            return;
        }
        if (onFatFsOpResultListener != null) {
            onFatFsOpResultListener.onResult(null);
        }
    }

    public void destroy() {
        FatFileSystem fatFileSystem = this;
        JL_Log.w((String)u, (String)"destroy");
        fatFileSystem.j();
        fatFileSystem.i();
        if (!fatFileSystem.c.isShutdown()) {
            this.c.shutdownNow();
        }
        FatFileSystem fatFileSystem2 = this;
        fatFileSystem2.f.clear();
        PackResFormat packResFormat = fatFileSystem2.r;
        if (packResFormat != null) {
            packResFormat.destroy();
            this.r = null;
        }
        FatFileSystem fatFileSystem3 = this;
        fatFileSystem3.d.release();
        fatFileSystem3.libDestroy(fatFileSystem3.b);
        fatFileSystem3.b = 0L;
        fatFileSystem3.s = null;
        fatFileSystem3.b(false);
    }

    public void updateSysStatus(int n) {
        FatFileSystem fatFileSystem = this;
        fatFileSystem.updateSysStatus(fatFileSystem.b, n);
    }

    public int getWriteStatus() {
        FatFileSystem fatFileSystem = this;
        return fatFileSystem.getWriteStatus(fatFileSystem.b);
    }

    public void updateWriteStatus(boolean bl) {
        if (!bl) {
            this.j();
        }
        FatFileSystem fatFileSystem = this;
        fatFileSystem.updateWriteStatus(fatFileSystem.b, bl ? 1 : 0);
    }

    public int getReadStatus() {
        FatFileSystem fatFileSystem = this;
        return fatFileSystem.getReadStatus(fatFileSystem.b);
    }

    public void updateReadStatus(boolean bl, byte[] byArray) {
        FatFileSystem fatFileSystem = this;
        fatFileSystem.updateReadStatus(fatFileSystem.b, bl ? 1 : 0, byArray);
    }

    public int getFlagStatus() {
        FatFileSystem fatFileSystem = this;
        return fatFileSystem.getFlagStatus(fatFileSystem.b);
    }

    public void updateFlagStatus(boolean bl) {
        FatFileSystem fatFileSystem = this;
        fatFileSystem.updateFlagStatus(fatFileSystem.b, bl ? 1 : 0);
    }

    public boolean writeBufferIsEmpty() {
        return this.h == null;
    }

    public void setWriteBuffer(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            FatFileSystem fatFileSystem = this;
            this.h = (byte[])byArray.clone();
            fatFileSystem.j = CryptoUtil.CRC16((byte[])this.h, (short)0);
            fatFileSystem.i = 0;
            fatFileSystem.m = 0;
            fatFileSystem.l = null;
            JL_Log.w((String)"zzc_crc", (String)("-setWriteBuffer- crc16 = " + this.j + ", hex str = " + CHexConver.byte2HexStr((byte[])CHexConver.shortToBigBytes((short)this.j))));
            return;
        }
        FatFileSystem fatFileSystem = this;
        fatFileSystem.h = null;
        fatFileSystem.i = 0;
    }

    public void setNeedWriteData(int n) {
        byte[] byArray = this.h;
        if (this.h != null) {
            int n2 = byArray.length;
            int n3 = this.i;
            this.l = n2 >= n3 + n ? new byte[n] : new byte[n2 - n3];
            byte[] byArray2 = byArray;
            byArray = this.l;
            n2 = this.l.length;
            System.arraycopy(byArray2, n3, byArray, 0, n2);
            this.m = 0;
        }
        this.k = n;
        JL_Log.w((String)"zzc_crc", (String)("-setNeedWriteData- leftSize = " + this.k + ", writeSize = " + this.i + ", needWriteData = " + CHexConver.byte2HexStr((byte[])this.l)));
    }

    public byte[] getNeedWriteData() {
        Object object = ((FatFileSystem)object).l;
        if (((FatFileSystem)object).l != null) {
            return (byte[])object.clone();
        }
        return null;
    }

    public int getLeftDevSize() {
        return this.k;
    }

    public byte[] getNeedSendLeftData() {
        byte[] byArray = this.l;
        if (this.l == null) {
            return null;
        }
        int n = this.m;
        int n2 = byArray.length - n;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        JL_Log.i((String)u, (String)("-getNeedSendLeftData- needWriteData len = " + this.l.length + ", writeDataOffset = " + this.m + ", leftSize = " + n2));
        return byArray2;
    }

    public boolean judgeWriteFinish(int n) {
        byte[] byArray = this.h;
        return this.h != null && this.i + n >= byArray.length;
    }

    public void callbackProgress(int n) {
        if (this.q != null) {
            FatFileSystem fatFileSystem = this;
            fatFileSystem.a(fatFileSystem.c(n));
        }
        FatFileSystem fatFileSystem = this;
        fatFileSystem.i += n;
        fatFileSystem.k -= n;
        fatFileSystem.m += n;
    }

    public byte[] getWriteLeftData() {
        byte[] byArray = this.h;
        int n = this.i;
        int n2 = this.h.length - n;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public short getCrc16() {
        return this.j;
    }

    public boolean readBufferIsEmpty() {
        return this.n == null;
    }

    public void createReadBuffer(int n) {
        FatFileSystem fatFileSystem = this;
        fatFileSystem.n = new byte[n];
        fatFileSystem.o = 0;
    }

    public void putDataInReadBuff(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            int n;
            byte[] byArray2 = this.n;
            if (this.n != null && byArray.length + (n = this.o) <= byArray2.length) {
                int n2 = byArray.length;
                System.arraycopy(byArray, 0, byArray2, n, n2);
                this.o += byArray.length;
                return;
            }
        }
        JL_Log.e((String)u, (String)"-putDataInReadBuff- readBuffer no enough space.");
    }

    public int getReadLeftSize() {
        byte[] byArray = this.n;
        if (this.n == null) {
            return 0;
        }
        return byArray.length - this.o;
    }

    public byte[] getReadBuffer() {
        Object object = ((FatFileSystem)object).n;
        if (((FatFileSystem)object).n == null) {
            return null;
        }
        return (byte[])object.clone();
    }

    public void onWriteDataNotify(byte[] byArray, int n) {
        IBluetoothCtrl iBluetoothCtrl = this.d;
        iBluetoothCtrl.writeFatDataToDevice(iBluetoothCtrl.getConnectedDevice(), n, byArray);
    }

    public void onReadDataNotify(int n, int n2) {
        IBluetoothCtrl iBluetoothCtrl = this.d;
        iBluetoothCtrl.readFatDataFromDevice(iBluetoothCtrl.getConnectedDevice(), n, n2);
    }

    public void onWriteFailed(ArrayList<FatWriteOp> arrayList) {
    }

    public void onWriteFlagNotify(boolean bl) {
        IBluetoothCtrl iBluetoothCtrl = this.d;
        iBluetoothCtrl.sendWriteFlag(iBluetoothCtrl.getConnectedDevice(), bl);
    }

    public boolean isMatchVersion(String object, byte[] object2) {
        block18: {
            block19: {
                block17: {
                    int n;
                    String string;
                    Object object3;
                    block16: {
                        block15: {
                            object3 = WatchFileUtil.getJsonFileName((String)object);
                            if (stringArray.r == null || object3 == null || object2 == null || ((byte[])object2).length == 0) break block18;
                            string = u;
                            JL_Log.d((String)string, (String)("isMatchVersion :: filePath = " + (String)object + ", jsonFileName = " + (String)object3 + ", file size = " + ((byte[])object2).length));
                            byte[] byArray = stringArray.r.getFileData((byte[])object2, (String)object3);
                            object = byArray;
                            object2 = new StringBuilder().append("isMatchVersion :: data = ").append(CHexConver.byte2HexStr((byte[])object)).append(", text = ");
                            if (byArray == null) {
                                object3 = "";
                            } else {
                                String string2;
                                object3 = string2;
                                string2 = new String((byte[])object);
                            }
                            JL_Log.d((String)string, (String)((StringBuilder)object2).append((String)object3).toString());
                            if (object == null) {
                                return false;
                            }
                            object = (FileExtMsg)stringArray.c().fromJson(new String((byte[])object).trim(), FileExtMsg.class);
                            JL_Log.d((String)string, (String)("isMatchVersion :: fileExtMsg = " + object));
                            if (object != null) break block15;
                            return false;
                        }
                        String[] stringArray = stringArray;
                        object2 = new StringBuilder().append("isMatchVersion :: matchVersions = ");
                        object3 = stringArray.t;
                        if (stringArray.t != null) break block16;
                        object3 = "null";
                    }
                    object3 = Arrays.toString(object3);
                    JL_Log.d((String)string, (String)((StringBuilder)object2).append((String)object3).toString());
                    String[] stringArray = stringArray.t;
                    if (stringArray.t == null) break block17;
                    if (stringArray.length <= 0) break block17;
                    try {
                        n = stringArray.length;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    for (int i = 0; i < n; ++i) {
                        string = stringArray[i];
                        JL_Log.d((String)u, (String)("isMatchVersion :: version = " + string));
                        if (!string.equalsIgnoreCase(((FileExtMsg)object).getVersionID())) continue;
                        return true;
                    }
                    break block19;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public native long libInit(int var1, int var2);

    public native void libDestroy(long var1);

    public native int initDiskOp();

    public native void updateSysStatus(long var1, int var3);

    public native int getWriteStatus(long var1);

    public native void updateWriteStatus(long var1, int var3);

    public native int getReadStatus(long var1);

    public native void updateReadStatus(long var1, int var3, byte[] var4);

    public native int getFlagStatus(long var1);

    public native void updateFlagStatus(long var1, int var3);

    public native int mountDevice(long var1);

    public native int createNewFile(String var1, byte[] var2);

    public native int deleteFile(String var1);

    public native byte[] openFile(String var1);

    public native ArrayList<FatFile> listDir(String var1);

    public native int getFreeSize();

    public native int replaceFatFile(String var1, byte[] var2);

    public native byte[] getFileHead(String var1);
}

