/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.impl;

import android.bluetooth.BluetoothDevice;
import com.jieli.jl_rcsp.impl.RcspOpImpl;
import com.jieli.jl_rcsp.interfaces.IHandleResult;
import com.jieli.jl_rcsp.interfaces.OnOperationCallback;
import com.jieli.jl_rcsp.interfaces.health.IHealthOp;
import com.jieli.jl_rcsp.interfaces.rcsp.RcspCommandCallback;
import com.jieli.jl_rcsp.model.HealthDataQuery;
import com.jieli.jl_rcsp.model.RealTimeSportsData;
import com.jieli.jl_rcsp.model.base.BaseError;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.command.watch.RequestHealthDataCmd;
import com.jieli.jl_rcsp.model.command.watch.SportsInfoStatusSyncCmd;
import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.health.IHealthSettingToAttr;
import com.jieli.jl_rcsp.model.device.health.SportsInfo;
import com.jieli.jl_rcsp.tool.BooleanRcspActionCallback;
import com.jieli.jl_rcsp.tool.CustomRcspActionCallback;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.CommandBuilder;
import java.util.ArrayList;
import java.util.List;

public class HealthOpImpl
implements IHealthOp {
    private final RcspOpImpl a;

    public HealthOpImpl(RcspOpImpl rcspOpImpl) {
        if (rcspOpImpl != null) {
            this.a = rcspOpImpl;
            return;
        }
        throw new NullPointerException("RcspOpImpl can not be null.");
    }

    public RcspOpImpl getRcspOp() {
        return this.a;
    }

    public BluetoothDevice getConnectedDevice() {
        return this.a.getConnectedDevice();
    }

    @Override
    public void readHealthData(BluetoothDevice bluetoothDevice, HealthDataQuery object, OnOperationCallback<Boolean> onOperationCallback) {
        IHandleResult<Boolean, RequestHealthDataCmd> iHandleResult;
        CustomRcspActionCallback<Boolean, RequestHealthDataCmd> customRcspActionCallback;
        if (object == null) {
            if (onOperationCallback != null) {
                BaseError baseError;
                HealthOpImpl healthOpImpl = baseError;
                baseError = new BaseError(4097, "HealthDataQuery is null.");
                onOperationCallback.onFailed((BaseError)healthOpImpl);
            }
            return;
        }
        HealthDataQuery healthDataQuery = object;
        int n = healthDataQuery.getVersion();
        CommandBase commandBase = CommandBuilder.buildGetHealthDataInfoCmd((int)((HealthDataQuery)object).getMask(), (int)n, (byte[])healthDataQuery.getParam());
        object = customRcspActionCallback;
        IHandleResult<Boolean, RequestHealthDataCmd> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<Boolean, RequestHealthDataCmd>(){

            @Override
            public int hasResult(BluetoothDevice bluetoothDevice, RequestHealthDataCmd requestHealthDataCmd) {
                if (requestHealthDataCmd == null) {
                    return 1;
                }
                if (requestHealthDataCmd.getStatus() != 0) {
                    return requestHealthDataCmd.getStatus();
                }
                if (requestHealthDataCmd.getResponse() == null) {
                    return 1;
                }
                return CHexConver.byteToInt((byte)((RequestHealthDataCmd.Response)requestHealthDataCmd.getResponse()).getRet());
            }

            @Override
            public Boolean handleResult(BluetoothDevice bluetoothDevice, RequestHealthDataCmd requestHealthDataCmd) {
                return Boolean.TRUE;
            }
        };
        customRcspActionCallback = new CustomRcspActionCallback<Boolean, RequestHealthDataCmd>("readHealthData", onOperationCallback, iHandleResult2);
        healthOpImpl.a.sendRcspCommand(bluetoothDevice, commandBase, (RcspCommandCallback)object);
    }

    @Override
    public void readHealthSettings(BluetoothDevice object, int n, OnOperationCallback<Boolean> onOperationCallback) {
        BooleanRcspActionCallback booleanRcspActionCallback;
        BluetoothDevice bluetoothDevice = object;
        HealthOpImpl healthOpImpl = CommandBuilder.buildGetHealthSettingCmd((int)n);
        object = booleanRcspActionCallback;
        booleanRcspActionCallback = new BooleanRcspActionCallback("readHealthSettings", onOperationCallback);
        healthOpImpl.a.sendRcspCommand(bluetoothDevice, (CommandBase)healthOpImpl, (RcspCommandCallback)object);
    }

    @Override
    public void configHealthSettings(BluetoothDevice object, List<AttrBean> list, OnOperationCallback<Boolean> onOperationCallback) {
        HealthOpImpl healthOpImpl;
        if (list != null && !list.isEmpty()) {
            BooleanRcspActionCallback booleanRcspActionCallback;
            BluetoothDevice bluetoothDevice = object;
            healthOpImpl = CommandBuilder.buildSetHealthSettingCmd(list);
            object = booleanRcspActionCallback;
            booleanRcspActionCallback = new BooleanRcspActionCallback("configHealthSettings", onOperationCallback);
            healthOpImpl.a.sendRcspCommand(bluetoothDevice, (CommandBase)healthOpImpl, (RcspCommandCallback)object);
            return;
        }
        if (onOperationCallback != null) {
            BaseError baseError;
            healthOpImpl = baseError;
            baseError = new BaseError(4097, "List of AttrBean can not be empty.");
            onOperationCallback.onFailed((BaseError)healthOpImpl);
        }
    }

    @Override
    public void configHealthSettings(BluetoothDevice bluetoothDevice, IHealthSettingToAttr iHealthSettingToAttr, OnOperationCallback<Boolean> onOperationCallback) {
        ArrayList arrayList;
        ArrayList<AttrBean> arrayList2;
        if (iHealthSettingToAttr == null) {
            if (onOperationCallback != null) {
                BaseError baseError;
                arrayList2 = baseError;
                baseError = new BaseError(4097, "IHealthSettingToAttr is null.");
                onOperationCallback.onFailed((BaseError)arrayList2);
            }
            return;
        }
        HealthOpImpl healthOpImpl = arrayList2;
        arrayList2 = arrayList;
        arrayList2();
        arrayList.add(iHealthSettingToAttr.toAttr());
        healthOpImpl.configHealthSettings(bluetoothDevice, arrayList2, onOperationCallback);
    }

    @Override
    public void readSportsInfo(BluetoothDevice bluetoothDevice, OnOperationCallback<SportsInfo> onOperationCallback) {
        IHandleResult<SportsInfo, SportsInfoStatusSyncCmd> iHandleResult;
        CustomRcspActionCallback<SportsInfo, SportsInfoStatusSyncCmd> customRcspActionCallback;
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        bluetoothDevice = CommandBuilder.buildSyncSportsStatusCmd((SportsInfoStatusSyncCmd.Param)new SportsInfoStatusSyncCmd.ReadSportsInfoParam());
        CustomRcspActionCallback<SportsInfo, SportsInfoStatusSyncCmd> customRcspActionCallback2 = customRcspActionCallback;
        IHandleResult<SportsInfo, SportsInfoStatusSyncCmd> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<SportsInfo, SportsInfoStatusSyncCmd>(){

            @Override
            public int hasResult(BluetoothDevice bluetoothDevice, SportsInfoStatusSyncCmd sportsInfoStatusSyncCmd) {
                return 0;
            }

            @Override
            public SportsInfo handleResult(BluetoothDevice bluetoothDevice, SportsInfoStatusSyncCmd sportsInfoStatusSyncCmd) {
                2 this_ = (SportsInfoStatusSyncCmd.Param)sportsInfoStatusSyncCmd.getParam();
                if (this_ != null && this_.getOp() == 0) {
                    this_ = (SportsInfoStatusSyncCmd.ReadSportsInfoResponse)sportsInfoStatusSyncCmd.getResponse();
                    if (this_ == null) {
                        return null;
                    }
                    return new SportsInfo().setMode((int)((SportsInfoStatusSyncCmd.ReadSportsInfoResponse)this_).type).setState((int)((SportsInfoStatusSyncCmd.ReadSportsInfoResponse)this_).status).setId(((SportsInfoStatusSyncCmd.ReadSportsInfoResponse)this_).id).setNeedAppGPS(((SportsInfoStatusSyncCmd.ReadSportsInfoResponse)this_).hasGps).setHeartRateMode((int)((SportsInfoStatusSyncCmd.ReadSportsInfoResponse)this_).heartRateMode).setReadRealTimeDataInterval(((SportsInfoStatusSyncCmd.ReadSportsInfoResponse)this_).readReadDataInterval);
                }
                return null;
            }
        };
        customRcspActionCallback = new CustomRcspActionCallback<SportsInfo, SportsInfoStatusSyncCmd>("readSportsInfo", onOperationCallback, iHandleResult2);
        this.a.sendRcspCommand(bluetoothDevice2, (CommandBase)bluetoothDevice, customRcspActionCallback2);
    }

    @Override
    public void readRealTimeSportsData(BluetoothDevice bluetoothDevice, OnOperationCallback<RealTimeSportsData> onOperationCallback) {
        IHandleResult<RealTimeSportsData, SportsInfoStatusSyncCmd> iHandleResult;
        CustomRcspActionCallback<RealTimeSportsData, SportsInfoStatusSyncCmd> customRcspActionCallback;
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        bluetoothDevice = CommandBuilder.buildSyncSportsStatusCmd((SportsInfoStatusSyncCmd.Param)new SportsInfoStatusSyncCmd.ReadRealDataParam());
        CustomRcspActionCallback<RealTimeSportsData, SportsInfoStatusSyncCmd> customRcspActionCallback2 = customRcspActionCallback;
        IHandleResult<RealTimeSportsData, SportsInfoStatusSyncCmd> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<RealTimeSportsData, SportsInfoStatusSyncCmd>(){

            @Override
            public int hasResult(BluetoothDevice bluetoothDevice, SportsInfoStatusSyncCmd sportsInfoStatusSyncCmd) {
                return 0;
            }

            @Override
            public RealTimeSportsData handleResult(BluetoothDevice bluetoothDevice, SportsInfoStatusSyncCmd sportsInfoStatusSyncCmd) {
                3 this_ = (SportsInfoStatusSyncCmd.Param)sportsInfoStatusSyncCmd.getParam();
                if (this_ != null && this_.getOp() == 6) {
                    this_ = (SportsInfoStatusSyncCmd.ReadRealDataResponse)sportsInfoStatusSyncCmd.getResponse();
                    if (this_ == null) {
                        return null;
                    }
                    return new RealTimeSportsData().setVersion(((SportsInfoStatusSyncCmd.ReadRealDataResponse)this_).version).setStep(((SportsInfoStatusSyncCmd.ReadRealDataResponse)this_).step).setDistance(((SportsInfoStatusSyncCmd.ReadRealDataResponse)this_).distance).setDuration(((SportsInfoStatusSyncCmd.ReadRealDataResponse)this_).duration).setSpeed(((SportsInfoStatusSyncCmd.ReadRealDataResponse)this_).speed).setPace(((SportsInfoStatusSyncCmd.ReadRealDataResponse)this_).pace).setCalorie(((SportsInfoStatusSyncCmd.ReadRealDataResponse)this_).kcal).setStepFreq(((SportsInfoStatusSyncCmd.ReadRealDataResponse)this_).stepFreq).setStride(((SportsInfoStatusSyncCmd.ReadRealDataResponse)this_).stride).setExerciseStatus(((SportsInfoStatusSyncCmd.ReadRealDataResponse)this_).exerciseStatus).setHeartRate(((SportsInfoStatusSyncCmd.ReadRealDataResponse)this_).heartRate);
                }
                return null;
            }
        };
        customRcspActionCallback = new CustomRcspActionCallback<RealTimeSportsData, SportsInfoStatusSyncCmd>("readRealTimeSportsData", onOperationCallback, iHandleResult2);
        this.a.sendRcspCommand(bluetoothDevice2, (CommandBase)bluetoothDevice, customRcspActionCallback2);
    }

    @Override
    public void startSports(BluetoothDevice object, int n, OnOperationCallback<Boolean> onOperationCallback) {
        BooleanRcspActionCallback booleanRcspActionCallback;
        BluetoothDevice bluetoothDevice = object;
        HealthOpImpl healthOpImpl = CommandBuilder.buildSyncSportsStatusCmd((SportsInfoStatusSyncCmd.Param)new SportsInfoStatusSyncCmd.StartSportsParam((byte)n));
        object = booleanRcspActionCallback;
        booleanRcspActionCallback = new BooleanRcspActionCallback("startSports", onOperationCallback);
        healthOpImpl.a.sendRcspCommand(bluetoothDevice, (CommandBase)healthOpImpl, (RcspCommandCallback)object);
    }

    @Override
    public void stopSports(BluetoothDevice object, OnOperationCallback<Boolean> onOperationCallback) {
        BooleanRcspActionCallback booleanRcspActionCallback;
        BluetoothDevice bluetoothDevice = object;
        HealthOpImpl healthOpImpl = CommandBuilder.buildSyncSportsStatusCmd((SportsInfoStatusSyncCmd.Param)new SportsInfoStatusSyncCmd.AppStopSportsParam());
        object = booleanRcspActionCallback;
        booleanRcspActionCallback = new BooleanRcspActionCallback("stopSports", onOperationCallback);
        healthOpImpl.a.sendRcspCommand(bluetoothDevice, (CommandBase)healthOpImpl, (RcspCommandCallback)object);
    }

    @Override
    public void pauseSports(BluetoothDevice object, OnOperationCallback<Boolean> onOperationCallback) {
        BooleanRcspActionCallback booleanRcspActionCallback;
        BluetoothDevice bluetoothDevice = object;
        HealthOpImpl healthOpImpl = CommandBuilder.buildSyncSportsStatusCmd((SportsInfoStatusSyncCmd.Param)new SportsInfoStatusSyncCmd.PauseSportsParam());
        object = booleanRcspActionCallback;
        booleanRcspActionCallback = new BooleanRcspActionCallback("pauseSports", onOperationCallback);
        healthOpImpl.a.sendRcspCommand(bluetoothDevice, (CommandBase)healthOpImpl, (RcspCommandCallback)object);
    }

    @Override
    public void resumeSports(BluetoothDevice object, OnOperationCallback<Boolean> onOperationCallback) {
        BooleanRcspActionCallback booleanRcspActionCallback;
        BluetoothDevice bluetoothDevice = object;
        HealthOpImpl healthOpImpl = CommandBuilder.buildSyncSportsStatusCmd((SportsInfoStatusSyncCmd.Param)new SportsInfoStatusSyncCmd.ResumeSportsParam());
        object = booleanRcspActionCallback;
        booleanRcspActionCallback = new BooleanRcspActionCallback("resumeSports", onOperationCallback);
        healthOpImpl.a.sendRcspCommand(bluetoothDevice, (CommandBase)healthOpImpl, (RcspCommandCallback)object);
    }
}

