/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.impl;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.jieli.jl_rcsp.constant.RcspErrorCode;
import com.jieli.jl_rcsp.impl.WatchOpImpl;
import com.jieli.jl_rcsp.interfaces.IHandleResult;
import com.jieli.jl_rcsp.interfaces.OnOperationCallback;
import com.jieli.jl_rcsp.interfaces.alarm.IRTCOp;
import com.jieli.jl_rcsp.interfaces.rcsp.RcspCommandCallback;
import com.jieli.jl_rcsp.interfaces.watch.OnWatchCallback;
import com.jieli.jl_rcsp.model.LtvBean;
import com.jieli.jl_rcsp.model.base.BaseError;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.command.AlarmExpandCmd;
import com.jieli.jl_rcsp.model.device.AlarmBean;
import com.jieli.jl_rcsp.model.device.AlarmListInfo;
import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.AuditionParam;
import com.jieli.jl_rcsp.model.device.DefaultAlarmBell;
import com.jieli.jl_rcsp.model.device.DeviceInfo;
import com.jieli.jl_rcsp.tool.BooleanRcspActionCallback;
import com.jieli.jl_rcsp.tool.CustomRcspActionCallback;
import com.jieli.jl_rcsp.tool.callback.RcspEventListenerManager;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.CommandBuilder;
import com.jieli.jl_rcsp.util.JL_Log;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public class RTCOpImpl
implements IRTCOp {
    private static final String e = "RTCOpImpl";
    public static final int WAY_REPLY = 0;
    public static final int WAY_NOTIFY = 1;
    private static final int f = 6000;
    private static final int g = 41216;
    private final WatchOpImpl a;
    private OnOperationCallback<Boolean> b;
    private final Handler c;
    private final OnWatchCallback d;

    public RTCOpImpl(WatchOpImpl watchOpImpl) {
        OnWatchCallback onWatchCallback;
        Handler handler;
        Object object2 = handler;
        Looper looper = Looper.getMainLooper();
        handler = new Handler(looper, object -> {
            if (((Message)object).what == 41216) {
                JL_Log.w((String)e, (String)"MSG_WAIT_ALARM_DATA >> ");
                object = rTCOpImpl2.b;
                if (object != null) {
                    BaseError baseError;
                    RTCOpImpl rTCOpImpl = rTCOpImpl2;
                    RTCOpImpl rTCOpImpl2 = baseError;
                    baseError = new BaseError(12290, "The device replies to the alarm clock data timeout.");
                    object.onFailed((BaseError)rTCOpImpl2);
                    rTCOpImpl.b = null;
                }
            }
            return true;
        });
        this.c = object2;
        object2 = onWatchCallback;
        onWatchCallback = new OnWatchCallback(){

            @Override
            public void onReceiveBigData(BluetoothDevice object, int n, byte[] byArray) {
                if (n == 2) {
                    BigRTCData bigRTCData;
                    object = bigRTCData;
                    bigRTCData = new BigRTCData(byArray);
                    if (RTCOpImpl.this.b() && object.b == 0) {
                        if (RTCOpImpl.this.b != null) {
                            2 v1 = this;
                            v1.RTCOpImpl.this.b.onSuccess(Boolean.TRUE);
                            RTCOpImpl.a(v1.RTCOpImpl.this, null);
                        }
                        RTCOpImpl.this.c.removeMessages(41216);
                    }
                }
            }
        };
        this.d = object2;
        if (watchOpImpl != null) {
            this.a = watchOpImpl;
            watchOpImpl.registerOnWatchCallback((OnWatchCallback)((Object)object2));
            return;
        }
        throw new NullPointerException("WatchOpImpl can not be null.");
    }

    private boolean b() {
        return this.c.hasMessages(41216);
    }

    public static void parseRTCBigData(WatchOpImpl watchOpImpl, RcspEventListenerManager rcspEventListenerManager, byte[] byArray) {
        BigRTCData bigRTCData;
        if (watchOpImpl == null) {
            return;
        }
        String string = e;
        JL_Log.d((String)string, (String)("parseRTCBigData >> " + CHexConver.byte2HexStr((byte[])byArray)));
        BigRTCData bigRTCData2 = bigRTCData;
        bigRTCData = new BigRTCData(byArray);
        JL_Log.d((String)string, (String)("parseRTCBigData >> " + bigRTCData2));
        if (bigRTCData2.a == 0) {
            RTCOpImpl.parseRTCDataVersion0(watchOpImpl, rcspEventListenerManager, bigRTCData2.c);
        }
    }

    public static void parseRTCDataVersion0(WatchOpImpl watchOpImpl, RcspEventListenerManager rcspEventListenerManager, byte[] object) {
        List<LtvBean> list = RTCOpImpl.a((byte[])object);
        object = list;
        if (list.isEmpty()) {
            return;
        }
        WatchOpImpl watchOpImpl2 = watchOpImpl;
        watchOpImpl = watchOpImpl2.getConnectedDevice();
        DeviceInfo deviceInfo = watchOpImpl2.getDeviceInfo((BluetoothDevice)watchOpImpl);
        if (deviceInfo == null) {
            return;
        }
        Object object2 = object;
        int n = RTCOpImpl.a((List<LtvBean>)object2);
        Iterator iterator = object2.iterator();
        block13: while (iterator.hasNext()) {
            AlarmListInfo alarmListInfo;
            AlarmBean alarmBean;
            block24: {
                ArrayList arrayList;
                int n2;
                LtvBean ltvBean = (LtvBean)iterator.next();
                Object object3 = ltvBean.getData();
                switch (ltvBean.getType()) {
                    default: {
                        continue block13;
                    }
                    case 7: {
                        deviceInfo.setAlarmExpandFlag(object3[0]);
                        continue block13;
                    }
                    case 5: {
                        AlarmBean alarmBean2;
                        int n3 = object3[0] & 0xF;
                        alarmBean = alarmBean2;
                        alarmBean2 = new ArrayList();
                        n2 = 1;
                        while (n2 < ((byte[])object3).length && alarmBean.size() < n3) {
                            String string;
                            DefaultAlarmBell defaultAlarmBell;
                            int n4 = n2 + 1;
                            n2 = object3[n2];
                            int n5 = n4 + 1;
                            n4 = object3[n4];
                            byte[] byArray = new byte[n4];
                            System.arraycopy(object3, n5, byArray, 0, n4);
                            n4 = n5 + n4;
                            DefaultAlarmBell defaultAlarmBell2 = defaultAlarmBell;
                            String string2 = string;
                            string = new String(byArray);
                            defaultAlarmBell = new DefaultAlarmBell(n2, string2, false);
                            alarmBean.add(defaultAlarmBell2);
                            n2 = n4;
                        }
                        deviceInfo.setAlarmDefaultBells((List)alarmBean);
                        if (rcspEventListenerManager == null) continue block13;
                        rcspEventListenerManager.onAlarmDefaultBellListChange((BluetoothDevice)watchOpImpl, (List)alarmBean);
                        continue block13;
                    }
                    case 4: {
                        DeviceInfo deviceInfo2 = deviceInfo;
                        deviceInfo2.setAlarmVersion(n);
                        if (deviceInfo2.getAlarmListInfo() == null) {
                            ArrayList arrayList2;
                            AlarmListInfo alarmListInfo2;
                            ltvBean = alarmListInfo2;
                            object3 = arrayList2;
                            arrayList2 = new ArrayList();
                            alarmListInfo2 = new AlarmListInfo(n, (List)object3);
                            deviceInfo.setAlarmListInfo((AlarmListInfo)ltvBean);
                            continue block13;
                        }
                        deviceInfo.getAlarmListInfo().setVersion(n);
                        continue block13;
                    }
                    case 2: 
                    case 3: {
                        Object object4;
                        int n6 = CHexConver.byteToInt((byte)object3[0]);
                        alarmBean = null;
                        if (deviceInfo.getAlarmListInfo() != null && (object4 = deviceInfo.getAlarmListInfo().getAlarmBeans()) != null && !object4.isEmpty()) {
                            object4 = object4.iterator();
                            while (object4.hasNext()) {
                                AlarmBean alarmBean3 = (AlarmBean)object4.next();
                                if (n6 != alarmBean3.getIndex()) continue;
                                alarmBean = alarmBean3.copy();
                                break;
                            }
                        }
                        if (alarmBean == null) {
                            AlarmBean alarmBean4;
                            alarmBean = alarmBean4;
                            alarmBean();
                            alarmBean4.setIndex((byte)n6);
                            alarmBean4.setName("Alarm");
                            Calendar calendar = Calendar.getInstance();
                            alarmBean.setHour((byte)calendar.get(11));
                            alarmBean4.setMin((byte)calendar.get(12));
                        }
                        if (ltvBean.getType() == 3) {
                            if (rcspEventListenerManager == null) continue block13;
                            rcspEventListenerManager.onAlarmStop((BluetoothDevice)watchOpImpl, alarmBean);
                            continue block13;
                        }
                        if (rcspEventListenerManager == null) continue block13;
                        rcspEventListenerManager.onAlarmNotify((BluetoothDevice)watchOpImpl, alarmBean);
                        continue block13;
                    }
                    case 1: 
                }
                int n7 = CHexConver.byteToInt((byte)object3[0]);
                alarmBean = arrayList;
                arrayList = new ArrayList();
                if (n7 <= 0) break block24;
                n2 = 1;
                for (int i = 0; i < n7 && ((byte[])object3).length - n2 > 5; ++i) {
                    String string;
                    byte by;
                    int n8;
                    byte by2;
                    String string3;
                    byte by3;
                    byte by4;
                    byte by5;
                    boolean bl;
                    byte by6;
                    block28: {
                        String string4;
                        block27: {
                            String string5;
                            block26: {
                                String string6;
                                block25: {
                                    String string7;
                                    int n9;
                                    by6 = object3[n2++];
                                    bl = CHexConver.byteToInt((byte)object3[n2++]) == 1;
                                    by5 = object3[n2++];
                                    by4 = object3[n2++];
                                    by3 = object3[n2++];
                                    string6 = null;
                                    if ((n9 = CHexConver.byteToInt((byte)object3[n2++])) > ((byte[])object3).length - n2) break;
                                    if (n9 <= 0) break block25;
                                    int n10 = n2;
                                    int n11 = n9;
                                    string3 = string7;
                                    try {
                                        string7 = new String((byte[])object3, n2, n9);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    n2 = n10 + n11;
                                    break block26;
                                }
                                string3 = string6;
                            }
                            by2 = 0;
                            string4 = "";
                            n8 = 0;
                            by = 0;
                            if (n == 0) {
                                n = deviceInfo.getAlarmVersion();
                            }
                            int n12 = ((byte[])object3).length - n2;
                            if (n != 1 || n12 <= 6) break block27;
                            by2 = object3[n2++];
                            by = object3[n2++];
                            byte[] byArray = new byte[4];
                            System.arraycopy(object3, n2, byArray, 0, 4);
                            n8 = CHexConver.bytesToInt((byte[])byArray);
                            int n13 = n2 + 4;
                            n2 = n13 + 1;
                            n12 = object3[n13] & 0xFF;
                            if (n12 > ((byte[])object3).length - n2) break block27;
                            int n14 = n2;
                            int n15 = n12;
                            string = string5;
                            try {
                                string5 = new String((byte[])object3, n2, n12);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            n2 = n14 + n15;
                            break block28;
                        }
                        string = string4;
                    }
                    AlarmBean alarmBean5 = new AlarmBean().setVersion(n).setIndex(by6).setRepeatMode(by5).setName(string3).setDevIndex(by).setHour(by4).setMin(by3).setBellCluster(n8).setBellName(string).setBellType(by2).setOpen(bl);
                    JL_Log.d((String)e, (String)("parseRTCBigData >>> " + alarmBean5));
                    alarmBean.add(alarmBean5);
                }
            }
            AlarmListInfo alarmListInfo3 = alarmListInfo;
            new AlarmListInfo((List)alarmBean).setVersion(n);
            deviceInfo.setAlarmListInfo(alarmListInfo3);
            if (rcspEventListenerManager == null) continue;
            rcspEventListenerManager.onAlarmListChange((BluetoothDevice)watchOpImpl, alarmListInfo3);
        }
    }

    private static int a(List<LtvBean> object) {
        object = object.iterator();
        while (object.hasNext()) {
            LtvBean ltvBean = (LtvBean)object.next();
            if (ltvBean.getType() != 4) continue;
            return ltvBean.getData()[0] & 7;
        }
        return 0;
    }

    private static List<LtvBean> a(byte[] byArray) {
        if (byArray != null && byArray.length > 2) {
            int n;
            ArrayList<LtvBean> arrayList;
            ArrayList<LtvBean> arrayList2 = arrayList;
            arrayList = new ArrayList<LtvBean>();
            int n2 = 0;
            while (n2 + 1 < byArray.length && (n2 += 2) + (n = CHexConver.bytesToInt((byte[])byArray, (int)n2, (int)2)) <= byArray.length) {
                int n3 = CHexConver.byteToInt((byte)byArray[n2]);
                int n4 = n2 + 1;
                n2 = n - 1;
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n4, byArray2, 0, n2);
                n2 = n4 + n2;
                arrayList2.add(new LtvBean(n, n3, byArray2));
            }
            return arrayList2;
        }
        return new ArrayList<LtvBean>();
    }

    public static /* synthetic */ OnOperationCallback a(RTCOpImpl rTCOpImpl, OnOperationCallback onOperationCallback) {
        rTCOpImpl.b = onOperationCallback;
        return onOperationCallback;
    }

    public WatchOpImpl getRcspOp() {
        return this.a;
    }

    public BluetoothDevice getConnectedDevice() {
        return this.a.getConnectedDevice();
    }

    public void destroy() {
        RTCOpImpl rTCOpImpl = this;
        rTCOpImpl.c.removeCallbacksAndMessages(null);
        rTCOpImpl.a.unregisterOnWatchCallback(this.d);
    }

    @Override
    public void syncTime(BluetoothDevice object, OnOperationCallback<Boolean> onOperationCallback) {
        BooleanRcspActionCallback booleanRcspActionCallback;
        BluetoothDevice bluetoothDevice = object;
        RTCOpImpl rTCOpImpl = CommandBuilder.buildSyncTimeCmd((Calendar)Calendar.getInstance());
        object = booleanRcspActionCallback;
        booleanRcspActionCallback = new BooleanRcspActionCallback("syncTime", onOperationCallback);
        rTCOpImpl.a.sendRcspCommand(bluetoothDevice, (CommandBase)rTCOpImpl, (RcspCommandCallback)object);
    }

    @Override
    public void readAlarmList(BluetoothDevice bluetoothDevice, OnOperationCallback<Boolean> onOperationCallback) {
        ReadAlarmRcspCallback readAlarmRcspCallback;
        if (rTCOpImpl.b()) {
            if (onOperationCallback != null) {
                BaseError baseError;
                RTCOpImpl rTCOpImpl = baseError;
                baseError = new BaseError(4352, "Reading alarm data is in progress.");
                onOperationCallback.onFailed((BaseError)rTCOpImpl);
            }
            return;
        }
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        bluetoothDevice = CommandBuilder.buildGetAlarmCmd();
        ReadAlarmRcspCallback readAlarmRcspCallback2 = readAlarmRcspCallback;
        readAlarmRcspCallback = rTCOpImpl.new ReadAlarmRcspCallback(onOperationCallback);
        rTCOpImpl.a.sendRcspCommand(bluetoothDevice2, (CommandBase)bluetoothDevice, readAlarmRcspCallback2);
    }

    @Override
    public void readAlarmDefaultBellList(BluetoothDevice bluetoothDevice, OnOperationCallback<Boolean> onOperationCallback) {
        ReadAlarmRcspCallback readAlarmRcspCallback;
        if (rTCOpImpl.b()) {
            if (onOperationCallback != null) {
                BaseError baseError;
                RTCOpImpl rTCOpImpl = baseError;
                baseError = new BaseError(4352, "Reading alarm data is in progress.");
                onOperationCallback.onFailed((BaseError)rTCOpImpl);
            }
            return;
        }
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        bluetoothDevice = CommandBuilder.buildGetDefaultAlarmBellsCmd();
        ReadAlarmRcspCallback readAlarmRcspCallback2 = readAlarmRcspCallback;
        readAlarmRcspCallback = rTCOpImpl.new ReadAlarmRcspCallback(onOperationCallback);
        rTCOpImpl.a.sendRcspCommand(bluetoothDevice2, (CommandBase)bluetoothDevice, readAlarmRcspCallback2);
    }

    @Override
    public void deleteAlarm(BluetoothDevice object, AlarmBean alarmBean, OnOperationCallback<Boolean> onOperationCallback) {
        BooleanRcspActionCallback booleanRcspActionCallback;
        RTCOpImpl rTCOpImpl;
        if (alarmBean == null) {
            BaseError baseError;
            rTCOpImpl = baseError;
            baseError = new BaseError(4097, "AlarmBean is null.");
            if (onOperationCallback != null) {
                onOperationCallback.onFailed((BaseError)rTCOpImpl);
            }
            return;
        }
        BluetoothDevice bluetoothDevice = object;
        rTCOpImpl = CommandBuilder.buildDelAlarmCmd((AttrBean)AlarmBean.toAttrbean((AlarmBean)alarmBean, (boolean)true));
        object = booleanRcspActionCallback;
        booleanRcspActionCallback = new BooleanRcspActionCallback("deleteAlarm", onOperationCallback);
        rTCOpImpl.a.sendRcspCommand(bluetoothDevice, (CommandBase)rTCOpImpl, (RcspCommandCallback)object);
    }

    @Override
    public void addOrModifyAlarm(BluetoothDevice object, AlarmBean alarmBean, OnOperationCallback<Boolean> onOperationCallback) {
        BooleanRcspActionCallback booleanRcspActionCallback;
        RTCOpImpl rTCOpImpl;
        if (alarmBean == null) {
            BaseError baseError;
            rTCOpImpl = baseError;
            baseError = new BaseError(4097, "AlarmBean is null.");
            if (onOperationCallback != null) {
                onOperationCallback.onFailed((BaseError)rTCOpImpl);
            }
            return;
        }
        BluetoothDevice bluetoothDevice = object;
        rTCOpImpl = CommandBuilder.buildSetAlarmCmd((AttrBean)AlarmBean.toAttrbean((AlarmBean)alarmBean, (boolean)false));
        object = booleanRcspActionCallback;
        booleanRcspActionCallback = new BooleanRcspActionCallback("addOrModifyAlarm", onOperationCallback);
        rTCOpImpl.a.sendRcspCommand(bluetoothDevice, (CommandBase)rTCOpImpl, (RcspCommandCallback)object);
    }

    @Override
    public void stopAlarmBell(BluetoothDevice object, OnOperationCallback<Boolean> onOperationCallback) {
        BooleanRcspActionCallback booleanRcspActionCallback;
        BluetoothDevice bluetoothDevice = object;
        RTCOpImpl rTCOpImpl = CommandBuilder.buildStopAlarmCmd();
        object = booleanRcspActionCallback;
        booleanRcspActionCallback = new BooleanRcspActionCallback("stopAlarmBell", onOperationCallback);
        rTCOpImpl.a.sendRcspCommand(bluetoothDevice, (CommandBase)rTCOpImpl, (RcspCommandCallback)object);
    }

    @Override
    public void readAlarmBellArgs(BluetoothDevice bluetoothDevice, byte by, OnOperationCallback<List<AlarmExpandCmd.BellArg>> onOperationCallback) {
        IHandleResult<List<AlarmExpandCmd.BellArg>, AlarmExpandCmd> iHandleResult;
        CustomRcspActionCallback<List<AlarmExpandCmd.BellArg>, AlarmExpandCmd> customRcspActionCallback;
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        bluetoothDevice = CommandBuilder.buildReadBellArgsCmd((byte)by);
        CustomRcspActionCallback<List<AlarmExpandCmd.BellArg>, AlarmExpandCmd> customRcspActionCallback2 = customRcspActionCallback;
        IHandleResult<List<AlarmExpandCmd.BellArg>, AlarmExpandCmd> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<List<AlarmExpandCmd.BellArg>, AlarmExpandCmd>(){

            @Override
            public int hasResult(BluetoothDevice bluetoothDevice, AlarmExpandCmd alarmExpandCmd) {
                return 0;
            }

            @Override
            public List<AlarmExpandCmd.BellArg> handleResult(BluetoothDevice bluetoothDevice, AlarmExpandCmd alarmExpandCmd) {
                1 this_ = (AlarmExpandCmd.Response)alarmExpandCmd.getResponse();
                if (this_ == null) {
                    return null;
                }
                if (this_ instanceof AlarmExpandCmd.ReadRtcBellArgsResponse) {
                    return ((AlarmExpandCmd.ReadRtcBellArgsResponse)this_).getBellArg();
                }
                return null;
            }
        };
        customRcspActionCallback = new CustomRcspActionCallback<List<AlarmExpandCmd.BellArg>, AlarmExpandCmd>("readAlarmBellArgs", onOperationCallback, iHandleResult2);
        this.a.sendRcspCommand(bluetoothDevice2, (CommandBase)bluetoothDevice, customRcspActionCallback2);
    }

    @Override
    public void setAlarmBellArg(BluetoothDevice object, AlarmExpandCmd.BellArg bellArg, OnOperationCallback<Boolean> onOperationCallback) {
        BooleanRcspActionCallback booleanRcspActionCallback;
        RTCOpImpl rTCOpImpl;
        if (bellArg == null) {
            BaseError baseError;
            rTCOpImpl = baseError;
            baseError = new BaseError(4097, "AlarmExpandCmd.BellArg is null.");
            if (onOperationCallback != null) {
                onOperationCallback.onFailed((BaseError)rTCOpImpl);
            }
            return;
        }
        BluetoothDevice bluetoothDevice = object;
        rTCOpImpl = CommandBuilder.buildSetBellArgsCmd((AlarmExpandCmd.BellArg)bellArg);
        object = booleanRcspActionCallback;
        booleanRcspActionCallback = new BooleanRcspActionCallback("setAlarmBellArg", onOperationCallback);
        rTCOpImpl.a.sendRcspCommand(bluetoothDevice, (CommandBase)rTCOpImpl, (RcspCommandCallback)object);
    }

    @Override
    public void auditionAlarmBell(BluetoothDevice object, AuditionParam auditionParam, OnOperationCallback<Boolean> onOperationCallback) {
        BooleanRcspActionCallback booleanRcspActionCallback;
        if (auditionParam == null) {
            BaseError baseError;
            RTCOpImpl rTCOpImpl = baseError;
            baseError = new BaseError(4097, "AlarmExpandCmd.BellArg is null.");
            if (onOperationCallback != null) {
                onOperationCallback.onFailed((BaseError)rTCOpImpl);
            }
            return;
        }
        BluetoothDevice bluetoothDevice = object;
        AuditionParam auditionParam2 = auditionParam;
        byte by = auditionParam2.getDev();
        CommandBase commandBase = CommandBuilder.buildAuditionAlarmBellCmd((byte)auditionParam.getType(), (byte)by, (int)auditionParam2.getCluster());
        object = booleanRcspActionCallback;
        booleanRcspActionCallback = new BooleanRcspActionCallback("auditionAlarmBell", onOperationCallback);
        rTCOpImpl.a.sendRcspCommand(bluetoothDevice, commandBase, (RcspCommandCallback)object);
    }

    @Override
    public void stopPlayAlarmBell(BluetoothDevice object, OnOperationCallback<Boolean> onOperationCallback) {
        BooleanRcspActionCallback booleanRcspActionCallback;
        BluetoothDevice bluetoothDevice = object;
        RTCOpImpl rTCOpImpl = CommandBuilder.buildStopAuditionAlarmBellCmd();
        object = booleanRcspActionCallback;
        booleanRcspActionCallback = new BooleanRcspActionCallback("stopPlayAlarmBell", onOperationCallback);
        rTCOpImpl.a.sendRcspCommand(bluetoothDevice, (CommandBase)rTCOpImpl, (RcspCommandCallback)object);
    }

    public static class BigRTCData {
        public int a;
        public int b;
        public byte[] c;

        public BigRTCData(byte[] byArray) {
            BigRTCData bigRTCData = this;
            bigRTCData.a(byArray);
        }

        public void a(byte[] byArray) {
            this.a = CHexConver.byteToInt((byte)byArray[0]);
            int n = 1;
            if (this.a == 0) {
                byte[] byArray2 = byArray;
                this.b = CHexConver.byteToInt((byte)byArray[n]);
                int n2 = Math.min(CHexConver.bytesToInt((byte[])byArray, (int)2, (int)2), byArray.length - 4);
                byArray = new byte[n2];
                this.c = byArray;
                System.arraycopy(byArray2, 4, byArray, 0, n2);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("BigRTCData{version=").append(this.a).append(", way=").append(this.b).append(", len=");
            byte[] byArray = this.c;
            int n = this.c == null ? 0 : byArray.length;
            return stringBuilder.append(n).append(", payload=").append(CHexConver.byte2HexStr((byte[])this.c)).append('}').toString();
        }
    }

    public class ReadAlarmRcspCallback
    implements RcspCommandCallback<CommandBase> {
        private final OnOperationCallback<Boolean> a;

        public ReadAlarmRcspCallback(OnOperationCallback<Boolean> onOperationCallback) {
            this.a = onOperationCallback;
        }

        public void onCommandResponse(BluetoothDevice bluetoothDevice, CommandBase commandBase) {
            if (commandBase.getStatus() != 0) {
                if (commandBase.getStatus() == 8) {
                    OnOperationCallback<Boolean> onOperationCallback = onOperationCallback;
                    JL_Log.w((String)e, (String)"start .... MSG_WAIT_ALARM_DATA >> ");
                    RTCOpImpl.a(((ReadAlarmRcspCallback)((Object)onOperationCallback)).RTCOpImpl.this, ((ReadAlarmRcspCallback)((Object)onOperationCallback)).a);
                    ((ReadAlarmRcspCallback)((Object)onOperationCallback)).RTCOpImpl.this.c.sendEmptyMessageDelayed(41216, 6000L);
                } else {
                    ((ReadAlarmRcspCallback)((Object)onOperationCallback)).onErrCode(bluetoothDevice, RcspErrorCode.buildJsonError((int)commandBase.getId(), (int)12292, (int)commandBase.getStatus(), null));
                }
                return;
            }
            OnOperationCallback<Boolean> onOperationCallback = ((ReadAlarmRcspCallback)((Object)onOperationCallback)).a;
            if (onOperationCallback != null) {
                onOperationCallback.onSuccess(Boolean.TRUE);
            }
        }

        public void onErrCode(BluetoothDevice bluetoothDevice, BaseError baseError) {
            OnOperationCallback<Boolean> onOperationCallback = ((ReadAlarmRcspCallback)((Object)onOperationCallback)).a;
            if (onOperationCallback != null) {
                onOperationCallback.onFailed(baseError);
            }
        }
    }
}

