/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.impl;

import android.bluetooth.BluetoothDevice;
import com.jieli.jl_fatfs.interfaces.OnFatFileProgressListener;
import com.jieli.jl_fatfs.model.FatFile;
import com.jieli.jl_filebrowse.FileBrowseManager;
import com.jieli.jl_rcsp.constant.WatchConstant;
import com.jieli.jl_rcsp.constant.WatchError;
import com.jieli.jl_rcsp.impl.DataTransferOpImpl;
import com.jieli.jl_rcsp.impl.RTCOpImpl;
import com.jieli.jl_rcsp.impl.RcspOpImpl;
import com.jieli.jl_rcsp.interfaces.OnOperationCallback;
import com.jieli.jl_rcsp.interfaces.data.IDataTransferOp;
import com.jieli.jl_rcsp.interfaces.data.OnDataEventCallback;
import com.jieli.jl_rcsp.interfaces.data.OnDataTransferListener;
import com.jieli.jl_rcsp.interfaces.rcsp.OnRcspCallback;
import com.jieli.jl_rcsp.interfaces.rcsp.OnRcspEventListener;
import com.jieli.jl_rcsp.interfaces.rcsp.RcspCommandCallback;
import com.jieli.jl_rcsp.interfaces.watch.IWatchManager;
import com.jieli.jl_rcsp.interfaces.watch.IWatchOp;
import com.jieli.jl_rcsp.interfaces.watch.OnUpdateResourceCallback;
import com.jieli.jl_rcsp.interfaces.watch.OnWatchCallback;
import com.jieli.jl_rcsp.interfaces.watch.OnWatchOpCallback;
import com.jieli.jl_rcsp.model.NotificationMsg;
import com.jieli.jl_rcsp.model.WatchFileContent;
import com.jieli.jl_rcsp.model.base.BaseError;
import com.jieli.jl_rcsp.model.base.BasePacket;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.command.external_flash.ExtFlashIOCtrlNoResponseCmd;
import com.jieli.jl_rcsp.model.command.external_flash.GetExternalFlashMsgCmd;
import com.jieli.jl_rcsp.model.command.watch.PushInfoDataToDeviceCmd;
import com.jieli.jl_rcsp.model.data.DataParams;
import com.jieli.jl_rcsp.model.data.SendParams;
import com.jieli.jl_rcsp.model.device.BatteryInfo;
import com.jieli.jl_rcsp.model.device.DeviceInfo;
import com.jieli.jl_rcsp.model.parameter.ExternalFlashIOCtrlParam;
import com.jieli.jl_rcsp.model.response.ExternalFlashMsgResponse;
import com.jieli.jl_rcsp.tool.WatchCallbackManager;
import com.jieli.jl_rcsp.tool.datahandles.ParseHelper;
import com.jieli.jl_rcsp.util.JL_Log;
import com.jieli.jl_rcsp.util.RcspUtil;
import com.jieli.jl_rcsp.watch.WatchBase;
import com.jieli.jl_rcsp.watch.fatfs.FatFsWatch;
import com.jieli.jl_rcsp.watch.rcsp.RcspWatch;
import java.util.ArrayList;

public abstract class WatchOpImpl
extends RcspOpImpl
implements IWatchOp,
IDataTransferOp {
    private static final String g = WatchOpImpl.class.getSimpleName();
    public static final int FUNC_RCSP = 0;
    public static final int FUNC_WATCH = 1;
    public static final int FUNC_FILE_BROWSE = 2;
    private final WatchCallbackManager a;
    private final int b;
    private IWatchManager c;
    private final DataTransferOpImpl d;
    private final OnRcspCallback e;
    private final OnRcspEventListener f;

    public WatchOpImpl(int n) {
        OnDataTransferListener onDataTransferListener;
        DataTransferOpImpl dataTransferOpImpl;
        OnRcspCallback onRcspCallback;
        Object object = onRcspCallback;
        this.e = new OnRcspCallback(){

            public void onRcspInit(BluetoothDevice bluetoothDevice, boolean bl) {
                JL_Log.i((String)g, (String)("-onRcspInit- device = " + RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice) + ", isInit = " + bl));
                WatchOpImpl.this.a.onRcspInit(bluetoothDevice, bl);
                if (bl) {
                    3 v0 = this;
                    v0.WatchOpImpl.this.b();
                    v0.WatchOpImpl.this.a(bluetoothDevice);
                }
            }

            public void onRcspCommand(BluetoothDevice bluetoothDevice, CommandBase commandBase) {
                WatchOpImpl.this.a.onRcspCommand(bluetoothDevice, commandBase);
                if (commandBase.getId() == 26 && commandBase instanceof ExtFlashIOCtrlNoResponseCmd && (commandBase = (ExternalFlashIOCtrlParam)((ExtFlashIOCtrlNoResponseCmd)commandBase).getParam()).getOp() == 3 && commandBase.getWatchOp() == 2) {
                    WatchOpImpl.this.a.onCurrentWatchInfo(bluetoothDevice, commandBase.getFilePath());
                }
            }

            public void onRcspDataCmd(BluetoothDevice bluetoothDevice, CommandBase commandBase) {
                WatchOpImpl.this.a.onRcspDataCmd(bluetoothDevice, commandBase);
            }

            public void onRcspError(BluetoothDevice bluetoothDevice, BaseError baseError) {
                WatchOpImpl.this.a.onRcspError(bluetoothDevice, baseError);
            }

            public void onMandatoryUpgrade(BluetoothDevice bluetoothDevice) {
                WatchOpImpl.this.a.onMandatoryUpgrade(bluetoothDevice);
            }

            public void onConnectStateChange(BluetoothDevice bluetoothDevice, int n) {
                BluetoothDevice bluetoothDevice2 = WatchOpImpl.this.getTargetDevice();
                WatchOpImpl.this.a.onConnectStateChange(bluetoothDevice, n);
                JL_Log.w((String)g, (String)("-onConnectStateChange- device = " + RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice) + ", connectedDevice = " + RcspUtil.printBtDeviceInfo((BluetoothDevice)bluetoothDevice2) + ", status = " + n));
                if (RcspUtil.deviceEquals((BluetoothDevice)bluetoothDevice, (BluetoothDevice)bluetoothDevice2) && (n == 2 || n == 0)) {
                    WatchOpImpl.this.b();
                }
                super.onConnectStateChange(bluetoothDevice, n);
            }
        };
        this.f = new OnRcspEventListener(){

            public void onBatteryChange(BluetoothDevice bluetoothDevice, BatteryInfo batteryInfo) {
                WatchOpImpl.this.a.onDevicePower(bluetoothDevice, batteryInfo);
            }
        };
        this.a = new WatchCallbackManager();
        this.b = n;
        JL_Log.i((String)g, (String)("init WatchOpImpl. Lib name = " + WatchConstant.getLibVersionName() + ", func = " + n));
        if (n != 1) {
            if (n == 2 && !FileBrowseManager.getInstance().isInit()) {
                FileBrowseManager.getInstance().init((RcspOpImpl)this);
            }
        } else {
            this.registerOnRcspCallback((OnRcspCallback)object);
            if (!FileBrowseManager.getInstance().isInit()) {
                FileBrowseManager.getInstance().init((RcspOpImpl)this);
            }
        }
        DataTransferOpImpl dataTransferOpImpl2 = dataTransferOpImpl;
        object = onDataTransferListener;
        onDataTransferListener = new OnDataTransferListener(){

            @Override
            public void onReceiveData(BluetoothDevice bluetoothDevice, int n, byte[] byArray) {
                WatchOpImpl.this.a.onReceiveBigData(bluetoothDevice, n, byArray);
                if (n == 2) {
                    WatchOpImpl watchOpImpl = WatchOpImpl.this;
                    RTCOpImpl.parseRTCBigData(watchOpImpl, watchOpImpl.mRcspEventListenerManager, byArray);
                }
            }

            @Override
            public void onError(BluetoothDevice bluetoothDevice, BaseError baseError) {
                WatchOpImpl.this.a.onBigDataError(bluetoothDevice, baseError);
            }
        };
        dataTransferOpImpl = new DataTransferOpImpl(this, (OnDataTransferListener)object);
        this.d = dataTransferOpImpl2;
    }

    private void a(OnOperationCallback<ExternalFlashMsgResponse> onOperationCallback) {
        WatchBase.queryExtFlashMsgForDevice(this, onOperationCallback);
    }

    private void a(final BluetoothDevice object) {
        if (this.b != 1) {
            return;
        }
        Object object2 = this.mStatusManager.getDeviceInfo(object);
        String string = g;
        JL_Log.d((String)string, (String)("handleRcspInit : " + RcspUtil.printBtDeviceInfo((BluetoothDevice)object) + ", " + object2));
        if (object2 != null) {
            if (object2.isSupportExternalFlashTransfer()) {
                object2 = this.mStatusManager.getExtFlashMsg(object);
                JL_Log.d((String)string, (String)("-getExtFlashMsg- flashMsg = " + object2));
                if (object2 == null) {
                    OnOperationCallback<ExternalFlashMsgResponse> onOperationCallback;
                    object2 = onOperationCallback;
                    onOperationCallback = new OnOperationCallback<ExternalFlashMsgResponse>(){

                        @Override
                        public void onSuccess(ExternalFlashMsgResponse externalFlashMsgResponse) {
                            if (WatchOpImpl.this.mStatusManager.getExtFlashMsg(object) == null) {
                                WatchOpImpl.this.mStatusManager.updateExtFlashMsg(object, externalFlashMsgResponse);
                            }
                            WatchOpImpl.this.a(object);
                        }

                        @Override
                        public void onFailed(BaseError baseError) {
                            WatchOpImpl.this.a.onWatchSystemInit(baseError.getSubCode());
                        }
                    };
                    this.a((OnOperationCallback<ExternalFlashMsgResponse>)object2);
                    return;
                }
                if (object2.getSystem() == 0) {
                    FatFsWatch fatFsWatch;
                    object = fatFsWatch;
                    fatFsWatch = new FatFsWatch(this, this.a);
                    this.c = object;
                } else {
                    RcspWatch rcspWatch;
                    object = rcspWatch;
                    rcspWatch = new RcspWatch(this, this.a);
                    this.c = object;
                }
                WatchOpImpl watchOpImpl = this;
                this.c.init();
                JL_Log.w((String)string, (String)("init WatchManager....SysStatus = " + object2.getSysStatus()));
                watchOpImpl.registerOnRcspEventListener(watchOpImpl.f);
            } else {
                JL_Log.w((String)string, (String)"handleRcspInit :: device does not support flash to transfer data.");
            }
        }
    }

    private void b() {
        if (this.c != null) {
            WatchOpImpl watchOpImpl = this;
            watchOpImpl.unregisterOnRcspEventListener(watchOpImpl.f);
            watchOpImpl.c.destroy();
            watchOpImpl.c = null;
        }
    }

    private void a(BluetoothDevice bluetoothDevice, BasePacket basePacket) {
        BasePacket basePacket2 = basePacket;
        int n = basePacket2.getOpCode();
        boolean bl = basePacket2.getType() == 1;
        CommandBase commandBase = ParseHelper.convert2Command((BluetoothDevice)bluetoothDevice, (BasePacket)basePacket);
        if (commandBase == null) {
            BaseError baseError;
            WatchOpImpl watchOpImpl = watchOpImpl2;
            WatchOpImpl watchOpImpl2 = baseError;
            watchOpImpl2(12289, "Failed to parse RCSP data.");
            baseError.setOpCode(basePacket.getOpCode());
            watchOpImpl.a.onRcspError(bluetoothDevice, (BaseError)watchOpImpl2);
            return;
        }
        if (!bl && n == 214 && basePacket.getStatus() == 0 && (basePacket = (ExternalFlashMsgResponse)((GetExternalFlashMsgCmd)commandBase).getResponse()) != null) {
            WatchOpImpl watchOpImpl = watchOpImpl2;
            JL_Log.i((String)g, (String)("getDevExtFlashMsg ok, response : " + basePacket));
            watchOpImpl.mStatusManager.updateExtFlashMsg(bluetoothDevice, (ExternalFlashMsgResponse)basePacket);
            watchOpImpl.a.onExternalFlashMsg(bluetoothDevice, (ExternalFlashMsgResponse)basePacket);
            if (basePacket.getSysStatus() != 0) {
                if (watchOpImpl2.c == null) {
                    watchOpImpl2.mHandler.postDelayed(() -> watchOpImpl2.a(bluetoothDevice, (ExternalFlashMsgResponse)basePacket), 100L);
                    return;
                }
                watchOpImpl2.a.onWatchSystemException(bluetoothDevice, basePacket.getSysStatus());
            }
        }
    }

    private boolean c() {
        return (this = this.getDeviceInfo()) != null && this.getPhoneStatus() == 1;
    }

    private boolean a(OnFatFileProgressListener onFatFileProgressListener) {
        if (this.c == null) {
            JL_Log.e((String)g, (String)"checkWatchManagerIsInit : Watch system has not been initialized.");
            if (onFatFileProgressListener != null) {
                onFatFileProgressListener.onStop(16662);
            }
            return false;
        }
        return true;
    }

    private boolean a(String string, OnFatFileProgressListener onFatFileProgressListener) {
        if (this.c()) {
            JL_Log.w((String)g, (String)(string + " : " + WatchError.getErrorDesc(12545)));
            if (onFatFileProgressListener != null) {
                onFatFileProgressListener.onStop(12545);
            }
            return true;
        }
        return false;
    }

    private <T> boolean a(OnWatchOpCallback<T> onWatchOpCallback) {
        if (watchOpImpl.c == null) {
            if (onWatchOpCallback != null) {
                BaseError baseError;
                WatchOpImpl watchOpImpl = baseError;
                baseError = new BaseError(16662, WatchError.getErrorDesc(16662));
                onWatchOpCallback.onFailed((BaseError)watchOpImpl);
            }
            return false;
        }
        return true;
    }

    private /* synthetic */ void a(BluetoothDevice bluetoothDevice, ExternalFlashMsgResponse externalFlashMsgResponse) {
        this.a.onWatchSystemException(bluetoothDevice, externalFlashMsgResponse.getSysStatus());
    }

    @Override
    public void registerOnWatchCallback(OnWatchCallback onWatchCallback) {
        WatchOpImpl watchOpImpl = watchOpImpl2;
        watchOpImpl.a.registerWatchCallback(onWatchCallback);
        BluetoothDevice bluetoothDevice = watchOpImpl.getTargetDevice();
        if (bluetoothDevice != null) {
            DeviceInfo deviceInfo = watchOpImpl2.mStatusManager.getDeviceInfo(bluetoothDevice);
            WatchOpImpl watchOpImpl2 = watchOpImpl2.mStatusManager.getExtFlashMsg(bluetoothDevice);
            if (deviceInfo != null) {
                if (deviceInfo.isMandatoryUpgrade()) {
                    onWatchCallback.onMandatoryUpgrade(bluetoothDevice);
                } else if (watchOpImpl2 != null && watchOpImpl2.getSysStatus() != 0) {
                    onWatchCallback.onWatchSystemException(bluetoothDevice, watchOpImpl2.getSysStatus());
                } else if (deviceInfo.getExpandMode() == 1) {
                    JL_Log.w((String)g, (String)"-registerOnWatchCallback- onResourceUpdateUnfinished >>> ");
                    onWatchCallback.onResourceUpdateUnfinished(bluetoothDevice);
                }
            }
        }
    }

    @Override
    public void unregisterOnWatchCallback(OnWatchCallback onWatchCallback) {
        this.a.unregisterWatchCallback(onWatchCallback);
    }

    public boolean isDeviceConnected(BluetoothDevice bluetoothDevice) {
        return RcspUtil.deviceEquals((BluetoothDevice)bluetoothDevice, (BluetoothDevice)this.getConnectedDevice());
    }

    @Override
    public boolean isOTAResource() {
        IWatchOp iWatchOp = ((WatchOpImpl)iWatchOp).c;
        return iWatchOp != null && iWatchOp.isOTAResource();
    }

    @Override
    public void restoreWatchSystem(OnFatFileProgressListener onFatFileProgressListener) {
        if (this.a(onFatFileProgressListener)) {
            this.c.restoreWatchSystem(onFatFileProgressListener);
        }
    }

    @Override
    public void updateWatchResource(String string, OnUpdateResourceCallback onUpdateResourceCallback) {
        IWatchOp iWatchOp = ((WatchOpImpl)iWatchOp).c;
        if (iWatchOp != null) {
            iWatchOp.updateWatchResource(string, onUpdateResourceCallback);
        } else if (onUpdateResourceCallback != null) {
            onUpdateResourceCallback.onError(16662, WatchError.getErrorDesc(16662));
        }
    }

    @Override
    public String getCurrentBrowsePath() {
        IWatchOp iWatchOp = ((WatchOpImpl)iWatchOp).c;
        if (iWatchOp == null) {
            return null;
        }
        return iWatchOp.getCurrentBrowsePath();
    }

    @Override
    public void listWatchList(OnWatchOpCallback<ArrayList<FatFile>> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.listWatchList(onWatchOpCallback);
        }
    }

    @Override
    public void getCurrentWatchInfo(OnWatchOpCallback<FatFile> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.getCurrentWatchInfo(onWatchOpCallback);
        }
    }

    @Override
    public void setCurrentWatchInfo(String string, OnWatchOpCallback<FatFile> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.setCurrentWatchInfo(string, onWatchOpCallback);
        }
    }

    @Override
    public void enableCustomWatchBg(String string, OnWatchOpCallback<FatFile> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.enableCustomWatchBg(string, onWatchOpCallback);
        }
    }

    @Override
    public void createWatchFile(String object, boolean bl, OnFatFileProgressListener onFatFileProgressListener) {
        if (this.a(onFatFileProgressListener)) {
            RcspProgressListener rcspProgressListener;
            if (this.a("createWatchFile", onFatFileProgressListener)) {
                return;
            }
            String string = object;
            object = rcspProgressListener;
            rcspProgressListener = new RcspProgressListener(onFatFileProgressListener);
            this.c.createWatchFile(string, bl, (OnFatFileProgressListener)object);
        }
    }

    @Override
    public void deleteWatchFile(String string, OnFatFileProgressListener onFatFileProgressListener) {
        if (this.a(onFatFileProgressListener)) {
            if (this.a("deleteWatchFile", onFatFileProgressListener)) {
                return;
            }
            this.c.deleteWatchFile(string, onFatFileProgressListener);
        }
    }

    @Override
    public void openWatchFile(String string, OnWatchOpCallback<byte[]> onWatchOpCallback) {
        if (watchOpImpl.a(onWatchOpCallback)) {
            if (watchOpImpl.c()) {
                JL_Log.w((String)g, (String)"openWatchFile : The device is busy.");
                if (onWatchOpCallback != null) {
                    BaseError baseError;
                    WatchOpImpl watchOpImpl = baseError;
                    baseError = new BaseError(12545, WatchError.getErrorDesc(12545));
                    onWatchOpCallback.onFailed((BaseError)watchOpImpl);
                }
                return;
            }
            watchOpImpl.c.openWatchFile(string, onWatchOpCallback);
        }
    }

    @Override
    public void replaceWatchFile(String object, OnFatFileProgressListener onFatFileProgressListener) {
        if (this.a(onFatFileProgressListener)) {
            RcspProgressListener rcspProgressListener;
            if (this.a("replaceWatchFile", onFatFileProgressListener)) {
                return;
            }
            String string = object;
            object = rcspProgressListener;
            rcspProgressListener = new RcspProgressListener(onFatFileProgressListener);
            this.c.replaceWatchFile(string, (OnFatFileProgressListener)object);
        }
    }

    @Override
    public void getWatchSysLeftSize(OnWatchOpCallback<Long> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.getWatchSysLeftSize(onWatchOpCallback);
        }
    }

    @Override
    public void getWatchFileSize(String string, OnWatchOpCallback<WatchFileContent> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.getWatchFileSize(string, onWatchOpCallback);
        }
    }

    public void release() {
        WatchOpImpl watchOpImpl = this;
        FileBrowseManager.getInstance().release();
        watchOpImpl.unregisterOnRcspCallback(watchOpImpl.e);
        super.release();
        watchOpImpl.b();
        watchOpImpl.d.destroy();
        watchOpImpl.a.release();
    }

    @Override
    public void jumpToUpdateResource(boolean bl, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.jumpToUpdateResource(bl, onWatchOpCallback);
        }
    }

    @Override
    public void writeResourceOTAFlag(boolean bl, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.writeResourceOTAFlag(bl, onWatchOpCallback);
        }
    }

    @Override
    public void getCustomWatchBgInfo(String string, OnWatchOpCallback<String> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.getCustomWatchBgInfo(string, onWatchOpCallback);
        }
    }

    @Override
    public void getWatchMessage(String string, OnWatchOpCallback<String> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.getWatchMessage(string, onWatchOpCallback);
        }
    }

    @Override
    public void syncWeatherInfo(PushInfoDataToDeviceCmd.Weather weather, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.syncWeatherInfo(weather, onWatchOpCallback);
        }
    }

    @Override
    public void requestDevicePower(OnWatchOpCallback<Boolean> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.requestDevicePower(onWatchOpCallback);
        }
    }

    @Override
    public void pushMessageInfo(NotificationMsg notificationMsg, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.pushMessageInfo(notificationMsg, onWatchOpCallback);
        }
    }

    @Override
    public void removeMessageInfo(NotificationMsg notificationMsg, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        if (this.a(onWatchOpCallback)) {
            this.c.removeMessageInfo(notificationMsg, onWatchOpCallback);
        }
    }

    public void receiveDataFromDevice(BluetoothDevice bluetoothDevice, BasePacket basePacket) {
        WatchOpImpl watchOpImpl = this;
        super.receiveDataFromDevice(bluetoothDevice, basePacket);
        watchOpImpl.a(bluetoothDevice, basePacket);
    }

    @Override
    public boolean cancelTransfer() {
        IWatchOp iWatchOp = ((WatchOpImpl)iWatchOp).c;
        if (iWatchOp == null) {
            return false;
        }
        return iWatchOp.cancelTransfer();
    }

    @Override
    public void sendLargeData(SendParams sendParams, OnDataEventCallback onDataEventCallback) {
        this.d.sendLargeData(sendParams, onDataEventCallback);
    }

    @Override
    public void readLargeData(DataParams dataParams, OnDataEventCallback onDataEventCallback) {
        this.d.readLargeData(dataParams, onDataEventCallback);
    }

    public boolean isWatchSystemOk() {
        IWatchOp iWatchOp = ((WatchOpImpl)iWatchOp).c;
        return iWatchOp != null && iWatchOp.isInit();
    }

    public void sendRcspCommand(CommandBase commandBase, RcspCommandCallback rcspCommandCallback) {
        WatchOpImpl watchOpImpl = this;
        watchOpImpl.sendRcspCommand(watchOpImpl.getConnectedDevice(), commandBase, rcspCommandCallback);
    }

    public final class RcspProgressListener
    implements OnFatFileProgressListener {
        private final OnFatFileProgressListener a;

        public RcspProgressListener(OnFatFileProgressListener onFatFileProgressListener) {
            this.a = onFatFileProgressListener;
        }

        @Override
        public void onStart(String string) {
            OnFatFileProgressListener onFatFileProgressListener = ((RcspProgressListener)onFatFileProgressListener).a;
            if (onFatFileProgressListener != null) {
                onFatFileProgressListener.onStart(string);
            }
        }

        @Override
        public void onProgress(float f) {
            OnFatFileProgressListener onFatFileProgressListener = ((RcspProgressListener)onFatFileProgressListener).a;
            if (onFatFileProgressListener != null) {
                onFatFileProgressListener.onProgress(f);
            }
        }

        @Override
        public void onStop(int n) {
            OnFatFileProgressListener onFatFileProgressListener;
            if (((RcspProgressListener)onFatFileProgressListener).WatchOpImpl.this.c instanceof RcspWatch) {
                if (n == 0) {
                    ((RcspWatch)((RcspProgressListener)onFatFileProgressListener).WatchOpImpl.this.c).reLoadFolder(new OnWatchOpCallback<ArrayList<FatFile>>(){

                        @Override
                        public void onSuccess(ArrayList<FatFile> arrayList) {
                            if (RcspProgressListener.this.a != null) {
                                RcspProgressListener.this.a.onStop(0);
                            }
                        }

                        @Override
                        public void onFailed(BaseError baseError) {
                            if (RcspProgressListener.this.a != null) {
                                RcspProgressListener.this.a.onStop(baseError.getSubCode());
                            }
                        }
                    });
                    JL_Log.w((String)g, (String)"-RcspHandProgressListener- reLoadFolder >>>> ");
                } else {
                    onFatFileProgressListener = ((RcspProgressListener)onFatFileProgressListener).a;
                    if (onFatFileProgressListener != null) {
                        onFatFileProgressListener.onStop(n);
                    }
                }
            } else {
                onFatFileProgressListener = ((RcspProgressListener)onFatFileProgressListener).a;
                if (onFatFileProgressListener != null) {
                    onFatFileProgressListener.onStop(n);
                }
            }
        }
    }
}

