/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model;

import com.jieli.jl_rcsp.model.LtvBean;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.RcspUtil;

public class SportHealthConfigure {
    public static final int CONFIGURE_TYPE_GSENSOR = 0;
    public static final int CONFIGURE_TYPE_RATE = 1;
    public static final int CONFIGURE_TYPE_BLOOD_OXYGEN = 2;
    public static final int CONFIGURE_TYPE_ALTITUDE = 3;
    public static final int CONFIGURE_TYPE_GPS = 4;
    public static final int CONFIGURE_TYPE_SPORT_MODE = 254;
    public static final int CONFIGURE_TYPE_COMBINE_FUNC = 255;
    private GSensorFunc gSensorFunc;
    private RateFunc rateFunc;
    private BloodOxygenFunc bloodOxygenFunc;
    private AltitudeFunc altitudeFunc;
    private GPSFunc gpsFunc;
    private SportModeFunc sportModeFunc;
    private CombineFunc combineFunc;

    public SportHealthConfigure(int n, byte[] byArray) throws RuntimeException {
        SportHealthConfigure sportHealthConfigure = this;
        sportHealthConfigure.parseData(n, byArray);
    }

    private void parseData(int n, byte[] object) throws RuntimeException {
        if (n == 0) {
            if (object != null && ((byte[])object).length >= 2) {
                object = RcspUtil.parseLTVData((byte[])object).iterator();
                block7: while (object.hasNext()) {
                    SportModeFunc sportModeFunc;
                    LtvBean ltvBean = (LtvBean)object.next();
                    byte[] byArray = ltvBean.getData();
                    int n2 = ltvBean.getType();
                    if (n2 != 254) {
                        CombineFunc combineFunc;
                        if (n2 != 255) {
                            GSensorFunc gSensorFunc;
                            switch (n2) {
                                default: {
                                    continue block7;
                                }
                                case 4: {
                                    GPSFunc gPSFunc;
                                    GPSFunc gPSFunc2 = gPSFunc;
                                    gPSFunc = new GPSFunc(n, byArray);
                                    this.gpsFunc = gPSFunc2;
                                    continue block7;
                                }
                                case 3: {
                                    AltitudeFunc altitudeFunc;
                                    AltitudeFunc altitudeFunc2 = altitudeFunc;
                                    altitudeFunc = new AltitudeFunc(n, byArray);
                                    this.altitudeFunc = altitudeFunc2;
                                    continue block7;
                                }
                                case 2: {
                                    BloodOxygenFunc bloodOxygenFunc;
                                    BloodOxygenFunc bloodOxygenFunc2 = bloodOxygenFunc;
                                    bloodOxygenFunc = new BloodOxygenFunc(n, byArray);
                                    this.bloodOxygenFunc = bloodOxygenFunc2;
                                    continue block7;
                                }
                                case 1: {
                                    RateFunc rateFunc;
                                    RateFunc rateFunc2 = rateFunc;
                                    rateFunc = new RateFunc(n, byArray);
                                    this.rateFunc = rateFunc2;
                                    continue block7;
                                }
                                case 0: 
                            }
                            GSensorFunc gSensorFunc2 = gSensorFunc;
                            gSensorFunc = new GSensorFunc(n, byArray);
                            this.gSensorFunc = gSensorFunc2;
                            continue;
                        }
                        CombineFunc combineFunc2 = combineFunc;
                        combineFunc = new CombineFunc(n, byArray);
                        this.combineFunc = combineFunc2;
                        continue;
                    }
                    SportModeFunc sportModeFunc2 = sportModeFunc;
                    sportModeFunc = new SportModeFunc(n, byArray);
                    this.sportModeFunc = sportModeFunc2;
                }
                return;
            }
            throw new RuntimeException("Data exception : " + CHexConver.byte2HexStr((byte[])object));
        }
        throw new RuntimeException("Unsupported version :  " + n);
    }

    public boolean isExistGSensor() {
        return this.gSensorFunc != null;
    }

    public boolean isExistRate() {
        return this.rateFunc != null;
    }

    public boolean isExistBloodOxygen() {
        return this.bloodOxygenFunc != null;
    }

    public boolean isExistAltitude() {
        return this.altitudeFunc != null;
    }

    public boolean isExistGps() {
        return this.gpsFunc != null;
    }

    public GSensorFunc getGSensorFunc() {
        return this.gSensorFunc;
    }

    public RateFunc getRateFunc() {
        return this.rateFunc;
    }

    public BloodOxygenFunc getBloodOxygenFunc() {
        return this.bloodOxygenFunc;
    }

    public AltitudeFunc getAltitudeFunc() {
        return this.altitudeFunc;
    }

    public GPSFunc getGpsFunc() {
        return this.gpsFunc;
    }

    public SportModeFunc getSportModeFunc() {
        return this.sportModeFunc;
    }

    public CombineFunc getCombineFunc() {
        return this.combineFunc;
    }

    public String toString() {
        return "SportHealthConfigure{gSensorFunc=" + this.gSensorFunc + ", rateFunc=" + this.rateFunc + ",bloodOxygenFunc=" + this.bloodOxygenFunc + ",altitudeFunc=" + this.altitudeFunc + ",gpsFunc=" + this.gpsFunc + ",sportModeFunc=" + this.sportModeFunc + ",combineFunc=" + this.combineFunc + '}';
    }

    public static class CombineFunc
    extends BaseFunc {
        private boolean isSupportHealthMonitoring;
        private boolean isSupportPersonalInfo;
        private boolean isSupportSleepDetection;
        private boolean isSupportSedentaryReminder;
        private boolean isSupportSportRateReminder;
        private boolean isSupportAutoPressureDetection;
        private boolean isSupportFallDetection;
        private boolean isSupportSensorSettings;

        public CombineFunc(int n, byte[] byArray) throws RuntimeException {
            super(255, n, byArray);
        }

        public boolean isSupportHealthMonitoring() {
            return this.isSupportHealthMonitoring;
        }

        public boolean isSupportPersonalInfo() {
            return this.isSupportPersonalInfo;
        }

        public boolean isSupportSleepDetection() {
            return this.isSupportSleepDetection;
        }

        public boolean isSupportSedentaryReminder() {
            return this.isSupportSedentaryReminder;
        }

        public boolean isSupportSportRateReminder() {
            return this.isSupportSportRateReminder;
        }

        public boolean isSupportAutoPressureDetection() {
            return this.isSupportAutoPressureDetection;
        }

        public boolean isSupportFallDetection() {
            return this.isSupportFallDetection;
        }

        public boolean isSupportSensorSettings() {
            return this.isSupportSensorSettings;
        }

        @Override
        public void parseData(int n, byte[] byArray) throws RuntimeException {
            if (n == 0) {
                if (byArray != null && byArray.length >= 1) {
                    n = (byArray[0] & 1) == 1 ? 1 : 0;
                    this.isSupportHealthMonitoring = n;
                    n = (byArray[0] >> 1 & 1) == 1 ? 1 : 0;
                    this.isSupportPersonalInfo = n;
                    n = (byArray[0] >> 2 & 1) == 1 ? 1 : 0;
                    this.isSupportSleepDetection = n;
                    n = (byArray[0] >> 3 & 1) == 1 ? 1 : 0;
                    this.isSupportSedentaryReminder = n;
                    n = (byArray[0] >> 4 & 1) == 1 ? 1 : 0;
                    this.isSupportSportRateReminder = n;
                    n = (byArray[0] >> 5 & 1) == 1 ? 1 : 0;
                    this.isSupportAutoPressureDetection = n;
                    n = (byArray[0] >> 6 & 1) == 1 ? 1 : 0;
                    this.isSupportFallDetection = n;
                    n = (byArray[0] >> 7 & 1) == 1 ? 1 : 0;
                    this.isSupportSensorSettings = n;
                    return;
                }
                throw new RuntimeException(this.getClass().getSimpleName() + " : Data exception : " + CHexConver.byte2HexStr((byte[])byArray));
            }
            throw new RuntimeException("Unsupported version :  " + n);
        }

        public String toString() {
            return "CombineFunc{isSupportHealthMonitoring=" + this.isSupportHealthMonitoring + ", isSupportPersonalInfo=" + this.isSupportPersonalInfo + ", isSupportSleepDetection=" + this.isSupportSleepDetection + ", isSupportSedentaryReminder=" + this.isSupportSedentaryReminder + ", isSupportSportRateReminder=" + this.isSupportSportRateReminder + ", isSupportAutoPressureDetection=" + this.isSupportAutoPressureDetection + ", isSupportFallDetection=" + this.isSupportFallDetection + ", isSupportSensorSettings=" + this.isSupportSensorSettings + "} ";
        }
    }

    public static class SportModeFunc
    extends BaseFunc {
        private boolean isSupportRecord;
        private boolean isSupportCount;
        private boolean isSupportOutDoor;
        private boolean isSupportInDoor;

        public SportModeFunc(int n, byte[] byArray) throws RuntimeException {
            super(254, n, byArray);
        }

        public boolean isSupportRecord() {
            return this.isSupportRecord;
        }

        public boolean isSupportCount() {
            return this.isSupportCount;
        }

        public boolean isSupportOutDoor() {
            return this.isSupportOutDoor;
        }

        public boolean isSupportInDoor() {
            return this.isSupportInDoor;
        }

        @Override
        public void parseData(int n, byte[] byArray) throws RuntimeException {
            if (n == 0) {
                if (byArray != null && byArray.length >= 1) {
                    n = (byArray[0] & 1) == 1 ? 1 : 0;
                    this.isSupportRecord = n;
                    n = (byArray[0] >> 1 & 1) == 1 ? 1 : 0;
                    this.isSupportCount = n;
                    n = (byArray[0] >> 2 & 1) == 1 ? 1 : 0;
                    this.isSupportOutDoor = n;
                    n = (byArray[0] >> 3 & 1) == 1 ? 1 : 0;
                    this.isSupportInDoor = n;
                    return;
                }
                throw new RuntimeException(this.getClass().getSimpleName() + " : Data exception : " + CHexConver.byte2HexStr((byte[])byArray));
            }
            throw new RuntimeException("Unsupported version :  " + n);
        }

        public String toString() {
            return "SportModeFunc{isSupportRecord=" + this.isSupportRecord + ", isSupportCount=" + this.isSupportCount + ", isSupportOutDoor=" + this.isSupportOutDoor + ", isSupportInDoor=" + this.isSupportInDoor + "} ";
        }
    }

    public static class GPSFunc
    extends BaseFunc {
        private boolean isOpen;

        public GPSFunc(int n, byte[] byArray) throws RuntimeException {
            super(4, n, byArray);
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        @Override
        public void parseData(int n, byte[] byArray) throws RuntimeException {
            if (n == 0) {
                if (byArray != null && byArray.length >= 1) {
                    n = (byArray[0] & 1) == 1 ? 1 : 0;
                    this.isOpen = n;
                    return;
                }
                throw new RuntimeException(this.getClass().getSimpleName() + " : Data exception : " + CHexConver.byte2HexStr((byte[])byArray));
            }
            throw new RuntimeException("Unsupported version :  " + n);
        }

        public String toString() {
            return "GPSFunc{isOpen=" + this.isOpen + "} ";
        }
    }

    public static class AltitudeFunc
    extends BaseFunc {
        private boolean isOpen;

        public AltitudeFunc(int n, byte[] byArray) throws RuntimeException {
            super(3, n, byArray);
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        @Override
        public void parseData(int n, byte[] byArray) throws RuntimeException {
            if (n == 0) {
                if (byArray != null && byArray.length >= 1) {
                    n = (byArray[0] & 1) == 1 ? 1 : 0;
                    this.isOpen = n;
                    return;
                }
                throw new RuntimeException(this.getClass().getSimpleName() + " : Data exception : " + CHexConver.byte2HexStr((byte[])byArray));
            }
            throw new RuntimeException("Unsupported version :  " + n);
        }

        public String toString() {
            return "AltitudeFunc{isOpen=" + this.isOpen + "} ";
        }
    }

    public static class BloodOxygenFunc
    extends BaseFunc {
        private boolean isOpen;

        public BloodOxygenFunc(int n, byte[] byArray) throws RuntimeException {
            super(2, n, byArray);
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        @Override
        public void parseData(int n, byte[] byArray) throws RuntimeException {
            if (n == 0) {
                if (byArray != null && byArray.length >= 1) {
                    n = (byArray[0] & 1) == 1 ? 1 : 0;
                    this.isOpen = n;
                    return;
                }
                throw new RuntimeException(this.getClass().getSimpleName() + " : Data exception : " + CHexConver.byte2HexStr((byte[])byArray));
            }
            throw new RuntimeException("Unsupported version :  " + n);
        }

        public String toString() {
            return "BloodOxygenFunc{isOpen=" + this.isOpen + "} ";
        }
    }

    public static class RateFunc
    extends BaseFunc {
        private boolean isOpen;
        private boolean isEnableContinuousTest;

        public RateFunc(int n, byte[] byArray) throws RuntimeException {
            super(1, n, byArray);
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public boolean isEnableContinuousTest() {
            return this.isEnableContinuousTest;
        }

        @Override
        public void parseData(int n, byte[] byArray) throws RuntimeException {
            if (n == 0) {
                if (byArray != null && byArray.length >= 1) {
                    n = (byArray[0] & 1) == 1 ? 1 : 0;
                    this.isOpen = n;
                    n = (byArray[0] >> 1 & 1) == 1 ? 1 : 0;
                    this.isEnableContinuousTest = n;
                    return;
                }
                throw new RuntimeException(this.getClass().getSimpleName() + " : Data exception : " + CHexConver.byte2HexStr((byte[])byArray));
            }
            throw new RuntimeException("Unsupported version :  " + n);
        }

        public String toString() {
            return "RateFunc{isOpen=" + this.isOpen + ", isEnableContinuousTest=" + this.isEnableContinuousTest + "} ";
        }
    }

    public static class GSensorFunc
    extends BaseFunc {
        private boolean isOpen;
        private boolean isEnableSportStep;

        public GSensorFunc(int n, byte[] byArray) throws RuntimeException {
            super(0, n, byArray);
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public boolean isEnableSportStep() {
            return this.isEnableSportStep;
        }

        @Override
        public void parseData(int n, byte[] byArray) throws RuntimeException {
            if (n == 0) {
                if (byArray != null && byArray.length >= 1) {
                    n = (byArray[0] & 1) == 1 ? 1 : 0;
                    this.isOpen = n;
                    n = (byArray[0] >> 1 & 1) == 1 ? 1 : 0;
                    this.isEnableSportStep = n;
                    return;
                }
                throw new RuntimeException(this.getClass().getSimpleName() + " : Data exception : " + CHexConver.byte2HexStr((byte[])byArray));
            }
            throw new RuntimeException("Unsupported version :  " + n);
        }

        public String toString() {
            return "GSensorFunc{, isOpen=" + this.isOpen + ", isEnableSportStep=" + this.isEnableSportStep + "} ";
        }
    }

    public static abstract class BaseFunc {
        private final int type;

        public BaseFunc(int n, int n2, byte[] byArray) throws RuntimeException {
            BaseFunc baseFunc = this;
            baseFunc.type = n;
            baseFunc.parseData(n2, byArray);
        }

        public int getType() {
            return this.type;
        }

        public abstract void parseData(int var1, byte[] var2) throws RuntimeException;
    }
}

