/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.task;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.Looper;
import com.jieli.jl_rcsp.constant.WatchError;
import com.jieli.jl_rcsp.impl.RcspOpImpl;
import com.jieli.jl_rcsp.interfaces.IHandleResult;
import com.jieli.jl_rcsp.interfaces.OnOperationCallback;
import com.jieli.jl_rcsp.interfaces.rcsp.OnRcspCallback;
import com.jieli.jl_rcsp.interfaces.rcsp.RcspCommandCallback;
import com.jieli.jl_rcsp.model.base.BaseError;
import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.command.data.DataCmd;
import com.jieli.jl_rcsp.model.command.file_op.ReadFileFromDeviceCmd;
import com.jieli.jl_rcsp.model.parameter.DataParam;
import com.jieli.jl_rcsp.task.TaskBase;
import com.jieli.jl_rcsp.tool.BooleanRcspActionCallback;
import com.jieli.jl_rcsp.tool.CustomRcspActionCallback;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.CryptoUtil;
import com.jieli.jl_rcsp.util.JL_Log;
import com.jieli.jl_rcsp.util.RcspUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class GetFileTask
extends TaskBase {
    public static final int REASON_LOST_DATA = 1;
    public static final int REASON_CRC_ERROR = 2;
    public static final String BYTE_ARRAY_STREAM = "byte_array_stream";
    private final String b;
    private OutputStream c;
    private byte[] d;
    public boolean useCrc;
    private final Param e;
    private final ExecutorService f;
    private final Handler g;
    private final OnRcspCallback h;

    public GetFileTask(RcspOpImpl rcspOpImpl, String string) {
        GetFileTask getFileTask = this;
        super(rcspOpImpl);
        this.c = null;
        this.d = new byte[0];
        this.useCrc = true;
        this.f = Executors.newSingleThreadExecutor();
        rcspOpImpl = Looper.getMainLooper();
        this.g = new Handler((Looper)rcspOpImpl, message -> {
            if (message.what == 4386) {
                GetFileTask getFileTask = this;
                JL_Log.e((String)getFileTask.tag, (String)"MSG_WAITING_FOR_DATA_TIMEOUT >>>>");
                getFileTask.onError(12290, "Waiting for data timeout.");
            }
            return true;
        });
        this.h = new OnRcspCallback(){

            private /* synthetic */ void a(byte[] byArray) {
                GetFileTask.this.a(byArray);
            }

            public void onRcspCommand(BluetoothDevice bluetoothDevice, CommandBase commandBase) {
                if (!GetFileTask.this.isRun()) {
                    return;
                }
                if (commandBase.getId() != 36) {
                    return;
                }
                ReadFileFromDeviceCmd readFileFromDeviceCmd = (ReadFileFromDeviceCmd)commandBase;
                ReadFileFromDeviceCmd.Param param = (ReadFileFromDeviceCmd.Param)readFileFromDeviceCmd.getParam();
                byte by = param.op;
                if (by != -128) {
                    if (by == -127) {
                        ReadFileFromDeviceCmd.CancelParam cancelParam = (ReadFileFromDeviceCmd.CancelParam)param;
                        GetFileTask.this.b(cancelParam.reason);
                    }
                } else {
                    by = ((ReadFileFromDeviceCmd.StopParam)param).ret;
                    if (by != 0) {
                        4 v0 = this;
                        4 v1 = this = v0.GetFileTask.this.buildResponseBadResult(readFileFromDeviceCmd.getId(), by);
                        int n = v1.getSubCode();
                        v0.GetFileTask.this.onError(n, v1.getMessage());
                        return;
                    }
                    GetFileTask.this.b();
                }
                ReadFileFromDeviceCmd readFileFromDeviceCmd2 = readFileFromDeviceCmd;
                readFileFromDeviceCmd.setParam((BaseParameter)param);
                readFileFromDeviceCmd2.setOpCodeSn(commandBase.getOpCodeSn());
                readFileFromDeviceCmd2.setStatus(0);
                readFileFromDeviceCmd2.setParam((BaseParameter)new ReadFileFromDeviceCmd.Param(((ReadFileFromDeviceCmd.Param)readFileFromDeviceCmd.getParam()).op));
                GetFileTask.this.mRcspOp.sendCommandResponse(bluetoothDevice, (CommandBase)readFileFromDeviceCmd, null);
            }

            public void onRcspDataCmd(BluetoothDevice object, CommandBase commandBase) {
                if (!GetFileTask.this.isRun()) {
                    return;
                }
                if (commandBase.getId() != 1) {
                    return;
                }
                object = (DataCmd)commandBase;
                if (((DataParam)object.getParam()).getXmOpCode() != 36) {
                    return;
                }
                object = ((DataParam)object.getParam()).getData();
                if (!GetFileTask.this.f.isShutdown() && !GetFileTask.this.f.isTerminated()) {
                    GetFileTask.this.f.submit(() -> this.a((byte[])object));
                    return;
                }
                JL_Log.w((String)GetFileTask.this.tag, (String)"onRcspDataCmd >> thread pool is close.");
            }

            public void onConnectStateChange(BluetoothDevice bluetoothDevice, int n) {
                if (!GetFileTask.this.isRun()) {
                    return;
                }
                if (n != 1) {
                    GetFileTask.this.onError(8192);
                }
            }
        };
        getFileTask.b = string;
        getFileTask.e = new Param(null);
    }

    private boolean a() {
        GetFileTask getFileTask = getFileTask.mRcspOp.getDeviceInfo();
        return getFileTask != null && getFileTask.getPhoneStatus() == 1;
    }

    private void d() {
        IHandleResult<ReadFileFromDeviceCmd.StartResponse, ReadFileFromDeviceCmd> iHandleResult;
        OnOperationCallback<ReadFileFromDeviceCmd.StartResponse> onOperationCallback;
        CustomRcspActionCallback<ReadFileFromDeviceCmd.StartResponse, ReadFileFromDeviceCmd> customRcspActionCallback;
        ReadFileFromDeviceCmd readFileFromDeviceCmd;
        Object object = readFileFromDeviceCmd;
        GetFileTask getFileTask = this;
        readFileFromDeviceCmd = new ReadFileFromDeviceCmd(getFileTask.createParam(getFileTask.getConnectedDevice()));
        ReadFileFromDeviceCmd readFileFromDeviceCmd2 = object;
        object = customRcspActionCallback;
        OnOperationCallback<ReadFileFromDeviceCmd.StartResponse> onOperationCallback2 = onOperationCallback;
        onOperationCallback = new OnOperationCallback<ReadFileFromDeviceCmd.StartResponse>(){

            @Override
            public void onSuccess(ReadFileFromDeviceCmd.StartResponse startResponse) {
                1 v0 = this;
                ((GetFileTask)v0.GetFileTask.this).e.totalSize = startResponse.size;
                ((GetFileTask)v0.GetFileTask.this).e.lastCrc = 0;
                v0.GetFileTask.this.g.removeMessages(4386);
                long l = TaskBase.TIMEOUT;
                v0.GetFileTask.this.g.sendEmptyMessageDelayed(4386, l);
            }

            @Override
            public void onFailed(BaseError baseError) {
                BaseError baseError2 = baseError;
                int n = baseError2.getSubCode();
                GetFileTask.this.onError(n, baseError2.getMessage());
            }
        };
        IHandleResult<ReadFileFromDeviceCmd.StartResponse, ReadFileFromDeviceCmd> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<ReadFileFromDeviceCmd.StartResponse, ReadFileFromDeviceCmd>(){

            @Override
            public int hasResult(BluetoothDevice bluetoothDevice, ReadFileFromDeviceCmd readFileFromDeviceCmd) {
                return 0;
            }

            @Override
            public ReadFileFromDeviceCmd.StartResponse handleResult(BluetoothDevice bluetoothDevice, ReadFileFromDeviceCmd readFileFromDeviceCmd) {
                if (readFileFromDeviceCmd != null && readFileFromDeviceCmd.getStatus() == 0) {
                    if (!(readFileFromDeviceCmd.getResponse() instanceof ReadFileFromDeviceCmd.StartResponse)) {
                        return null;
                    }
                    return (ReadFileFromDeviceCmd.StartResponse)readFileFromDeviceCmd.getResponse();
                }
                return null;
            }
        };
        customRcspActionCallback = new CustomRcspActionCallback<ReadFileFromDeviceCmd.StartResponse, ReadFileFromDeviceCmd>("ReadFileFromDevice", onOperationCallback2, iHandleResult2);
        this.mRcspOp.sendRcspCommand(this.getConnectedDevice(), (CommandBase)readFileFromDeviceCmd2, (RcspCommandCallback)object);
    }

    private void a(final int n, final String string) {
        OnOperationCallback<Boolean> onOperationCallback;
        BooleanRcspActionCallback booleanRcspActionCallback;
        if (!this.isRun()) {
            return;
        }
        GetFileTask getFileTask = this;
        JL_Log.w((String)getFileTask.tag, (String)("cancel task : " + n));
        BooleanRcspActionCallback booleanRcspActionCallback2 = booleanRcspActionCallback;
        OnOperationCallback<Boolean> onOperationCallback2 = onOperationCallback;
        onOperationCallback = new OnOperationCallback<Boolean>(){

            @Override
            public void onSuccess(Boolean bl) {
                int n2 = n;
                if (n2 != 0) {
                    if (n2 == 2) {
                        GetFileTask.this.onError(12544, string);
                    }
                } else {
                    GetFileTask.this.b(0);
                }
            }

            @Override
            public void onFailed(BaseError baseError) {
                BaseError baseError2 = baseError;
                int n2 = baseError2.getSubCode();
                GetFileTask.this.onError(n2, baseError2.getMessage());
            }
        };
        booleanRcspActionCallback = new BooleanRcspActionCallback("cancelBigFileTransfer", onOperationCallback2);
        getFileTask.mRcspOp.sendRcspCommand(this.getConnectedDevice(), (CommandBase)new ReadFileFromDeviceCmd((ReadFileFromDeviceCmd.Param)new ReadFileFromDeviceCmd.CancelParam(CHexConver.intToByte((int)n))), (RcspCommandCallback)booleanRcspActionCallback2);
    }

    private void c() {
        GetFileTask getFileTask = this;
        getFileTask.e.reset();
        getFileTask.d = new byte[0];
        getFileTask.mRcspOp.registerOnRcspCallback(this.h);
        getFileTask.callbackBegin();
    }

    private void a(byte[] object) {
        block10: {
            ByteBuffer byteBuffer;
            Object[] objectArray;
            if (!objectArray.isRun() || object == null || ((byte[])object).length < 4) break block10;
            objectArray.g.removeMessages(4386);
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(object);
            object = byteBuffer2;
            int n = byteBuffer2.getInt();
            Param param = objectArray.e;
            int n2 = param.lastOffset;
            if (n2 != n) {
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = new Object[2];
                objectArray = objectArray3;
                objectArray[0] = n2;
                objectArray3[1] = n;
                super.a(1, RcspUtil.formatString((String)"Offset does not match. sdk count offset = %d, firmware return offset = %d.", (Object[])objectArray));
                return;
            }
            if (param.lastProgress != (n2 = (int)((float)n2 * 1.0f / (float)param.totalSize * 100.0f))) {
                param.lastProgress = n2;
                objectArray.g.post(() -> this.callbackProgress(n2));
            }
            if (objectArray.useCrc) {
                short s = object.getShort();
                byte[] byArray = object;
                byte[] byArray2 = new byte[byArray.remaining()];
                object = byArray2;
                byteBuffer = byArray.get(byArray2);
                objectArray.e.lastCrc = CryptoUtil.CRC16((byte[])object, (short)objectArray.e.lastCrc);
                short s2 = objectArray.e.lastCrc;
                if (s != s2) {
                    Object[] objectArray4 = objectArray;
                    Object[] objectArray5 = new Object[2];
                    objectArray = objectArray5;
                    objectArray[0] = s2;
                    objectArray5[1] = s;
                    super.a(2, RcspUtil.formatString((String)"CRC error. data crc = %x, firmware return crc = %x", (Object[])objectArray));
                    return;
                }
            } else {
                byte[] byArray = object;
                byte[] byArray3 = new byte[byArray.remaining()];
                object = byArray3;
                byteBuffer = byArray.get(byArray3);
            }
            Object[] objectArray6 = objectArray;
            objectArray.c.write((byte[])object);
            Param param2 = objectArray.e;
            int n3 = n + ((byte[])object).length;
            param2.lastOffset = n3;
            Handler handler = objectArray6.g;
            long l = TaskBase.TIMEOUT;
            try {
                handler.sendEmptyMessageDelayed(4386, l);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                super.a(1, "IO exception : " + iOException.getMessage());
            }
            byteBuffer.rewind();
            return;
        }
    }

    private void b(int n) {
        GetFileTask getFileTask = this;
        getFileTask.release();
        getFileTask.callbackCancel(n);
    }

    private void onError(int n) {
        this.onError(n, null);
    }

    private void onError(int n, String string) {
        GetFileTask getFileTask = this;
        JL_Log.e((String)getFileTask.tag, (String)("onError : code = " + n + ", " + string));
        getFileTask.release();
        if (string == null) {
            this.callbackError(n);
        } else {
            this.callbackError(n, string);
        }
    }

    private void b() {
        if (!this.isRun()) {
            return;
        }
        long l = 0L;
        OutputStream outputStream = this.c;
        if (outputStream instanceof ByteArrayOutputStream) {
            byte[] byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
            this.d = byArray;
            l = byArray.length;
        } else if (outputStream instanceof FileOutputStream) {
            l = new File(this.b).length();
        }
        if (l != (long)this.e.totalSize) {
            this.onError(16387, "Data loss. Firmware return data size = " + this.e.totalSize + ", Actual received data size = " + l);
            return;
        }
        GetFileTask getFileTask = this;
        getFileTask.release();
        getFileTask.callbackProgress(100);
        getFileTask.callbackFinish();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void release() {
        Throwable throwable2;
        OutputStream outputStream;
        GetFileTask getFileTask = this;
        getFileTask.e.reset();
        getFileTask.mRcspOp.unregisterOnRcspCallback(this.h);
        getFileTask.g.removeCallbacksAndMessages(null);
        if (!getFileTask.f.isShutdown()) {
            this.f.shutdownNow();
        }
        if ((outputStream = this.c) == null) return;
        outputStream.flush();
        this.c.close();
        this.c = null;
        return;
        {
            catch (Throwable throwable2) {
            }
            catch (IOException iOException) {}
            {
                iOException.printStackTrace();
                this.c = null;
                return;
            }
        }
        this.c = null;
        throw throwable2;
    }

    public byte[] getCacheData() {
        return this.d;
    }

    @Override
    public void start() {
        if (this.isRun()) {
            JL_Log.w((String)this.tag, (String)"Task is in progress.");
            return;
        }
        if (this.a()) {
            this.onError(12545);
            return;
        }
        GetFileTask getFileTask = this;
        getFileTask.c();
        if (BYTE_ARRAY_STREAM.equals(getFileTask.b)) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            this.c = byteArrayOutputStream2;
        } else {
            try {
                this.c = new FileOutputStream(this.b);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = WatchError.getErrorDesc(4097);
                this.onError(4097, RcspUtil.formatString((String)"%s File not found.", (Object[])objectArray2));
            }
        }
        if (this.c != null) {
            this.d();
        }
    }

    @Override
    public void cancel(byte by) {
        if (!this.isRun()) {
            return;
        }
        this.a(0, null);
    }

    public abstract ReadFileFromDeviceCmd.Param createParam(BluetoothDevice var1);

    public static class Param {
        public int totalSize;
        public int lastOffset = 0;
        public short lastCrc = 0;
        public int lastProgress = -1;

        private Param() {
        }

        public /* synthetic */ Param(1 var1_1) {
            this();
        }

        public void reset() {
            Param param = this;
            param.totalSize = 0;
            param.lastOffset = 0;
            param.lastCrc = 0;
            param.lastProgress = -1;
        }
    }
}

