/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.task;

import android.bluetooth.BluetoothDevice;
import com.jieli.jl_rcsp.constant.RcspErrorCode;
import com.jieli.jl_rcsp.constant.WatchError;
import com.jieli.jl_rcsp.impl.RcspOpImpl;
import com.jieli.jl_rcsp.model.base.BaseError;
import com.jieli.jl_rcsp.task.ITask;
import com.jieli.jl_rcsp.task.TaskListener;

public abstract class TaskBase
implements ITask {
    public static final int ERR_BUSY = 4352;
    public static final int ERR_DEVICE_NOT_CONNECT = 8192;
    public static final int ERR_COMMAND_RESPONSE = 12292;
    public static final int ERR_WAIT_DATA_TIMEOUT = 12290;
    public static final int ERR_NO_TARGET_STORAGE = 16384;
    public static final int ERR_IO_EXCEPTION = 16389;
    public static final int ERR_FUNC_NOT_SUPPORT = 4353;
    public static final int ERR_CRC_CHECK = 12544;
    public static final int ERR_MISSING_DATA = 16387;
    public static final int ERR_PARAM = 4097;
    public static final int ERR_DEVICE_IN_CALL = 12545;
    public static final int ERR_RENAME = 16898;
    public static int TIMEOUT = 20000;
    public static final int MSG_WAITING_FOR_DATA_TIMEOUT = 4386;
    public final String tag;
    public final RcspOpImpl mRcspOp;
    public TaskListener listener;
    private volatile boolean a;

    public TaskBase(RcspOpImpl rcspOpImpl) throws RuntimeException {
        TaskBase taskBase = this;
        taskBase.tag = taskBase.getClass().getSimpleName();
        if (rcspOpImpl != null) {
            this.mRcspOp = rcspOpImpl;
            return;
        }
        throw new RuntimeException("RcspOpImpl can not be null.");
    }

    @Override
    public boolean isRun() {
        return this.a;
    }

    @Override
    public void setListener(TaskListener taskListener) {
        this.listener = taskListener;
    }

    public BluetoothDevice getConnectedDevice() {
        return this.mRcspOp.getConnectedDevice();
    }

    public BaseError buildResponseBadState(int n, int n2) {
        return RcspErrorCode.buildJsonError((int)n, (int)12292, (int)n2, null);
    }

    public BaseError buildResponseBadResult(int n, int n2) {
        return RcspErrorCode.buildJsonError((int)n, (int)12293, (int)n2, null);
    }

    public void callbackBegin() {
        ((TaskBase)((Object)taskListener)).a = true;
        TaskListener taskListener = ((TaskBase)((Object)taskListener)).listener;
        if (taskListener != null) {
            taskListener.onBegin();
        }
    }

    public void callbackProgress(int n) {
        TaskListener taskListener = ((TaskBase)((Object)taskListener)).listener;
        if (taskListener != null) {
            taskListener.onProgress(n);
        }
    }

    public void callbackFinish() {
        ((TaskBase)((Object)taskListener)).a = false;
        TaskListener taskListener = ((TaskBase)((Object)taskListener)).listener;
        if (taskListener != null) {
            taskListener.onFinish();
        }
    }

    public void callbackCancel(int n) {
        ((TaskBase)((Object)taskListener)).a = false;
        TaskListener taskListener = ((TaskBase)((Object)taskListener)).listener;
        if (taskListener != null) {
            taskListener.onCancel(n);
        }
    }

    public void callbackError(int n) {
        this.callbackError(n, WatchError.getErrorDesc(n));
    }

    public void callbackError(int n, String string) {
        ((TaskBase)((Object)taskListener)).a = false;
        TaskListener taskListener = ((TaskBase)((Object)taskListener)).listener;
        if (taskListener != null) {
            taskListener.onError(n, string);
        }
    }
}

