/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.task.logcat;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.Looper;
import com.jieli.jl_rcsp.constant.WatchError;
import com.jieli.jl_rcsp.impl.RcspOpImpl;
import com.jieli.jl_rcsp.interfaces.IHandleResult;
import com.jieli.jl_rcsp.interfaces.OnOperationCallback;
import com.jieli.jl_rcsp.interfaces.rcsp.OnRcspCallback;
import com.jieli.jl_rcsp.interfaces.rcsp.RcspCommandCallback;
import com.jieli.jl_rcsp.model.base.BaseError;
import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.command.ReadErrorMsgCmd;
import com.jieli.jl_rcsp.model.command.data.DataCmd;
import com.jieli.jl_rcsp.model.parameter.DataParam;
import com.jieli.jl_rcsp.task.TaskBase;
import com.jieli.jl_rcsp.tool.CustomRcspActionCallback;
import com.jieli.jl_rcsp.util.CommandBuilder;
import com.jieli.jl_rcsp.util.CryptoUtil;
import com.jieli.jl_rcsp.util.JL_Log;
import com.jieli.jl_rcsp.util.RcspUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ReadLogcatTask
extends TaskBase {
    public static int WAIT_CMD_TIMEOUT = 12000;
    private static final int g = 4118;
    private BluetoothDevice b;
    private final ByteArrayOutputStream c;
    private ReadErrorMsgCmd.ReadErrorMsgResponse d;
    private final Handler e;
    private final OnRcspCallback f;

    public ReadLogcatTask(RcspOpImpl object) throws RuntimeException {
        super((RcspOpImpl)object);
        OnRcspCallback onRcspCallback;
        Handler handler;
        ByteArrayOutputStream byteArrayOutputStream;
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        this.c = object;
        object = handler;
        Looper looper = Looper.getMainLooper();
        handler = new Handler(looper, message -> {
            if (message.what == 4118) {
                ReadLogcatTask readLogcatTask = this;
                JL_Log.w((String)readLogcatTask.tag, (String)"MSG_WAIT_COMMAND_TIMEOUT : >>>>>>>>>>");
                if (readLogcatTask.isRun()) {
                    this.a(12290, "Waiting for data timeout.");
                }
            }
            return true;
        });
        this.e = object;
        object = onRcspCallback;
        onRcspCallback = new OnRcspCallback(){

            public void onRcspDataCmd(BluetoothDevice bluetoothDevice, CommandBase commandBase) {
                4 v0 = this;
                super.onRcspDataCmd(bluetoothDevice, commandBase);
                if (v0.ReadLogcatTask.this.a(bluetoothDevice)) {
                    bluetoothDevice = (DataParam)((DataCmd)commandBase).getParam();
                    if (bluetoothDevice != null && bluetoothDevice.getXmOpCode() == 41) {
                        ReadLogcatTask.this.a(bluetoothDevice.getData());
                    } else {
                        return;
                    }
                }
            }

            public void onRcspCommand(BluetoothDevice bluetoothDevice, CommandBase commandBase) {
                super.onRcspCommand(bluetoothDevice, commandBase);
                if (commandBase != null && commandBase.getId() == 41) {
                    if (ReadLogcatTask.this.a(bluetoothDevice) && ((ReadErrorMsgCmd.ReadErrorMsgParam)(bluetoothDevice = (ReadErrorMsgCmd)commandBase).getParam()).getOp() == 1) {
                        ReadLogcatTask.this.a((ReadErrorMsgCmd)bluetoothDevice);
                    }
                    return;
                }
            }
        };
        this.f = object;
    }

    private void a(ReadErrorMsgCmd.ReadErrorMsgResponse readErrorMsgResponse) {
        this.d = readErrorMsgResponse;
    }

    private void c() {
        IHandleResult<ReadErrorMsgCmd.ReadErrorMsgResponse, ReadErrorMsgCmd> iHandleResult;
        OnOperationCallback<ReadErrorMsgCmd.ReadErrorMsgResponse> onOperationCallback;
        ReadLogcatTask readLogcatTask = this;
        readLogcatTask.b();
        OnOperationCallback<ReadErrorMsgCmd.ReadErrorMsgResponse> onOperationCallback2 = onOperationCallback;
        onOperationCallback = new OnOperationCallback<ReadErrorMsgCmd.ReadErrorMsgResponse>(){

            @Override
            public void onSuccess(ReadErrorMsgCmd.ReadErrorMsgResponse readErrorMsgResponse) {
                if (readErrorMsgResponse == null) {
                    BaseError baseError;
                    1 v0 = this_;
                    1 this_ = baseError;
                    baseError = new BaseError(12289, WatchError.getErrorDesc(12289));
                    v0.onFailed((BaseError)this_);
                    return;
                }
                1 v2 = this_;
                v2.ReadLogcatTask.this.a(readErrorMsgResponse);
                if (v2.ReadLogcatTask.this.d.getSize() <= 0) {
                    1 v3 = this_;
                    JL_Log.w((String)v3.ReadLogcatTask.this.tag, (String)("startReadLogcat : Device has no abnormal information. file size = " + this_.ReadLogcatTask.this.d.getSize()));
                    v3.ReadLogcatTask.this.a();
                    return;
                }
                1 v4 = this_;
                v4.ReadLogcatTask.this.e.removeMessages(4118);
                long l = WAIT_CMD_TIMEOUT;
                v4.ReadLogcatTask.this.e.sendEmptyMessageDelayed(4118, l);
            }

            @Override
            public void onFailed(BaseError baseError) {
                BaseError baseError2 = baseError;
                int n = baseError2.getSubCode();
                ReadLogcatTask.this.a(n, baseError2.getMessage());
            }
        };
        IHandleResult<ReadErrorMsgCmd.ReadErrorMsgResponse, ReadErrorMsgCmd> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<ReadErrorMsgCmd.ReadErrorMsgResponse, ReadErrorMsgCmd>(){

            @Override
            public int hasResult(BluetoothDevice bluetoothDevice, ReadErrorMsgCmd readErrorMsgCmd) {
                return 0;
            }

            @Override
            public ReadErrorMsgCmd.ReadErrorMsgResponse handleResult(BluetoothDevice bluetoothDevice, ReadErrorMsgCmd readErrorMsgCmd) {
                if (readErrorMsgCmd != null && readErrorMsgCmd.getStatus() == 0) {
                    return (ReadErrorMsgCmd.ReadErrorMsgResponse)readErrorMsgCmd.getResponse();
                }
                return null;
            }
        };
        readLogcatTask.mRcspOp.sendRcspCommand(this.b, CommandBuilder.buildStartReadErrorMsgCmd(), new CustomRcspActionCallback<ReadErrorMsgCmd.ReadErrorMsgResponse, ReadErrorMsgCmd>("startReadLogcat", onOperationCallback2, iHandleResult2));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(byte[] byArray) {
        Throwable throwable222222;
        block16: {
            if (byArray != null && byArray.length != 0 && this.isRun()) {
                block15: {
                    if (this.e.hasMessages(4118)) {
                        this.e.removeMessages(4118);
                    }
                    ReadLogcatTask readLogcatTask = this;
                    readLogcatTask.c.write(byArray);
                    int n = readLogcatTask.c.size();
                    if (readLogcatTask.d.getSize() <= 0) break block15;
                    if ((n = n * 100 / this.d.getSize()) >= 100) {
                        n = 99;
                    }
                    this.callbackProgress(n);
                }
                try {
                    this.c.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
            JL_Log.w((String)this.tag, (String)"handleLogcat: invalid param.");
            return;
            {
                ReadLogcatTask readLogcatTask;
                catch (Throwable throwable222222) {
                    break block16;
                }
                catch (IOException iOException) {}
                {
                    ReadLogcatTask readLogcatTask2 = this;
                    readLogcatTask = readLogcatTask2;
                    iOException.printStackTrace();
                    readLogcatTask2.callbackError(16389, "IO Exception = " + iOException.getMessage());
                }
                try {
                    readLogcatTask.c.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return;
        }
        try {
            this.c.close();
            throw throwable222222;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        throw throwable222222;
    }

    private void a(ReadErrorMsgCmd object) {
        if (object != null && this.isRun()) {
            RcspCommandCallback<ReadErrorMsgCmd> rcspCommandCallback;
            ReadErrorMsgCmd.ResponseReadResult responseReadResult;
            ReadLogcatTask readLogcatTask = this;
            byte[] byArray = readLogcatTask.c.toByteArray();
            final short s = CryptoUtil.CRC16((byte[])byArray, (short)0);
            final short s2 = readLogcatTask.d.getCrc();
            final int n = s2 == s ? 0 : 6;
            ReadErrorMsgCmd readErrorMsgCmd = object;
            ReadErrorMsgCmd.ResponseReadResult responseReadResult2 = new Object[3];
            ReadErrorMsgCmd.ResponseReadResult responseReadResult3 = responseReadResult2;
            responseReadResult3[0] = s;
            responseReadResult3[1] = s2;
            responseReadResult2[2] = n;
            JL_Log.d((String)this.tag, (String)RcspUtil.formatString((String)"handleStopRead: sdk read logcat crc = %d, firmware crc = %d, status = %d", (Object[])responseReadResult3));
            readErrorMsgCmd.setStatus(n);
            responseReadResult3 = responseReadResult;
            responseReadResult3();
            responseReadResult3.setSize(byArray.length);
            responseReadResult.setCrc(s);
            readErrorMsgCmd.setParam((BaseParameter)responseReadResult);
            ReadErrorMsgCmd readErrorMsgCmd2 = object;
            object = rcspCommandCallback;
            rcspCommandCallback = new RcspCommandCallback<ReadErrorMsgCmd>(){

                public void onCommandResponse(BluetoothDevice bluetoothDevice, ReadErrorMsgCmd readErrorMsgCmd) {
                    if (n == 0) {
                        ReadLogcatTask.this.a();
                    } else {
                        ReadLogcatTask.this.a(12544, "Check data crc error. firmware crc = " + s2 + ", data crc = " + s);
                    }
                }

                public void onErrCode(BluetoothDevice bluetoothDevice, BaseError baseError) {
                    BaseError baseError2 = baseError;
                    int n2 = baseError2.getSubCode();
                    ReadLogcatTask.this.a(n2, baseError2.getMessage());
                }
            };
            this.mRcspOp.sendCommandResponse(this.b, (CommandBase)readErrorMsgCmd2, (RcspCommandCallback)object);
            return;
        }
        JL_Log.w((String)this.tag, (String)"handleStopRead : Reading logcat did not start.");
    }

    private void release() {
        ReadLogcatTask readLogcatTask = this;
        readLogcatTask.b = null;
        readLogcatTask.mRcspOp.unregisterOnRcspCallback(this.f);
        readLogcatTask.e.removeCallbacksAndMessages(null);
    }

    private boolean a(BluetoothDevice bluetoothDevice) {
        return bluetoothDevice != null && this.b != null && bluetoothDevice.getAddress().equals(this.b.getAddress());
    }

    private void b() {
        ReadLogcatTask readLogcatTask = this;
        readLogcatTask.b = readLogcatTask.getConnectedDevice();
        readLogcatTask.c.reset();
        readLogcatTask.mRcspOp.registerOnRcspCallback(this.f);
        readLogcatTask.callbackBegin();
    }

    private void a(int n) {
        this.a(n, null);
    }

    private void a(int n, String string) {
        JL_Log.w((String)this.tag, (String)("postError : " + n + ", " + string));
        if (string == null) {
            this.callbackError(n);
        } else {
            this.callbackError(n, string);
        }
        this.release();
    }

    private void a() {
        ReadLogcatTask readLogcatTask = this;
        readLogcatTask.callbackProgress(100);
        readLogcatTask.callbackFinish();
        readLogcatTask.release();
    }

    @Override
    public void start() {
        if (this.isRun()) {
            JL_Log.w((String)this.tag, (String)"Task is in progress.");
            return;
        }
        if (!this.mRcspOp.isRcspInit()) {
            this.a(8192);
            return;
        }
        if (!this.mRcspOp.getDeviceInfo().isSupportReadErrorMSg()) {
            this.a(4353);
            return;
        }
        ReadLogcatTask readLogcatTask = this;
        JL_Log.d((String)readLogcatTask.tag, (String)"start... device support reading error message.");
        readLogcatTask.c();
    }

    @Override
    public void cancel(byte by) {
    }

    public byte[] getResult() {
        return this.c.toByteArray();
    }
}

