/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.watch;

import android.bluetooth.BluetoothDevice;
import com.jieli.jl_fatfs.model.FatFile;
import com.jieli.jl_fatfs.utils.FatUtil;
import com.jieli.jl_rcsp.constant.RcspErrorCode;
import com.jieli.jl_rcsp.constant.WatchError;
import com.jieli.jl_rcsp.impl.RcspOpImpl;
import com.jieli.jl_rcsp.interfaces.IHandleResult;
import com.jieli.jl_rcsp.interfaces.OnOperationCallback;
import com.jieli.jl_rcsp.interfaces.listener.ThreadStateListener;
import com.jieli.jl_rcsp.interfaces.rcsp.OnRcspCallback;
import com.jieli.jl_rcsp.interfaces.rcsp.RcspCommandCallback;
import com.jieli.jl_rcsp.interfaces.watch.IWatchManager;
import com.jieli.jl_rcsp.interfaces.watch.OnWatchCallback;
import com.jieli.jl_rcsp.interfaces.watch.OnWatchOpCallback;
import com.jieli.jl_rcsp.model.NotificationMsg;
import com.jieli.jl_rcsp.model.base.BaseError;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.command.external_flash.ExternalFlashIOCtrlCmd;
import com.jieli.jl_rcsp.model.command.external_flash.GetExternalFlashMsgCmd;
import com.jieli.jl_rcsp.model.command.watch.PushInfoDataToDeviceCmd;
import com.jieli.jl_rcsp.model.response.ExternalFlashIOCtrlResponse;
import com.jieli.jl_rcsp.model.response.ExternalFlashMsgResponse;
import com.jieli.jl_rcsp.tool.CustomRcspActionCallback;
import com.jieli.jl_rcsp.tool.DeviceStatusManager;
import com.jieli.jl_rcsp.tool.SyncMessageTask;
import com.jieli.jl_rcsp.tool.WatchCallbackManager;
import com.jieli.jl_rcsp.util.CommandBuilder;
import com.jieli.jl_rcsp.util.JL_Log;
import com.jieli.jl_rcsp.util.RcspUtil;

public abstract class WatchBase
implements IWatchManager {
    public String TAG;
    public final RcspOpImpl mRcspOp;
    public final WatchCallbackManager mWatchCallbackManager;
    public final DeviceStatusManager mStatusManager;
    public volatile boolean isOTAResource;
    public boolean isSysException;
    private SyncMessageTask a;
    private final OnRcspCallback b;

    public WatchBase(RcspOpImpl object, WatchCallbackManager watchCallbackManager) {
        OnRcspCallback onRcspCallback;
        RcspOpImpl rcspOpImpl = object;
        RcspOpImpl rcspOpImpl2 = object;
        WatchBase watchBase = this;
        watchBase.TAG = watchBase.getClass().getSimpleName();
        watchBase.mStatusManager = DeviceStatusManager.getInstance();
        watchBase.isSysException = false;
        object = onRcspCallback;
        watchBase.b = new OnRcspCallback(){

            public void onConnectStateChange(BluetoothDevice bluetoothDevice, int n) {
                if (n != 1) {
                    WatchBase.this.isOTAResource = false;
                    WatchBase.this.isSysException = false;
                    WatchBase.this.a();
                }
            }
        };
        this.mRcspOp = rcspOpImpl2;
        this.mWatchCallbackManager = watchCallbackManager;
        rcspOpImpl.registerOnRcspCallback((OnRcspCallback)object);
    }

    public static void queryExtFlashMsgForDevice(RcspOpImpl rcspOpImpl, OnOperationCallback<ExternalFlashMsgResponse> onOperationCallback) {
        IHandleResult<ExternalFlashMsgResponse, GetExternalFlashMsgCmd> iHandleResult;
        CustomRcspActionCallback<ExternalFlashMsgResponse, GetExternalFlashMsgCmd> customRcspActionCallback;
        if (rcspOpImpl == null) {
            return;
        }
        RcspOpImpl rcspOpImpl2 = rcspOpImpl;
        rcspOpImpl = rcspOpImpl2.getConnectedDevice();
        CustomRcspActionCallback<ExternalFlashMsgResponse, GetExternalFlashMsgCmd> customRcspActionCallback2 = customRcspActionCallback;
        IHandleResult<ExternalFlashMsgResponse, GetExternalFlashMsgCmd> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<ExternalFlashMsgResponse, GetExternalFlashMsgCmd>(){

            @Override
            public int hasResult(BluetoothDevice bluetoothDevice, GetExternalFlashMsgCmd getExternalFlashMsgCmd) {
                return 0;
            }

            @Override
            public ExternalFlashMsgResponse handleResult(BluetoothDevice bluetoothDevice, GetExternalFlashMsgCmd getExternalFlashMsgCmd) {
                if (getExternalFlashMsgCmd != null && getExternalFlashMsgCmd.getStatus() == 0) {
                    return (ExternalFlashMsgResponse)getExternalFlashMsgCmd.getResponse();
                }
                return null;
            }
        };
        customRcspActionCallback = new CustomRcspActionCallback<ExternalFlashMsgResponse, GetExternalFlashMsgCmd>("queryExtFlashMsgForDevice", onOperationCallback, iHandleResult2);
        rcspOpImpl2.sendRcspCommand((BluetoothDevice)rcspOpImpl, CommandBuilder.buildGetExternalFlashMsgCmd(), customRcspActionCallback2);
    }

    private void b() {
        if (this.a == null) {
            ThreadStateListener threadStateListener;
            SyncMessageTask syncMessageTask;
            SyncMessageTask syncMessageTask2 = syncMessageTask;
            RcspOpImpl rcspOpImpl = this.mRcspOp;
            ThreadStateListener threadStateListener2 = threadStateListener;
            threadStateListener = new ThreadStateListener(){

                public void onStart(long l) {
                }

                public void onFinish(long l) {
                    if (WatchBase.this.a != null && WatchBase.this.a.getId() == l) {
                        WatchBase.a(WatchBase.this, null);
                    }
                }
            };
            syncMessageTask2(rcspOpImpl, threadStateListener2);
            this.a = syncMessageTask2;
            syncMessageTask.start();
        }
    }

    private void a() {
        SyncMessageTask syncMessageTask = ((WatchBase)((Object)syncMessageTask)).a;
        if (syncMessageTask != null) {
            syncMessageTask.exit();
        }
    }

    public static /* synthetic */ SyncMessageTask a(WatchBase watchBase, SyncMessageTask syncMessageTask) {
        watchBase.a = syncMessageTask;
        return syncMessageTask;
    }

    @Override
    public void registerOnWatchCallback(OnWatchCallback onWatchCallback) {
        this.mWatchCallbackManager.registerWatchCallback(onWatchCallback);
    }

    @Override
    public void unregisterOnWatchCallback(OnWatchCallback onWatchCallback) {
        this.mWatchCallbackManager.unregisterWatchCallback(onWatchCallback);
    }

    @Override
    public OnWatchCallback getCallback() {
        return this.mWatchCallbackManager;
    }

    @Override
    public boolean isOTAResource() {
        return this.isOTAResource;
    }

    @Override
    public boolean isSysException() {
        return this.isSysException;
    }

    public RcspOpImpl getRcspOp() {
        return this.mRcspOp;
    }

    @Override
    public void destroy() {
        WatchBase watchBase = this;
        watchBase.mRcspOp.unregisterOnRcspCallback(this.b);
        watchBase.a();
    }

    @Override
    public void getCurrentWatchInfo(OnWatchOpCallback<FatFile> onWatchOpCallback) {
        ExternalFlashIOCtrlHandleResult<FatFile> externalFlashIOCtrlHandleResult;
        HandleRcspCallback<FatFile, ExternalFlashIOCtrlCmd> handleRcspCallback;
        RcspOpImpl rcspOpImpl = this.mRcspOp;
        BluetoothDevice bluetoothDevice = rcspOpImpl.getTargetDevice();
        HandleRcspCallback<FatFile, ExternalFlashIOCtrlCmd> handleRcspCallback2 = handleRcspCallback;
        ExternalFlashIOCtrlHandleResult<FatFile> externalFlashIOCtrlHandleResult2 = externalFlashIOCtrlHandleResult;
        externalFlashIOCtrlHandleResult = new ExternalFlashIOCtrlHandleResult<FatFile>(){

            @Override
            public FatFile handleResult(BluetoothDevice bluetoothDevice, ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd) {
                return WatchBase.this.getWatchFileByPath(((ExternalFlashIOCtrlResponse)externalFlashIOCtrlCmd.getResponse()).getFilePath());
            }
        };
        handleRcspCallback = new HandleRcspCallback<FatFile, ExternalFlashIOCtrlCmd>("getCurrentWatchInfo", onWatchOpCallback, externalFlashIOCtrlHandleResult2);
        rcspOpImpl.sendRcspCommand(bluetoothDevice, CommandBuilder.buildExternalFlashGetCurrentWatchMsgCmd(), handleRcspCallback2);
    }

    @Override
    public void setCurrentWatchInfo(final String string, OnWatchOpCallback<FatFile> onWatchOpCallback) {
        ExternalFlashIOCtrlHandleResult<FatFile> externalFlashIOCtrlHandleResult;
        HandleRcspCallback<FatFile, ExternalFlashIOCtrlCmd> handleRcspCallback;
        RcspOpImpl rcspOpImpl = this.mRcspOp;
        BluetoothDevice bluetoothDevice = rcspOpImpl.getTargetDevice();
        HandleRcspCallback<FatFile, ExternalFlashIOCtrlCmd> handleRcspCallback2 = handleRcspCallback;
        ExternalFlashIOCtrlHandleResult<FatFile> externalFlashIOCtrlHandleResult2 = externalFlashIOCtrlHandleResult;
        externalFlashIOCtrlHandleResult = new ExternalFlashIOCtrlHandleResult<FatFile>(){

            @Override
            public FatFile handleResult(BluetoothDevice bluetoothDevice, ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd) {
                return WatchBase.this.getWatchFileByPath(string);
            }
        };
        handleRcspCallback = new HandleRcspCallback<FatFile, ExternalFlashIOCtrlCmd>("setCurrentWatchInfo", onWatchOpCallback, externalFlashIOCtrlHandleResult2);
        rcspOpImpl.sendRcspCommand(bluetoothDevice, CommandBuilder.buildExternalFlashSetWatchCmd((String)string), handleRcspCallback2);
    }

    @Override
    public void enableCustomWatchBg(final String string, OnWatchOpCallback<FatFile> onWatchOpCallback) {
        ExternalFlashIOCtrlHandleResult<FatFile> externalFlashIOCtrlHandleResult;
        HandleRcspCallback<FatFile, ExternalFlashIOCtrlCmd> handleRcspCallback;
        RcspOpImpl rcspOpImpl = this.mRcspOp;
        BluetoothDevice bluetoothDevice = rcspOpImpl.getTargetDevice();
        HandleRcspCallback<FatFile, ExternalFlashIOCtrlCmd> handleRcspCallback2 = handleRcspCallback;
        ExternalFlashIOCtrlHandleResult<FatFile> externalFlashIOCtrlHandleResult2 = externalFlashIOCtrlHandleResult;
        externalFlashIOCtrlHandleResult = new ExternalFlashIOCtrlHandleResult<FatFile>(){

            @Override
            public FatFile handleResult(BluetoothDevice bluetoothDevice, ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd) {
                return WatchBase.this.getWatchFileByPath(string);
            }
        };
        handleRcspCallback = new HandleRcspCallback<FatFile, ExternalFlashIOCtrlCmd>("enableCustomWatchBg", onWatchOpCallback, externalFlashIOCtrlHandleResult2);
        rcspOpImpl.sendRcspCommand(bluetoothDevice, CommandBuilder.buildExternalFlashEnableCustomWatchCmd((String)string), handleRcspCallback2);
    }

    @Override
    public void jumpToUpdateResource(boolean bl, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        ExternalFlashIOCtrlBooleanResult externalFlashIOCtrlBooleanResult;
        HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd> handleRcspCallback;
        RcspOpImpl rcspOpImpl = watchBase.mRcspOp;
        WatchBase watchBase = rcspOpImpl.getTargetDevice();
        HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd> handleRcspCallback2 = handleRcspCallback;
        ExternalFlashIOCtrlBooleanResult externalFlashIOCtrlBooleanResult2 = externalFlashIOCtrlBooleanResult;
        externalFlashIOCtrlBooleanResult = new ExternalFlashIOCtrlBooleanResult(null);
        handleRcspCallback = new HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd>("jumpToUpdateResource", onWatchOpCallback, externalFlashIOCtrlBooleanResult2);
        rcspOpImpl.sendRcspCommand((BluetoothDevice)watchBase, CommandBuilder.buildExternalFlashUpdateResourceCmd((boolean)bl), handleRcspCallback2);
    }

    @Override
    public void writeResourceOTAFlag(final boolean bl, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        ExternalFlashIOCtrlHandleResult<Boolean> externalFlashIOCtrlHandleResult;
        HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd> handleRcspCallback;
        RcspOpImpl rcspOpImpl = this.mRcspOp;
        BluetoothDevice bluetoothDevice = rcspOpImpl.getTargetDevice();
        HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd> handleRcspCallback2 = handleRcspCallback;
        ExternalFlashIOCtrlHandleResult<Boolean> externalFlashIOCtrlHandleResult2 = externalFlashIOCtrlHandleResult;
        externalFlashIOCtrlHandleResult = new ExternalFlashIOCtrlHandleResult<Boolean>(){

            @Override
            public Boolean handleResult(BluetoothDevice bluetoothDevice, ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd) {
                WatchBase.this.setOTAResource(bl ^ true);
                return Boolean.TRUE;
            }
        };
        handleRcspCallback = new HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd>("writeResourceOTAFlag", onWatchOpCallback, externalFlashIOCtrlHandleResult2);
        rcspOpImpl.sendRcspCommand(bluetoothDevice, CommandBuilder.buildExternalFlashOTAResourceCmd((boolean)bl), handleRcspCallback2);
    }

    @Override
    public void getCustomWatchBgInfo(String string, OnWatchOpCallback<String> onWatchOpCallback) {
        ExternalFlashIOCtrlHandleResult<String> externalFlashIOCtrlHandleResult;
        HandleRcspCallback<String, ExternalFlashIOCtrlCmd> handleRcspCallback;
        if (string == null) {
            if (onWatchOpCallback != null) {
                BaseError baseError;
                WatchBase watchBase = baseError;
                baseError = new BaseError(4097, "fat file path is null.");
                onWatchOpCallback.onFailed((BaseError)watchBase);
            }
            return;
        }
        RcspOpImpl rcspOpImpl = watchBase.mRcspOp;
        string = rcspOpImpl.getTargetDevice();
        HandleRcspCallback<String, ExternalFlashIOCtrlCmd> handleRcspCallback2 = handleRcspCallback;
        ExternalFlashIOCtrlHandleResult<String> externalFlashIOCtrlHandleResult2 = externalFlashIOCtrlHandleResult;
        externalFlashIOCtrlHandleResult = new ExternalFlashIOCtrlHandleResult<String>(){

            @Override
            public String handleResult(BluetoothDevice bluetoothDevice, ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd) {
                return ((ExternalFlashIOCtrlResponse)externalFlashIOCtrlCmd.getResponse()).getFilePath();
            }
        };
        handleRcspCallback = new HandleRcspCallback<String, ExternalFlashIOCtrlCmd>("getCustomWatchBgInfo", onWatchOpCallback, externalFlashIOCtrlHandleResult2);
        rcspOpImpl.sendRcspCommand((BluetoothDevice)string, CommandBuilder.buildExternalFlashGetCustomBgInfoCmd((String)string), handleRcspCallback2);
    }

    @Override
    public void getWatchMessage(String string, OnWatchOpCallback<String> onWatchOpCallback) {
        ExternalFlashIOCtrlHandleResult<String> externalFlashIOCtrlHandleResult;
        HandleRcspCallback<String, ExternalFlashIOCtrlCmd> handleRcspCallback;
        if (string == null) {
            if (onWatchOpCallback != null) {
                BaseError baseError;
                WatchBase watchBase = baseError;
                baseError = new BaseError(4097, "fat file path is null.");
                onWatchOpCallback.onFailed((BaseError)watchBase);
            }
            return;
        }
        RcspOpImpl rcspOpImpl = watchBase.mRcspOp;
        string = rcspOpImpl.getTargetDevice();
        HandleRcspCallback<String, ExternalFlashIOCtrlCmd> handleRcspCallback2 = handleRcspCallback;
        ExternalFlashIOCtrlHandleResult<String> externalFlashIOCtrlHandleResult2 = externalFlashIOCtrlHandleResult;
        externalFlashIOCtrlHandleResult = new ExternalFlashIOCtrlHandleResult<String>(){

            @Override
            public String handleResult(BluetoothDevice bluetoothDevice, ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd) {
                return ((ExternalFlashIOCtrlResponse)externalFlashIOCtrlCmd.getResponse()).getVersion();
            }
        };
        handleRcspCallback = new HandleRcspCallback<String, ExternalFlashIOCtrlCmd>("getWatchMessage", onWatchOpCallback, externalFlashIOCtrlHandleResult2);
        rcspOpImpl.sendRcspCommand((BluetoothDevice)string, CommandBuilder.buildExternalFlashGetWatchVersionCmd((String)string), handleRcspCallback2);
    }

    @Override
    public void syncWeatherInfo(PushInfoDataToDeviceCmd.Weather weather, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        RcspBooleanResult rcspBooleanResult;
        HandleRcspCallback<Boolean, CommandBase> handleRcspCallback;
        PushInfoDataToDeviceCmd pushInfoDataToDeviceCmd;
        PushInfoDataToDeviceCmd.Param param;
        WatchBase watchBase;
        if (weather == null) {
            if (onWatchOpCallback != null) {
                BaseError baseError;
                watchBase = baseError;
                baseError = new BaseError(4097, "Weather is null.");
                onWatchOpCallback.onFailed((BaseError)watchBase);
            }
            return;
        }
        WatchBase watchBase2 = watchBase;
        watchBase = param;
        param = new PushInfoDataToDeviceCmd.Param((PushInfoDataToDeviceCmd.BaseInfo)weather);
        weather = pushInfoDataToDeviceCmd;
        pushInfoDataToDeviceCmd = new PushInfoDataToDeviceCmd((PushInfoDataToDeviceCmd.Param)watchBase);
        RcspOpImpl rcspOpImpl = watchBase2.mRcspOp;
        watchBase = rcspOpImpl.getTargetDevice();
        HandleRcspCallback<Boolean, CommandBase> handleRcspCallback2 = handleRcspCallback;
        RcspBooleanResult rcspBooleanResult2 = rcspBooleanResult;
        rcspBooleanResult = new RcspBooleanResult(null);
        handleRcspCallback = new HandleRcspCallback<Boolean, CommandBase>("syncWeatherInfo", onWatchOpCallback, rcspBooleanResult2);
        rcspOpImpl.sendRcspCommand((BluetoothDevice)watchBase, (CommandBase)weather, handleRcspCallback2);
    }

    @Override
    public void sendWriteProtectFlag(final boolean bl, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        ExternalFlashIOCtrlHandleResult<Boolean> externalFlashIOCtrlHandleResult;
        HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd> handleRcspCallback;
        RcspOpImpl rcspOpImpl = this.mRcspOp;
        BluetoothDevice bluetoothDevice = rcspOpImpl.getTargetDevice();
        HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd> handleRcspCallback2 = handleRcspCallback;
        ExternalFlashIOCtrlHandleResult<Boolean> externalFlashIOCtrlHandleResult2 = externalFlashIOCtrlHandleResult;
        externalFlashIOCtrlHandleResult = new ExternalFlashIOCtrlHandleResult<Boolean>(){

            @Override
            public Boolean handleResult(BluetoothDevice bluetoothDevice, ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd) {
                7 v0 = this;
                JL_Log.i((String)v0.WatchBase.this.TAG, (String)("-sendWriteProtectFlag- send OK, writeFlag = " + bl));
                v0.WatchBase.this.setSysException(bl ^ true);
                v0.WatchBase.this.mWatchCallbackManager.onExternalFlashWriteFlag(bluetoothDevice, bl);
                return Boolean.TRUE;
            }
        };
        handleRcspCallback = new HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd>("sendWriteProtectFlag", onWatchOpCallback, externalFlashIOCtrlHandleResult2);
        rcspOpImpl.sendRcspCommand(bluetoothDevice, CommandBuilder.buildExternalFlashWriteProtectCmd((boolean)bl), handleRcspCallback2);
    }

    @Override
    public void requestDevicePower(OnWatchOpCallback<Boolean> onWatchOpCallback) {
        RcspBooleanResult rcspBooleanResult;
        HandleRcspCallback<Boolean, CommandBase> handleRcspCallback;
        RcspOpImpl rcspOpImpl = watchBase.mRcspOp;
        WatchBase watchBase = rcspOpImpl.getTargetDevice();
        HandleRcspCallback<Boolean, CommandBase> handleRcspCallback2 = handleRcspCallback;
        RcspBooleanResult rcspBooleanResult2 = rcspBooleanResult;
        rcspBooleanResult = new RcspBooleanResult(null);
        handleRcspCallback = new HandleRcspCallback<Boolean, CommandBase>("requestDevicePower", onWatchOpCallback, rcspBooleanResult2);
        rcspOpImpl.sendRcspCommand((BluetoothDevice)watchBase, CommandBuilder.buildGetBtSysInfoCmd((int)1), handleRcspCallback2);
    }

    @Override
    public void pushMessageInfo(NotificationMsg notificationMsg, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        SyncMessageTask.SyncTask syncTask;
        if (!((WatchBase)((Object)syncTask2)).mRcspOp.isRcspInit()) {
            ((WatchBase)((Object)syncTask2)).callbackError(onWatchOpCallback, 8192);
            return;
        }
        WatchBase watchBase = syncTask2;
        watchBase.b();
        SyncMessageTask.SyncTask syncTask2 = syncTask;
        syncTask = new SyncMessageTask.SyncTask(0, notificationMsg, onWatchOpCallback);
        watchBase.a.putNotification(syncTask2);
    }

    @Override
    public void removeMessageInfo(NotificationMsg notificationMsg, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        SyncMessageTask.SyncTask syncTask;
        if (!((WatchBase)((Object)syncTask2)).mRcspOp.isRcspInit()) {
            ((WatchBase)((Object)syncTask2)).callbackError(onWatchOpCallback, 8192);
            return;
        }
        WatchBase watchBase = syncTask2;
        watchBase.b();
        SyncMessageTask.SyncTask syncTask2 = syncTask;
        syncTask = new SyncMessageTask.SyncTask(1, notificationMsg, onWatchOpCallback);
        watchBase.a.putNotification(syncTask2);
    }

    public ExternalFlashMsgResponse getExternalFlashMsg(BluetoothDevice bluetoothDevice) {
        return this.mStatusManager.getExtFlashMsg(bluetoothDevice);
    }

    public BluetoothDevice getConnectedDevice() {
        return this.mRcspOp.getTargetDevice();
    }

    public void setSysException(boolean bl) {
        this.isSysException = bl;
    }

    public void setOTAResource(boolean bl) {
        this.isOTAResource = bl;
    }

    public void queryExtFlashMsg(OnOperationCallback<ExternalFlashMsgResponse> onOperationCallback) {
        WatchBase.queryExtFlashMsgForDevice(this.mRcspOp, onOperationCallback);
    }

    public void deleteFileStart(String string, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        ExternalFlashIOCtrlBooleanResult externalFlashIOCtrlBooleanResult;
        HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd> handleRcspCallback;
        Object object = ((WatchBase)object).getConnectedDevice();
        string = CommandBuilder.buildExternalFlashDeleteFileStartCmd((String)string);
        WatchBase watchBase = object;
        object = handleRcspCallback;
        ExternalFlashIOCtrlBooleanResult externalFlashIOCtrlBooleanResult2 = externalFlashIOCtrlBooleanResult;
        externalFlashIOCtrlBooleanResult = new ExternalFlashIOCtrlBooleanResult(null);
        handleRcspCallback = new HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd>("deleteFileStart", onWatchOpCallback, externalFlashIOCtrlBooleanResult2);
        ((WatchBase)object).mRcspOp.sendRcspCommand((BluetoothDevice)watchBase, (CommandBase)string, (RcspCommandCallback)object);
    }

    public void createFileStart(String string, int n, OnWatchOpCallback<Boolean> onWatchOpCallback) {
        ExternalFlashIOCtrlBooleanResult externalFlashIOCtrlBooleanResult;
        HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd> handleRcspCallback;
        Object object = ((WatchBase)object).getConnectedDevice();
        string = CommandBuilder.buildExternalFlashInsertNewFileStartCmd((String)string, (int)n);
        WatchBase watchBase = object;
        object = handleRcspCallback;
        ExternalFlashIOCtrlBooleanResult externalFlashIOCtrlBooleanResult2 = externalFlashIOCtrlBooleanResult;
        externalFlashIOCtrlBooleanResult = new ExternalFlashIOCtrlBooleanResult(null);
        handleRcspCallback = new HandleRcspCallback<Boolean, ExternalFlashIOCtrlCmd>("createFileStart", onWatchOpCallback, externalFlashIOCtrlBooleanResult2);
        ((WatchBase)object).mRcspOp.sendRcspCommand((BluetoothDevice)watchBase, (CommandBase)string, (RcspCommandCallback)object);
    }

    public <T> void callbackError(OnWatchOpCallback<T> onWatchOpCallback, int n) {
        WatchBase watchBase = string;
        String string = FatUtil.getFatFsErrorCodeMsg(n);
        watchBase.callbackError(onWatchOpCallback, n, string);
    }

    public <T> void callbackError(OnWatchOpCallback<T> onWatchOpCallback, int n, String string) {
        if (onWatchOpCallback != null) {
            BaseError baseError;
            WatchBase watchBase = baseError;
            baseError = new BaseError(n, string);
            onWatchOpCallback.onFailed((BaseError)watchBase);
        }
    }

    public <T> void onCallbackError(OnWatchOpCallback<T> onWatchOpCallback, int n) {
        if (onWatchOpCallback != null) {
            BaseError baseError;
            WatchBase watchBase = baseError;
            baseError = new BaseError(n, WatchError.getErrorDesc(n));
            onWatchOpCallback.onFailed((BaseError)watchBase);
        }
    }

    public static class HandleRcspCallback<T, C extends CommandBase>
    implements RcspCommandCallback<C> {
        public final String funcName;
        public final IHandleResult<T, C> handler;
        public final OnWatchOpCallback<T> callback;

        public HandleRcspCallback(String string, OnWatchOpCallback<T> onWatchOpCallback, IHandleResult<T, C> iHandleResult) {
            this.funcName = string;
            this.handler = iHandleResult;
            this.callback = onWatchOpCallback;
        }

        public void onCommandResponse(BluetoothDevice object, C c) {
            if (c == null) {
                return;
            }
            IHandleResult<T, C> iHandleResult = ((HandleRcspCallback)((Object)onWatchOpCallback)).handler;
            int n = iHandleResult == null ? 0 : iHandleResult.hasResult((BluetoothDevice)object, c);
            if (c.getStatus() == 0 && n == 0) {
                IHandleResult<T, C> iHandleResult2 = ((HandleRcspCallback)((Object)onWatchOpCallback)).handler;
                object = iHandleResult2 == null ? null : iHandleResult2.handleResult((BluetoothDevice)object, c);
                OnWatchOpCallback<T> onWatchOpCallback = ((HandleRcspCallback)((Object)onWatchOpCallback)).callback;
                if (onWatchOpCallback != null) {
                    onWatchOpCallback.onSuccess(object);
                }
            } else if (c.getStatus() != 0) {
                ((HandleRcspCallback)((Object)onWatchOpCallback)).onErrCode((BluetoothDevice)object, RcspErrorCode.buildJsonError((int)c.getId(), (int)12292, (int)c.getStatus(), null));
            } else {
                ((HandleRcspCallback)((Object)onWatchOpCallback)).onErrCode((BluetoothDevice)object, RcspErrorCode.buildJsonError((int)c.getId(), (int)12293, (int)n, null));
            }
        }

        public void onErrCode(BluetoothDevice objectArray, BaseError baseError) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = ((HandleRcspCallback)object).funcName;
            objectArray2[1] = baseError;
            JL_Log.w((String)"HandleRcspCallback", (String)RcspUtil.formatString((String)"-%s- have an exception : %s", (Object[])objectArray));
            Object object = ((HandleRcspCallback)object).callback;
            if (object != null) {
                BaseError baseError2;
                Object object2 = object;
                object = baseError2;
                BaseError baseError3 = baseError;
                int n = baseError3.getSubCode();
                baseError2 = new BaseError(n, baseError3.getMessage());
                object2.onFailed((BaseError)object);
            }
        }
    }

    public static class RcspBooleanResult
    implements IHandleResult<Boolean, CommandBase> {
        private RcspBooleanResult() {
        }

        public /* synthetic */ RcspBooleanResult(1 var1_1) {
            this();
        }

        @Override
        public int hasResult(BluetoothDevice bluetoothDevice, CommandBase commandBase) {
            return 0;
        }

        @Override
        public Boolean handleResult(BluetoothDevice bluetoothDevice, CommandBase commandBase) {
            return Boolean.TRUE;
        }
    }

    public static abstract class ExternalFlashIOCtrlHandleResult<T>
    implements IHandleResult<T, ExternalFlashIOCtrlCmd> {
        private ExternalFlashIOCtrlHandleResult() {
        }

        public /* synthetic */ ExternalFlashIOCtrlHandleResult(1 var1_1) {
            this();
        }

        @Override
        public int hasResult(BluetoothDevice bluetoothDevice, ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd) {
            if (externalFlashIOCtrlCmd == null) {
                return 1;
            }
            if (externalFlashIOCtrlCmd.getStatus() != 0) {
                return externalFlashIOCtrlCmd.getStatus();
            }
            if (externalFlashIOCtrlCmd.getResponse() == null) {
                return 1;
            }
            return ((ExternalFlashIOCtrlResponse)externalFlashIOCtrlCmd.getResponse()).getResult();
        }
    }

    public static class ExternalFlashIOCtrlBooleanResult
    extends ExternalFlashIOCtrlHandleResult<Boolean> {
        private ExternalFlashIOCtrlBooleanResult() {
            super(null);
        }

        public /* synthetic */ ExternalFlashIOCtrlBooleanResult(1 var1_1) {
            this();
        }

        @Override
        public Boolean handleResult(BluetoothDevice bluetoothDevice, ExternalFlashIOCtrlCmd externalFlashIOCtrlCmd) {
            return Boolean.TRUE;
        }
    }
}

