/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.impl;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.jieli.jl_bt_ota.interfaces.CommandCallback;
import com.jieli.jl_bt_ota.interfaces.IBluetoothCallback;
import com.jieli.jl_bt_ota.interfaces.IBluetoothManager;
import com.jieli.jl_bt_ota.interfaces.IUpgradeManager;
import com.jieli.jl_bt_ota.interfaces.rcsp.ICmdSnGenerator;
import com.jieli.jl_bt_ota.model.BluetoothOTAConfigure;
import com.jieli.jl_bt_ota.model.DataInfo;
import com.jieli.jl_bt_ota.model.OTAError;
import com.jieli.jl_bt_ota.model.base.BaseError;
import com.jieli.jl_bt_ota.model.base.BasePacket;
import com.jieli.jl_bt_ota.model.base.CommandBase;
import com.jieli.jl_bt_ota.tool.BtEventCallbackHelper;
import com.jieli.jl_bt_ota.tool.CommandCache;
import com.jieli.jl_bt_ota.tool.DeviceStatusCache;
import com.jieli.jl_bt_ota.tool.IDataHandler;
import com.jieli.jl_bt_ota.tool.ParseHelper;
import com.jieli.jl_bt_ota.tool.SnGenerator;
import com.jieli.jl_bt_ota.util.BluetoothUtil;
import com.jieli.jl_bt_ota.util.CommonUtil;
import com.jieli.jl_bt_ota.util.JL_Log;

public abstract class BluetoothBase
implements IBluetoothManager,
IUpgradeManager {
    protected String TAG;
    protected final BluetoothAdapter mBluetoothAdapter;
    protected final DeviceStatusCache mDeviceStatusCache;
    protected final CommandCache mCommandCache;
    protected final BtEventCallbackHelper mBtEventCbHelper;
    protected final Context context;
    protected BluetoothOTAConfigure mBluetoothOption;
    private volatile BluetoothDevice a;
    protected volatile IDataHandler dataHandler;
    private ICmdSnGenerator b;
    private BluetoothAdapterReceiver c;
    private final boolean d;

    public BluetoothBase(Context context) {
        BluetoothBase bluetoothBase = this;
        BluetoothBase bluetoothBase2 = this;
        bluetoothBase2.TAG = bluetoothBase2.getClass().getSimpleName();
        bluetoothBase2.mBluetoothOption = BluetoothOTAConfigure.createDefault();
        this.context = context;
        CommonUtil.setMainContext(context);
        bluetoothBase.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        bluetoothBase.mDeviceStatusCache = new DeviceStatusCache();
        bluetoothBase.mCommandCache = new CommandCache();
        this.d = BluetoothUtil.hasBle(context);
        this.mBtEventCbHelper = new BtEventCallbackHelper();
        this.a();
    }

    private void a() {
        if (this.c == null && this.context != null) {
            IntentFilter intentFilter;
            this.c = new BluetoothAdapterReceiver();
            IntentFilter intentFilter2 = intentFilter;
            new IntentFilter().addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            this.context.registerReceiver((BroadcastReceiver)this.c, intentFilter2);
        }
    }

    private void b() {
        Context context;
        BluetoothAdapterReceiver bluetoothAdapterReceiver = this.c;
        if (bluetoothAdapterReceiver != null && (context = this.context) != null) {
            context.unregisterReceiver((BroadcastReceiver)bluetoothAdapterReceiver);
            this.c = null;
        }
    }

    private void a(BaseError baseError, CommandCallback commandCallback) {
        if (commandCallback != null) {
            commandCallback.onErrCode(baseError);
        } else {
            this.errorEventCallback(baseError);
        }
    }

    private void a(BluetoothDevice bluetoothDevice, CommandBase object, int n, int n2, CommandCallback commandCallback) {
        if (bluetoothDevice == null) {
            bluetoothDevice = ((BluetoothBase)((Object)dataInfo)).getConnectedBtDevice();
        }
        if (bluetoothDevice == null) {
            ((BluetoothBase)((Object)dataInfo)).a(OTAError.buildError(4114), commandCallback);
            return;
        }
        if (object == null) {
            ((BluetoothBase)((Object)dataInfo)).a(OTAError.buildError(4097, "Command is null."), commandCallback);
            return;
        }
        if (!((BluetoothBase)((Object)dataInfo)).checkDeviceIsCertify(bluetoothDevice)) {
            ((BluetoothBase)((Object)dataInfo)).a(OTAError.buildError(20481, "Device may need to be certified."), commandCallback);
            return;
        }
        if (((BluetoothBase)((Object)dataInfo)).dataHandler == null) {
            BluetoothBase bluetoothBase = dataInfo;
            JL_Log.d(bluetoothBase.TAG, "-sendCommandAsync- Data handler is null.");
            bluetoothBase.a(OTAError.buildError(4114, "Data handler is null."), commandCallback);
            return;
        }
        if (n == 1) {
            ((CommandBase)object).setOpCodeSn(((BluetoothBase)((Object)dataInfo)).a(bluetoothDevice));
            ((BluetoothBase)((Object)dataInfo)).mCommandCache.putCommandBase(bluetoothDevice, (CommandBase)object);
        }
        if ((object = ParseHelper.convert2BasePacket((CommandBase)object, n)) == null) {
            ((BluetoothBase)((Object)dataInfo)).a(OTAError.buildError(12293, "Data is error."), commandCallback);
            return;
        }
        BluetoothBase bluetoothBase = dataInfo;
        DataInfo dataInfo = new DataInfo().setType(0).setDevice(bluetoothDevice).setBasePacket((BasePacket)object).setTimeoutMs(n2).setCallback(commandCallback);
        JL_Log.d(bluetoothBase.TAG, "sendRcspCommand >> addSendData : cmdType = " + n + ", " + dataInfo);
        bluetoothBase.dataHandler.addSendData(dataInfo);
    }

    private int a(BluetoothDevice bluetoothDevice) {
        if (this.b == null) {
            SnGenerator snGenerator;
            SnGenerator snGenerator2 = snGenerator;
            snGenerator = new SnGenerator();
            this.b = snGenerator2;
        }
        return this.b.getRcspCmdSeq(bluetoothDevice);
    }

    public boolean isConnectedDevice(BluetoothDevice bluetoothDevice) {
        return BluetoothUtil.deviceEquals(this.getConnectedDevice(), bluetoothDevice);
    }

    public CommandBase getCacheCommand(BluetoothDevice bluetoothDevice, BasePacket basePacket) {
        if (basePacket == null) {
            return null;
        }
        BasePacket basePacket2 = basePacket;
        int n = basePacket2.getOpCode();
        return this.mCommandCache.getCommand(bluetoothDevice, n, basePacket2.getOpCodeSn());
    }

    public void removeCacheCommand(BluetoothDevice bluetoothDevice, BasePacket basePacket) {
        this.mCommandCache.removeCommandBase(bluetoothDevice, basePacket);
    }

    public boolean registerBluetoothCallback(IBluetoothCallback iBluetoothCallback) {
        return this.mBtEventCbHelper.addCallback(iBluetoothCallback);
    }

    public boolean unregisterBluetoothCallback(IBluetoothCallback iBluetoothCallback) {
        return this.mBtEventCbHelper.removeCallback(iBluetoothCallback);
    }

    @Override
    public void configure(BluetoothOTAConfigure bluetoothOTAConfigure) {
        this.mBluetoothOption = CommonUtil.checkNotNull(bluetoothOTAConfigure, "configure must not null.");
        JL_Log.d(this.TAG, "configure : " + bluetoothOTAConfigure);
        this.b = bluetoothOTAConfigure.getSnGenerator();
    }

    public BluetoothOTAConfigure getBluetoothOption() {
        return this.mBluetoothOption;
    }

    @Override
    public void release() {
        BluetoothBase bluetoothBase = this;
        bluetoothBase.b();
        bluetoothBase.mDeviceStatusCache.clear();
        bluetoothBase.mCommandCache.release();
        bluetoothBase.mBtEventCbHelper.release();
        ICmdSnGenerator iCmdSnGenerator = bluetoothBase.b;
        if (iCmdSnGenerator != null) {
            if (iCmdSnGenerator instanceof SnGenerator) {
                ((SnGenerator)iCmdSnGenerator).destroy();
            }
            this.b = null;
        }
    }

    protected void onAdapterStatus(boolean bl, boolean bl2) {
        this.mBtEventCbHelper.onAdapterStatus(bl, bl2);
    }

    protected void onA2dpStatus(BluetoothDevice bluetoothDevice, int n) {
        this.mBtEventCbHelper.onA2dpStatus(bluetoothDevice, n);
    }

    protected void onHfpStatus(BluetoothDevice bluetoothDevice, int n) {
        this.mBtEventCbHelper.onHfpStatus(bluetoothDevice, n);
    }

    @Override
    public void onBtDeviceConnection(BluetoothDevice bluetoothDevice, int n) {
        this.mBtEventCbHelper.onBtDeviceConnection(bluetoothDevice, n);
    }

    protected void onConnection(BluetoothDevice bluetoothDevice, int n) {
        this.mBtEventCbHelper.onConnection(bluetoothDevice, n);
    }

    protected void onReceiveCommand(BluetoothDevice bluetoothDevice, CommandBase commandBase) {
        this.mBtEventCbHelper.onReceiveCommand(bluetoothDevice, commandBase);
    }

    @Override
    public void onError(BaseError baseError) {
        this.mBtEventCbHelper.onError(baseError);
    }

    protected BluetoothDevice getConnectedBtDevice() {
        if (this.a == null) {
            this.a = this.getConnectedDevice();
        } else if (this.getConnectedDevice() != null && !BluetoothUtil.deviceEquals(this.getConnectedDevice(), this.a)) {
            this.a = this.getConnectedDevice();
        }
        return this.a;
    }

    protected void setConnectedBtDevice(BluetoothDevice bluetoothDevice) {
        this.a = bluetoothDevice;
    }

    public boolean checkDeviceIsCertify(BluetoothDevice bluetoothDevice) {
        return !this.mBluetoothOption.isUseAuthDevice() || this.mDeviceStatusCache.isAuthBtDevice(bluetoothDevice);
    }

    public void sendCommandAsync(CommandBase commandBase, CommandCallback commandCallback) {
        BluetoothBase bluetoothBase = this;
        bluetoothBase.sendCommandAsync(bluetoothBase.getConnectedBtDevice(), commandBase, this.getBluetoothOption().getTimeoutMs(), commandCallback);
    }

    public void sendCommandAsync(CommandBase commandBase, int n, CommandCallback commandCallback) {
        BluetoothBase bluetoothBase = this;
        bluetoothBase.sendCommandAsync(bluetoothBase.getConnectedBtDevice(), commandBase, n, commandCallback);
    }

    public void sendCommandAsync(BluetoothDevice bluetoothDevice, CommandBase commandBase, int n, CommandCallback commandCallback) {
        this.a(bluetoothDevice, commandBase, 1, n, commandCallback);
    }

    public void sendCommandResponse(CommandBase commandBase) {
        BluetoothBase bluetoothBase = this;
        bluetoothBase.sendCommandResponse(bluetoothBase.getConnectedBtDevice(), commandBase);
    }

    public void sendCommandResponse(BluetoothDevice bluetoothDevice, CommandBase commandBase) {
        int n = this.getBluetoothOption().getTimeoutMs();
        this.a(bluetoothDevice, commandBase, 0, n, null);
    }

    protected void onBleDataBlockChanged(BluetoothDevice bluetoothDevice, int n, int n2) {
        this.mBtEventCbHelper.onBleDataBlockChanged(bluetoothDevice, n, n2);
    }

    protected String printBtDeviceInfo(BluetoothDevice bluetoothDevice) {
        return BluetoothUtil.printBtDeviceInfo(this.context, bluetoothDevice);
    }

    private class BluetoothAdapterReceiver
    extends BroadcastReceiver {
        private BluetoothAdapterReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction()) && (context = object.BluetoothBase.this.mBluetoothAdapter) != null) {
                Object object;
                int n = context.getState();
                JL_Log.i(object.BluetoothBase.this.TAG, "recv action : ACTION_STATE_CHANGED, state : " + n);
                if (10 == n) {
                    object = object.BluetoothBase.this;
                    ((BluetoothBase)object).mBtEventCbHelper.onAdapterStatus(false, ((BluetoothBase)object).d);
                } else if (12 == n) {
                    object = object.BluetoothBase.this;
                    ((BluetoothBase)object).mBtEventCbHelper.onAdapterStatus(true, ((BluetoothBase)object).d);
                }
            }
        }
    }
}

