/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.impl;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import com.jieli.jl_bt_ota.impl.BluetoothBase;
import com.jieli.jl_bt_ota.model.BleScanMessage;
import com.jieli.jl_bt_ota.model.OTAError;
import com.jieli.jl_bt_ota.util.BluetoothUtil;
import com.jieli.jl_bt_ota.util.CommonUtil;
import com.jieli.jl_bt_ota.util.JL_Log;
import java.util.ArrayList;
import java.util.List;

public abstract class BluetoothDiscovery
extends BluetoothBase {
    private static final int p = 4660;
    private static final int q = 4661;
    private final List<BluetoothDevice> e;
    private final List<BluetoothDevice> f;
    private BluetoothDiscoveryReceiver g;
    private BluetoothLeScanner h;
    private volatile int i;
    private volatile boolean j;
    private volatile boolean k;
    private long l;
    private final Handler m;
    private final BluetoothAdapter.LeScanCallback n;
    @RequiresApi(value=21)
    private final ScanCallback o;

    public BluetoothDiscovery(Context context) {
        BluetoothDiscovery bluetoothDiscovery = this;
        super(context);
        bluetoothDiscovery.e = new ArrayList<BluetoothDevice>();
        bluetoothDiscovery.f = new ArrayList<BluetoothDevice>();
        bluetoothDiscovery.j = false;
        bluetoothDiscovery.k = false;
        bluetoothDiscovery.l = 8000L;
        context = Looper.getMainLooper();
        bluetoothDiscovery.m = new Handler((Looper)context, message -> {
            int n = message.what;
            if (n != 4660) {
                if (n == 4661 && this.j) {
                    BluetoothDiscovery bluetoothDiscovery = this;
                    JL_Log.w(bluetoothDiscovery.TAG, "-mBleTimeOut- stopBLEScan");
                    bluetoothDiscovery.stopBLEScan();
                }
            } else if (this.k) {
                BluetoothDiscovery bluetoothDiscovery = this;
                JL_Log.w(bluetoothDiscovery.TAG, "-MSG_STOP_EDR- stopDeviceScan");
                bluetoothDiscovery.stopDeviceScan();
                bluetoothDiscovery.k = false;
            }
            return false;
        });
        bluetoothDiscovery.n = (bluetoothDevice, n, byArray) -> this.a(bluetoothDevice, n, byArray, true);
        bluetoothDiscovery.o = new ScanCallback(){

            public void onBatchScanResults(List<ScanResult> list) {
                super.onBatchScanResults(list);
            }

            public void onScanResult(int n, ScanResult scanResult) {
                super.onScanResult(n, scanResult);
                if (scanResult != null && scanResult.getScanRecord() != null) {
                    BluetoothDevice bluetoothDevice = scanResult.getDevice();
                    boolean bl = true;
                    if (Build.VERSION.SDK_INT >= 26) {
                        bl = scanResult.isConnectable();
                    }
                    ScanResult scanResult2 = scanResult;
                    int n2 = scanResult2.getRssi();
                    BluetoothDiscovery.this.a(bluetoothDevice, n2, scanResult2.getScanRecord().getBytes(), bl);
                }
            }

            public void onScanFailed(int n) {
                1 v0 = this;
                super.onScanFailed(n);
                v0.BluetoothDiscovery.this.onError(OTAError.buildError(8194, n, "Scan ble error."));
            }
        };
        context = bluetoothDiscovery.mBluetoothAdapter;
        if (context != null && Build.VERSION.SDK_INT >= 21) {
            this.h = context.getBluetoothLeScanner();
        }
    }

    private boolean c() {
        return BluetoothUtil.isBluetoothEnable();
    }

    @SuppressLint(value={"MissingPermission"})
    private void a(BluetoothDevice bluetoothDevice, int n, byte[] byArray, boolean bl) {
        if (bluetoothDevice != null && CommonUtil.checkHasConnectPermission(this.context) && this.c() && !this.e.contains(bluetoothDevice)) {
            BluetoothDiscovery bluetoothDiscovery = this;
            bluetoothDiscovery.e.add(bluetoothDevice);
            bluetoothDiscovery.mBtEventCbHelper.onDiscovery(bluetoothDevice, new BleScanMessage().setRawData(byArray).setRssi(n).setEnableConnect(bl));
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean b(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice != null && CommonUtil.checkHasConnectPermission(this.context)) {
            return bluetoothDevice.getType() == 2 || bluetoothDevice.getType() == 3;
        }
        return false;
    }

    private void b(boolean bl) {
        List<BluetoothDevice> list = BluetoothUtil.getSystemConnectedBtDeviceList(this.context);
        if (list != null && !list.isEmpty()) {
            for (Object object : list) {
                BleScanMessage bleScanMessage;
                if (bl && this.b((BluetoothDevice)object)) {
                    BleScanMessage bleScanMessage2;
                    if (this.e.contains(object)) continue;
                    BluetoothDiscovery bluetoothDiscovery = this;
                    bluetoothDiscovery.e.add((BluetoothDevice)object);
                    BluetoothDevice bluetoothDevice = object;
                    object = bleScanMessage2;
                    bleScanMessage2 = new BleScanMessage();
                    bluetoothDiscovery.mBtEventCbHelper.onDiscovery(bluetoothDevice, (BleScanMessage)object);
                    continue;
                }
                if (bl || this.b((BluetoothDevice)object) || this.f.contains(object)) continue;
                BluetoothDiscovery bluetoothDiscovery = this;
                bluetoothDiscovery.f.add((BluetoothDevice)object);
                BluetoothDevice bluetoothDevice = object;
                object = bleScanMessage;
                bleScanMessage = new BleScanMessage();
                bluetoothDiscovery.mBtEventCbHelper.onDiscovery(bluetoothDevice, (BleScanMessage)object);
            }
            return;
        }
    }

    private void a(boolean bl) {
        boolean bl2 = this.i == 0;
        JL_Log.i(this.TAG, "-notifyDiscoveryStatus- scanType : " + this.i + " ,bStart : " + bl);
        if (bl) {
            if (bl2) {
                this.j = true;
                this.e.clear();
            } else {
                this.k = true;
                this.f.clear();
            }
        } else if (bl2) {
            this.j = false;
        } else {
            this.k = false;
        }
        this.mBtEventCbHelper.onDiscoveryStatus(bl2, bl);
        if (!bl) {
            this.setScanType(0);
        } else {
            this.b(bl2);
        }
    }

    private void d() {
        BluetoothDiscovery bluetoothDiscovery = this;
        bluetoothDiscovery.setScanType(0);
        bluetoothDiscovery.j = false;
        bluetoothDiscovery.k = false;
        bluetoothDiscovery.e.clear();
        bluetoothDiscovery.f.clear();
    }

    private void a() {
        if (this.g == null && this.context != null) {
            IntentFilter intentFilter;
            this.g = new BluetoothDiscoveryReceiver();
            IntentFilter intentFilter2 = intentFilter;
            new IntentFilter().addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
            intentFilter2.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
            intentFilter2.addAction("android.bluetooth.device.action.FOUND");
            this.context.registerReceiver((BroadcastReceiver)this.g, intentFilter2);
        }
    }

    private void b() {
        Context context;
        BluetoothDiscoveryReceiver bluetoothDiscoveryReceiver = this.g;
        if (bluetoothDiscoveryReceiver != null && (context = this.context) != null) {
            context.unregisterReceiver((BroadcastReceiver)bluetoothDiscoveryReceiver);
            this.g = null;
        }
    }

    static /* synthetic */ boolean a(BluetoothDiscovery bluetoothDiscovery, boolean bl) {
        bluetoothDiscovery.k = bl;
        return bl;
    }

    @Override
    public void onAdapterStatus(boolean bl, boolean bl2) {
        super.onAdapterStatus(bl, bl2);
        if (!bl) {
            if (this.isDeviceScanning()) {
                this.a(false);
            }
            this.d();
        }
    }

    public int getScanType() {
        return this.i;
    }

    public ArrayList<BluetoothDevice> getDiscoveredBluetoothDevices() {
        if (this.i == 0) {
            return new ArrayList<BluetoothDevice>(this.e);
        }
        return new ArrayList<BluetoothDevice>(this.f);
    }

    @SuppressLint(value={"MissingPermission"})
    public int startDeviceScan(long l, int n) {
        if (n == 0) {
            return this.startBLEScan(l);
        }
        if (!CommonUtil.checkHasScanPermission(this.context)) {
            JL_Log.e(this.TAG, "startDeviceScan :: no scan permission");
            return 4113;
        }
        if (this.mBluetoothAdapter == null) {
            JL_Log.e(this.TAG, "startDeviceScan :: this device is not supported bluetooth.");
            return 4098;
        }
        if (!this.c()) {
            JL_Log.e(this.TAG, "startDeviceScan :: bluetooth is close.");
            return 4099;
        }
        if (this.j) {
            BluetoothDiscovery bluetoothDiscovery = this;
            JL_Log.w(bluetoothDiscovery.TAG, "startDeviceScan :: stopBLEScan: ");
            bluetoothDiscovery.stopBLEScan();
        }
        this.setScanType(n);
        long l2 = l <= 0L ? 8000L : l;
        this.l = l2;
        if (this.k) {
            BluetoothDiscovery bluetoothDiscovery = this;
            JL_Log.i(bluetoothDiscovery.TAG, "scanning br/edr ..... timeout = " + l);
            bluetoothDiscovery.m.removeMessages(4660);
            long l3 = this.l;
            bluetoothDiscovery.m.sendEmptyMessageDelayed(4660, l3);
            bluetoothDiscovery.a(true);
            return 0;
        }
        BluetoothDiscovery bluetoothDiscovery = this;
        bluetoothDiscovery.a();
        boolean bl = bluetoothDiscovery.mBluetoothAdapter.startDiscovery();
        JL_Log.w(this.TAG, "-startDiscovery- >>>>>> bRet : " + bl);
        if (!bl) {
            this.b();
            return 8194;
        }
        BluetoothDiscovery bluetoothDiscovery2 = this;
        bluetoothDiscovery2.m.removeMessages(4660);
        long l4 = this.l;
        bluetoothDiscovery2.m.sendEmptyMessageDelayed(4660, l4);
        return 0;
    }

    @SuppressLint(value={"MissingPermission"})
    public int stopDeviceScan() {
        if (!CommonUtil.checkHasScanPermission(this.context)) {
            JL_Log.e(this.TAG, "stopDeviceScan : no scan permission");
            return 4113;
        }
        if (this.mBluetoothAdapter == null) {
            JL_Log.e(this.TAG, "stopDeviceScan : this device is not supported bluetooth.");
            return 4113;
        }
        if (!this.k) {
            return 0;
        }
        boolean bl = this.mBluetoothAdapter.cancelDiscovery();
        JL_Log.w(this.TAG, "stopDeviceScan : cancelDiscovery = " + bl);
        if (!bl) {
            return 8194;
        }
        this.m.removeMessages(4660);
        return 0;
    }

    @SuppressLint(value={"MissingPermission"})
    public int startBLEScan(long l) {
        int n;
        if (!CommonUtil.checkHasScanPermission(this.context)) {
            JL_Log.e(this.TAG, "startBLEScan : no scan permission");
            return 4113;
        }
        if (!CommonUtil.checkHasLocationPermission(this.context)) {
            JL_Log.e(this.TAG, "startBLEScan : no location permission");
            return 4113;
        }
        if (this.mBluetoothAdapter == null) {
            JL_Log.e(this.TAG, "startBLEScan : this device is not supported bluetooth.");
            return 4113;
        }
        if (!this.c()) {
            JL_Log.e(this.TAG, "startBLEScan : bluetooth is close.");
            return 4099;
        }
        if (this.k) {
            BluetoothDiscovery bluetoothDiscovery = this;
            JL_Log.d(bluetoothDiscovery.TAG, "startBLEScan : stopDeviceScan");
            if (bluetoothDiscovery.stopDeviceScan() == 0) {
                n = 0;
                do {
                    SystemClock.sleep((long)30L);
                } while ((n += 30) <= 300 && this.mBluetoothAdapter.isDiscovering());
            }
        }
        this.setScanType(0);
        if (l <= 0L) {
            l = 8000L;
        }
        if (this.j) {
            BluetoothDiscovery bluetoothDiscovery = this;
            JL_Log.i(bluetoothDiscovery.TAG, "scanning ble ..... timeout = " + l);
            BluetoothLeScanner bluetoothLeScanner = bluetoothDiscovery.h;
            if (bluetoothLeScanner != null && Build.VERSION.SDK_INT >= 21) {
                bluetoothLeScanner.flushPendingScanResults(this.o);
            }
            BluetoothDiscovery bluetoothDiscovery2 = this;
            bluetoothDiscovery2.m.removeMessages(4661);
            bluetoothDiscovery2.m.sendEmptyMessageDelayed(4661, l);
            bluetoothDiscovery2.a(true);
            return 0;
        }
        n = Build.VERSION.SDK_INT;
        if (n >= 21 && this.h != null) {
            ArrayList arrayList;
            ScanSettings scanSettings = n >= 23 ? new ScanSettings.Builder().setScanMode(this.mBluetoothOption.getBleScanMode()).setMatchMode(1).build() : new ScanSettings.Builder().setScanMode(this.mBluetoothOption.getBleScanMode()).build();
            BluetoothDiscovery bluetoothDiscovery = this;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            bluetoothDiscovery.h.startScan(arrayList2, scanSettings, this.o);
            JL_Log.w(bluetoothDiscovery.TAG, "-startBLEScan- >>>>>> startScan :>> timeout = " + l);
        } else {
            boolean bl = this.mBluetoothAdapter.startLeScan(this.n);
            n = bl ? 1 : 0;
            JL_Log.w(this.TAG, "-startBLEScan- >>>>>> startLeScan : " + (n != 0));
            if (!bl) {
                return 8194;
            }
        }
        BluetoothDiscovery bluetoothDiscovery = this;
        JL_Log.i(bluetoothDiscovery.TAG, "-startBLEScan- timeout = " + l);
        bluetoothDiscovery.m.removeMessages(4661);
        bluetoothDiscovery.m.sendEmptyMessageDelayed(4661, l);
        bluetoothDiscovery.a(true);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"MissingPermission"})
    public int stopBLEScan() {
        if (!CommonUtil.checkHasScanPermission(this.context)) {
            JL_Log.e(this.TAG, "stopBLEScan : no scan permission.");
            return 4113;
        }
        if (this.mBluetoothAdapter == null) {
            JL_Log.e(this.TAG, "stopBLEScan : this device is not supported bluetooth.");
            return 4113;
        }
        if (!this.j) {
            return 0;
        }
        BluetoothDiscovery bluetoothDiscovery = this;
        JL_Log.w(bluetoothDiscovery.TAG, "-stopBLEScan- >>>>>> " + this.i);
        if (bluetoothDiscovery.i != 0) {
            this.setScanType(0);
        }
        if (this.c()) {
            try {
                BluetoothLeScanner bluetoothLeScanner;
                if (Build.VERSION.SDK_INT >= 21 && (bluetoothLeScanner = this.h) != null) {
                    bluetoothLeScanner.stopScan(this.o);
                } else {
                    this.mBluetoothAdapter.stopLeScan(this.n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        BluetoothDiscovery bluetoothDiscovery2 = this;
        bluetoothDiscovery2.m.removeMessages(4661);
        bluetoothDiscovery2.a(false);
        return 0;
    }

    @Override
    public void release() {
        BluetoothDiscovery bluetoothDiscovery = this;
        super.release();
        bluetoothDiscovery.b();
        bluetoothDiscovery.stopDeviceScan();
        bluetoothDiscovery.stopBLEScan();
        bluetoothDiscovery.d();
        bluetoothDiscovery.m.removeCallbacksAndMessages(null);
    }

    public void setScanType(int n) {
        this.i = n;
    }

    public boolean isScanning() {
        return this.k || this.j;
    }

    protected boolean isBleScanning() {
        return this.j;
    }

    protected boolean isDeviceScanning() {
        return this.k;
    }

    private class BluetoothDiscoveryReceiver
    extends BroadcastReceiver {
        private BluetoothDiscoveryReceiver() {
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @SuppressLint(value={"MissingPermission"})
        public void onReceive(Context object, Intent intent) {
            void var2_6;
            String string = var2_6.getAction();
            if ("android.bluetooth.adapter.action.DISCOVERY_STARTED".equals(string)) {
                BluetoothDiscoveryReceiver bluetoothDiscoveryReceiver = this;
                BluetoothDiscovery.a(bluetoothDiscoveryReceiver.BluetoothDiscovery.this, true);
                bluetoothDiscoveryReceiver.BluetoothDiscovery.this.m.removeMessages(4660);
                long l = BluetoothDiscovery.this.l;
                bluetoothDiscoveryReceiver.BluetoothDiscovery.this.m.sendEmptyMessageDelayed(4660, l);
                bluetoothDiscoveryReceiver.BluetoothDiscovery.this.a(true);
                return;
            }
            if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(string)) {
                BluetoothDiscoveryReceiver bluetoothDiscoveryReceiver = this;
                BluetoothDiscovery.a(bluetoothDiscoveryReceiver.BluetoothDiscovery.this, false);
                bluetoothDiscoveryReceiver.BluetoothDiscovery.this.m.removeMessages(4660);
                bluetoothDiscoveryReceiver.BluetoothDiscovery.this.b();
                bluetoothDiscoveryReceiver.BluetoothDiscovery.this.a(false);
                return;
            }
            if (!"android.bluetooth.device.action.FOUND".equals(string)) return;
            BluetoothDevice bluetoothDevice = (BluetoothDevice)var2_6.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (bluetoothDevice == null) return;
            if (!BluetoothDiscovery.this.c()) return;
            if (!CommonUtil.checkHasConnectPermission(BluetoothDiscovery.this.context)) return;
            boolean bl = false;
            if (BluetoothDiscovery.this.i == 1 && bluetoothDevice.getType() != 2 || BluetoothDiscovery.this.i == 0 && bluetoothDevice.getType() != 1 || BluetoothDiscovery.this.i == 2) {
                bl = true;
            }
            short s = var2_6.getShortExtra("android.bluetooth.device.extra.RSSI", (short)0);
            if (!bl) return;
            if (BluetoothDiscovery.this.f.contains(bluetoothDevice)) return;
            BluetoothDiscoveryReceiver bluetoothDiscoveryReceiver = this;
            bluetoothDiscoveryReceiver.BluetoothDiscovery.this.f.add(bluetoothDevice);
            BleScanMessage bleScanMessage = new BleScanMessage().setRssi(s).setEnableConnect(true);
            bluetoothDiscoveryReceiver.BluetoothDiscovery.this.mBtEventCbHelper.onDiscovery(bluetoothDevice, bleScanMessage);
        }
    }
}

