/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.impl;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.jieli.jl_bt_ota.interfaces.JieLiLibLoader;
import com.jieli.jl_bt_ota.util.BluetoothUtil;
import com.jieli.jl_bt_ota.util.CHexConver;
import com.jieli.jl_bt_ota.util.CommonUtil;
import com.jieli.jl_bt_ota.util.JL_Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Keep
public class RcspAuth {
    private static final String TAG = "RcspAuth";
    private static volatile boolean mIsLibLoaded = false;
    private static final int AUTH_RETRY_COUNT = 2;
    private static final long DEFAULT_AUTH_TIMEOUT = 3000L;
    private static long DELAY_AUTH_WAITING_TIME = 3000L;
    public static final int ERR_NONE = 0;
    public static final int ERR_AUTH_DEVICE_TIMEOUT = 40977;
    public static final int ERR_AUTH_USER_STOP = 40978;
    public static final int ERR_AUTH_DATA_SEND = 40979;
    public static final int ERR_AUTH_DATA_CHECK = 40980;
    public static boolean SUPPORT_RESET_FLAG = false;
    private static final int MSG_SEND_AUTH_DATA_TIMEOUT = 17;
    private static final int MSG_AUTH_DEVICE_TIMEOUT = 18;
    public static final JieLiLibLoader sLocalLibLoader = System::loadLibrary;
    private final boolean isLibInit;
    private final Context mContext;
    private final IRcspAuthOp mIRcspAuthOp;
    private final List<OnRcspAuthListener> mOnRcspAuthListeners = Collections.synchronizedList(new ArrayList());
    private final Map<String, AuthTask> mAuthTaskMap = Collections.synchronizedMap(new HashMap());
    private final Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(@NonNull Message message) {
            int n = message.what;
            if (n != 17) {
                if (n == 18) {
                    message = (BluetoothDevice)message.obj;
                    AuthTask authTask = (AuthTask)RcspAuth.this.mAuthTaskMap.get(message.getAddress());
                    if (authTask != null && !authTask.isAuthDevice()) {
                        RcspAuth.this.onAuthFailed((BluetoothDevice)message, 40977);
                    }
                }
            } else {
                message = (BluetoothDevice)message.obj;
                AuthTask authTask = (AuthTask)RcspAuth.this.mAuthTaskMap.get(message.getAddress());
                if (authTask == null) {
                    return false;
                }
                if (authTask.getRetryNum() < 2) {
                    1 v0 = this;
                    AuthTask authTask2 = authTask;
                    authTask2.setRetryNum(authTask2.getRetryNum() + 1);
                    AuthTask authTask3 = authTask;
                    authTask = authTask3.getDevice();
                    v0.RcspAuth.this.sendAuthDataToDevice((BluetoothDevice)authTask, authTask3.getRandomData());
                    v0.RcspAuth.this.mHandler.removeMessages(18);
                    v0.RcspAuth.this.mHandler.sendMessageDelayed(RcspAuth.this.mHandler.obtainMessage(17, (Object)message), DELAY_AUTH_WAITING_TIME);
                } else {
                    RcspAuth.this.onAuthFailed((BluetoothDevice)message, 40977);
                }
            }
            return true;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadLibrariesOnce(JieLiLibLoader jieLiLibLoader) {
        Class<RcspAuth> clazz = RcspAuth.class;
        synchronized (RcspAuth.class) {
            if (!mIsLibLoaded) {
                if (jieLiLibLoader == null) {
                    jieLiLibLoader = sLocalLibLoader;
                }
                jieLiLibLoader.loadLibrary("jl_ota_auth");
                mIsLibLoaded = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean setAuthTimeout(long l) {
        if (l < 3000L) {
            JL_Log.d(TAG, "setAuthTimeout >> false. " + l);
            return false;
        }
        DELAY_AUTH_WAITING_TIME = l;
        return true;
    }

    public RcspAuth(Context context, IRcspAuthOp iRcspAuthOp, OnRcspAuthListener onRcspAuthListener) {
        if (iRcspAuthOp != null) {
            RcspAuth.loadLibrariesOnce(null);
            this.isLibInit = this.nativeInit();
            this.mContext = context;
            this.mIRcspAuthOp = iRcspAuthOp;
            this.addListener(onRcspAuthListener);
            return;
        }
        throw new IllegalArgumentException("IRcspAuthOp can not be null.");
    }

    private String printDeviceInfo(BluetoothDevice bluetoothDevice) {
        return BluetoothUtil.printBtDeviceInfo(this.mContext, bluetoothDevice);
    }

    private byte[] getResetAuthFlagCmdData() {
        return CHexConver.hexStr2Bytes("FEDCBAC00600020001EF");
    }

    private String getErrorMsg(int n) {
        Object object = "";
        switch (n) {
            default: {
                break;
            }
            case 40980: {
                object = "Check auth data error.";
                break;
            }
            case 40979: {
                object = "Failed to send data.";
                break;
            }
            case 40978: {
                object = "User stop auth device.";
                break;
            }
            case 40977: {
                object = "Auth device timeout.";
            }
        }
        return object;
    }

    private boolean sendAuthDataToDevice(BluetoothDevice bluetoothDevice, byte[] byArray) {
        if (bluetoothDevice != null && byArray != null) {
            boolean bl = this.mIRcspAuthOp.sendAuthDataToDevice(bluetoothDevice, byArray);
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.printDeviceInfo(bluetoothDevice);
            objectArray[1] = CHexConver.byte2HexStr(byArray);
            JL_Log.i(TAG, CommonUtil.formatString("-sendAuthDataToDevice- device : %s, authData : %s", objectArray2));
            return bl;
        }
        return false;
    }

    private boolean isValidAuthData(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            return byArray.length == 5 && byArray[0] == 2 || byArray.length == 17 && (byArray[0] == 0 || byArray[0] == 1);
        }
        return false;
    }

    private void onInitResult(boolean bl) {
        this.mHandler.post(() -> {
            if (!((RcspAuth)((Object)iterator)).mOnRcspAuthListeners.isEmpty()) {
                Iterator<OnRcspAuthListener> iterator = new ArrayList<OnRcspAuthListener>(((RcspAuth)((Object)iterator)).mOnRcspAuthListeners).iterator();
                while (iterator.hasNext()) {
                    ((OnRcspAuthListener)iterator.next()).onInitResult(bl);
                }
            }
        });
    }

    private void onAuthSuccess(BluetoothDevice bluetoothDevice) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.printDeviceInfo(bluetoothDevice);
        JL_Log.w(TAG, CommonUtil.formatString("-onAuthSuccess- device = %s,  auth ok.", objectArray2));
        this.mHandler.post(() -> {
            if (!((RcspAuth)((Object)iterator)).mOnRcspAuthListeners.isEmpty()) {
                Iterator<OnRcspAuthListener> iterator = new ArrayList<OnRcspAuthListener>(((RcspAuth)((Object)iterator)).mOnRcspAuthListeners).iterator();
                while (iterator.hasNext()) {
                    ((OnRcspAuthListener)iterator.next()).onAuthSuccess(bluetoothDevice);
                }
            }
        });
        if (bluetoothDevice != null) {
            this.mAuthTaskMap.remove(bluetoothDevice.getAddress());
        }
    }

    private void onAuthFailed(BluetoothDevice bluetoothDevice, int n) {
        RcspAuth rcspAuth = string;
        String string = rcspAuth.getErrorMsg(n);
        rcspAuth.onAuthFailed(bluetoothDevice, n, string);
    }

    private void onAuthFailed(BluetoothDevice bluetoothDevice, int n, String string) {
        RcspAuth rcspAuth = this;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = bluetoothDevice;
        objectArray[1] = n;
        objectArray[2] = string;
        JL_Log.e(TAG, CommonUtil.formatString("-onAuthFailed- device = %s,  code = %d, message = %s.", objectArray2));
        rcspAuth.mHandler.removeMessages(17);
        rcspAuth.mHandler.removeMessages(18);
        rcspAuth.mHandler.post(() -> {
            if (!((RcspAuth)((Object)iterator)).mOnRcspAuthListeners.isEmpty()) {
                Iterator<OnRcspAuthListener> iterator = new ArrayList<OnRcspAuthListener>(((RcspAuth)((Object)iterator)).mOnRcspAuthListeners).iterator();
                while (iterator.hasNext()) {
                    ((OnRcspAuthListener)iterator.next()).onAuthFailed(bluetoothDevice, n, string);
                }
            }
        });
        if (bluetoothDevice != null) {
            this.mAuthTaskMap.remove(bluetoothDevice.getAddress());
        }
    }

    public void addListener(OnRcspAuthListener onRcspAuthListener) {
        if (onRcspAuthListener != null) {
            RcspAuth rcspAuth = this;
            rcspAuth.mOnRcspAuthListeners.add(onRcspAuthListener);
            onRcspAuthListener.onInitResult(rcspAuth.isLibInit);
        }
    }

    public void removeListener(OnRcspAuthListener onRcspAuthListener) {
        if (onRcspAuthListener != null) {
            this.mOnRcspAuthListeners.remove(onRcspAuthListener);
        }
    }

    public int setDeviceConnectionLinkKey(byte[] byArray) {
        return this.setLinkKey(byArray);
    }

    public byte[] getRandomData() {
        return this.getRandomAuthData();
    }

    public byte[] getAuthData(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return this.getEncryptedAuthData(byArray);
    }

    public byte[] getAuthOkData() {
        return new byte[]{2, 112, 97, 115, 115};
    }

    public boolean startAuth(BluetoothDevice bluetoothDevice) {
        boolean bl;
        AuthTask authTask;
        if (bluetoothDevice == null) {
            return false;
        }
        if (this.mAuthTaskMap.containsKey(bluetoothDevice.getAddress())) {
            authTask = this.mAuthTaskMap.get(bluetoothDevice.getAddress());
            if (authTask != null && (authTask.isAuthDevice() || this.mHandler.hasMessages(18))) {
                JL_Log.i(TAG, "-startAuth- The device has been certified or certification of device is in progress.");
                return true;
            }
            this.mAuthTaskMap.remove(bluetoothDevice.getAddress());
        }
        JL_Log.i(TAG, "-startAuth- device = " + this.printDeviceInfo(bluetoothDevice));
        authTask = new AuthTask().setDevice(bluetoothDevice).setRandomData(this.getRandomData());
        this.mAuthTaskMap.put(bluetoothDevice.getAddress(), authTask);
        if (SUPPORT_RESET_FLAG) {
            RcspAuth rcspAuth = this;
            bl = rcspAuth.sendAuthDataToDevice(bluetoothDevice, rcspAuth.getResetAuthFlagCmdData());
            if (bl) {
                this.mHandler.postDelayed(() -> {
                    if (this.sendAuthDataToDevice(bluetoothDevice, authTask.getRandomData())) {
                        RcspAuth rcspAuth = this;
                        rcspAuth.mHandler.removeMessages(17);
                        Handler handler = rcspAuth.mHandler;
                        handler.sendMessageDelayed(handler.obtainMessage(17, (Object)bluetoothDevice), DELAY_AUTH_WAITING_TIME);
                        return;
                    }
                    this.onAuthFailed(bluetoothDevice, 40979, "Failed to send data.");
                }, 500L);
            }
        } else {
            bl = this.sendAuthDataToDevice(bluetoothDevice, authTask.getRandomData());
            if (bl) {
                RcspAuth rcspAuth = this;
                rcspAuth.mHandler.removeMessages(17);
                Handler handler = rcspAuth.mHandler;
                handler.sendMessageDelayed(handler.obtainMessage(17, (Object)bluetoothDevice), DELAY_AUTH_WAITING_TIME);
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void handleAuthData(BluetoothDevice var1_1, byte[] var2_3) {
        block13: {
            block14: {
                block17: {
                    block12: {
                        block15: {
                            block16: {
                                if (var1_1 == null || !this.isValidAuthData(var2_3)) break block13;
                                var3_5 = this.mAuthTaskMap.get(var1_1.getAddress());
                                if (var3_5 == null || var3_5.isAuthDevice()) break block14;
                                var4_6 = RcspAuth.TAG;
                                v0 = new Object[2];
                                var5_8 /* !! */  = v0;
                                var5_8 /* !! */ [0] = this.printDeviceInfo(var1_1);
                                v0[1] = CHexConver.byte2HexStr(var2_3);
                                JL_Log.d((String)RcspAuth.TAG, CommonUtil.formatString("-handleAuthData- device : %s, data : %s", var5_8 /* !! */ ));
                                if (var3_5.isAuthProgressResult()) break block15;
                                if (var2_3.length != 17 || var2_3[0] != 1) break block16;
                                v1 = this.getAuthData(var3_5.getRandomData());
                                var5_8 /* !! */  = v1;
                                if (v1 != null && Arrays.equals((byte[])var5_8 /* !! */ , var2_3)) {
                                    if (this.sendAuthDataToDevice(var1_1, this.getAuthOkData())) lbl-1000:
                                    // 2 sources

                                    {
                                        while (true) {
                                            var2_4 = 0;
                                            break block12;
                                            break;
                                        }
                                    }
                                    while (true) {
                                        var2_4 = 40979;
                                        break block12;
                                        break;
                                    }
                                }
                                var2_4 = 40980;
                                JL_Log.w((String)var4_6, "-handleAuthData- data not match. authData : " + CHexConver.byte2HexStr((byte[])var5_8 /* !! */ ));
                                break block12;
                            }
                            return;
                        }
                        if (var2_3.length == 17 && var2_3[0] == 0) {
                            var2_3 = this.getAuthData(var2_3);
                            JL_Log.i((String)var4_6, "-handleAuthData- devAuthData : " + CHexConver.byte2HexStr(var2_3));
                            if (!this.sendAuthDataToDevice(var1_1, var2_3)) ** continue;
                            ** continue;
                        }
                        if (!Arrays.equals(var2_3, this.getAuthOkData())) break block17;
                        v2 = var4_6;
                        var2_4 = 0;
                        var3_5.setAuthDevice(true);
                        this.onAuthSuccess(var1_1);
                        v3 = new Object[1];
                        var4_6 = v3;
                        v3[0] = this.printDeviceInfo(var1_1);
                        JL_Log.w((String)v2, CommonUtil.formatString("-handleAuthData- device : %s, auth ok.", var4_6));
                    }
                    var4_7 = var2_4 == 0;
                    var3_5.setAuthProgressResult(var4_7);
                    if (var2_4 != 0) {
                        v4 = this;
                        var3_5.setAuthDevice(false);
                        this = v4.getErrorMsg(var2_4);
                        v4.onAuthFailed(var1_1, var2_4, (String)this);
                    } else {
                        v5 = this;
                        v5.mHandler.removeMessages(17);
                        v5.mHandler.removeMessages(18);
                        if (!var3_5.isAuthDevice()) {
                            v6 = this.mHandler;
                            this = v6.obtainMessage(18, (Object)var1_1);
                            var1_2 = RcspAuth.DELAY_AUTH_WAITING_TIME;
                            v6.sendMessageDelayed((Message)this, var1_2);
                        }
                    }
                    return;
                }
                return;
            }
            return;
        }
    }

    public void stopAuth(BluetoothDevice bluetoothDevice) {
        this.stopAuth(bluetoothDevice, true);
    }

    public void stopAuth(BluetoothDevice bluetoothDevice, boolean bl) {
        if (bluetoothDevice == null) {
            return;
        }
        AuthTask authTask = this.mAuthTaskMap.remove(bluetoothDevice.getAddress());
        if (!bl) {
            return;
        }
        if (authTask != null) {
            this.onAuthFailed(bluetoothDevice, 40978);
        }
        RcspAuth rcspAuth = this;
        rcspAuth.mHandler.removeMessages(17);
        rcspAuth.mHandler.removeMessages(18);
    }

    public void destroy() {
        RcspAuth rcspAuth = this;
        rcspAuth.mHandler.removeCallbacksAndMessages(null);
        rcspAuth.mAuthTaskMap.clear();
        rcspAuth.mOnRcspAuthListeners.clear();
        mIsLibLoaded = false;
    }

    protected native boolean nativeInit();

    protected native byte[] getRandomAuthData();

    protected native int setLinkKey(byte[] var1);

    protected native byte[] getEncryptedAuthData(byte[] var1);

    public static interface IRcspAuthOp {
        public boolean sendAuthDataToDevice(BluetoothDevice var1, byte[] var2);
    }

    public static interface OnRcspAuthListener {
        public void onInitResult(boolean var1);

        public void onAuthSuccess(BluetoothDevice var1);

        public void onAuthFailed(BluetoothDevice var1, int var2, String var3);
    }

    private static class AuthTask {
        private BluetoothDevice a;
        private boolean b;
        private boolean c;
        private byte[] d;
        private int e;

        private AuthTask() {
        }

        public BluetoothDevice getDevice() {
            return this.a;
        }

        public AuthTask setDevice(BluetoothDevice bluetoothDevice) {
            this.a = bluetoothDevice;
            return this;
        }

        public boolean isAuthProgressResult() {
            return this.b;
        }

        public void setAuthProgressResult(boolean bl) {
            this.b = bl;
        }

        public boolean isAuthDevice() {
            return this.c;
        }

        public void setAuthDevice(boolean bl) {
            this.c = bl;
        }

        public byte[] getRandomData() {
            return this.d;
        }

        public AuthTask setRandomData(byte[] byArray) {
            this.d = byArray;
            return this;
        }

        public int getRetryNum() {
            return this.e;
        }

        public void setRetryNum(int n) {
            this.e = n;
        }

        public String toString() {
            return "AuthTask{device=" + this.a + ", isAuthProgressResult=" + this.b + ", isAuthDevice=" + this.c + ", randomData=" + CHexConver.byte2HexStr(this.d) + ", retryNum=" + this.e + '}';
        }
    }
}

