/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.model;

import android.text.TextUtils;
import com.jieli.jl_bt_ota.model.ErrorMsg;
import com.jieli.jl_bt_ota.model.base.BaseError;

public class OTAError {
    public static BaseError buildError(int n) {
        return new BaseError(n, OTAError.getErrorDesc(n));
    }

    public static BaseError buildError(int n, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return OTAError.buildError(n);
        }
        return OTAError.buildError(n, 0, string);
    }

    public static BaseError buildError(int n, int n2, String string) {
        ErrorMsg errorMsg;
        ErrorMsg errorMsg2 = errorMsg;
        errorMsg = new ErrorMsg(n, OTAError.getErrorDesc(n), n2, string);
        return new BaseError(n, errorMsg2.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getErrorDesc(int n) {
        String string = "Unknown Error";
        if (n == 12295) return "Command waiting for the device to reply timed out.";
        if (n == 12296) return "Device returned the failed result.";
        if (n == 12298) return "Device returned an error result.";
        if (n == 12299) return "Waiting command timeout.";
        switch (n) {
            default: {
                switch (n) {
                    default: {
                        switch (n) {
                            default: {
                                switch (n) {
                                    default: {
                                        return string;
                                    }
                                    case 20486: {
                                        return "I/O exception.";
                                    }
                                    case 20485: {
                                        return "No upgrade data found.";
                                    }
                                    case 20484: {
                                        return "Not found file.";
                                    }
                                }
                            }
                            case 16402: {
                                return "Failed to reconnect the device.";
                            }
                            case 16401: {
                                return "Reconnecting to the device timed out.";
                            }
                            case 16400: {
                                return "Unknown error code.";
                            }
                            case 16399: {
                                return "Same upgrade file.";
                            }
                            case 16398: {
                                return "The headphones are not in the charging bin.";
                            }
                            case 16397: {
                                return "The TWS is not connected.";
                            }
                            case 16396: {
                                return "File version is the same as the device version.";
                            }
                            case 16395: {
                                return "Command processing timeout.";
                            }
                            case 16394: {
                                return "Flash IO exception.";
                            }
                            case 16393: {
                                return "Data length error.";
                            }
                            case 16392: {
                                return "OTA is in progress.";
                            }
                            case 16391: {
                                return "The type of the upgrade file is incorrect.";
                            }
                            case 16390: {
                                return "Key of the upgrade file does not match.";
                            }
                            case 16389: {
                                return "Data verification failure.";
                            }
                            case 16388: {
                                return "Data offset error.";
                            }
                            case 16387: {
                                return "Corrupted upgrade file.";
                            }
                            case 16386: {
                                return "Device is in low charge.";
                            }
                            case 16385: {
                                return "Update failed.";
                            }
                        }
                    }
                    case 12293: {
                        return "Failed to parse data.";
                    }
                    case 12292: {
                        return "Abnormal data format.";
                    }
                    case 12291: {
                        return "System is busy.";
                    }
                    case 12290: {
                        return "Failed to send data.";
                    }
                }
            }
            case 20481: {
                return "Device authentication fails.";
            }
            case 8194: {
                return "Searching for a Device Exception.";
            }
            case 4114: {
                return "Bluetooth device is disconnected.";
            }
            case 4099: {
                return "Bluetooth is close.";
            }
            case 4097: {
                return "Parameter error.";
            }
            case 0: {
                return "Success.";
            }
        }
    }
}

