/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.tool;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.jieli.jl_bt_ota.impl.BluetoothOTAManager;
import com.jieli.jl_bt_ota.interfaces.CommandCallback;
import com.jieli.jl_bt_ota.model.DataInfo;
import com.jieli.jl_bt_ota.model.OTAError;
import com.jieli.jl_bt_ota.model.base.BaseError;
import com.jieli.jl_bt_ota.model.base.BasePacket;
import com.jieli.jl_bt_ota.model.base.CommandBase;
import com.jieli.jl_bt_ota.tool.IDataHandler;
import com.jieli.jl_bt_ota.tool.ParseHelper;
import com.jieli.jl_bt_ota.util.CHexConver;
import com.jieli.jl_bt_ota.util.JL_Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DataHandler
implements IDataHandler {
    private static final String e = "DataHandler";
    private final BluetoothOTAManager a;
    private final Handler b;
    private WorkThread c;
    private DataHandlerThread d;

    public DataHandler(BluetoothOTAManager bluetoothOTAManager) {
        this.a = bluetoothOTAManager;
        this.b = new Handler(Looper.getMainLooper());
        this.a();
    }

    private void b() {
        if (this.c == null) {
            WorkThread workThread;
            WorkThread workThread2 = workThread;
            workThread = new WorkThread("Work_Thread");
            this.c = workThread2;
        }
        this.c.start();
    }

    private void d() {
        WorkThread workThread = this.c;
        if (workThread != null) {
            workThread.quitSafely();
            this.c = null;
        }
    }

    private void a() {
        if (this.d == null) {
            DataHandlerThread dataHandlerThread;
            DataHandlerThread dataHandlerThread2 = dataHandlerThread;
            dataHandlerThread2();
            this.d = dataHandlerThread2;
            dataHandlerThread.start();
            this.b();
        }
    }

    private void c() {
        DataHandlerThread dataHandlerThread = this.d;
        if (dataHandlerThread != null) {
            dataHandlerThread.stopThread();
        }
        this.d();
    }

    static /* synthetic */ DataHandlerThread a(DataHandler dataHandler, DataHandlerThread dataHandlerThread) {
        dataHandler.d = dataHandlerThread;
        return dataHandlerThread;
    }

    @Override
    public void addSendData(DataInfo dataInfo) {
        if (this.c == null) {
            this.a();
        }
        this.c.tryToAddSendData(dataInfo);
    }

    @Override
    public void addRecvData(DataInfo dataInfo) {
        if (this.c == null) {
            this.a();
        }
        this.c.tryToAddRecvData(dataInfo);
    }

    @Override
    public void release() {
        JL_Log.e(e, "-release-");
        this.c();
    }

    private class DataHandlerThread
    extends Thread {
        private volatile boolean a;
        private volatile boolean b;
        private ArrayList<BasePacket> c;
        private final LinkedBlockingQueue<DataInfo> d;
        private final List<DataInfo> e;
        private final List<DataInfo> f;
        private TimerThread g;

        public DataHandlerThread() {
            super("DataHandlerThread");
            this.d = new LinkedBlockingQueue();
            this.e = Collections.synchronizedList(new ArrayList());
            this.f = Collections.synchronizedList(new ArrayList());
        }

        private void a(int n) {
            TimerThread timerThread = this.g;
            if (timerThread == null) {
                ThreadStateListener threadStateListener;
                TimerThread timerThread2;
                timerThread = timerThread2;
                DataHandler dataHandler = DataHandler.this;
                long l = n;
                ThreadStateListener threadStateListener2 = threadStateListener;
                threadStateListener = new ThreadStateListener(){

                    @Override
                    public void onStart(long l) {
                    }

                    @Override
                    public void onFinish(long l) {
                        if (DataHandlerThread.this.g != null && DataHandlerThread.this.g.getId() == l) {
                            DataHandlerThread.a(DataHandlerThread.this, null);
                        }
                    }
                };
                timerThread(l, threadStateListener2);
                this.g = timerThread;
                timerThread2.start();
            } else if (!timerThread.b) {
                TimerThread.a(this.g, true);
            }
        }

        private void e() {
            TimerThread timerThread = this.g;
            if (timerThread != null && timerThread.b) {
                JL_Log.i(DataHandler.e, "-stopTimer- >>> ");
                this.g.a();
            }
        }

        private void c() {
            DataHandlerThread dataHandlerThread = this;
            dataHandlerThread.a();
            DataInfo dataInfo = dataHandlerThread.d();
            if (dataInfo == null) {
                if (this.f.size() > 0) {
                    this.a(500);
                } else if (this.e.size() > 0) {
                    this.a(500);
                } else {
                    this.e();
                }
            } else {
                this.e(dataInfo);
            }
        }

        private int a(BluetoothDevice bluetoothDevice) {
            return DataHandler.this.a.getCommunicationMtu(bluetoothDevice);
        }

        private int b(BluetoothDevice bluetoothDevice) {
            return DataHandler.this.a.getReceiveMtu(bluetoothDevice);
        }

        private void e(DataInfo dataInfo) {
            Object object = ParseHelper.packSendBasePacket(dataInfo.getBasePacket());
            if (object == null) {
                JL_Log.i(DataHandler.e, "send data :: pack data error.");
                this.d(dataInfo);
            } else {
                int n = this.a(dataInfo.getDevice());
                JL_Log.i(DataHandler.e, "send data : [" + CHexConver.byte2HexStr(object) + "], sendMtu = " + n);
                if (((byte[])object).length > n + 8) {
                    JL_Log.e(DataHandler.e, "send data over communication mtu [" + n + "] limit.");
                    this.d(dataInfo);
                    return;
                }
                n = 0;
                for (int i = 0; i < 3; ++i) {
                    if (DataHandler.this.a != null) {
                        n = DataHandler.this.a.sendDataToDevice(DataHandler.this.a.getConnectedDevice(), (byte[])object);
                    }
                    if (n != 0) break;
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                JL_Log.i(DataHandler.e, "send ret : " + (n != 0));
                if (n == 0) {
                    this.d(dataInfo);
                } else if (dataInfo.getBasePacket().getHasResponse() == 1) {
                    DataInfo dataInfo2 = dataInfo;
                    dataInfo2.setSend(true);
                    dataInfo2.setSendTime(Calendar.getInstance().getTimeInMillis());
                } else {
                    CommandCallback commandCallback = dataInfo.getCallback();
                    object = commandCallback;
                    if (commandCallback != null) {
                        DataHandler.this.b.post(() -> DataHandlerThread.b((CommandCallback)object));
                    }
                    this.e.remove(dataInfo);
                }
            }
        }

        private void d(DataInfo object) {
            BasePacket basePacket = ((DataInfo)object).getBasePacket();
            if (basePacket == null) {
                return;
            }
            if (basePacket.getHasResponse() == 1) {
                this.f.remove(object);
            } else {
                this.e.remove(object);
            }
            object = ((DataInfo)object).getCallback();
            DataHandler.this.b.post(() -> this.a(basePacket, (CommandCallback)object));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void f() {
            block4: {
                if (!this.b) break block4;
                DataHandlerThread dataHandlerThread = this;
                LinkedBlockingQueue<DataInfo> linkedBlockingQueue = dataHandlerThread.d;
                synchronized (linkedBlockingQueue) {
                    if (!dataHandlerThread.b) break block4;
                    JL_Log.i(DataHandler.e, "wakeUpThread:: notifyAll");
                    this.d.notifyAll();
                }
            }
        }

        private boolean a(DataInfo dataInfo) {
            boolean bl = false;
            if (dataInfo != null) {
                LinkedBlockingQueue<DataInfo> linkedBlockingQueue = this.d;
                try {
                    bl = linkedBlockingQueue.offer(dataInfo, 3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (bl) {
                this.f();
            }
            return bl;
        }

        private void c(DataInfo dataInfo) {
            if (dataInfo != null) {
                if (dataInfo.getType() == 1) {
                    int n = this.b(dataInfo.getDevice());
                    ArrayList<BasePacket> arrayList = ParseHelper.findPacketData(dataInfo.getDevice(), n, dataInfo.getRecvData());
                    if (arrayList != null) {
                        ArrayList<BasePacket> arrayList2 = this.c;
                        if (arrayList2 != null && arrayList2.size() != 0) {
                            this.c.addAll(arrayList);
                        } else {
                            this.c = arrayList;
                        }
                        arrayList = arrayList.iterator();
                        while (arrayList.hasNext()) {
                            JL_Log.d(DataHandler.e, "-handlerQueue- opCode : " + ((BasePacket)arrayList.next()).getOpCode());
                        }
                        this.f();
                    } else {
                        JL_Log.e(DataHandler.e, "-handlerQueue- findPacketData not found. ");
                    }
                } else if (dataInfo.getBasePacket() != null) {
                    if (dataInfo.getBasePacket().getHasResponse() == 1) {
                        if (this.f.size() < 30) {
                            this.f.add(dataInfo);
                        } else {
                            JL_Log.i(DataHandler.e, "-handlerQueue- haveResponseDataList is busy. ");
                            DataHandler.this.a.errorEventCallback(OTAError.buildError(12291));
                        }
                    } else if (this.e.size() < 60) {
                        this.e.add(dataInfo);
                    } else {
                        JL_Log.i(DataHandler.e, "-handlerQueue- noResponseDataList is busy. ");
                        DataHandler.this.a.errorEventCallback(OTAError.buildError(12291));
                    }
                }
            }
        }

        private void a() {
            ArrayList<BasePacket> arrayList;
            ArrayList<BasePacket> arrayList2 = arrayList;
            arrayList = new ArrayList<BasePacket>();
            ArrayList<BasePacket> arrayList3 = this.c;
            if (arrayList3 != null && arrayList3.size() > 0) {
                ArrayList<BasePacket> arrayList4;
                ArrayList<BasePacket> arrayList5;
                arrayList3 = arrayList5;
                arrayList5 = new ArrayList<BasePacket>();
                ArrayList<BasePacket> arrayList6 = arrayList4;
                arrayList4 = new ArrayList<BasePacket>();
                for (BasePacket basePacket : new ArrayList<BasePacket>(this.c)) {
                    byte[] byArray = ParseHelper.packSendBasePacket(basePacket);
                    if (byArray != null) {
                        if (DataHandler.this.a != null) {
                            DataHandler.this.a.receiveDataFromDevice(DataHandler.this.a.getConnectedDevice(), byArray);
                        }
                        if (basePacket.getType() == 1) {
                            arrayList3.add(basePacket);
                            continue;
                        }
                        arrayList2.add(basePacket);
                        continue;
                    }
                    arrayList6.add(basePacket);
                }
                if (!arrayList3.isEmpty()) {
                    this.c.removeAll(arrayList3);
                }
                if (arrayList6.size() > 0) {
                    this.c.removeAll(arrayList6);
                }
                this.a(arrayList2);
            } else {
                this.a((ArrayList<BasePacket>)null);
            }
        }

        private void a(ArrayList<BasePacket> object) {
            if (this.f.size() > 0) {
                Object object2 = this.b();
                Object object3 = DataHandler.e;
                Serializable serializable = new StringBuilder().append("-checkHaveResponseList- waitList size : ");
                int n = object2 == null ? 0 : ((ArrayList)object2).size();
                JL_Log.w((String)object3, ((StringBuilder)serializable).append(n).toString());
                if (object2 != null && ((ArrayList)object2).size() > 0) {
                    ArrayList arrayList;
                    ArrayList arrayList2;
                    object3 = arrayList2;
                    arrayList2 = new ArrayList();
                    serializable = arrayList;
                    arrayList = new ArrayList();
                    long l = Calendar.getInstance().getTimeInMillis();
                    if (object != null && ((ArrayList)object).size() > 0) {
                        Iterator<BasePacket> iterator = ((ArrayList)object).iterator();
                        block0: while (iterator.hasNext()) {
                            BasePacket basePacket = iterator.next();
                            JL_Log.w(DataHandler.e, "-checkHaveResponseList- opCode : " + basePacket.getOpCode() + ", sn : " + basePacket.getOpCodeSn());
                            Object object4 = ((ArrayList)object2).iterator();
                            while (object4.hasNext()) {
                                DataInfo dataInfo = object4.next();
                                BasePacket basePacket2 = dataInfo.getBasePacket();
                                if (basePacket2 != null) {
                                    JL_Log.w(DataHandler.e, "-checkHaveResponseList- packet opCode : " + basePacket2.getOpCode() + ", packet sn : " + basePacket2.getOpCodeSn());
                                }
                                if (basePacket2 != null && basePacket2.getOpCode() == basePacket.getOpCode() && basePacket2.getOpCodeSn() == basePacket.getOpCodeSn()) {
                                    JL_Log.w(DataHandler.e, "-checkHaveResponseList- callback");
                                    object4 = dataInfo.getCallback();
                                    DataHandler.this.b.post(() -> this.a((CommandCallback)object4, basePacket, dataInfo, basePacket2));
                                    ((ArrayList)object3).add(basePacket);
                                    ((ArrayList)serializable).add(dataInfo);
                                    continue block0;
                                }
                                if (dataInfo.getTimeoutMs() < 500) {
                                    dataInfo.setTimeoutMs(500);
                                }
                                if (l - dataInfo.getSendTime() <= (long)dataInfo.getTimeoutMs()) continue;
                                int n2 = dataInfo.getReSendCount();
                                JL_Log.e(DataHandler.e, "wait for response timeout !!! reSend count : " + n2 + ", data : " + dataInfo);
                                if (n2 >= 3) {
                                    JL_Log.e(DataHandler.e, "retry count over time, callbackTimeOutError.");
                                    this.b(dataInfo);
                                    ((ArrayList)object3).add(basePacket);
                                    ((ArrayList)serializable).add(dataInfo);
                                    continue;
                                }
                                DataInfo dataInfo2 = dataInfo;
                                dataInfo2.setReSendCount(n2 + 1);
                                dataInfo2.setSend(false);
                            }
                        }
                        if (((ArrayList)object3).size() > 0 && this.c != null) {
                            ((ArrayList)object).removeAll((Collection<?>)object3);
                            this.c.removeAll((Collection<?>)object3);
                        }
                        if (((ArrayList)object).size() > 0 && this.c != null) {
                            JL_Log.e(DataHandler.e, "-checkHaveResponseList- remove unused response.");
                            this.c.removeAll((Collection<?>)object);
                        }
                        if (((ArrayList)serializable).size() > 0) {
                            this.f.removeAll((Collection<?>)((Object)serializable));
                            ((ArrayList)serializable).clear();
                            object2 = this.b();
                        }
                    }
                    if (object2 != null && ((ArrayList)object2).size() > 0) {
                        object = ((ArrayList)object2).iterator();
                        while (object.hasNext()) {
                            object2 = (DataInfo)object.next();
                            if (((DataInfo)object2).getTimeoutMs() < 500) {
                                ((DataInfo)object2).setTimeoutMs(500);
                            }
                            if (l - ((DataInfo)object2).getSendTime() <= (long)((DataInfo)object2).getTimeoutMs()) continue;
                            int n3 = ((DataInfo)object2).getReSendCount();
                            JL_Log.e(DataHandler.e, "wait for response timeout 222222 !!! reSend count : " + n3 + ", data : " + object2);
                            if (n3 >= 3) {
                                JL_Log.e(DataHandler.e, "retry count over time 222222, callbackTimeOutError.");
                                this.b((DataInfo)object2);
                                ((ArrayList)serializable).add(object2);
                                continue;
                            }
                            ArrayList<DataInfo> arrayList3 = object2;
                            ((DataInfo)((Object)arrayList3)).setReSendCount(n3 + 1);
                            ((DataInfo)((Object)arrayList3)).setSend(false);
                        }
                        if (((ArrayList)serializable).size() > 0) {
                            this.f.removeAll((Collection<?>)((Object)serializable));
                        }
                    }
                }
            } else if (object != null && ((ArrayList)object).size() > 0 && this.c != null) {
                JL_Log.e(DataHandler.e, "-checkHaveResponseList- 22222 remove unused response.");
                this.c.removeAll((Collection<?>)object);
            }
        }

        private DataInfo d() {
            DataInfo dataInfo;
            block7: {
                DataInfo dataInfo2 = null;
                if (this.e.size() > 0) {
                    for (int i = 0; i < this.e.size(); ++i) {
                        dataInfo = this.e.get(i);
                        if (dataInfo.isSend()) {
                            continue;
                        }
                        break block7;
                    }
                } else if (this.f.size() > 0) {
                    for (int i = 0; i < this.f.size(); ++i) {
                        dataInfo = this.f.get(i);
                        if (dataInfo.isSend()) {
                            continue;
                        }
                        break block7;
                    }
                }
                dataInfo = dataInfo2;
            }
            return dataInfo;
        }

        private ArrayList<DataInfo> b() {
            ArrayList<DataInfo> arrayList = null;
            if (((DataHandlerThread)this).f.size() > 0) {
                ArrayList<DataInfo> arrayList2;
                arrayList = arrayList2;
                arrayList2 = new ArrayList<DataInfo>();
                for (DataInfo dataInfo : ((DataHandlerThread)this).f) {
                    if (!dataInfo.isSend()) continue;
                    arrayList.add(dataInfo);
                }
            }
            return arrayList;
        }

        private void b(DataInfo dataInfo) {
            DataHandlerThread dataHandlerThread = this;
            CommandCallback commandCallback = dataInfo.getCallback();
            DataInfo dataInfo2 = dataInfo;
            dataInfo = dataInfo2.getDevice();
            dataHandlerThread.DataHandler.this.a.removeCacheCommand((BluetoothDevice)dataInfo, dataInfo2.getBasePacket());
            dataHandlerThread.DataHandler.this.b.post(() -> {
                BaseError baseError = OTAError.buildError(12295);
                if (commandCallback != null) {
                    commandCallback.onErrCode(baseError);
                }
                DataHandler.this.a.errorEventCallback(baseError);
            });
        }

        private /* synthetic */ void a(CommandCallback commandCallback, BasePacket object, DataInfo dataInfo, BasePacket basePacket) {
            if (commandCallback != null) {
                if ((object = ParseHelper.convert2Command((BasePacket)object, DataHandler.this.a.getCacheCommand(dataInfo.getDevice(), (BasePacket)object))) == null) {
                    commandCallback.onErrCode(OTAError.buildError(12293));
                } else {
                    commandCallback.onCommandResponse((CommandBase)object);
                }
            }
            DataHandler.this.a.removeCacheCommand(dataInfo.getDevice(), basePacket);
        }

        private /* synthetic */ void a(BasePacket basePacket, CommandCallback commandCallback) {
            BaseError baseError = OTAError.buildError(12290);
            baseError.setOpCode(basePacket.getOpCode());
            if (commandCallback != null) {
                commandCallback.onErrCode(baseError);
            }
            DataHandler.this.a.errorEventCallback(baseError);
        }

        private static /* synthetic */ void b(CommandCallback commandCallback) {
            commandCallback.onCommandResponse(null);
        }

        static /* synthetic */ TimerThread a(DataHandlerThread dataHandlerThread, TimerThread timerThread) {
            dataHandlerThread.g = timerThread;
            return timerThread;
        }

        @Override
        public synchronized void start() {
            this.a = true;
            super.start();
            JL_Log.i(DataHandler.e, "DataHandlerThread start....");
        }

        public void stopThread() {
            JL_Log.w(DataHandler.e, "-stopThread-");
            this.a = false;
            this.f();
        }

        public void tryToAddSendData(DataInfo dataInfo) {
            JL_Log.d(DataHandler.e, "-tryToAddSendData-  ret : " + this.a(dataInfo) + ",isWaiting = " + this.b);
        }

        public void tryToAddRecvData(DataInfo dataInfo) {
            JL_Log.d(DataHandler.e, "-tryToAddRecvData-  ret : " + this.a(dataInfo) + ",isWaiting = " + this.b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            DataHandlerThread dataHandlerThread;
            DataHandlerThread dataHandlerThread2;
            DataHandlerThread dataHandlerThread3;
            DataHandlerThread dataHandlerThread4;
            DataHandlerThread dataHandlerThread5;
            LinkedBlockingQueue<DataInfo> linkedBlockingQueue = this.d;
            synchronized (linkedBlockingQueue) {
                while (this.a) {
                    if (this.d.isEmpty()) {
                        DataHandlerThread dataHandlerThread6 = this;
                        dataHandlerThread6.b = true;
                        dataHandlerThread6.c();
                        JL_Log.d(DataHandler.e, "DataHandlerThread is waiting...");
                        try {
                            dataHandlerThread6.d.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        continue;
                    }
                    DataHandlerThread dataHandlerThread7 = this;
                    dataHandlerThread7.b = false;
                    dataHandlerThread7.c(dataHandlerThread7.d.poll());
                    dataHandlerThread7.c();
                }
                DataHandlerThread dataHandlerThread8 = this;
                dataHandlerThread5 = dataHandlerThread8;
                dataHandlerThread4 = dataHandlerThread8;
                dataHandlerThread3 = dataHandlerThread8;
                dataHandlerThread2 = dataHandlerThread8;
                dataHandlerThread = dataHandlerThread8;
                DataHandlerThread dataHandlerThread9 = dataHandlerThread8;
            }
            JL_Log.e(DataHandler.e, "-DataHandlerThread- exit...");
            dataHandlerThread3.e.clear();
            dataHandlerThread2.f.clear();
            dataHandlerThread.d.clear();
            dataHandlerThread9.a = false;
            dataHandlerThread5.e();
            DataHandler.a(dataHandlerThread4.DataHandler.this, null);
        }
    }

    public class WorkThread
    extends HandlerThread
    implements Handler.Callback {
        private static final int c = 1;
        private static final int d = 2;
        private Handler a;

        public WorkThread(String string) {
            super(string, 10);
        }

        public Handler getWorkHandler() {
            if (this.a == null) {
                this.a = new Handler(this.getLooper(), (Handler.Callback)this);
            }
            return this.a;
        }

        protected void onLooperPrepared() {
            super.onLooperPrepared();
            this.a = new Handler(this.getLooper(), (Handler.Callback)this);
        }

        public boolean handleMessage(@NonNull Message object) {
            int n = object.what;
            if (n != 1) {
                if (n == 2) {
                    object = (DataInfo)object.obj;
                    if (DataHandler.this.d != null && object != null) {
                        DataHandler.this.d.tryToAddRecvData((DataInfo)object);
                    }
                }
            } else {
                object = (DataInfo)object.obj;
                if (DataHandler.this.d != null) {
                    DataHandler.this.d.tryToAddSendData((DataInfo)object);
                }
            }
            return false;
        }

        public void tryToAddSendData(DataInfo dataInfo) {
            if (workThread2.a == null) {
                workThread2.a = new Handler(workThread2.getLooper(), (Handler.Callback)workThread2);
            }
            WorkThread workThread = workThread2;
            WorkThread workThread2 = workThread.a.obtainMessage();
            ((Message)workThread2).what = 1;
            workThread.a.obtainMessage().obj = dataInfo;
            workThread.a.sendMessage((Message)workThread2);
        }

        public void tryToAddRecvData(DataInfo dataInfo) {
            if (workThread2.a == null) {
                workThread2.a = new Handler(workThread2.getLooper(), (Handler.Callback)workThread2);
            }
            WorkThread workThread = workThread2;
            WorkThread workThread2 = workThread.a.obtainMessage();
            ((Message)workThread2).what = 2;
            workThread.a.obtainMessage().obj = dataInfo;
            workThread.a.sendMessage((Message)workThread2);
        }
    }

    public static interface ThreadStateListener {
        public void onStart(long var1);

        public void onFinish(long var1);
    }

    private class TimerThread
    extends Thread {
        private final long a;
        private volatile boolean b;
        private final ThreadStateListener c;

        TimerThread(long l, ThreadStateListener threadStateListener) {
            super("TimerThread");
            this.a = l;
            this.c = threadStateListener;
        }

        static /* synthetic */ boolean a(TimerThread timerThread, boolean bl) {
            timerThread.b = bl;
            return bl;
        }

        @Override
        public synchronized void start() {
            TimerThread timerThread = this;
            timerThread.b = true;
            super.start();
            JL_Log.w(DataHandler.e, "TimerThread is start....name : " + this.getName());
            ThreadStateListener threadStateListener = timerThread.c;
            if (threadStateListener != null) {
                threadStateListener.onStart(this.getId());
            }
        }

        synchronized void a() {
            this.b = false;
        }

        @Override
        public void run() {
            while (this.b) {
                try {
                    Thread.sleep(this.a);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (DataHandler.this.d == null) break;
                DataHandler.this.d.f();
            }
            this.b = false;
            JL_Log.w(DataHandler.e, "TimerThread is end....name : " + this.getName());
            ThreadStateListener threadStateListener = this.c;
            if (threadStateListener != null) {
                threadStateListener.onFinish(this.getId());
            }
        }
    }
}

