/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_filebrowse.bean;

import com.jieli.jl_rcsp.util.CHexConver;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PathData {
    public static final byte PATH_TYPE_FlODER = 0;
    public static final byte PATH_TYPE_FILE = 1;
    private byte type = 0;
    private byte readNum = (byte)10;
    private short startIndex = 1;
    private int devHandler = 0;
    private List<Integer> path = new ArrayList<Integer>();
    private int repeatTimes = 3;

    public PathData() {
        this.path.add(0);
    }

    public static PathData build(byte[] object) {
        if (object != null) {
            if (((byte[])object).length >= 14) {
                ArrayList<Integer> arrayList;
                PathData pathData;
                ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object);
                object = byteBuffer;
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                PathData pathData2 = pathData;
                pathData2();
                pathData2.type = ((ByteBuffer)object).get();
                pathData2.readNum = ((ByteBuffer)object).get();
                pathData2.startIndex = ((ByteBuffer)object).getShort();
                pathData.devHandler = ((ByteBuffer)object).getInt();
                ArrayList<Integer> arrayList2 = arrayList;
                arrayList = new ArrayList<Integer>();
                int n = byteBuffer.getShort();
                for (int i = 0; i < n; i += 4) {
                    arrayList2.add(((ByteBuffer)object).getInt());
                }
                pathData2.path = arrayList2;
                return pathData2;
            }
            throw new IllegalArgumentException("");
        }
        throw new NullPointerException("param is null.");
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte by) {
        this.type = by;
    }

    public byte getReadNum() {
        return this.readNum;
    }

    public void setReadNum(byte by) {
        this.readNum = by;
    }

    public short getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(short s) {
        this.startIndex = s;
    }

    public int getDevHandler() {
        return this.devHandler;
    }

    public void setDevHandler(int n) {
        this.devHandler = n;
    }

    public List<Integer> getPath() {
        return this.path;
    }

    public void setPath(List<Integer> list) {
        this.path = list;
    }

    public int getRepeatTimes() {
        return this.repeatTimes;
    }

    public void setRepeatTimes(int n) {
        this.repeatTimes = n;
    }

    public byte[] toParamData() {
        List<Integer> list = this.path;
        if (list == null) {
            return null;
        }
        int n = list.size() * 4;
        byte[] byArray = new byte[n + 10];
        byte[] byArray2 = byArray;
        byArray2[0] = this.type;
        byArray2[1] = this.readNum;
        short s = this.startIndex;
        byArray2[2] = (byte)(s >> 8 & 0xFF);
        byArray2[3] = (byte)(s & 0xFF);
        byte[] byArray3 = CHexConver.intToBigBytes(this.devHandler);
        int n2 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray2, 4, n2);
        byArray2[8] = (byte)(n >> 8 & 0xFF);
        byArray[9] = (byte)(n & 0xFF);
        n2 = 10;
        Iterator<Integer> iterator = this.path.iterator();
        while (iterator.hasNext()) {
            byte[] byArray4 = CHexConver.intToBigBytes(iterator.next());
            int n3 = byArray4.length;
            System.arraycopy(byArray4, 0, byArray2, n2, n3);
            n2 += byArray4.length;
        }
        return byArray2;
    }

    public String toString() {
        return "PathData{type=" + this.type + ", readNum=" + this.readNum + ", startIndex=" + this.startIndex + ", devHandler=" + this.devHandler + ", path=" + this.path + ", repeatTimes=" + this.repeatTimes + '}';
    }
}

