/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.impl;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.Looper;
import com.jieli.jl_rcsp.constant.Command;
import com.jieli.jl_rcsp.constant.RcspConstant;
import com.jieli.jl_rcsp.constant.RcspErrorCode;
import com.jieli.jl_rcsp.interfaces.bluetooth.CmdSnGenerator;
import com.jieli.jl_rcsp.interfaces.bluetooth.IBluetoothProxy;
import com.jieli.jl_rcsp.interfaces.rcsp.IRcspOp;
import com.jieli.jl_rcsp.interfaces.rcsp.OnRcspCallback;
import com.jieli.jl_rcsp.interfaces.rcsp.OnRcspEventListener;
import com.jieli.jl_rcsp.interfaces.rcsp.RcspCommandCallback;
import com.jieli.jl_rcsp.model.DataInfo;
import com.jieli.jl_rcsp.model.Option;
import com.jieli.jl_rcsp.model.base.BaseError;
import com.jieli.jl_rcsp.model.base.BasePacket;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.command.SettingsMtuCmd;
import com.jieli.jl_rcsp.model.command.status.GetTargetInfoCmd;
import com.jieli.jl_rcsp.model.command.sys.GetSysInfoCmd;
import com.jieli.jl_rcsp.model.command.sys.UpdateSysInfoCmd;
import com.jieli.jl_rcsp.model.command.watch.HealthSettingCmd;
import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.DeviceInfo;
import com.jieli.jl_rcsp.model.device.DeviceStatus;
import com.jieli.jl_rcsp.model.parameter.SettingsMtuParam;
import com.jieli.jl_rcsp.model.parameter.UpdateSysInfoParam;
import com.jieli.jl_rcsp.model.response.SettingsMtuResponse;
import com.jieli.jl_rcsp.model.response.SysInfoResponse;
import com.jieli.jl_rcsp.model.response.TargetInfoResponse;
import com.jieli.jl_rcsp.tool.CommandHelper;
import com.jieli.jl_rcsp.tool.DataHandlerCache;
import com.jieli.jl_rcsp.tool.DeviceStatusManager;
import com.jieli.jl_rcsp.tool.HealthDataParseHelper;
import com.jieli.jl_rcsp.tool.RcspDataHandler;
import com.jieli.jl_rcsp.tool.SnGenerator;
import com.jieli.jl_rcsp.tool.callback.RcspCallbackManager;
import com.jieli.jl_rcsp.tool.callback.RcspEventListenerManager;
import com.jieli.jl_rcsp.tool.datahandles.DataHandler;
import com.jieli.jl_rcsp.tool.datahandles.DataHandlerModify;
import com.jieli.jl_rcsp.tool.datahandles.DataHandlerOld;
import com.jieli.jl_rcsp.tool.datahandles.ParseHelper;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.CommandBuilder;
import com.jieli.jl_rcsp.util.JL_Log;
import com.jieli.jl_rcsp.util.RcspUtil;
import java.util.List;

public abstract class RcspOpImpl
implements IBluetoothProxy,
IRcspOp {
    private static final String c = "jl_rcsp";
    public static boolean sUseNewDataHandler = true;
    public final Option mOption;
    public final DeviceStatusManager mStatusManager;
    public final RcspCallbackManager mRcspCallbackManager;
    public final RcspEventListenerManager mRcspEventListenerManager;
    public final RcspDataHandler mRcspDataHandler;
    public CmdSnGenerator mCmdSnGenerator;
    private BluetoothDevice a;
    public final Handler mHandler = new Handler(Looper.getMainLooper());
    private final HealthDataParseHelper b;

    public RcspOpImpl() {
        this(Option.createOption());
    }

    public RcspOpImpl(Option object) {
        if (object != null) {
            RcspEventListenerManager rcspEventListenerManager;
            RcspOpImpl rcspOpImpl = this;
            rcspOpImpl.mOption = object;
            JL_Log.d(c, "init Option : " + object + ", Lib name = " + RcspConstant.getLibVersionName());
            rcspOpImpl.mStatusManager = DeviceStatusManager.getInstance();
            rcspOpImpl.mRcspCallbackManager = new RcspCallbackManager();
            object = rcspEventListenerManager;
            rcspOpImpl.mRcspEventListenerManager = new RcspEventListenerManager();
            rcspOpImpl.mRcspDataHandler = new RcspDataHandler(this, (RcspEventListenerManager)object);
            rcspOpImpl.b = new HealthDataParseHelper(this, (RcspEventListenerManager)object);
            return;
        }
        throw new NullPointerException("Option can not be null.");
    }

    private void d(BluetoothDevice bluetoothDevice) {
        if (!RcspUtil.deviceEquals(this.a, bluetoothDevice)) {
            this.a = bluetoothDevice;
            if (this.a != null && bluetoothDevice != null) {
                this.mRcspCallbackManager.onSwitchConnectedDevice(bluetoothDevice);
            }
        }
        this.a(bluetoothDevice);
    }

    private int b(BluetoothDevice bluetoothDevice) {
        if (this.mCmdSnGenerator == null) {
            SnGenerator snGenerator;
            SnGenerator snGenerator2 = snGenerator;
            snGenerator = new SnGenerator();
            this.mCmdSnGenerator = snGenerator2;
        }
        return this.mCmdSnGenerator.getRcspCmdSeq(bluetoothDevice);
    }

    private void a(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice != null && DataHandlerCache.getInstance().getDataHandler(bluetoothDevice) == null) {
            DataHandler dataHandler;
            if (sUseNewDataHandler) {
                DataHandlerModify dataHandlerModify;
                dataHandler = dataHandlerModify;
                dataHandlerModify = new DataHandlerModify(this);
            } else {
                DataHandlerOld dataHandlerOld;
                dataHandler = dataHandlerOld;
                dataHandlerOld = new DataHandlerOld(this);
            }
            DataHandlerCache.getInstance().addDataHandler(bluetoothDevice, dataHandler);
        }
    }

    private <T extends CommandBase> void a(BluetoothDevice bluetoothDevice, RcspCommandCallback<T> rcspCommandCallback, BaseError baseError) {
        if (baseError == null) {
            return;
        }
        if (rcspCommandCallback != null) {
            this.mHandler.post(() -> rcspCommandCallback.onErrCode(bluetoothDevice, baseError));
        } else {
            this.a(bluetoothDevice, baseError);
        }
    }

    private void a(BluetoothDevice bluetoothDevice, BaseError baseError) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = RcspUtil.printBtDeviceInfo(bluetoothDevice);
        objectArray2[1] = baseError;
        JL_Log.e(c, RcspUtil.formatString("notifyRcspError : %s ---> %s", objectArray3));
        objectArray.mRcspCallbackManager.onRcspError(bluetoothDevice, baseError);
    }

    private void a(BluetoothDevice object, int n) {
        block9: {
            block7: {
                block8: {
                    this.mRcspCallbackManager.onConnectStateChange((BluetoothDevice)object, n);
                    if (n == 0) break block7;
                    if (n == 1) break block8;
                    if (n == 2) break block7;
                    if (n != 4) break block9;
                }
                if (this.a == null) {
                    this.d((BluetoothDevice)object);
                } else {
                    this.a((BluetoothDevice)object);
                }
                this.c((BluetoothDevice)object);
                break block9;
            }
            RcspOpImpl rcspOpImpl = this;
            rcspOpImpl.mStatusManager.removeDeviceStatus((BluetoothDevice)object);
            DataHandlerCache.getInstance().removeDataHandler((BluetoothDevice)object);
            if (RcspUtil.deviceEquals(rcspOpImpl.a, (BluetoothDevice)object)) {
                object = DataHandlerCache.getInstance().getDeviceList();
                if (object.isEmpty()) {
                    this.d(null);
                } else {
                    Object object2 = object;
                    this.d((BluetoothDevice)object2.get(object2.size() - 1));
                }
            }
        }
    }

    private void c(BluetoothDevice bluetoothDevice) {
        Object object = this.mStatusManager.getDeviceStatus(bluetoothDevice);
        object = object == null ? null : ((DeviceStatus)object).getDeviceInfo();
        if (object == null) {
            this.e(bluetoothDevice);
        } else if (((DeviceInfo)object).isMandatoryUpgrade()) {
            RcspOpImpl rcspOpImpl = this;
            rcspOpImpl.mStatusManager.updateDeviceMaxCommunicationMtu(bluetoothDevice, 530);
            rcspOpImpl.mRcspCallbackManager.onMandatoryUpgrade(bluetoothDevice);
        } else {
            this.mRcspCallbackManager.onRcspInit(bluetoothDevice, true);
        }
    }

    private void e(BluetoothDevice object) {
        RcspCommandCallback<GetTargetInfoCmd> rcspCommandCallback;
        BluetoothDevice bluetoothDevice = object;
        JL_Log.i(c, "-getDeviceInfo- device : " + RcspUtil.printBtDeviceInfo(object));
        object = CommandBuilder.buildGetDeviceInfoCmdForAll();
        RcspCommandCallback<GetTargetInfoCmd> rcspCommandCallback2 = rcspCommandCallback;
        rcspCommandCallback = new RcspCommandCallback<GetTargetInfoCmd>(){

            @Override
            public void onCommandResponse(BluetoothDevice bluetoothDevice, GetTargetInfoCmd getTargetInfoCmd) {
                JL_Log.i(RcspOpImpl.c, "-getDeviceInfo- cmd = " + getTargetInfoCmd);
                if (getTargetInfoCmd.getStatus() == 0) {
                    TargetInfoResponse targetInfoResponse = (TargetInfoResponse)getTargetInfoCmd.getResponse();
                    if (targetInfoResponse != null) {
                        if (RcspOpImpl.this.mStatusManager.getDeviceInfo(bluetoothDevice) == null) {
                            RcspOpImpl.this.mStatusManager.updateDeviceTargetInfo(bluetoothDevice, targetInfoResponse);
                        }
                        RcspOpImpl.this.c(bluetoothDevice);
                        return;
                    }
                    RcspOpImpl.this.a(bluetoothDevice, new BaseError(12289).setOpCode(getTargetInfoCmd.getId()));
                } else {
                    RcspOpImpl.this.a(bluetoothDevice, RcspErrorCode.buildJsonError(getTargetInfoCmd.getId(), 12292, getTargetInfoCmd.getStatus(), null));
                }
                RcspOpImpl.this.mRcspCallbackManager.onRcspInit(bluetoothDevice, false);
            }

            @Override
            public void onErrCode(BluetoothDevice bluetoothDevice, BaseError baseError) {
                2 v0 = this;
                JL_Log.w(RcspOpImpl.c, "-getDeviceInfo- onErrCode = " + baseError);
                v0.RcspOpImpl.this.a(bluetoothDevice, baseError);
                v0.RcspOpImpl.this.mRcspCallbackManager.onRcspInit(bluetoothDevice, false);
            }
        };
        this.sendRcspCommand(bluetoothDevice, (CommandBase)object, rcspCommandCallback2);
    }

    private void a(BluetoothDevice bluetoothDevice, BasePacket basePacket) {
        BasePacket basePacket2 = basePacket;
        int n = basePacket2.getOpCode();
        boolean bl = basePacket2.getType() == 1;
        CommandBase commandBase = ParseHelper.convert2Command(bluetoothDevice, basePacket);
        if (commandBase == null) {
            BaseError baseError;
            RcspOpImpl rcspOpImpl = baseError2;
            BaseError baseError2 = baseError;
            baseError2(12289);
            baseError.setOpCode(basePacket.getOpCode());
            rcspOpImpl.a(bluetoothDevice, baseError2);
            return;
        }
        if (1 == n) {
            ((RcspOpImpl)((Object)baseError2)).mRcspCallbackManager.onRcspDataCmd(bluetoothDevice, commandBase);
        } else {
            if (bl) {
                int n2 = basePacket.getHasResponse();
                super.a(bluetoothDevice, commandBase, n2);
            } else {
                ((RcspOpImpl)((Object)baseError2)).handleRcspResponse(bluetoothDevice, commandBase);
            }
            ((RcspOpImpl)((Object)baseError2)).b.receiveCmdFromDevice(bluetoothDevice, commandBase);
        }
    }

    private void a(BluetoothDevice bluetoothDevice, CommandBase commandBase, int n) {
        int n2 = commandBase.getId();
        if (Command.isValidCmd(n2)) {
            if (n2 != 9) {
                if (n2 != 165) {
                    if (n2 == 209) {
                        SettingsMtuCmd settingsMtuCmd = (SettingsMtuCmd)commandBase;
                        SettingsMtuParam settingsMtuParam = (SettingsMtuParam)settingsMtuCmd.getParam();
                        if (settingsMtuParam != null) {
                            int n3 = settingsMtuParam.getMtu();
                            ((RcspOpImpl)((Object)commandBase3)).mStatusManager.updateDeviceMaxCommunicationMtu(bluetoothDevice, n3);
                            settingsMtuCmd.setResponse(new SettingsMtuResponse(n3));
                        }
                        settingsMtuCmd.setStatus(0);
                        ((RcspOpImpl)((Object)commandBase3)).sendCommandResponse(bluetoothDevice, settingsMtuCmd, null);
                    }
                } else {
                    Object object = (HealthSettingCmd.Param)((HealthSettingCmd)commandBase).getParam();
                    if (object instanceof HealthSettingCmd.UpdateParam) {
                        object = ((HealthSettingCmd.UpdateParam)object).getList();
                        ((RcspOpImpl)((Object)commandBase3)).mRcspDataHandler.parseHealthSetting(bluetoothDevice, (List<AttrBean>)object);
                    }
                }
            } else {
                UpdateSysInfoParam updateSysInfoParam = (UpdateSysInfoParam)((UpdateSysInfoCmd)commandBase).getParam();
                List<AttrBean> list = updateSysInfoParam.getAttrBeanList();
                ((RcspOpImpl)((Object)commandBase3)).mRcspDataHandler.parseAttrMessage(bluetoothDevice, updateSysInfoParam.getFunction(), list);
            }
            ((RcspOpImpl)((Object)commandBase3)).mRcspCallbackManager.onRcspCommand(bluetoothDevice, commandBase);
        } else if (n == 1) {
            CommandBase commandBase2;
            RcspOpImpl rcspOpImpl = commandBase3;
            CommandBase commandBase3 = commandBase2;
            commandBase3(n2, "unknownCommand");
            commandBase2.setOpCodeSn(commandBase.getOpCodeSn());
            commandBase2.setStatus(2);
            rcspOpImpl.sendCommandResponse(bluetoothDevice, commandBase3, null);
        }
    }

    public boolean isRcspInit() {
        return this.getConnectedDevice() != null && this.getDeviceInfo() != null;
    }

    @Override
    public void setCmdSnGenerator(CmdSnGenerator cmdSnGenerator) {
        this.mCmdSnGenerator = cmdSnGenerator;
    }

    @Override
    public void notifyBtDeviceConnection(BluetoothDevice bluetoothDevice, int n) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = RcspUtil.printBtDeviceInfo(bluetoothDevice);
        objectArray2[1] = n;
        JL_Log.d(c, RcspUtil.formatString("-notifyBtDeviceConnection- device = %s, status = %d", objectArray3));
        super.a(bluetoothDevice, n);
    }

    @Override
    public void notifyReceiveDeviceData(BluetoothDevice bluetoothDevice, byte[] byArray) {
        BaseError baseError;
        Object object;
        Object[] objectArray = new Object[2];
        Object object2 = objectArray;
        object2[0] = RcspUtil.printBtDeviceInfo(bluetoothDevice);
        objectArray[1] = CHexConver.byte2HexStr(byArray);
        JL_Log.d(c, RcspUtil.formatString("-notifyReceiveDeviceData- device = %s, data = [%s]", (Object[])object2));
        if (bluetoothDevice != null && byArray != null) {
            if (!((RcspOpImpl)object).mOption.isMultiDevice() && !RcspUtil.deviceEquals(bluetoothDevice, ((RcspOpImpl)object).getTargetDevice())) {
                BaseError baseError2;
                Object object3 = object;
                object = baseError2;
                baseError2 = new BaseError(8193);
                super.a(bluetoothDevice, (BaseError)object);
                return;
            }
            object2 = DataHandlerCache.getInstance().getDataHandler(bluetoothDevice);
            if (object2 == null) {
                BaseError baseError3;
                Object object4 = object;
                JL_Log.e(c, "-onReceiveDataFromDevice- mDataHandler is null.");
                object = baseError3;
                baseError3 = new BaseError(8192);
                super.a(bluetoothDevice, (BaseError)object);
                return;
            }
            object2.addRecvData(new DataInfo().setDevice(bluetoothDevice).setType(1).setRecvData(byArray));
            return;
        }
        RcspOpImpl rcspOpImpl = object;
        object = baseError;
        baseError = new BaseError(4097);
        rcspOpImpl.a(bluetoothDevice, (BaseError)object);
    }

    @Override
    public void receiveDataFromDevice(BluetoothDevice bluetoothDevice, BasePacket basePacket) {
        BaseError baseError;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = bluetoothDevice;
        objectArray[1] = basePacket;
        JL_Log.v(c, RcspUtil.formatString("-receiveDataFromDevice- device = %s, packet = %s", objectArray2));
        if (bluetoothDevice != null && basePacket != null) {
            if (!(((RcspOpImpl)((Object)baseError2)).mOption.isMultiDevice() || RcspUtil.deviceEquals(bluetoothDevice, ((RcspOpImpl)((Object)baseError2)).getTargetDevice()) || basePacket.getType() == 1 && basePacket.getOpCode() == 194)) {
                return;
            }
            super.a(bluetoothDevice, basePacket);
            return;
        }
        RcspOpImpl rcspOpImpl = baseError2;
        BaseError baseError2 = baseError;
        baseError = new BaseError(4097);
        rcspOpImpl.a(bluetoothDevice, baseError2);
    }

    public void callbackErrorEvent(BaseError baseError) {
        this.mRcspCallbackManager.onRcspError(this.getTargetDevice(), baseError);
    }

    @Override
    public void registerOnRcspCallback(OnRcspCallback onRcspCallback) {
        RcspOpImpl rcspOpImpl = deviceInfo;
        rcspOpImpl.mRcspCallbackManager.registerCallback(onRcspCallback);
        BluetoothDevice bluetoothDevice = rcspOpImpl.getTargetDevice();
        if (bluetoothDevice == null) {
            return;
        }
        DeviceInfo deviceInfo = ((RcspOpImpl)((Object)deviceInfo)).mStatusManager.getDeviceInfo(bluetoothDevice);
        if (deviceInfo == null) {
            return;
        }
        if (deviceInfo.isMandatoryUpgrade()) {
            onRcspCallback.onMandatoryUpgrade(bluetoothDevice);
        }
    }

    @Override
    public void unregisterOnRcspCallback(OnRcspCallback onRcspCallback) {
        this.mRcspCallbackManager.unregisterCallback(onRcspCallback);
    }

    @Override
    public void registerOnRcspEventListener(OnRcspEventListener onRcspEventListener) {
        this.mRcspEventListenerManager.registerCallback(onRcspEventListener);
    }

    @Override
    public void unregisterOnRcspEventListener(OnRcspEventListener onRcspEventListener) {
        this.mRcspEventListenerManager.unregisterCallback(onRcspEventListener);
    }

    @Override
    public void switchConnectedDevice(BluetoothDevice bluetoothDevice) {
        List<BluetoothDevice> list = DataHandlerCache.getInstance().getDeviceList();
        if (bluetoothDevice != null && list.contains(bluetoothDevice) && !RcspUtil.deviceEquals(this.a, bluetoothDevice)) {
            this.d(bluetoothDevice);
        }
    }

    @Override
    public <T extends CommandBase> void sendCommandAsync(BluetoothDevice bluetoothDevice, CommandBase object, int n, RcspCommandCallback<T> rcspCommandCallback) {
        Object object2;
        if (object == null) {
            BaseError baseError;
            RcspOpImpl rcspOpImpl = object2;
            object2 = baseError;
            baseError = new BaseError(4097);
            rcspOpImpl.a(bluetoothDevice, rcspCommandCallback, (BaseError)object2);
            return;
        }
        if (object2.isDeviceConnected(bluetoothDevice) && DataHandlerCache.getInstance().getDataHandler(bluetoothDevice) != null) {
            CommandBase commandBase = object;
            commandBase.setOpCodeSn(super.b(bluetoothDevice));
            BasePacket basePacket = ParseHelper.convert2BasePacket(commandBase, 1);
            if (basePacket == null) {
                BaseError baseError;
                Object object3 = object2;
                object2 = baseError;
                ((BaseError)object2)(12289);
                baseError.setOpCode(((CommandBase)object).getId());
                super.a(bluetoothDevice, rcspCommandCallback, (BaseError)object2);
                return;
            }
            Object object4 = object2;
            CommandHelper.getInstance().putCommandBase(bluetoothDevice, (CommandBase)object);
            object2 = new DataInfo().setDevice(bluetoothDevice).setType(0).setBasePacket(basePacket).setTimeoutMs(n).setRcspCmdCallback(rcspCommandCallback);
            object = ParseHelper.packSendBasePacket(basePacket);
            ((RcspOpImpl)object4).mRcspCallbackManager.onPutDataToDataHandler(bluetoothDevice, (byte[])object);
            DataHandlerCache.getInstance().getDataHandler(bluetoothDevice).addSendData((DataInfo)object2);
        } else {
            BaseError baseError;
            Object object5 = object2;
            object2 = baseError;
            ((BaseError)object2)(8192);
            baseError.setOpCode(((CommandBase)object).getId());
            super.a(bluetoothDevice, rcspCommandCallback, (BaseError)object2);
        }
    }

    @Override
    public <T extends CommandBase> void sendCommandResponse(BluetoothDevice bluetoothDevice, CommandBase commandBase, RcspCommandCallback<T> rcspCommandCallback) {
        Object object;
        if (commandBase == null) {
            BaseError baseError;
            RcspOpImpl rcspOpImpl = object;
            object = baseError;
            baseError = new BaseError(4097);
            rcspOpImpl.a(bluetoothDevice, rcspCommandCallback, (BaseError)object);
            return;
        }
        if (object.isDeviceConnected(bluetoothDevice) && DataHandlerCache.getInstance().getDataHandler(bluetoothDevice) != null) {
            BasePacket basePacket = ParseHelper.convert2BasePacket(commandBase, 0);
            if (basePacket == null) {
                BaseError baseError;
                Object object2 = object;
                object = baseError;
                ((BaseError)object)(12289);
                baseError.setOpCode(commandBase.getId());
                super.a(bluetoothDevice, rcspCommandCallback, (BaseError)object);
                return;
            }
            DataHandlerCache.getInstance().getDataHandler(bluetoothDevice).addSendData(new DataInfo().setDevice(bluetoothDevice).setType(0).setBasePacket(basePacket).setRcspCmdCallback(rcspCommandCallback));
        } else {
            BaseError baseError;
            Object object3 = object;
            object = baseError;
            ((BaseError)object)(8192);
            baseError.setOpCode(commandBase.getId());
            super.a(bluetoothDevice, rcspCommandCallback, (BaseError)object);
        }
    }

    @Override
    public void release() {
        RcspOpImpl rcspOpImpl = this;
        rcspOpImpl.d(null);
        CmdSnGenerator cmdSnGenerator = rcspOpImpl.mCmdSnGenerator;
        if (cmdSnGenerator != null) {
            if (cmdSnGenerator instanceof SnGenerator) {
                ((SnGenerator)cmdSnGenerator).destroy();
            }
            this.mCmdSnGenerator = null;
        }
        RcspOpImpl rcspOpImpl2 = this;
        rcspOpImpl2.mRcspCallbackManager.release();
        rcspOpImpl2.mRcspEventListenerManager.release();
        rcspOpImpl2.mStatusManager.release();
        DataHandlerCache.getInstance().destroy();
        rcspOpImpl2.mHandler.removeCallbacksAndMessages(null);
    }

    public BluetoothDevice getTargetDevice() {
        return this.a;
    }

    public DeviceInfo getDeviceInfo() {
        RcspOpImpl rcspOpImpl = this;
        return rcspOpImpl.getDeviceInfo(rcspOpImpl.a);
    }

    public DeviceInfo getDeviceInfo(BluetoothDevice bluetoothDevice) {
        return this.mStatusManager.getDeviceInfo(bluetoothDevice);
    }

    public <T extends CommandBase> void sendRcspCommand(BluetoothDevice bluetoothDevice, CommandBase commandBase, RcspCommandCallback<T> rcspCommandCallback) {
        this.sendRcspCommand(bluetoothDevice, commandBase, this.mOption.getCmdTimeout(), rcspCommandCallback);
    }

    public <T extends CommandBase> void sendRcspCommand(BluetoothDevice bluetoothDevice, CommandBase commandBase, final int n, final RcspCommandCallback<T> rcspCommandCallback) {
        RcspCommandCallback rcspCommandCallback2;
        RcspCommandCallback rcspCommandCallback3 = rcspCommandCallback2;
        rcspCommandCallback2 = new RcspCommandCallback<T>(){
            public int a = 0;

            @Override
            public void onCommandResponse(BluetoothDevice bluetoothDevice, T t) {
                if (3 == ((CommandBase)t).getStatus() && ++rcspCommandCallback2.a < 3) {
                    rcspCommandCallback2.RcspOpImpl.this.mHandler.postDelayed(() -> RcspOpImpl.this.sendCommandAsync(bluetoothDevice, (CommandBase)t, rcspCommandCallback2.n, rcspCommandCallback2), 500L);
                    return;
                }
                rcspCommandCallback2.a = 0;
                RcspCommandCallback rcspCommandCallback2 = rcspCommandCallback2.rcspCommandCallback;
                if (rcspCommandCallback2 != null) {
                    rcspCommandCallback2.onCommandResponse(bluetoothDevice, t);
                }
            }

            @Override
            public void onErrCode(BluetoothDevice bluetoothDevice, BaseError baseError) {
                rcspCommandCallback2.a = 0;
                RcspCommandCallback rcspCommandCallback2 = rcspCommandCallback2.rcspCommandCallback;
                if (rcspCommandCallback2 != null) {
                    rcspCommandCallback2.onErrCode(bluetoothDevice, baseError);
                }
            }
        };
        this.sendCommandAsync(bluetoothDevice, commandBase, n, rcspCommandCallback3);
    }

    public void handleRcspResponse(BluetoothDevice bluetoothDevice, CommandBase object) {
        if (((CommandBase)object).getStatus() != 0) {
            return;
        }
        int n = ((CommandBase)object).getId();
        if (n != 3) {
            List<AttrBean> list;
            if (n != 7) {
                if (n != 165) {
                    if (n == 209 && (object = (SettingsMtuResponse)((SettingsMtuCmd)object).getResponse()) != null) {
                        ((RcspOpImpl)((Object)list)).mStatusManager.updateDeviceMaxCommunicationMtu(bluetoothDevice, ((SettingsMtuResponse)object).getRealMtu());
                    }
                } else if ((object = (HealthSettingCmd.Response)((HealthSettingCmd)object).getResponse()) instanceof HealthSettingCmd.GetResponse) {
                    List<AttrBean> list2 = list;
                    list = ((HealthSettingCmd.GetResponse)object).getList();
                    ((RcspOpImpl)((Object)list2)).mRcspDataHandler.parseHealthSetting(bluetoothDevice, list);
                }
            } else {
                RcspOpImpl rcspOpImpl = list;
                list = (SysInfoResponse)((GetSysInfoCmd)object).getResponse();
                object = ((SysInfoResponse)((Object)list)).getAttrs();
                rcspOpImpl.mRcspDataHandler.parseAttrMessage(bluetoothDevice, ((SysInfoResponse)((Object)list)).getFunction(), (List<AttrBean>)object);
            }
        } else if ((object = (TargetInfoResponse)((GetTargetInfoCmd)object).getResponse()) != null) {
            ((RcspOpImpl)((Object)list)).mStatusManager.updateDeviceTargetInfo(bluetoothDevice, (TargetInfoResponse)object);
        }
    }
}

