/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.cmdHandler;

import android.bluetooth.BluetoothDevice;
import com.jieli.jl_rcsp.interfaces.cmd.ICmdHandler;
import com.jieli.jl_rcsp.model.base.BasePacket;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.command.file_op.DeviceExtendParamCmd;
import com.jieli.jl_rcsp.tool.CommandHelper;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.JL_Log;
import com.jieli.jl_rcsp.util.RcspUtil;

public class DeviceExtendParamCmdHandler
implements ICmdHandler {
    private final String tag;

    public DeviceExtendParamCmdHandler() {
        DeviceExtendParamCmdHandler deviceExtendParamCmdHandler = this;
        deviceExtendParamCmdHandler.tag = deviceExtendParamCmdHandler.getClass().getSimpleName();
    }

    @Override
    public CommandBase parseDataToCmd(BluetoothDevice object, BasePacket basePacket) {
        byte[] byArray = basePacket.getParamData();
        if (byArray != null && byArray.length >= 1) {
            if (basePacket.getType() == 1) {
                int n = byArray[0];
                object = null;
                if (n != 0) {
                    if (n != 1) {
                        if (n == 2) {
                            DeviceExtendParamCmd.ReadFileParam readFileParam;
                            n = CHexConver.bytesToInt(byArray, 1, 4);
                            object = readFileParam;
                            readFileParam = new DeviceExtendParamCmd.ReadFileParam(n);
                        }
                    } else {
                        DeviceExtendParamCmd.DeleteFileParam deleteFileParam;
                        n = CHexConver.bytesToInt(byArray, 1, 4);
                        object = deleteFileParam;
                        deleteFileParam = new DeviceExtendParamCmd.DeleteFileParam(n);
                    }
                } else {
                    n = CHexConver.bytesToInt(byArray, 1, 4);
                    boolean bl = byArray[5] == 1;
                    object = new DeviceExtendParamCmd.FileTransferParam(n, bl);
                }
                return new DeviceExtendParamCmd((DeviceExtendParamCmd.Param)object);
            }
            BasePacket basePacket2 = basePacket;
            int n = basePacket2.getOpCode();
            CommandBase commandBase = CommandHelper.getInstance().getCommand((BluetoothDevice)object, n, basePacket2.getOpCodeSn());
            if (commandBase != null) {
                commandBase = (DeviceExtendParamCmd)commandBase;
            } else {
                DeviceExtendParamCmd deviceExtendParamCmd;
                commandBase = deviceExtendParamCmd;
                deviceExtendParamCmd = new DeviceExtendParamCmd(new DeviceExtendParamCmd.Param(byArray[0]));
            }
            if (byArray[0] == 0) {
                boolean bl = byArray[1] == 1;
                object = new DeviceExtendParamCmd.FileTransferResponse(bl);
            } else {
                DeviceExtendParamCmd.Response response;
                object = response;
                response = new DeviceExtendParamCmd.Response(byArray[0]);
            }
            CommandBase commandBase2 = commandBase;
            commandBase.setStatus(basePacket.getStatus());
            commandBase.setOpCodeSn(basePacket.getOpCodeSn());
            commandBase2.setResponse(object);
            return commandBase2;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = basePacket.getOpCode();
        JL_Log.e(objectArray2.tag, "\u5f02\u5e38\uff1a\u6570\u636e\u5305\u5185\u5bb9\u4e3a\u7a7a\uff0ccmd id = " + RcspUtil.formatString("%02x", objectArray2));
        return null;
    }
}

