/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.cmdHandler;

import android.bluetooth.BluetoothDevice;
import com.jieli.jl_rcsp.interfaces.cmd.ICmdHandler;
import com.jieli.jl_rcsp.model.base.BasePacket;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.command.SettingsMtuCmd;
import com.jieli.jl_rcsp.model.parameter.SettingsMtuParam;
import com.jieli.jl_rcsp.model.response.SettingsMtuResponse;
import com.jieli.jl_rcsp.tool.CommandHelper;
import com.jieli.jl_rcsp.tool.DeviceStatusManager;
import com.jieli.jl_rcsp.util.CHexConver;

public class SettingsMtuCmdHandler
implements ICmdHandler {
    @Override
    public CommandBase parseDataToCmd(BluetoothDevice bluetoothDevice, BasePacket basePacket) {
        SettingsMtuCmd settingsMtuCmd;
        SettingsMtuResponse settingsMtuResponse;
        if (basePacket == null) {
            return null;
        }
        if (basePacket.getOpCode() != 209) {
            return null;
        }
        BasePacket basePacket2 = basePacket;
        Object object = basePacket2.getParamData();
        if (basePacket2.getType() == 1) {
            int n = DeviceStatusManager.getInstance().getMaxCommunicationMtu(bluetoothDevice);
            if (object != null && ((Object)object).length >= 2) {
                n = CHexConver.bytesToInt((byte)object[0], (byte)object[1]);
            }
            return new SettingsMtuCmd(new SettingsMtuParam(n)).setOpCodeSn(basePacket.getOpCodeSn());
        }
        BasePacket basePacket3 = basePacket;
        int n = basePacket3.getOpCode();
        CommandBase commandBase = CommandHelper.getInstance().getCommand(bluetoothDevice, n, basePacket3.getOpCodeSn());
        SettingsMtuResponse settingsMtuResponse2 = settingsMtuResponse;
        settingsMtuResponse2(530);
        settingsMtuResponse.setRawData((byte[])object);
        if (object != null && ((Object)object).length >= 2) {
            settingsMtuResponse2.setRealMtu(CHexConver.bytesToInt((byte)object[0], (byte)object[1]));
        }
        if (commandBase != null) {
            SettingsMtuCmd settingsMtuCmd2 = (SettingsMtuCmd)commandBase;
            settingsMtuCmd2.setStatus(basePacket.getStatus());
            settingsMtuCmd2.setResponse(settingsMtuResponse2);
            return settingsMtuCmd2;
        }
        object = settingsMtuCmd;
        ((SettingsMtuCmd)object)(new SettingsMtuParam(530));
        ((CommandBase)object).setOpCodeSn(basePacket.getOpCodeSn());
        ((CommandBase)object).setStatus(basePacket.getStatus());
        settingsMtuCmd.setResponse(settingsMtuResponse2);
        return settingsMtuCmd;
    }
}

