/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.command;

import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.model.base.CommandWithParamAndResponse;
import com.jieli.jl_rcsp.model.base.CommonResponse;
import com.jieli.jl_rcsp.util.CHexConver;
import java.util.ArrayList;
import java.util.List;

public class AlarmExpandCmd
extends CommandWithParamAndResponse<Param, Response> {
    public AlarmExpandCmd(Param param) {
        super(37, AlarmExpandCmd.class.getSimpleName(), param);
    }

    public static class BellArg {
        public final byte[] data;

        public BellArg(byte[] byArray) {
            this.data = byArray;
        }

        private static byte enable(boolean bl, byte by) {
            return (byte)(bl ? by | 0x80 : by & 0x7F);
        }

        public byte getIndex() {
            return this.data[1];
        }

        public boolean isCanSetCount() {
            return (this.data[2] & 0x80) == 128;
        }

        public BellArg setCanSetCount(boolean bl) {
            BellArg bellArg = this;
            bellArg.data[2] = BellArg.enable(bl, bellArg.data[2]);
            return bellArg;
        }

        public byte getCount() {
            return (byte)(this.data[2] & 0xF);
        }

        public BellArg setCount(byte by) {
            BellArg bellArg = this;
            bellArg.data[2] = (byte)(by | bellArg.data[2] & 0xEF0);
            return bellArg;
        }

        public boolean isCanSetInterval() {
            return (this.data[3] & 0x80) == 128;
        }

        public BellArg setCanSetInterval(boolean bl) {
            BellArg bellArg = this;
            bellArg.data[3] = BellArg.enable(bl, bellArg.data[3]);
            return bellArg;
        }

        public byte getInterval() {
            return (byte)(this.data[3] & 0x1F);
        }

        public BellArg setInterval(byte by) {
            BellArg bellArg = this;
            bellArg.data[3] = (byte)(by | bellArg.data[3] & 0xE0);
            return bellArg;
        }

        public boolean isCanSetAlarmBellTime() {
            return (this.data[4] & 0x80) == 128;
        }

        public BellArg setCanSetAlarmTime(boolean bl) {
            BellArg bellArg = this;
            bellArg.data[4] = BellArg.enable(bl, bellArg.data[4]);
            return bellArg;
        }

        public byte getAlarmBellTime() {
            return (byte)(this.data[4] & 0x1F);
        }

        public BellArg setAlarmBellTime(byte by) {
            BellArg bellArg = this;
            bellArg.data[4] = (byte)(by | bellArg.data[4] & 0xE0);
            return bellArg;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return "BellArgs{data=" + CHexConver.byte2HexStr(this.data) + '}';
        }
    }

    public static class ReadRtcBellArgsResponse
    extends Response {
        private final List<BellArg> bellArgs;

        public ReadRtcBellArgsResponse(byte by, byte[] byArray) {
            super(by);
            this.bellArgs = ReadRtcBellArgsResponse.fromBytes(byArray);
        }

        public static List<BellArg> fromBytes(byte[] byArray) {
            ArrayList<BellArg> arrayList;
            ArrayList<BellArg> arrayList2 = arrayList;
            arrayList = new ArrayList<BellArg>();
            if (byArray != null && byArray.length >= 1) {
                int n;
                int n2;
                int n3 = 0;
                while (n3 < byArray.length && (n2 = (n = byArray[n3] + 1) + n3) <= byArray.length && n > 1) {
                    BellArg bellArg;
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, n3, byArray2, 0, n);
                    BellArg bellArg2 = bellArg;
                    bellArg = new BellArg(byArray2);
                    arrayList2.add(bellArg2);
                    n3 = n2;
                }
                return arrayList2;
            }
            return arrayList2;
        }

        public List<BellArg> getBellArg() {
            return this.bellArgs;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder;
            ReadRtcBellArgsResponse readRtcBellArgsResponse = stringBuilder2;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            List<BellArg> list = readRtcBellArgsResponse.bellArgs;
            if (list != null) {
                list = list.iterator();
                while (list.hasNext()) {
                    Object object = stringBuilder2;
                    ((StringBuilder)object).append(((BellArg)list.next()).toString());
                    ((StringBuilder)object).append("\t");
                }
            }
            return "ReadRtcBellArgsResponse{bellArgs=" + stringBuilder2 + '}';
        }
    }

    public static class Response
    extends CommonResponse {
        private final byte op;

        public Response(byte by) {
            this.op = by;
        }

        public byte getOp() {
            return this.op;
        }
    }

    public static class ReadRtcBellArgsParams
    extends Param {
        private final byte mask;

        public ReadRtcBellArgsParams(byte by) {
            ReadRtcBellArgsParams readRtcBellArgsParams = object;
            byte[] byArray = new byte[1];
            Object object = byArray;
            byArray[0] = by;
            super((byte)0, (byte[])object);
            readRtcBellArgsParams.mask = by;
        }

        public byte getMask() {
            return this.mask;
        }
    }

    public static class SetRtcBellArgsParams
    extends Param {
        private final BellArg bellArg;

        public SetRtcBellArgsParams(BellArg bellArg) {
            super((byte)1, bellArg.data);
            this.bellArg = bellArg;
        }

        public BellArg getBellArg() {
            return this.bellArg;
        }
    }

    public static class Param
    extends BaseParameter {
        private final byte op;
        private final byte[] data;

        public Param(byte by, byte[] byArray) {
            this.op = by;
            this.data = byArray;
        }

        public byte getOp() {
            return this.op;
        }

        public byte[] getData() {
            return this.data;
        }

        @Override
        public byte[] getParamData() {
            byte[] byArray = this.data;
            int n = this.data == null ? 0 : byArray.length;
            byte[] byArray2 = new byte[n + 1];
            byte[] byArray3 = byArray2;
            byArray2[0] = this.op;
            if (byArray != null) {
                System.arraycopy(byArray, 0, byArray3, 1, n);
            }
            return byArray3;
        }
    }
}

