/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.command;

import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.model.base.CommandWithParamAndResponse;
import com.jieli.jl_rcsp.model.base.CommonResponse;
import com.jieli.jl_rcsp.util.CHexConver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ReadErrorMsgCmd
extends CommandWithParamAndResponse<ReadErrorMsgParam, ReadErrorMsgResponse> {
    public ReadErrorMsgCmd(ReadErrorMsgParam readErrorMsgParam) {
        super(41, ReadErrorMsgCmd.class.getSimpleName(), readErrorMsgParam);
    }

    public static class ReadErrorMsgResponse
    extends CommonResponse {
        private int size;
        private short crc;

        public int getSize() {
            return this.size;
        }

        public void setSize(int n) {
            this.size = n;
        }

        public short getCrc() {
            return this.crc;
        }

        public void setCrc(short s) {
            this.crc = s;
        }

        public void parseData(byte[] byArray) {
            if (byArray != null && byArray.length >= 4) {
                this.setSize(CHexConver.bytesToInt(byArray, 0, 4));
                int n = 4;
                if (6 > byArray.length) {
                    return;
                }
                this.setCrc(CHexConver.bytesToShort(byArray[n], byArray[5]));
                return;
            }
        }
    }

    public static class ResponseReadResult
    extends ReadErrorMsgParam {
        private int size;
        private short crc;

        public int getSize() {
            return this.size;
        }

        public void setSize(int n) {
            this.size = n;
        }

        public short getCrc() {
            return this.crc;
        }

        public void setCrc(short s) {
            this.crc = s;
        }

        @Override
        public byte[] getParamData() {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            try {
                byteArrayOutputStream2.write(CHexConver.intToBigBytes(this.size));
                byteArrayOutputStream.write(CHexConver.shortToBigBytes(this.crc));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return byteArrayOutputStream2.toByteArray();
        }
    }

    public static class ReadErrorMsgParam
    extends BaseParameter {
        public static final int READ_START = 0;
        public static final int READ_STOP = 1;
        private int op;

        public int getOp() {
            return this.op;
        }

        public void setOp(int n) {
            this.op = n;
        }

        @Override
        public byte[] getParamData() {
            return new byte[]{CHexConver.intToByte(this.op)};
        }

        public void parseData(byte[] byArray) {
            if (byArray != null && byArray.length > 0) {
                this.setOp(CHexConver.byteToInt(byArray[0]));
                return;
            }
        }
    }
}

