/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.command.data;

import com.jieli.jl_rcsp.interfaces.cmd.IParamBase;
import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.base.CommonResponse;
import com.jieli.jl_rcsp.util.CHexConver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DataTransferCmd
extends CommandBase<Param, Response> {
    public DataTransferCmd(Param param) {
        this(2, param);
    }

    public DataTransferCmd(int n, Param param) {
        DataTransferCmd dataTransferCmd = this;
        super(48, DataTransferCmd.class.getSimpleName(), n);
        dataTransferCmd.setParam(param);
    }

    public static class DataTransferResponse
    extends Response {
        private int type;
        private boolean isEnd;
        private int seq;
        private int result;
        private byte[] message;

        public DataTransferResponse(byte[] byArray) {
            DataTransferResponse dataTransferResponse = this;
            super(byArray);
            dataTransferResponse.parseResponseData(dataTransferResponse.getResponse());
        }

        public DataTransferResponse(int n, boolean bl, int n2, int n3, byte[] byArray) {
            super(1, DataTransferResponse.getResponseData(n, bl, n2, n3, byArray));
        }

        private void parseResponseData(byte[] byArray) {
            if (byArray != null && byArray.length >= 4) {
                this.type = CHexConver.byteToInt(byArray[0]);
                int n = CHexConver.bytesToInt(byArray, 1, 2);
                int n2 = 3;
                this.seq = n & 0x7F;
                boolean bl = n >> 15 == 1;
                this.isEnd = bl;
                this.result = CHexConver.byteToInt(byArray[n2]);
                n2 = 4;
                if (byArray.length > n2) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[byArray.length - n2];
                    this.message = byArray;
                    int n3 = byArray.length;
                    System.arraycopy(byArray2, n2, byArray, 0, n3);
                } else {
                    this.message = new byte[0];
                }
                return;
            }
        }

        private static byte[] getResponseData(int n, boolean bl, int n2, int n3, byte[] byArray) {
            ByteArrayOutputStream byteArrayOutputStream;
            block4: {
                ByteArrayOutputStream byteArrayOutputStream2;
                byteArrayOutputStream = byteArrayOutputStream2;
                new ByteArrayOutputStream().write(n);
                n = bl ? n2 | 0x8000 : n2 & Short.MAX_VALUE;
                byteArrayOutputStream.write(CHexConver.int2byte2(n));
                byteArrayOutputStream.write(n3);
                if (byArray == null) break block4;
                if (byArray.length <= 0) break block4;
                try {
                    byteArrayOutputStream.write(byArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return byteArrayOutputStream.toByteArray();
        }

        public int getType() {
            return this.type;
        }

        public boolean isEnd() {
            return this.isEnd;
        }

        public int getSeq() {
            return this.seq;
        }

        public int getResult() {
            return this.result;
        }

        public byte[] getMessage() {
            return this.message;
        }

        @Override
        public String toString() {
            return "DataTransferResponse{type=" + this.type + ", isEnd=" + this.isEnd + ", seq=" + this.seq + ", result=" + this.result + ", message=" + CHexConver.byte2HexStr(this.message) + "} " + super.toString();
        }
    }

    public static class SendDataResponse
    extends TransferParamResponse {
        private int result;
        private int sendDataLimit;
        private int receiveDataLimit;

        public SendDataResponse(byte[] byArray) {
            SendDataResponse sendDataResponse = this;
            super(byArray);
            sendDataResponse.parseResponseData(sendDataResponse.getData());
        }

        public SendDataResponse(int n, int n2, int n3, int n4, int n5, int n6) {
            SendDataResponse sendDataResponse = object;
            Object object = SendDataResponse.getResponseData(n4, n5, n6);
            super(n, n2, n3, (byte[])object);
            sendDataResponse.result = n4;
            sendDataResponse.sendDataLimit = n5;
            sendDataResponse.receiveDataLimit = n6;
        }

        private void parseResponseData(byte[] byArray) {
            if (byArray != null && byArray.length >= 5) {
                this.result = CHexConver.byteToInt(byArray[0]);
                this.sendDataLimit = CHexConver.bytesToInt(byArray, 1, 2);
                this.receiveDataLimit = CHexConver.bytesToInt(byArray, 3, 2);
                return;
            }
        }

        private static byte[] getResponseData(int n, int n2, int n3) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            byteArrayOutputStream2.write(n);
            try {
                byteArrayOutputStream2.write(CHexConver.int2byte2(n2));
                byteArrayOutputStream.write(CHexConver.int2byte2(n3));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return byteArrayOutputStream2.toByteArray();
        }

        public int getResult() {
            return this.result;
        }

        public int getSendDataLimit() {
            return this.sendDataLimit;
        }

        public int getReceiveDataLimit() {
            return this.receiveDataLimit;
        }

        @Override
        public String toString() {
            return "SendDataResponse{result=" + this.result + ", sendDataLimit=" + this.sendDataLimit + ", receiveDataLimit=" + this.receiveDataLimit + "} " + super.toString();
        }
    }

    public static class ReadDataResponse
    extends TransferParamResponse {
        private int result;
        private int dataLen;
        private short crc;
        private int sendDataLimit;
        private int receiveDataLimit;

        public ReadDataResponse(byte[] byArray) {
            ReadDataResponse readDataResponse = this;
            super(byArray);
            readDataResponse.parseResponseData(readDataResponse.getData());
        }

        public ReadDataResponse(int n, int n2, int n3, int n4, short s, int n5, int n6) {
            ReadDataResponse readDataResponse = object;
            Object object = ReadDataResponse.getResponseData(n3, n4, s, n5, n6);
            super(0, n, n2, (byte[])object);
            readDataResponse.result = n3;
            readDataResponse.dataLen = n4;
            readDataResponse.crc = s;
            readDataResponse.sendDataLimit = n5;
            readDataResponse.receiveDataLimit = n6;
        }

        private void parseResponseData(byte[] byArray) {
            if (byArray != null && byArray.length >= 11) {
                this.result = CHexConver.byteToInt(byArray[0]);
                this.dataLen = CHexConver.bytesToInt(byArray, 1, 4);
                this.crc = (short)CHexConver.bytesToInt(byArray, 3, 2);
                this.sendDataLimit = CHexConver.bytesToInt(byArray, 5, 2);
                this.receiveDataLimit = CHexConver.bytesToInt(byArray, 7, 2);
                return;
            }
        }

        private static byte[] getResponseData(int n, int n2, short s, int n3, int n4) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            byteArrayOutputStream2.write(n);
            try {
                byteArrayOutputStream2.write(CHexConver.intToBigBytes(n2));
                byteArrayOutputStream2.write(CHexConver.shortToBigBytes(s));
                byteArrayOutputStream2.write(CHexConver.int2byte2(n3));
                byteArrayOutputStream.write(CHexConver.int2byte2(n4));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return byteArrayOutputStream2.toByteArray();
        }

        public int getResult() {
            return this.result;
        }

        public int getDataLen() {
            return this.dataLen;
        }

        public short getCrc() {
            return this.crc;
        }

        public int getSendDataLimit() {
            return this.sendDataLimit;
        }

        public int getReceiveDataLimit() {
            return this.receiveDataLimit;
        }

        @Override
        public String toString() {
            return "ReadDataResponse{result=" + this.result + ", dataLen=" + this.dataLen + ", crc=" + this.crc + ", sendDataLimit=" + this.sendDataLimit + ", receiveDataLimit=" + this.receiveDataLimit + "} " + super.toString();
        }
    }

    public static class TransferParamResponse
    extends Response {
        private int way;
        private int type;
        private int version;
        private byte[] data;

        public TransferParamResponse(byte[] byArray) {
            TransferParamResponse transferParamResponse = this;
            super(byArray);
            transferParamResponse.parseResponseData(transferParamResponse.getResponse());
        }

        public TransferParamResponse(int n, int n2, int n3, byte[] byArray) {
            super(0, TransferParamResponse.getResponseData(n, n2, n3, byArray));
            this.way = n;
            this.type = n2;
            this.version = n3;
            this.data = byArray;
        }

        private void parseResponseData(byte[] byArray) {
            int n = 3;
            if (byArray != null && byArray.length >= n) {
                this.way = CHexConver.byteToInt(byArray[0]);
                this.type = CHexConver.byteToInt(byArray[1]);
                this.version = CHexConver.byteToInt(byArray[2]);
                if (byArray.length > n) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[byArray.length - n];
                    this.data = byArray;
                    int n2 = byArray.length;
                    System.arraycopy(byArray2, n, byArray, 0, n2);
                } else {
                    this.data = new byte[0];
                }
                return;
            }
        }

        private static byte[] getResponseData(int n, int n2, int n3, byte[] byArray) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            new ByteArrayOutputStream().write(n);
            byteArrayOutputStream2.write(n2);
            byteArrayOutputStream2.write(n3);
            if (byArray != null && byArray.length > 0) {
                try {
                    byteArrayOutputStream2.write(byArray);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return byteArrayOutputStream2.toByteArray();
        }

        public int getWay() {
            return this.way;
        }

        public int getType() {
            return this.type;
        }

        public int getVersion() {
            return this.version;
        }

        public byte[] getData() {
            return this.data;
        }

        @Override
        public String toString() {
            return "TransferParamResponse{op=" + this.getOp() + ", way=" + this.way + ", type=" + this.type + ", version=" + this.version + ", data=" + CHexConver.byte2HexStr(this.data) + "} ";
        }
    }

    public static class Response
    extends CommonResponse
    implements IParamBase {
        private int op;
        private byte[] response;

        public Response(byte[] byArray) {
            Response response = this;
            response.parseData(byArray);
        }

        public Response(int n, byte[] byArray) {
            this.op = n;
            this.response = byArray;
        }

        private void parseData(byte[] byArray) {
            if (byArray != null && byArray.length >= 1) {
                this.op = CHexConver.byteToInt(byArray[0]);
                if (byArray.length > 1) {
                    byArray = new byte[byArray.length - 1];
                    this.response = byArray;
                    int n = byArray.length;
                    System.arraycopy(byArray, 1, byArray, 0, n);
                } else {
                    this.response = new byte[0];
                }
                return;
            }
        }

        public int getOp() {
            return this.op;
        }

        public byte[] getResponse() {
            return this.response;
        }

        @Override
        public byte[] getParamData() {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            byteArrayOutputStream.write(((Response)object).op);
            Object object = ((Response)object).response;
            if (((Response)object).response != null && ((Object)object).length > 0) {
                try {
                    byteArrayOutputStream2.write((byte[])object);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return byteArrayOutputStream2.toByteArray();
        }

        @Override
        public String toString() {
            return "Response{op=" + this.op + ", response=" + CHexConver.byte2HexStr(this.response) + "} ";
        }
    }

    public static class DataTransferParam
    extends Param {
        private int type;
        private boolean isEnd;
        private int seq;
        private short crc;
        private int offset;
        private int len;
        private byte[] data;

        public DataTransferParam(byte[] byArray) {
            DataTransferParam dataTransferParam = this;
            super(byArray);
            dataTransferParam.parsePayload(dataTransferParam.getPayload());
        }

        public DataTransferParam(int n, boolean bl, int n2, short s, int n3, byte[] byArray) {
            super(1, DataTransferParam.getPayload(n, bl, n2, s, n3, byArray));
            this.type = n;
            this.isEnd = bl;
            this.seq = n2;
            this.crc = s;
            this.offset = n3;
            this.data = byArray;
        }

        private void parsePayload(byte[] byArray) {
            if (byArray != null && byArray.length >= 11) {
                this.type = CHexConver.byteToInt(byArray[0]);
                int n = CHexConver.bytesToInt(byArray, 1, 2);
                this.seq = n & 0x7F;
                int n2 = n >> 15 == 1 ? 1 : 0;
                this.isEnd = n2;
                this.crc = (short)CHexConver.bytesToInt(byArray, 3, 2);
                this.offset = CHexConver.bytesToInt(byArray, 5, 4);
                this.len = n2 = CHexConver.bytesToInt(byArray, 9, 2);
                int n3 = 11;
                if (byArray.length > n3) {
                    byte[] byArray2 = byArray;
                    this.len = Math.min(n2, byArray.length - n3);
                    byArray = new byte[this.len];
                    this.data = byArray;
                    int n4 = byArray.length;
                    System.arraycopy(byArray2, n3, byArray, 0, n4);
                } else {
                    DataTransferParam dataTransferParam = this;
                    dataTransferParam.len = 0;
                    dataTransferParam.data = new byte[0];
                }
                return;
            }
        }

        private static byte[] getPayload(int n, boolean bl, int n2, short s, int n3, byte[] byArray) {
            ByteArrayOutputStream byteArrayOutputStream;
            block7: {
                int n4;
                block6: {
                    block5: {
                        ByteArrayOutputStream byteArrayOutputStream2;
                        byteArrayOutputStream = byteArrayOutputStream2;
                        new ByteArrayOutputStream().write(n);
                        byte[] byArray2 = CHexConver.int2byte2(bl ? n2 | 0x8000 : n2 & Short.MAX_VALUE);
                        byteArrayOutputStream.write(byArray2);
                        byteArrayOutputStream.write(CHexConver.shortToBigBytes(s));
                        byteArrayOutputStream.write(CHexConver.intToBigBytes(n3));
                        if (byArray != null) break block5;
                        n4 = 0;
                        break block6;
                    }
                    n4 = byArray.length;
                }
                byteArrayOutputStream.write(CHexConver.int2byte2(n4));
                if (n4 <= 0) break block7;
                try {
                    byteArrayOutputStream.write(byArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return byteArrayOutputStream.toByteArray();
        }

        public int getType() {
            return this.type;
        }

        public boolean isEnd() {
            return this.isEnd;
        }

        public int getSeq() {
            return this.seq;
        }

        public short getCrc() {
            return this.crc;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLen() {
            return this.len;
        }

        public byte[] getData() {
            return this.data;
        }

        @Override
        public String toString() {
            return "DataTransferParam{op=" + this.getOp() + ", type=" + this.type + ", isEnd=" + this.isEnd + ", seq=" + this.seq + ", crc=" + this.crc + ", offset=" + this.offset + ", len=" + this.len + ", data=" + CHexConver.byte2HexStr(this.data) + "} ";
        }
    }

    public static class SendDataParam
    extends TransferParam {
        private int dataLen;
        private short crc;
        private int sendDataLimit;
        private int receiveDataLimit;

        public SendDataParam(byte[] byArray) {
            SendDataParam sendDataParam = this;
            super(byArray);
            sendDataParam.parseParams(sendDataParam.getParam());
        }

        public SendDataParam(int n, int n2, int n3, short s, int n4, int n5) {
            SendDataParam sendDataParam = object;
            Object object = SendDataParam.getParams(n3, s, n4, n5);
            super(1, n, n2, (byte[])object);
            sendDataParam.dataLen = n3;
            sendDataParam.crc = s;
            sendDataParam.sendDataLimit = n4;
            sendDataParam.receiveDataLimit = n5;
        }

        private void parseParams(byte[] byArray) {
            if (byArray != null && byArray.length >= 10) {
                this.dataLen = CHexConver.bytesToInt(byArray, 0, 4);
                this.crc = (short)CHexConver.bytesToInt(byArray, 4, 2);
                this.sendDataLimit = CHexConver.bytesToInt(byArray, 6, 2);
                this.receiveDataLimit = CHexConver.bytesToInt(byArray, 8, 2);
                return;
            }
        }

        private static byte[] getParams(int n, short s, int n2, int n3) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            try {
                byteArrayOutputStream2.write(CHexConver.intToBigBytes(n));
                byteArrayOutputStream2.write(CHexConver.shortToBigBytes(s));
                byteArrayOutputStream2.write(CHexConver.int2byte2(n2));
                byteArrayOutputStream.write(CHexConver.int2byte2(n3));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return byteArrayOutputStream2.toByteArray();
        }

        public int getDataLen() {
            return this.dataLen;
        }

        public short getCrc() {
            return this.crc;
        }

        public int getSendDataLimit() {
            return this.sendDataLimit;
        }

        public int getReceiveDataLimit() {
            return this.receiveDataLimit;
        }

        @Override
        public String toString() {
            return "SendDataParam{dataLen=" + this.dataLen + ", crc=" + this.crc + ", sendDataLimit=" + this.sendDataLimit + ", receiveDataLimit=" + this.receiveDataLimit + "} " + super.toString();
        }
    }

    public static class ReadDataParam
    extends TransferParam {
        private int sendDataLimit;
        private int receiveDataLimit;

        public ReadDataParam(byte[] byArray) {
            ReadDataParam readDataParam = this;
            super(byArray);
            readDataParam.parseParams(readDataParam.getParam());
        }

        public ReadDataParam(int n, int n2, int n3, int n4) {
            ReadDataParam readDataParam = object;
            Object object = ReadDataParam.getParams(n3, n4);
            super(0, n, n2, (byte[])object);
            readDataParam.sendDataLimit = n3;
            readDataParam.receiveDataLimit = n4;
        }

        private void parseParams(byte[] byArray) {
            if (byArray != null && byArray.length >= 4) {
                this.sendDataLimit = CHexConver.bytesToInt(byArray, 0, 2);
                this.receiveDataLimit = CHexConver.bytesToInt(byArray, 2, 2);
                return;
            }
        }

        public static byte[] getParams(int n, int n2) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            try {
                byteArrayOutputStream2.write(CHexConver.int2byte2(n));
                byteArrayOutputStream.write(CHexConver.int2byte2(n2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return byteArrayOutputStream2.toByteArray();
        }

        public int getSendDataLimit() {
            return this.sendDataLimit;
        }

        public int getReceiveDataLimit() {
            return this.receiveDataLimit;
        }

        @Override
        public String toString() {
            return "ReadDataParam{sendDataLimit=" + this.sendDataLimit + ", receiveDataLimit=" + this.receiveDataLimit + "} " + super.toString();
        }
    }

    public static class TransferParam
    extends Param {
        private int way;
        private int type;
        private int version;
        private byte[] param;

        public TransferParam(byte[] byArray) {
            TransferParam transferParam = this;
            super(byArray);
            transferParam.parsePayload(transferParam.getPayload());
        }

        public TransferParam(int n, int n2, int n3, byte[] byArray) {
            super(0, TransferParam.getPayload(n, n2, n3, byArray));
            this.way = n;
            this.type = n2;
            this.version = n3;
            this.param = byArray;
        }

        private void parsePayload(byte[] byArray) {
            int n = 3;
            if (byArray != null && byArray.length >= n) {
                this.way = CHexConver.byteToInt(byArray[0]);
                this.type = CHexConver.byteToInt(byArray[1]);
                this.version = CHexConver.byteToInt(byArray[2]);
                if (byArray.length > n) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[byArray.length - n];
                    this.param = byArray;
                    int n2 = byArray.length;
                    System.arraycopy(byArray2, n, byArray, 0, n2);
                } else {
                    this.param = new byte[0];
                }
                return;
            }
        }

        private static byte[] getPayload(int n, int n2, int n3, byte[] byArray) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            new ByteArrayOutputStream().write(n);
            byteArrayOutputStream2.write(n2);
            byteArrayOutputStream2.write(n3);
            if (byArray != null && byArray.length > 0) {
                try {
                    byteArrayOutputStream2.write(byArray);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return byteArrayOutputStream2.toByteArray();
        }

        public int getWay() {
            return this.way;
        }

        public int getType() {
            return this.type;
        }

        public int getVersion() {
            return this.version;
        }

        public byte[] getParam() {
            return this.param;
        }

        @Override
        public String toString() {
            return "TransferParam{op=" + this.getOp() + ", way=" + this.way + ", type=" + this.type + ", version=" + this.version + ", param=" + CHexConver.byte2HexStr(this.param) + "} ";
        }
    }

    public static class CustomReplyParam
    extends Param {
        private final byte[] customData;

        public CustomReplyParam(byte[] byArray) {
            super(new byte[0]);
            this.customData = byArray;
        }

        @Override
        public byte[] getParamData() {
            return this.customData;
        }
    }

    public static class Param
    extends BaseParameter {
        private int op;
        private byte[] payload;

        public Param(byte[] byArray) {
            Param param = this;
            param.parseData(byArray);
        }

        public Param(int n, byte[] byArray) {
            this.op = n;
            this.payload = byArray;
        }

        public int getOp() {
            return this.op;
        }

        public byte[] getPayload() {
            return this.payload;
        }

        public void parseData(byte[] byArray) {
            if (byArray != null && byArray.length >= 1) {
                this.op = CHexConver.byteToInt(byArray[0]);
                if (byArray.length > 1) {
                    byArray = new byte[byArray.length - 1];
                    this.payload = byArray;
                    int n = byArray.length;
                    System.arraycopy(byArray, 1, byArray, 0, n);
                } else {
                    this.payload = new byte[0];
                }
                return;
            }
        }

        @Override
        public byte[] getParamData() {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            byteArrayOutputStream.write(((Param)object).op);
            Object object = ((Param)object).payload;
            if (((Param)object).payload != null && ((Object)object).length > 0) {
                try {
                    byteArrayOutputStream2.write((byte[])object);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return byteArrayOutputStream2.toByteArray();
        }
    }
}

