/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.command.file_op;

import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.model.base.CommandWithParamAndResponse;
import com.jieli.jl_rcsp.model.base.CommonResponse;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ReadFileFromDeviceCmd
extends CommandWithParamAndResponse<Param, Response> {
    public ReadFileFromDeviceCmd(Param param) {
        super(36, ReadFileFromDeviceCmd.class.getCanonicalName(), param);
    }

    public static class StartResponse
    extends Response {
        public int size;

        public StartResponse(int n) {
            this.size = n;
        }

        @Override
        public String toString() {
            return "StartResponse{size=" + this.size + '}';
        }
    }

    public static class Response
    extends CommonResponse {
    }

    public static class CancelParam
    extends Param {
        public byte reason;

        public CancelParam(byte by) {
            super((byte)-127);
            this.reason = by;
        }

        @Override
        public byte[] getParamData() {
            return new byte[]{this.op, this.reason};
        }

        @Override
        public String toString() {
            return "CancelParam{op=" + this.op + ", reason=" + this.reason + '}';
        }
    }

    public static class StopParam
    extends Param {
        public byte ret;

        public StopParam(byte by) {
            super((byte)-128);
            this.ret = by;
        }

        @Override
        public byte[] getParamData() {
            return new byte[]{this.op, this.ret};
        }

        @Override
        public String toString() {
            return "StopParam{op=" + this.op + ", ret=" + this.ret + '}';
        }
    }

    public static class StartWithClusterParam
    extends Param {
        public int offset;
        public int cluster;
        public int devHandler;

        public StartWithClusterParam(int n, int n2, int n3) {
            super((byte)1);
            this.offset = n2;
            this.cluster = n3;
            this.devHandler = n;
        }

        @Override
        public byte[] getParamData() {
            ByteBuffer byteBuffer = ByteBuffer.allocate(13);
            byteBuffer.put(this.op).putInt(this.devHandler).putInt(this.offset).putInt(this.cluster);
            return byteBuffer.array();
        }

        @Override
        public String toString() {
            return "StartWithClusterParam{op=" + this.op + ", offset=" + this.offset + ", cluster=" + this.cluster + '}';
        }
    }

    public static class StartWithDevAndNameParam
    extends Param {
        public int offset;
        public int devHandler;
        public String name;
        public boolean unicode;

        public StartWithDevAndNameParam(int n, int n2, String string, boolean bl) {
            super((byte)2);
            this.offset = n2;
            this.devHandler = n;
            this.name = string;
            this.unicode = bl;
        }

        @Override
        public byte[] getParamData() {
            byte[] byArray = Param.getNameData(this.name, this.unicode);
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + 10);
            byteBuffer.put(this.op).putInt(this.devHandler).putInt(this.offset).put((byte)byArray.length).put(byArray);
            return byteBuffer.array();
        }

        @Override
        public String toString() {
            return "StartWithNameParam{offset=" + this.offset + ", name='" + this.name + '\'' + ", unicode='" + this.unicode + '\'' + '}';
        }
    }

    @Deprecated
    public static class StartWithNameParam
    extends Param {
        public int offset;
        public String name;
        public boolean unicode;

        public StartWithNameParam(int n, String string, boolean bl) {
            super((byte)0);
            this.offset = n;
            this.name = string;
            this.unicode = bl;
        }

        @Override
        public byte[] getParamData() {
            byte[] byArray = Param.getNameData(this.name, this.unicode);
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + 5);
            byteBuffer.put(this.op).putInt(this.offset).put(byArray);
            return byteBuffer.array();
        }

        @Override
        public String toString() {
            return "StartWithNameParam{offset=" + this.offset + ", name='" + this.name + '\'' + ", unicode='" + this.unicode + '\'' + '}';
        }
    }

    public static class Param
    extends BaseParameter {
        public static final byte OP_UNKNOWN = -1;
        public static final byte OP_START_WITH_NAME = 0;
        public static final byte OP_START_WITH_CLUSTER = 1;
        public static final byte OP_START_WITH_DEV_AND_NAME = 2;
        public static final byte OP_STOP = -128;
        public static final byte OP_CANCEL = -127;
        public byte op;

        public Param(byte by) {
            this.op = by;
        }

        public static byte[] getNameData(String object, boolean bl) {
            if (!bl) {
                return ((String)object).getBytes(Charset.forName("gbk"));
            }
            String string = object;
            object = "\\U".getBytes();
            byte[] byArray = string.getBytes(Charset.forName("utf-16le"));
            byte[] byArray2 = new byte[byArray.length + ((Object)object).length + 2];
            Object object2 = object;
            int n = ((Object)object2).length;
            System.arraycopy(object2, 0, byArray2, 0, n);
            n = ((Object)object2).length;
            int n2 = byArray.length;
            System.arraycopy(byArray, 0, byArray2, n, n2);
            return byArray2;
        }

        @Override
        public byte[] getParamData() {
            return new byte[]{this.op};
        }
    }
}

