/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.command.watch;

import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.base.CommonResponse;
import com.jieli.jl_rcsp.util.CHexConver;

public class RequestHealthDataCmd
extends CommandBase<Param, Response> {
    public RequestHealthDataCmd(Param param) {
        this(2, param);
    }

    public RequestHealthDataCmd(int n, Param param) {
        RequestHealthDataCmd requestHealthDataCmd = this;
        super(160, RequestHealthDataCmd.class.getSimpleName(), n);
        requestHealthDataCmd.setParam(param);
    }

    public static class Response
    extends CommonResponse {
        public final byte ret;
        public final byte flag;
        public final byte[] data;

        public Response(byte by, byte by2, byte[] byArray) {
            this.ret = by;
            this.flag = by2;
            this.data = byArray;
        }

        public byte getRet() {
            return this.ret;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static class Param
    extends BaseParameter {
        public final int mask;
        public final byte version;
        public final byte[] subMask;

        public Param(int n, byte by, byte ... byArray) {
            Param param = this;
            param.checkMaskAndSubMaskRelation(n, byArray);
            param.mask = n;
            param.version = by;
            param.subMask = byArray;
        }

        private void checkMaskAndSubMaskRelation(int n, byte[] byArray) {
            int n2 = 0;
            for (int i = 0; i < 32; ++i) {
                if (CHexConver.getBitByPosition(n, i) != 1) continue;
                ++n2;
            }
            if (n2 != 0) {
                if (byArray.length == n2) {
                    return;
                }
                throw new IllegalArgumentException("mask set count not equal to subMask length");
            }
            throw new IllegalArgumentException("mask must not be 0x00");
        }

        @Override
        public byte[] getParamData() {
            byte[] byArray = new byte[this.subMask.length + 5];
            Param param = this;
            byte[] byArray2 = CHexConver.intToBigBytes(param.mask);
            int n = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray[4] = param.version;
            n = this.subMask.length;
            System.arraycopy(this.subMask, 0, byArray, 5, n);
            return byArray;
        }
    }
}

