/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.command.watch;

import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.base.CommonResponse;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.RcspUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SportsInfoStatusSyncCmd
extends CommandBase<Param, Response> {
    public static final byte OP_READ_SPORTS_INFO = 0;
    public static final byte OP_START_SPORTS = 1;
    public static final byte OP_APP_STOP_SPORTS = 2;
    public static final byte OP_FIRMWARE_STOP_SPORTS = 3;
    public static final byte OP_PAUSE_SPORTS = 4;
    public static final byte OP_RESUME_SPORTS = 5;
    public static final byte OP_READ_REAL_DATA = 6;
    public static final byte OP_SET_REAL_DATA_READ_INTERVAL = 7;
    public static final byte SPORTS_TYPE_INDOOR = 2;
    public static final byte SPORTS_TYPE_OUTDOOR = 1;
    public static final byte SPORTS_STATUS_STOP = 0;
    public static final byte SPORTS_STATUS_RUNNING = 1;

    public SportsInfoStatusSyncCmd(Param param) {
        this(2, param);
    }

    public SportsInfoStatusSyncCmd(int n, Param param) {
        SportsInfoStatusSyncCmd sportsInfoStatusSyncCmd = this;
        super(166, SportsInfoStatusSyncCmd.class.getSimpleName(), n);
        sportsInfoStatusSyncCmd.setParam(param);
    }

    private static float getFormatValue(float f) {
        Object[] objectArray = new Object[1];
        int n = 0;
        try {
            objectArray[n] = Float.valueOf(f);
            f = Float.parseFloat(RcspUtil.formatString("%.2f", objectArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return f;
    }

    public static class AppStopSportsResponse
    extends Response {
        public int stopTime;
        public int restoreTime;
        public byte[] strengthIntervalTimer;
        public short fileId;
        public int fileSize;

        public AppStopSportsResponse(byte[] byArray) {
            this.stopTime = CHexConver.bytesToInt(byArray, 0, 4);
            this.restoreTime = CHexConver.bytesToInt(byArray, 4, 4);
            this.fileId = CHexConver.bytesToShort(byArray[8], byArray[9]);
            this.fileSize = CHexConver.bytesToInt(byArray[10], byArray[11]);
            this.strengthIntervalTimer = ByteBuffer.allocate(byArray.length - 8).put(byArray, 12, byArray.length - 12).array();
        }

        @Override
        public String toString() {
            return "AppStopExerciseResponse{stopTime=" + this.stopTime + ", restoreTime=" + this.restoreTime + ", strengthIntervalTimer=" + Arrays.toString(this.strengthIntervalTimer) + '}';
        }
    }

    public static class ReadSportsInfoResponse
    extends Response {
        public byte type;
        public byte status;
        public int id;
        public boolean hasGps;
        public byte heartRateMode;
        public int readReadDataInterval;

        public ReadSportsInfoResponse(byte[] byArray) {
            this.type = byArray[0];
            this.status = byArray[1];
            this.id = CHexConver.bytesToInt(byArray, 2, 4);
            boolean bl = byArray[6] == 1;
            this.hasGps = bl;
            this.heartRateMode = byArray[7];
            this.readReadDataInterval = CHexConver.bytesToInt(byArray, 8, 2);
        }

        @Override
        public String toString() {
            return "ReadExerciseInfoResponse{mode=" + this.type + ", status=" + this.status + ", id=" + this.id + ", hasGps=" + this.hasGps + ", heartRateMode=" + this.heartRateMode + '}';
        }
    }

    public static class Response
    extends CommonResponse {
    }

    public static class ReadRealDataResponse
    extends Response {
        public byte version;
        public int step;
        public float distance;
        public int duration;
        public float speed;
        public float pace;
        public int kcal;
        public int stepFreq;
        public int stride;
        public int exerciseStatus;
        public int heartRate;

        public ReadRealDataResponse(byte[] byArray) {
            float f;
            this.version = byArray[0];
            this.step = CHexConver.bytesToInt(byArray, 1, 4);
            this.distance = SportsInfoStatusSyncCmd.getFormatValue((float)CHexConver.bytesToInt(byArray, 5, 2) * 0.01f);
            this.duration = CHexConver.bytesToInt(byArray, 7, 4);
            this.speed = f = SportsInfoStatusSyncCmd.getFormatValue((float)CHexConver.bytesToInt(byArray, 11, 2) * 0.01f);
            f = f == 0.0f ? 0.0f : SportsInfoStatusSyncCmd.getFormatValue(1.0f / f * 3600.0f);
            this.pace = f;
            this.kcal = CHexConver.bytesToInt(byArray, 13, 2);
            this.stepFreq = CHexConver.bytesToInt(byArray, 15, 2);
            this.stride = CHexConver.bytesToInt(byArray, 17, 2);
            this.exerciseStatus = CHexConver.byteToInt(byArray[19]);
            this.heartRate = CHexConver.byteToInt(byArray[20]);
        }

        @Override
        public String toString() {
            return "UpdateRealDataParam{version=" + this.version + ", step=" + this.step + ", distance=" + this.distance + ", duration=" + this.duration + ", speed=" + this.speed + ", pace=" + this.pace + ", kcal=" + this.kcal + ", stepFreq=" + this.stepFreq + ", stride=" + this.stride + ", exerciseStatus=" + this.exerciseStatus + '}';
        }
    }

    public static class SetReadRealDataIntervalParam
    extends Param {
        public SetReadRealDataIntervalParam(short s) {
            super((byte)7, CHexConver.shortToBigBytes(s));
        }
    }

    public static class ReadRealDataParam
    extends Param {
        public ReadRealDataParam() {
            super((byte)6, new byte[0]);
        }
    }

    public static class ResumeSportsParam
    extends Param {
        public ResumeSportsParam() {
            super((byte)5, new byte[0]);
        }
    }

    public static class PauseSportsParam
    extends Param {
        public PauseSportsParam() {
            super((byte)4, new byte[0]);
        }
    }

    public static class FirmwareStopSportsParam
    extends Param {
        public int stopTime;
        public int restoreTime;
        public short fileId;
        public int fileSize;
        public byte[] strengthIntervalTimer;

        public FirmwareStopSportsParam(byte[] byArray) {
            super((byte)3, byArray);
            this.stopTime = CHexConver.bytesToInt(byArray, 0, 4);
            this.restoreTime = CHexConver.bytesToInt(byArray, 4, 4);
            this.fileId = CHexConver.bytesToShort(byArray[8], byArray[9]);
            this.fileSize = CHexConver.bytesToInt(byArray[10], byArray[11]);
            this.strengthIntervalTimer = ByteBuffer.allocate(byArray.length - 8).put(byArray, 12, byArray.length - 12).array();
        }
    }

    public static class AppStopSportsParam
    extends Param {
        public AppStopSportsParam() {
            super((byte)2, new byte[0]);
        }
    }

    public static class StartSportsParam
    extends Param {
        public byte type;

        public StartSportsParam(byte by) {
            StartSportsParam startSportsParam = object;
            byte[] byArray = new byte[1];
            Object object = byArray;
            byArray[0] = by;
            super((byte)1, (byte[])object);
            startSportsParam.type = by;
        }
    }

    public static class ReadSportsInfoParam
    extends Param {
        public ReadSportsInfoParam() {
            super((byte)0, null);
        }
    }

    public static class Param
    extends BaseParameter {
        private final byte op;
        private final byte[] data;

        public Param(byte by, byte[] byArray) {
            this.op = by;
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.data = byArray;
        }

        public byte getOp() {
            return this.op;
        }

        public byte[] getData() {
            return this.data;
        }

        @Override
        public byte[] getParamData() {
            return ByteBuffer.allocate(this.data.length + 1).put(this.op).put(this.data).array();
        }
    }
}

