/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device;

import com.jieli.jl_rcsp.model.command.GetDevConfigureCmd;
import com.jieli.jl_rcsp.model.device.DeviceInfo;
import com.jieli.jl_rcsp.model.device.VoiceData;
import com.jieli.jl_rcsp.model.response.ADVInfoResponse;
import com.jieli.jl_rcsp.model.response.ExternalFlashMsgResponse;
import com.jieli.jl_rcsp.model.response.GetLowLatencySettingsResponse;
import com.jieli.jl_rcsp.model.response.TargetInfoResponse;

public class DeviceStatus {
    private int status;
    private boolean isAuthDevice;
    private boolean isEnterLowPowerMode;
    private boolean isMandatoryUpgrade;
    private boolean isEnableLatencyMode;
    private DeviceInfo mDeviceInfo;
    private ADVInfoResponse mADVInfo;
    private String mDevMD5;
    private GetLowLatencySettingsResponse mLatencySettings;
    private int maxCommunicationMtu = 530;
    private int maxReceiveMtu = 530;
    private VoiceData mVoiceData;
    private boolean isTwsConnected;
    private ExternalFlashMsgResponse mExtFlashMSg;
    private GetDevConfigureCmd.Response deviceConfigure;

    public int getStatus() {
        return this.status;
    }

    public DeviceStatus setStatus(int n) {
        this.status = n;
        return this;
    }

    public boolean isAuthDevice() {
        return this.isAuthDevice;
    }

    public DeviceStatus setAuthDevice(boolean bl) {
        this.isAuthDevice = bl;
        return this;
    }

    public boolean isEnterLowPowerMode() {
        return this.isEnterLowPowerMode;
    }

    public DeviceStatus setEnterLowPowerMode(boolean bl) {
        this.isEnterLowPowerMode = bl;
        return this;
    }

    public boolean isMandatoryUpgrade() {
        return this.isMandatoryUpgrade;
    }

    public DeviceStatus setMandatoryUpgrade(boolean bl) {
        this.isMandatoryUpgrade = bl;
        return this;
    }

    public DeviceInfo getDeviceInfo() {
        return this.mDeviceInfo;
    }

    public DeviceStatus setDeviceInfo(TargetInfoResponse targetInfoResponse) {
        this.mDeviceInfo = targetInfoResponse instanceof DeviceInfo ? (DeviceInfo)targetInfoResponse : DeviceInfo.convertFromTargetInfo(targetInfoResponse);
        return this;
    }

    public ADVInfoResponse getADVInfo() {
        return this.mADVInfo;
    }

    public DeviceStatus setADVInfo(ADVInfoResponse aDVInfoResponse) {
        this.mADVInfo = aDVInfoResponse;
        boolean bl = aDVInfoResponse != null && aDVInfoResponse.getLeftDeviceQuantity() > 0 && aDVInfoResponse.getRightDeviceQuantity() > 0;
        DeviceStatus deviceStatus = this;
        deviceStatus.setTwsConnected(bl);
        return deviceStatus;
    }

    public String getDevMD5() {
        return this.mDevMD5;
    }

    public DeviceStatus setDevMD5(String string) {
        this.mDevMD5 = string;
        return this;
    }

    public boolean isEnableLatencyMode() {
        return this.isEnableLatencyMode;
    }

    public DeviceStatus setEnableLatencyMode(boolean bl) {
        this.isEnableLatencyMode = bl;
        return this;
    }

    public GetLowLatencySettingsResponse getLatencySettings() {
        return this.mLatencySettings;
    }

    public DeviceStatus setLatencySettings(GetLowLatencySettingsResponse getLowLatencySettingsResponse) {
        this.mLatencySettings = getLowLatencySettingsResponse;
        return this;
    }

    public int getMaxCommunicationMtu() {
        return this.maxCommunicationMtu;
    }

    public DeviceStatus setMaxCommunicationMtu(int n) {
        this.maxCommunicationMtu = n;
        return this;
    }

    public int getMaxReceiveMtu() {
        return this.maxReceiveMtu;
    }

    public DeviceStatus setMaxReceiveMtu(int n) {
        this.maxReceiveMtu = n;
        return this;
    }

    public VoiceData getVoiceData() {
        return this.mVoiceData;
    }

    public DeviceStatus setVoiceData(VoiceData voiceData) {
        this.mVoiceData = voiceData;
        return this;
    }

    public boolean isTwsConnected() {
        return this.isTwsConnected;
    }

    public DeviceStatus setTwsConnected(boolean bl) {
        this.isTwsConnected = bl;
        return this;
    }

    public ExternalFlashMsgResponse getExtFlashMSg() {
        return this.mExtFlashMSg;
    }

    public DeviceStatus setExtFlashMSg(ExternalFlashMsgResponse externalFlashMsgResponse) {
        this.mExtFlashMSg = externalFlashMsgResponse;
        return this;
    }

    public GetDevConfigureCmd.Response getDeviceConfigure() {
        return this.deviceConfigure;
    }

    public DeviceStatus setDeviceConfigure(GetDevConfigureCmd.Response response) {
        this.deviceConfigure = response;
        return this;
    }

    public String toString() {
        return "DeviceStatus{status=" + this.status + ", isAuthDevice=" + this.isAuthDevice + ", isEnterLowPowerMode=" + this.isEnterLowPowerMode + ", isMandatoryUpgrade=" + this.isMandatoryUpgrade + ", isEnableLatencyMode=" + this.isEnableLatencyMode + ", mDeviceInfo=" + this.mDeviceInfo + ", mADVInfo=" + this.mADVInfo + ", mDevMD5='" + this.mDevMD5 + '\'' + ", mLatencySettings=" + this.mLatencySettings + ", maxCommunicationMtu=" + this.maxCommunicationMtu + ", maxReceiveMtu=" + this.maxReceiveMtu + ", mVoiceData=" + this.mVoiceData + ", isTwsConnected=" + this.isTwsConnected + ", mExtFlashMSg=" + this.mExtFlashMSg + ", deviceConfigure=" + this.deviceConfigure + '}';
    }
}

