/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device;

import android.graphics.Color;
import com.jieli.jl_rcsp.util.CHexConver;

public class LightControlInfo {
    public static final int STATE_OFF = 0;
    public static final int STATE_ON = 1;
    public static final int STATE_SETTING = 2;
    public static final int LIGHT_MODE_COLOURFUL = 0;
    public static final int LIGHT_MODE_TWINKLE = 1;
    public static final int LIGHT_MODE_SCENE = 2;
    public static final int TWINKLE_MODE_COLORFUL = 0;
    public static final int TWINKLE_MODE_RED = 1;
    public static final int TWINKLE_MODE_ORANGE = 2;
    public static final int TWINKLE_MODE_YELLOW = 3;
    public static final int TWINKLE_MODE_GREEN = 4;
    public static final int TWINKLE_MODE_CYAN = 5;
    public static final int TWINKLE_MODE_BLUE = 6;
    public static final int TWINKLE_MODE_PURPLE = 7;
    public static final int TWINKLE_FREQ_FAST = 0;
    public static final int TWINKLE_FREQ_SLOW = 1;
    public static final int TWINKLE_FREQ_BREATHE = 2;
    public static final int TWINKLE_FREQ_MUSIC = 3;
    public static final int SCENE_MODE_RAINBOW = 0;
    public static final int SCENE_MODE_HEARTBEAT = 1;
    public static final int SCENE_MODE_CANDLELIGHT = 2;
    public static final int SCENE_MODE_NIGHT_LIGHT = 3;
    public static final int SCENE_MODE_STAGE = 4;
    public static final int SCENE_MODE_COLORFUL_BREATHING = 5;
    public static final int SCENE_MODE_RED_BREATHING = 6;
    public static final int SCENE_MODE_GREEN_BREATHING = 7;
    public static final int SCENE_MODE_BLUE_BREATHING = 8;
    public static final int SCENE_MODE_GREEN_MOOD = 9;
    public static final int SCENE_MODE_BEAUTIFUL_SUNSET = 10;
    public static final int SCENE_MODE_MUSIC_RHYTHM = 11;
    private int switchState;
    private int lightMode;
    private int color;
    private int twinkleMode;
    private int twinkleFreq;
    private int sceneMode;
    private int hue;
    private int saturation;
    private int luminance;

    public int getSwitchState() {
        return this.switchState;
    }

    public LightControlInfo setSwitchState(int n) {
        this.switchState = n;
        return this;
    }

    public int getLightMode() {
        return this.lightMode;
    }

    public LightControlInfo setLightMode(int n) {
        this.lightMode = n;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public LightControlInfo setColor(int n) {
        this.color = n;
        return this;
    }

    public int getTwinkleMode() {
        return this.twinkleMode;
    }

    public LightControlInfo setTwinkleMode(int n) {
        this.twinkleMode = n;
        return this;
    }

    public int getTwinkleFreq() {
        return this.twinkleFreq;
    }

    public LightControlInfo setTwinkleFreq(int n) {
        this.twinkleFreq = n;
        return this;
    }

    public int getSceneMode() {
        return this.sceneMode;
    }

    public LightControlInfo setSceneMode(int n) {
        this.sceneMode = n;
        return this;
    }

    public int getHue() {
        return this.hue;
    }

    public LightControlInfo setHue(int n) {
        this.hue = n;
        return this;
    }

    public int getSaturation() {
        return this.saturation;
    }

    public LightControlInfo setSaturation(int n) {
        this.saturation = n;
        return this;
    }

    public int getLuminance() {
        return this.luminance;
    }

    public LightControlInfo setLuminance(int n) {
        this.luminance = n;
        return this;
    }

    public String toString() {
        return "LightControlInfo{switchState=" + this.switchState + ", lightMode=" + this.lightMode + ", color=" + this.color + ", twinkleMode=" + this.twinkleMode + ", twinkleFreq=" + this.twinkleFreq + ", hue=" + this.hue + ", saturation=" + this.saturation + ", luminance=" + this.luminance + '}';
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[11];
        byte[] byArray2 = byArray;
        LightControlInfo lightControlInfo = this;
        int n = lightControlInfo.switchState | this.lightMode << 2;
        byte[] byArray3 = CHexConver.int2byte2(lightControlInfo.hue);
        byArray2[0] = CHexConver.intToByte(n);
        byArray2[1] = CHexConver.intToByte(Color.red((int)this.color));
        byArray2[2] = CHexConver.intToByte(Color.green((int)this.color));
        byArray2[3] = CHexConver.intToByte(Color.blue((int)this.color));
        byArray2[4] = CHexConver.intToByte(this.twinkleMode);
        byArray2[5] = CHexConver.intToByte(this.twinkleFreq);
        byArray2[6] = CHexConver.intToByte(this.sceneMode);
        int n2 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray2, 7, n2);
        byArray2[9] = CHexConver.intToByte(lightControlInfo.saturation);
        byArray[10] = CHexConver.intToByte(this.luminance);
        return byArray;
    }
}

