/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.health.IHealthSettingToAttr;
import com.jieli.jl_rcsp.util.CHexConver;

public class AutomaticPressureDetection
implements IHealthSettingToAttr {
    public static final int MODE_RELAX = 0;
    public static final int MODE_NORMAL = 1;
    public static final int MODE_MIDDLE = 2;
    public static final int MODE_HIGH = 3;
    private boolean enable;
    private byte mode;

    public AutomaticPressureDetection(byte[] byArray) {
        AutomaticPressureDetection automaticPressureDetection = this;
        automaticPressureDetection.parseData(byArray);
    }

    private void parseData(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            int n = CHexConver.byteToInt(byArray[0]) == 1 ? 1 : 0;
            this.enable = n;
            n = 1;
            if (byArray.length >= 2) {
                this.mode = byArray[n];
            }
            return;
        }
    }

    private byte[] toData() {
        return new byte[]{(byte)(this.enable ? 1 : 0), this.mode};
    }

    public boolean isEnable() {
        return this.enable;
    }

    public AutomaticPressureDetection setEnable(boolean bl) {
        this.enable = bl;
        return this;
    }

    public byte getMode() {
        return this.mode;
    }

    public AutomaticPressureDetection setMode(byte by) {
        this.mode = by;
        return this;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public AttrBean toAttr() {
        return new AttrBean().setType((byte)this.getType()).setAttrData(this.toData());
    }

    public String toString() {
        return "AutomaticPressureDetection{enable=" + this.enable + ", mode=" + this.mode + '}';
    }
}

