/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.health.HealthData;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.JL_Log;

public class PressureDetection
extends HealthData {
    private int detectionValue;

    public PressureDetection(int n, byte by, byte[] byArray) {
        PressureDetection pressureDetection = this;
        super(5, by, byArray, n);
        pressureDetection.parsePressureDetectionData(n, by, byArray);
    }

    private void parsePressureDetectionData(int n, byte by, byte[] byArray) {
        if (n == 0) {
            byte[] byArray2 = CHexConver.getBooleanArrayBig(by);
            by = 0;
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] != 1 || i != 0) continue;
                this.detectionValue = CHexConver.byteToInt(byArray[by]);
                by = (byte)(by + 1);
            }
        } else {
            JL_Log.e("PressureDetection", "no support version : " + n);
        }
    }

    public int getDetectionValue() {
        return this.detectionValue;
    }

    @Override
    public String toString() {
        return "PressureDetection{detectionValue=" + this.detectionValue + "} " + super.toString();
    }
}

