/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.health.IHealthSettingToAttr;
import java.nio.ByteBuffer;

public class SedentaryReminder
implements IHealthSettingToAttr {
    public static final byte STATUS_CLOSE = 0;
    public static final byte STATUS_OPEN = 1;
    public static final byte MODE_BRIGHT = 0;
    public static final byte MODE_SHAKE = 1;
    private byte status;
    private boolean freeLunchBreak;
    private byte mode;
    private byte startHour;
    private byte startMin;
    private byte endHour;
    private byte endMin;

    public SedentaryReminder(byte[] byArray) {
        SedentaryReminder sedentaryReminder = this;
        sedentaryReminder.parseData(byArray);
    }

    private void parseData(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.status = byArray[0];
            int n = 1;
            int n2 = 2;
            if (byArray.length >= 2) {
                this.mode = byArray[n];
            } else {
                n2 = n;
            }
            n = n2 + 1;
            if (byArray.length >= n) {
                n2 = byArray[n2] == 1 ? 1 : 0;
                this.freeLunchBreak = n2;
            } else {
                n = n2;
            }
            if (byArray.length >= n + 2) {
                this.startHour = byArray[n];
                this.startMin = byArray[++n];
                ++n;
            }
            if (byArray.length >= n + 2) {
                this.endHour = byArray[n];
                this.endMin = byArray[n + 1];
            }
            return;
        }
    }

    private byte[] toData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(7);
        byteBuffer.put(this.status).put(this.mode).put((byte)(this.freeLunchBreak ? 1 : 0)).put(this.startHour).put(this.startMin).put(this.endHour).put(this.endMin);
        return byteBuffer.array();
    }

    public byte getStatus() {
        return this.status;
    }

    public SedentaryReminder setStatus(byte by) {
        this.status = by;
        return this;
    }

    public boolean isFreeLunchBreak() {
        return this.freeLunchBreak;
    }

    public SedentaryReminder setFreeLunchBreak(boolean bl) {
        this.freeLunchBreak = bl;
        return this;
    }

    public byte getMode() {
        return this.mode;
    }

    public SedentaryReminder setMode(byte by) {
        this.mode = by;
        return this;
    }

    public byte getStartHour() {
        return this.startHour;
    }

    public SedentaryReminder setStartHour(byte by) {
        this.startHour = by;
        return this;
    }

    public byte getStartMin() {
        return this.startMin;
    }

    public SedentaryReminder setStartMin(byte by) {
        this.startMin = by;
        return this;
    }

    public byte getEndHour() {
        return this.endHour;
    }

    public SedentaryReminder setEndHour(byte by) {
        this.endHour = by;
        return this;
    }

    public byte getEndMin() {
        return this.endMin;
    }

    public SedentaryReminder setEndMin(byte by) {
        this.endMin = by;
        return this;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public AttrBean toAttr() {
        return new AttrBean().setType((byte)this.getType()).setAttrData(this.toData());
    }

    public String toString() {
        return "SedentaryReminder{status=" + this.status + ", freeLunchBreak=" + this.freeLunchBreak + ", mode=" + this.mode + ", startHour=" + this.startHour + ", startMin=" + this.startMin + ", endHour=" + this.endHour + ", endMin=" + this.endMin + '}';
    }
}

